<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Language file.
 *
 * @package   theme_remui
 * @copyright (c) 2023 WisdmLabs (https://wisdmlabs.com/) <support@wisdmlabs.com>
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['advancedsettings'] = 'Zaawansowane ustawienia';
$string['backgroundimage'] = 'Obraz tła';
$string['backgroundimage_desc'] = 'Obraz do wyświetlenia jako tło strony. Obraz tła, który tu wgrasz, zastąpi obraz tła z plików predefiniowanych przez motyw.';
$string['brandcolor'] = 'Kolor marki';
$string['brandcolor_desc'] = 'Kolor marki.';
$string['bootswatch'] = 'Bootswatch';
$string['bootswatch_desc'] = 'Bootswatch to zestaw zmiennych Bootstrap i arkuszy stylów CSS do stylizowania Bootstrap.';
$string['choosereadme'] = 'remui to nowoczesny, wysoko konfigurowalny motyw. Motyw ten ma być używany bezpośrednio lub jako motyw nadrzędny przy tworzeniu nowych motywów opartych na Bootstrap 4.';
$string['currentinparentheses'] = '(aktualne)';
$string['configtitle'] = 'Edwiser RemUI';
$string['generalsettings'] = 'podstawowy';
$string['loginbackgroundimage'] = 'Obraz tła strony logowania';
$string['loginbackgroundimage_desc'] = 'Obraz do wyświetlenia jako tło strony logowania.';
$string['nobootswatch'] = 'Brak';
$string['pluginname'] = 'Edwiser RemUI';
$string['presetfiles'] = 'Dodatkowe pliki predefiniowane motywu';
$string['presetfiles_desc'] = 'Pliki predefiniowane mogą być używane do dramatycznej zmiany wyglądu motywu. Zobacz <a href="https://docs.moodle.org/dev/remui_Presets">predefiniowane pliki remui</a> w celu uzyskania informacji na temat tworzenia i udostępniania własnych predefiniowanych plików, a także zobacz <a href="https://archive.moodle.net/remui">Repozytorium predefiniowanych plików</a> w celu pobrania predefiniowanych plików udostępnionych przez innych.';
$string['preset'] = 'Predefiniowany motyw';
$string['preset_desc'] = 'Wybierz predefiniowany motyw, aby szeroko zmienić wygląd motywu.';
$string['privacy:metadata'] = 'Motyw remui nie przechowuje żadnych danych osobowych użytkownika.';
$string['rawscss'] = 'Surowy SCSS';
$string['rawscss_desc'] = 'Użyj tego pola, aby wprowadzić kod SCSS lub CSS, który zostanie wstrzyknięty na końcu arkusza stylów.';
$string['rawscsspre'] = 'Surowy wstępny SCSS';
$string['rawscsspre_desc'] = 'W tym polu możesz wprowadzić kod SCSS do inicjowania, który zostanie wstrzyknięty przed wszystkim innym. Większość czasu będziesz korzystał z tej opcji, aby zdefiniować zmienne.';
$string['region-side-pre'] = 'Prawy';
$string['region-side-top'] = 'Górny';
$string['region-side-bottom'] = 'Dolny';
$string['showfooter'] = 'Pokaż stopkę';
$string['unaddableblocks'] = 'Niepotrzebne bloki';
$string['unaddableblocks_desc'] = 'Określone bloki nie są potrzebne przy użyciu tego motywu i nie będą widoczne na liście \'Dodaj blok\'.';
$string['privacy:metadata:preference:draweropenblock'] = 'Preferencja użytkownika dotycząca ukrywania lub pokazywania szuflady z blokami.';
$string['privacy:metadata:preference:draweropenindex'] = 'Preferencja użytkownika dotycząca ukrywania lub pokazywania szuflady z indeksem kursów.';
$string['privacy:metadata:preference:draweropennav'] = 'Preferencja użytkownika dotycząca ukrywania lub pokazywania szuflady z menu nawigacyjnym.';
$string['privacy:drawerindexclosed'] = 'Obecna preferencja dotycząca zamkniętej szuflady z indeksem.';
$string['privacy:drawerindexopen'] = 'Obecna preferencja dotycząca otwartej szuflady z indeksem.';
$string['privacy:drawerblockclosed'] = 'Obecna preferencja dotycząca zamkniętej szuflady z blokami.';
$string['privacy:drawerblockopen'] = 'Obecna preferencja dotycząca otwartej szuflady z blokami.';
$string['privacy:drawernavclosed'] = 'Obecna preferencja dotycząca zamkniętej szuflady z menu nawigacyjnym.';
$string['privacy:drawernavopen'] = 'Obecna preferencja dotycząca otwartej szuflady z menu nawigacyjnym.';

// Deprecated since Moodle 4.0.
$string['totop'] = 'Przejdź do góry';

// Edwiser RemUI Settings Page Strings.

// Settings Tabs strings.
$string['homepagesettings'] = 'Strona główna';
$string['coursesettings'] = "Strona kursu";
$string['footersettings'] = 'Stopka';
$string["formsettings"] = "Formularze";
$string["iconsettings"] = "Ikony";
$string['loginsettings'] = 'Strona logowania';

$string['versionforheading'] = '<span class="small remuiversion"> Wersja {$a}</span>';
$string['themeversionforinfo'] = '<span>Aktualnie zainstalowana wersja: Edwiser RemUI v{$a}</span>';

// General Settings.
$string['mergemessagingsidebar'] = 'Scal panel wiadomości';
$string['mergemessagingsidebardesc'] = 'Scal panel wiadomości w prawej kolumnie bocznej';
$string['logoorsitename'] = 'Wybierz format logo strony';
$string['logoorsitenamedesc'] = 'Tylko logo - Duże logo marki <br/> Logo mini - Mini logo marki <br/> Tylko ikona - Ikona jako marka <br/> Ikona i nazwa strony - Ikona z nazwą strony';
$string['onlylogo'] = 'Tylko logo';
$string['logo'] = 'Logo';
$string['logomini'] = 'Logo mini';
$string['icononly'] = 'Tylko ikona';
$string['iconsitename'] = 'Ikona i nazwa strony';
$string['logodesc'] = 'Możesz dodać logo do wyświetlenia w nagłówku. Uwaga - Preferowana wysokość to 50 pikseli. Jeśli chcesz dostosować, możesz to zrobić z poziomu niestandardowego pola CSS.';
$string['logominidesc'] = 'Możesz dodać logomini do wyświetlenia w nagłówku, gdy kolumna boczna jest zwinięta. Uwaga - Preferowana wysokość to 50 pikseli. Jeśli chcesz dostosować, możesz to zrobić z poziomu niestandardowego pola CSS.';
$string['siteicon'] = 'Ikona strony';
$string['siteicondesc'] = 'Nie masz logo? Możesz wybrać jedno z tej <a href="https://fontawesome.com/v4.7.0/cheatsheet/" target="_new" ><b style="color:#17a2b8!important">listy</b></a>. <br /> Wprowadź tylko tekst po "fa-".';
$string['navlogin_popup'] = 'Włącz okienko logowania';
$string['navlogin_popupdesc'] = 'Włącz okienko logowania, aby szybko zalogować się bez przekierowywania do strony logowania.';
$string['coursecategories'] = 'Kategorie';
$string['enablecoursecategorymenu'] = "Rozwijane menu kategorii w nagłówku";
$string['enablecoursecategorymenudesc'] = "Zachowaj to włączone, jeśli chcesz wyświetlać rozwijane menu kategorii w nagłówku";
$string['coursepagesettings'] = "Strona kursu";
$string['coursepagesettingsdesc'] = "Ustawienia dotyczące kursów.";
$string['coursecategoriestext'] = "Zmień nazwę rozwijanego menu kategorii w nagłówku";
$string['coursecategoriestextdesc'] = "Możesz dodać niestandardową nazwę dla rozwijanego menu kategorii w nagłówku.";
$string['enablerecentcourses'] = 'Włącz menu ostatnich kursów';
$string['enablerecentcoursesdesc'] = 'Jeśli to włączone, menu ostatnich kursów zostanie wyświetlone w nagłówku.';
$string['recent'] = 'Ostatnie';
$string['recentcoursesmenu'] = 'Menu Ostatnich Kursów';
$string['searchcatplaceholdertext'] = 'Szukaj kategorii';
$string['viewallnotifications'] = 'Wyświetl wszystkie powiadomienia';
$string['forgotpassword'] = 'Zapomniałeś hasła?';
$string['enableannouncement'] = "Włącz ogłoszenie na całej stronie";
$string['enableannouncementdesc'] = "Włącz ogłoszenie na całej stronie dla wszystkich użytkowników.";
$string['enabledismissannouncement'] = "Włącz możliwość odrzucenia ogłoszenia na całej stronie";
$string['enabledismissannouncementdesc'] = "Jeśli włączone, pozwól użytkownikom odrzucić ogłoszenie.";
$string['brandlogo'] = 'Logo marki';
$string['brandname'] = 'Nazwa marki';

$string['announcementtext'] = "Ogłoszenie";
$string['announcementtextdesc'] = "Wiadomość ogłoszenia do wyświetlenia na całej stronie.";
$string['announcementtype'] = "Typ ogłoszenia";
$string['announcementtypedesc'] = "Wybierz typ ogłoszenia, aby wyświetlić inny kolor tła dla ogłoszenia.";
$string['typeinfo'] = "Informacja";
$string['typedanger'] = "Pilne";
$string['typewarning'] = "Ostrzeżenie";
$string['typesuccess'] = "Sukces";

// Google Analytics.
$string['googleanalytics'] = 'Google Analytics Tracking ID';
$string['googleanalyticsdesc'] = 'Proszę wprowadzić identyfikator śledzenia Google Analytics, aby włączyć analizę na swojej stronie internetowej. Format identyfikatora śledzenia powinien być taki jak [UA-XXXXX-Y].<br/>Prosimy pamiętać, że włączenie tej opcji spowoduje przesyłanie danych do Google Analytics i należy upewnić się, że użytkownicy są o tym ostrzeżeni. Nasz produkt nie przechowuje żadnych przesyłanych danych do Google Analytics.';
$string['favicon'] = 'Ikona strony';
$string['favicosize'] = 'Oczekiwany rozmiar to 16x16 pikseli';
$string['favicondesc'] = 'Twoja "ulubiona ikona" strony. Jest to wizualne przypomnienie tożsamości strony internetowej i jest wyświetlane w pasku adresu lub w kartach przeglądarki.';
$string['fontselect'] = 'Wybór czcionki';
$string['fontselectdesc'] = 'Wybierz spośród standardowych czcionek lub czcionek internetowych <a href="https://fonts.google.com/" target="_new">Google</a>. Prosimy zapisać, aby wyświetlić opcje wyboru. Uwaga: Jeśli niestandardowa czcionka jest ustawiona na standardową, zostanie zastosowana czcionka internetowa Google.';
$string['fontname'] = 'Czcionka strony';
$string['fontnamedesc'] = 'Wprowadź dokładną nazwę czcionki do użycia w Moodle.';
$string['fonttypestandard'] = 'Standardowa czcionka';
$string['fonttypegoogle'] = 'Czcionka internetowa Google';


$string['sendfeedback'] = "Wyślij opinie do Edwiser";
$string['enableedwfeedback'] = "Opinie i wsparcie Edwiser";
$string['enableedwfeedbackdesc'] = "Włącz Opinie i Wsparcie Edwiser, widoczne tylko dla administratorów.";
$string["checkfaq"] = "Edwiser RemUI - Sprawdź FAQ";
$string['poweredbyedwiser'] = 'Napędzane przez Edwiser';
$string['poweredbyedwiserdesc'] = 'Odznacz, aby usunąć "Napędzane przez Edwiser" ze swojej witryny.';
$string['enabledictionary'] = 'Włącz słownik';
$string['enabledictionarydesc'] = 'Jeśli włączone, funkcja Słownik będzie aktywowana, a wybrane słowo będzie pokazywać znaczenie w okienku popup.';
$string['customcss'] = 'Niestandardowy CSS';
$string['customcssdesc'] = 'Możesz dostosować CSS z pola tekstowego powyżej. Zmiany będą odzwierciedlane na wszystkich stronach Twojej witryny.';
// Zawartość stopki.
$string['followus'] = 'Śledź nas';
$string['poweredby'] = 'Napędzane przez';

// Jeden kliknięcie raport błędu/opinii.
$string['sendfeedback'] = "Wyślij opinię do Edwiser";
$string['descriptionmodal_text1'] = "<p>Opinia pozwala przesłać nam sugestie dotyczące naszych produktów. Witamy zgłoszenia problemów, pomysłów na funkcje i ogólne uwagi.</p><p>Zacznij od napisania krótkiego opisu:</p>";
$string['descriptionmodal_text2'] = "<p>Następnie pozwolimy Ci zidentyfikować obszary strony związane z Twoim opisem.</p>";
$string['emptydescription_error'] = "Proszę wpisać opis.";
$string['incorrectemail_error'] = "Proszę wpisać prawidłowy adres e-mail.";

$string['highlightmodal_text1'] = "Kliknij i przeciągnij na stronie, aby pomóc nam lepiej zrozumieć Twoją opinię. Możesz przenieść to okno dialogowe, jeśli przeszkadza.";
$string['highlight_button'] = "Podświetl obszar";
$string['blackout_button'] = "Ukryj informacje";
$string['highlight_button_tooltip'] = "Podświetl obszary istotne dla Twojej opinii.";
$string['blackout_button_tooltip'] = "Ukryj wszelkie dane osobowe.";

$string['feedbackmodal_next'] = 'Zrób zrzut ekranu i kontynuuj';
$string['feedbackmodal_skipnext'] = 'Pomiń i kontynuuj';
$string['feedbackmodal_previous'] = 'Wstecz';
$string['feedbackmodal_submit'] = 'Wyślij';
$string['feedbackmodal_ok'] = 'OK';

$string['description_heading'] = 'Opis';
$string['feedback_email_heading'] = 'Adres e-mail';
$string['additional_info'] = 'Dodatkowe informacje';
$string['additional_info_none'] = 'Brak';
$string['additional_info_browser'] = 'Informacje o przeglądarce';
$string['additional_info_page'] = 'Informacje o stronie';
$string['additional_info_pagestructure'] = 'Struktura strony';
$string['feedback_screenshot'] = 'Zrzut ekranu';
$string['feebdack_datacollected_desc'] = 'Przegląd zebranych danych jest dostępny <strong><a href="https://forums.edwiser.org/topic/67/anonymously-tracking-the-usage-of-edwiser-products" target="_blank">tutaj</a></strong>.';

$string['submit_loading'] = 'Wczytywanie...';
$string['submit_success'] = 'Dziękujemy za Twoją opinię. Doceniamy każdy jej element.';
$string['submit_error'] = 'Niestety, wystąpił błąd podczas wysyłania Twojej opinii. Proszę spróbuj ponownie.';
$string['send_feedback_license_error'] = "Aby otrzymać wsparcie techniczne, proszę aktywować licencję.";
$string['disabled'] = 'Wyłączone';

$string['nocoursefound'] = 'Nie znaleziono kursu';

$string['pagewidth'] = 'Układ motywu';
$string['pagewidthdesc'] = 'Tutaj możesz wybrać rozmiar układu stron.';
$string['defaultpermoodle'] = 'Wąski układ (domyślnie w Moodle)';
$string['fullwidthlayout'] = 'Pełny układ';

// Footer Page Settings.
$string['footersettings'] = 'Stopka';
$string['socialmedia'] = 'Media społecznościowe';
$string['socialmediadesc'] = 'Wprowadź linki do mediów społecznościowych dla Twojej strony.';
$string['facebooksetting'] = 'Facebook';
$string['facebooksettingdesc'] = 'Wprowadź link do strony Facebook Twojej strony. Na przykład: https://www.facebook.com/nazwastrony';
$string['twittersetting'] = 'Twitter';
$string['twittersettingdesc'] = 'Wprowadź link do strony Twitter Twojej strony. Na przykład: https://www.twitter.com/nazwastrony';
$string['linkedinsetting'] = 'Linkedin';
$string['linkedinsettingdesc'] = 'Wprowadź link do strony Linkedin Twojej strony. Na przykład: https://www.linkedin.com/in/nazwastrony';
$string['gplussetting'] = 'Google Plus';
$string['gplussettingdesc'] = 'Wprowadź link do strony Google Plus Twojej strony. Na przykład: https://plus.google.com/nazwastrony';
$string['youtubesetting'] = 'YouTube';
$string['youtubesettingdesc'] = 'Wprowadź link do strony YouTube Twojej strony. Na przykład: https://www.youtube.com/channel/nazwa';
$string['instagramsetting'] = 'Instagram';
$string['instagramsettingdesc'] = 'Wprowadź link do strony Instagram Twojej strony. Na przykład: https://www.instagram.com/nazwa';
$string['pinterestsetting'] = 'Pinterest';
$string['pinterestsettingdesc'] = 'Wprowadź link do strony Pinterest Twojej strony. Na przykład: https://www.pinterest.com/nazwa';
$string['quorasetting'] = 'Quora';
$string['quorasettingdesc'] = 'Wprowadź link do strony Quora Twojej strony. Na przykład: https://www.quora.com/nazwa';
$string['footerbottomtext'] = 'Tekst Stopki (dolny lewy)';
$string['footerbottomlink'] = 'Link Stopki (dolny lewy)';
$string['footerbottomlinkdesc'] = 'Wprowadź link do dolnej lewej sekcji Stopki. Na przykład: http://www.twojafirma.com';
$string['footercolumn1heading'] = 'Zawartość Stopki - Kolumna 1 (Lewa)';
$string['footercolumn1headingdesc'] = 'Ta sekcja dotyczy dolnej części (kolumna 1) Twojej strony głównej.';
$string['footercolumn1title'] = 'Tytuł kolumny Stopki 1';
$string['footercolumn1titledesc'] = 'Dodaj tytuł do tej kolumny.';
$string['footercolumncustomhtml'] = 'Treść';
$string['footercolumn1customhtmldesc'] = 'Możesz dostosować kod HTML tej kolumny za pomocą powyższego pola tekstowego.';
$string['footercolumn2heading'] = 'Zawartość Stopki - Kolumna 2 (Środkowa)';
$string['footercolumn2headingdesc'] = 'Ta sekcja dotyczy dolnej części (kolumna 2) Twojej strony głównej.';
$string['footercolumn2title'] = 'Tytuł drugiej kolumny stopki';
$string['footercolumn2titledesc'] = 'Dodaj tytuł do tej kolumny.';
$string['footercolumn2customhtml'] = 'Niestandardowe HTML';
$string['footercolumn2customhtmldesc'] = 'Możesz dostosować HTML tej kolumny za pomocą powyższego pola tekstowego.';
$string['footercolumn3heading'] = 'Zawartość stopki dla trzeciej kolumny (środkowej)';
$string['footercolumn3headingdesc'] = 'Ta sekcja dotyczy dolnej części (kolumna 3) Twojej strony głównej.';
$string['footercolumn3title'] = 'Tytuł trzeciej kolumny stopki';
$string['footercolumn3titledesc'] = 'Dodaj tytuł do tej kolumny.';
$string['footercolumn3customhtml'] = 'Niestandardowe HTML';
$string['footercolumn3customhtmldesc'] = 'Możesz dostosować HTML tej kolumny za pomocą powyższego pola tekstowego.';
$string['footercolumn4heading'] = 'Zawartość stopki dla czwartej kolumny (prawej)';
$string['footercolumn4headingdesc'] = 'Ta sekcja dotyczy dolnej części (kolumna 4) Twojej strony głównej.';
$string['footercolumn4title'] = 'Tytuł czwartej kolumny stopki';
$string['footercolumn4titledesc'] = 'Dodaj tytuł do tej kolumny.';
$string['footercolumn4customhtml'] = 'Niestandardowe HTML';
$string['footercolumn4customhtmldesc'] = 'Możesz dostosować HTML tej kolumny za pomocą powyższego pola tekstowego.';
$string['footerbottomheading'] = 'Ustawienia dolnej części stopki';
$string['footerbottomdesc'] = 'Tutaj możesz określić swój własny link, który chcesz dodać do dolnej części stopki.';
$string['footerbottomtextdesc'] = 'Dodaj tekst do dolnej części stopki.';
$string['footercopyrightsshow'] = 'pokaż';
$string['footercopyright'] = 'Pokaż zawartość praw autorskich';
$string['footercopyrights'] = '[site] © [year]. Wszelkie prawa zastrzeżone.';
$string['footercopyrightsdesc'] = 'Dodaj zawartość praw autorskich na dole strony.';
$string['footercopyrightstags'] = 'Tagi:<br>[site] - Nazwa strony<br>[year] - Bieżący rok';
$string['footerbottomlink'] = 'Link dolnej lewej części stopki';
$string['footerbottomlinkdesc'] = 'Wprowadź link dla dolnej lewej części stopki. Na przykład http://www.twojafirma.com';
$string['footerbottomtext'] = 'Tekst dolnej lewej części stopki';
$string['footerbottomlink'] = 'Link dolnej lewej części stopki';
$string['copyrighttextarea'] = 'Zawartość praw autorskich';
$string['footercolumnsize'] = 'Liczba widgetów';
$string['one'] = 'Jeden';
$string['two'] = 'Dwa';
$string['three'] = 'Trzy';
$string['four'] = 'Cztery';
$string['showsocialmediaicon'] = "Pokaż ikony mediów społecznościowych";
$string['footercolumntype'] = 'Typ';
$string['footercolumncustommenudesc'] = 'Dodaj swoje elementy menu w tym formacie, na przykład:<br><pre>[
    {
        "text": "Dodaj swój tekst tutaj",
        "address": "http://XYZ.abc"
    },
    {
        "text": "Dodaj swój tekst tutaj",
        "address": "http://XYZ.abc"
    }, ...
]</pre>
<b style="color:red;">Uwaga:</b> Aby łatwo dodać treść do stopki, spersonalizuj obszar stopki za pomocą naszego <a href="'.$CFG->wwwroot.'/admin/settings.php?section=themesettingremui#theme_remui_edwiserpersonalizer" onclick= location.href="'.$CFG->wwwroot.'/admin/settings.php?section=themesettingremui#theme_remui_edwiserpersonalizer";location.reload();>Wizualnego Personalizatora</a>';
$string['gotop'] = 'Przejdź do góry';

$string['menu'] = 'Menu';
$string['content'] = 'Zawartość';
$string['footercolumntypedesc'] = 'Możesz wybrać typ widgetu stopki';
$string['socialmediaicondesc'] = 'Pokaże ikony mediów społecznościowych w tej sekcji';
$string['footercolumncustommmenu'] = 'Dodaj elementy menu';
$string['follometext'] = 'Obserwuj mnie na {$a}';
$string['footercolumndesc'] = 'Wybierz liczbę widgetów w stopce';
$string['footershowlogo'] = 'Pokaż logo w stopce';
$string['footershowlogodesc'] = 'Pokaż logo w stopce pomocniczej.';

$string['footertermsandconditionsshow'] = 'Pokaż Regulamin';
$string['footertermsandconditions'] = 'Link do Regulaminu';
$string['footertermsandconditionsdesc'] = 'Możesz dodać link do strony Regulaminu.';
$string['footertermsandconditionsshowdesc'] = 'Regulamin w stopce';
$string['footerprivacypolicyshowdesc'] = 'Link do Polityki Prywatności';

$string['footerprivacypolicyshow'] = 'Pokaż Politykę Prywatności';
$string['footerprivacypolicy'] = 'Link do Polityki Prywatności';
$string['footerprivacypolicydesc'] = 'Możesz dodać link do strony Polityki Prywatności.';
$string['termsandconditions'] = 'Regulamin';
$string['privacypolicy'] = 'Polityka Prywatności';
$string['typeamessage'] = "Wpisz swoją wiadomość tutaj";
$string['allcontacts'] = "Wszystkie kontakty";

// Strona profilu
$string['administrator'] = 'Administrator';
$string['contacts'] = 'Kontakty';
$string['blogentries'] = 'Wpisy na blogu';
$string['discussions'] = 'Dyskusje';
$string['aboutme'] = 'O mnie';
$string['courses'] = 'Kursy';
$string['interests'] = 'Zainteresowania';
$string['institution'] = 'Wydział i instytucja';
$string['location'] = 'Lokalizacja';
$string['description'] = 'Opis';
$string['editprofile'] = 'Edytuj profil';
$string['start_date'] = 'Data rozpoczęcia';
$string['complete'] = 'Zakończone';
$string['surname'] = 'Nazwisko';
$string['actioncouldnotbeperformed'] = 'Nie można wykonać akcji!';
$string['enterfirstname'] = 'Proszę podać swoje imię.';
$string['enterlastname'] = 'Proszę podać swoje nazwisko.';
$string['entervalidphoneno'] = 'Podaj prawidłowy numer telefonu';
$string['enteremailid'] = 'Proszę podać swój adres e-mail.';
$string['enterproperemailid'] = 'Proszę podać prawidłowy adres e-mail.';
$string['detailssavedsuccessfully'] = 'Szczegóły zapisane pomyślnie!';
$string['fullname'] = 'Pełna nazwa';
$string['viewcourselow'] = "zobacz kurs";

$string['focusmodesettings'] = 'Ustawienia trybu skupienia';
$string['focusmode'] = 'Tryb skupienia';
$string['enablefocusmode'] = 'Włącz tryb skupienia';
$string['enablefocusmodedesc'] = 'Jeśli włączone, na stronie kursu pojawi się przycisk przejścia do trybu nauki bez rozpraszaczy.';
$string['focusmodeenabled'] = 'Tryb skupienia włączony';
$string['focusmodedisabled'] = 'Tryb skupienia wyłączony';
$string['coursedata'] = 'Dane kursu';
$string['prev'] = 'Poprzedni';
$string['next'] = 'Następny';
$string['enablecoursestats'] = 'Włącz statystyki kursu';
$string['enablecoursestatsdesc'] = 'Jeśli włączone, Administratorzy, Menadżerowie i Nauczyciele zobaczą statystyki użytkownika dotyczące zapisanego kursu na stronie pojedynczego kursu.';

// Statystyki kursu.
$string['notenrolledanycourse'] = 'Nie zapisano do żadnego kursu.';
$string['enrolledusers'] = 'Zapisani Studenci';
$string['studentcompleted'] = 'Studenci, którzy ukończyli';
$string['inprogress'] = 'W trakcie';
$string['yettostart'] = 'Do rozpoczęcia';
$string['completepercent'] = '{$a}% ukończonego kursu';
$string['seeallmycourses'] = "<span class='d-none d-lg-block'>Zobacz wszystkie moje </span> <span>kursy w trakcie</span>";
$string['noactivity'] = 'Brak aktywności w kursie';
$string['activitydata'] = '{$a->complete} z {$a->total} działań ukończonych';

// Login Page Strings.
$string['loginsettingpic'] = 'Prześlij obraz tła';
$string['loginsettingpicdesc'] = 'Prześlij obraz jako tło formularza logowania.';
$string['loginpagelayout'] = 'Pozycja formularza logowania';
$string['loginpagelayoutdesc'] = 'Wybierz projekt układu strony logowania.';
$string['logincenter'] = 'Środek';
$string['loginleft'] = 'Lewa strona';
$string['loginright'] = 'Prawa strona';
$string['brandlogopos'] = "Pokaż logo na stronie logowania";
$string['brandlogoposdesc'] = "Jeśli jest włączone, logo marki zostanie wyświetlone na stronie logowania.";
$string['hiddenlogo'] = "Wyłącz";
$string['sidebarregionlogo'] = 'Na karcie logowania';
$string['maincontentregionlogo'] = 'Na centralnej części strony';
$string['loginpanellogo'] = 'Logo nagłówka (Strona logowania)';
$string['loginpanellogodesc'] = 'Zależy od ustawienia <strong>Wybierz format logo strony</strong>';
$string['signuptextcolor'] = 'Kolor opisu strony';
$string['signuptextcolordesc'] = 'Wybierz kolor tekstu dla opisu strony.';
$string['brandlogotext'] = "Opis Strony";
$string['loginpagesitedescription'] = 'Opis Strony na Stronie Logowania';
$string['brandlogotextdesc'] = "Dodaj tekst opisu strony, który będzie wyświetlany na stronie logowania i rejestracji. Pozostaw to pole puste, jeśli nie chcesz dodawać żadnego opisu.";
$string['createnewaccount'] = 'Utwórz nowe konto';
$string['welcometobrand'] = 'Witaj, witamy na stronie {$a}';
$string['entertologin'] = "Wpisz swoje dane, aby się zalogować do swojego konta";
$string['forgotaccount'] = 'Nie pamiętasz hasła?';
$string['potentialidps'] = 'Lub zaloguj się używając swojego konta';
$string['firsttime'] = 'Pierwszy raz korzystasz z tej strony';

// Signup Page.
$string['createnewaccount'] = 'Utwórz nowe konto';
// Course Page Settings.
$string['coursesettings'] = "Strona kursu";
$string['enrolpagesettings'] = "Ustawienia strony zapisów";
$string['enrolpagesettingsdesc'] = "Zarządzaj treścią strony zapisów tutaj.";
$string['coursearchivepagesettings'] = 'Ustawienia strony archiwum kursów';
$string['coursearchivepagesettingsdesc'] = 'Zarządzaj układem i treścią strony archiwum kursów.';
$string['courseperpage'] = 'Kursy na stronę';
$string['courseperpagedesc'] = 'Liczba kursów wyświetlanych na stronie archiwum kursów.';
$string['none'] = 'Brak';
$string['fade'] = 'Przejście';
$string['slide-top'] = 'Przesunięcie w górę';
$string['slide-bottom'] = 'Przesunięcie w dół';
$string['slide-right'] = 'Przesunięcie w prawo';
$string['scale-up'] = 'Powiększenie';
$string['scale-down'] = 'Pomniejszenie';
$string['courseanimation'] = 'Animacja karty kursu';
$string['courseanimationdesc'] = 'Wybierz animację karty kursu, która ma pojawić się na stronie archiwum kursów.';

$string['currency'] = 'USD';
$string['currency_symbol'] = '$';
$string['enrolment_payment'] = 'Płatność za kurs';
$string['enrolment_payment_desc'] = 'Ustawienia preferencji zapisu na kurs. Czy wszystkie kursy wymagają opłaty, czy też niektóre są bezpłatne? Ustawienie to decyduje o tym, jak będzie działać i wyglądać zapis na kurs.';
$string['allrequirepayment'] = 'Wszystkie kursy wymagają opłaty';
$string['somearefree'] = 'Niektóre kursy są bezpłatne';
$string['allarefree'] = 'Wszystkie kursy są bezpłatne';

$string['showcoursepricing'] = 'Pokaż ceny kursów';
$string['showcoursepricingdesc'] = 'Włącz tę opcję, aby wyświetlać sekcję z cenami na stronie zapisów.';
$string['fullwidthcourseheader'] = 'Pełna szerokość nagłówka kursu';
$string['fullwidthcourseheaderdesc'] = 'Włącz tę opcję, aby nagłówek kursu zajmował pełną szerokość.';

$string['price'] = 'Cena';
$string['course_free'] = 'ZA DARMO';
$string['enrolnow'] = 'Zapisz się teraz';
$string['buyand'] = 'Kup & ';
$string['notags'] = 'Brak tagów.';
$string['tags'] = 'Tagi';

$string['enrolment_layout'] = 'Układ strony zapisu';
$string['enrolment_layout_desc'] = 'Włącz układ Edwiser dla nowego i ulepszonego projektu strony zapisu.';
$string['disable'] = 'Wyłącz';
$string['defaultlayout'] = 'Domyślny układ Moodle';
$string['enable_layout1'] = 'Układ Edwiser';

$string['webpage'] = "Strona internetowa";
$string['categorypagelayout'] = 'Układ strony archiwum kursów';
$string['categorypagelayoutdesc'] = 'Wybierz pomiędzy układami strony archiwum kursów.';
$string['edwiserlayout'] = 'Układ Edwiser';
$string['categoryfilter'] = 'Filtr kategorii';

$string['skill1'] = 'Początkujący';
$string['skill2'] = 'Średniozaawansowany';
$string['skill3'] = 'Zaawansowany';

$string['lastupdatedon'] = 'Ostatnia aktualizacja ';

$string['courseoverview'] = "Przegląd kursu";
$string['coursecontent'] = "Zawartość kursu";
$string['instructors'] = "Instruktorzy";
$string['reviews'] = "Recenzje";
$string['curatedby'] = 'Kuracja przez';
$string["studentsenrolled"] = 'Zapisanych studentów';
$string['lesson'] = 'Lekcja';
$string['category'] = 'Kategoria';
$string['review'] = 'Recenzja';
$string['length'] = 'Długość';
$string['lecture'] = 'Wykład';
$string['startdate'] = 'Data rozpoczęcia';
$string['skilllevel'] = 'Poziom zaawansowania';
$string['language'] = 'Język';
$string['certificate'] = 'Certyfikat';
$string['students'] = 'Studenci';
$string['courses'] = 'Kursy';

// Course archive.
$string['cachedef_courses'] = 'Cache dla kursów';
$string['cachedef_guestcourses'] = 'Cache dla gościnnych kursów';
$string['cachedef_updates'] = 'Cache dla aktualizacji';
$string['mycourses'] = "Moje kursy";
$string['allcategories'] = 'Wszystkie kategorie';
$string['categorysort'] = 'Sortuj kategorie';
$string['sortdefault'] = 'Sortuj (brak)';
$string['sortascending'] = 'Sortuj A do Z';
$string['sortdescending'] = 'Sortuj Z do A';


// Frontpage Old String.
// Home Page Settings.
$string['homepagesettings'] = 'Strona główna';
$string['frontpagedesign'] = 'Projektowanie strony głównej';
$string['frontpagedesigndesc'] = 'Włącz starszy kreator lub kreator strony głównej Edwiser RemUI';
$string['frontpagechooser'] = 'Wybierz projekt strony głównej';
$string['frontpagechooserdesc'] = 'Wybierz projekt strony głównej.';
$string['frontpagedesignold'] = 'Stary kreator strony głównej';
$string['frontpagedesignolddesc'] = 'Domyślny interfejs użytkownika jak poprzednio.';
$string['frontpagedesignnew'] = 'Nowy projekt';
$string['frontpagedesignnewdesc'] = 'Świeży projekt z wieloma sekcjami. Możesz konfigurować sekcje indywidualnie na stronie głównej.';
$string['newhomepagedescription'] = 'Kliknij "Strona główna witryny" w pasku nawigacji, aby przejść do "Kreatora strony głównej" i stworzyć własną stronę główną';
$string['frontpageloader'] = 'Załaduj obrazek ładowacza dla strony głównej';
$string['frontpageloaderdesc'] = 'To zastąpi domyślny ładowacz Twoim obrazem';
$string['frontpageimagecontent'] = 'Zawartość nagłówka';
$string['frontpageimagecontentdesc'] = 'Ta sekcja odnosi się do górnej części Twojej strony głównej.';
$string['frontpageimagecontentstyle'] = 'Styl';
$string['frontpageimagecontentstyledesc'] = 'Możesz wybrać między statycznym i suwakiem.';
$string['staticcontent'] = 'Statyczny';
$string['slidercontent'] = 'Suwak';
$string['addtext'] = 'Dodaj tekst';
$string['defaultaddtext'] = 'Edukacja to sprawdzona droga do postępu.';
$string['addtextdesc'] = 'Tutaj możesz dodać tekst do wyświetlenia na stronie głównej, najlepiej w HTML.';
$string['uploadimage'] = 'Prześlij obraz';
$string['uploadimagedesc'] = 'Możesz przesłać obraz jako treść do slajdu';
$string['video'] = 'Kod osadzenia iframe';
$string['videodesc'] = 'Tutaj możesz wstawić kod osadzenia iframe filmu do osadzenia.';
$string['contenttype'] = 'Wybierz rodzaj treści';
$string['contentdesc'] = 'Możesz wybierać między obrazem a podaniem adresu URL do filmu.';
$string['imageorvideo'] = 'Obraz/ film';
$string['image'] = 'Obraz';
$string['videourl'] = 'Adres URL do filmu';
$string['slideinterval'] = 'Interwał slajdu';
$string['slideintervalplaceholder'] = 'Dodatnia liczba całkowita w milisekundach.';
$string['slideintervaldesc'] = 'Możesz ustawić czas przejścia między slajdami. W przypadku, gdy jest tylko jeden slajd, ta opcja nie będzie miała wpływu. Jeśli wartość interwału jest nieprawidłowa (pusta|0|mniejsza niż 0), to domyślny interwał wynosi 5000 milisekund.';
$string['slidercount'] = 'Liczba slajdów';
$string['slidercountdesc'] = '';
$string['one'] = '1';
$string['two'] = '2';
$string['three'] = '3';
$string['four'] = '4';
$string['five'] = '5';
$string['six'] = '6';
$string['eight'] = '8';
$string['nine'] = '9';
$string['twelve'] = '12';
$string['slideimage'] = 'Wgraj obrazy do Slidera';
$string['slideimagedesc'] = 'Możesz wgrać obraz jako treść dla tego slajdu.';
$string['sliderurl'] = 'Dodaj link do przycisku Slidera';
$string['slidertext'] = 'Dodaj tekst do Slidera';
$string['defaultslidertext'] = '';
$string['slidertextdesc'] = 'Możesz wstawić treść tekstową dla tego slajdu. Preferowana jest treść w formacie HTML.';
$string['sliderbuttontext'] = 'Dodaj tekst do przycisku na slajdzie';
$string['sliderbuttontextdesc'] = 'Możesz dodać tekst do przycisku na tym slajdzie.';
$string['sliderurldesc'] = 'Możesz wstawić link do strony, na którą użytkownik zostanie przekierowany po kliknięciu przycisku.';
$string['sliderautoplay'] = 'Ustaw automatyczne odtwarzanie Slidera';
$string['sliderautoplaydesc'] = 'Wybierz "tak", jeśli chcesz, aby przejścia między slajdami odbywały się automatycznie.';
$string['true'] = 'Tak';
$string['false'] = 'Nie';
$string['frontpageblocks'] = 'Treść strony głównej';
$string['frontpageblocksdesc'] = 'Możesz wstawić nagłówek dla treści na Twojej stronie.';
$string['frontpageblockdisplay'] = 'Sekcja O nas';
$string['frontpageblockdisplaydesc'] = 'Możesz pokazać lub ukryć sekcję "O nas", a także pokazać sekcję "O nas" w formacie siatki.';
$string['donotshowaboutus'] = 'Nie pokazuj';
$string['showaboutusinrow'] = 'Pokaż sekcję w rzędzie';
$string['showaboutusingridblock'] = 'Pokaż sekcję w bloku siatki';

// About Us.
$string['frontpageaboutus'] = 'O nas na stronie głównej';
$string['frontpageaboutusdesc'] = 'Ta sekcja dotyczy informacji o nas na stronie głównej';
$string['frontpageaboutustitledesc'] = 'Dodaj tytuł do sekcji O nas';
$string['frontpageaboutusbody'] = 'Opis sekcji O nas';
$string['frontpageaboutusbodydesc'] = 'Krótki opis tej sekcji';
$string['enablesectionbutton'] = 'Włącz przyciski w sekcjach';
$string['enablesectionbuttondesc'] = 'Włącz przyciski w sekcjach tekstu';
$string['sectionbuttontextdesc'] = 'Wpisz tekst dla przycisku w tej sekcji';
$string['sectionbuttonlinkdesc'] = 'Wpisz link URL dla tej sekcji';
$string['frontpageblocksectiondesc'] = 'Dodaj tytuł do tej sekcji.';

// Block section 1.
$string['frontpageblocksection1'] = 'Tytuł sekcji 1';
$string['frontpageblockdescriptionsection1'] = 'Opis sekcji 1';
$string['frontpageblockiconsection1'] = 'Ikona Font-Awesome dla sekcji 1';
$string['sectionbuttontext1'] = 'Tekst przycisku dla sekcji 1';
$string['sectionbuttonlink1'] = 'Link URL dla sekcji 1';

// Block section 2.
$string['frontpageblocksection2'] = 'Tytuł sekcji 2';
$string['frontpageblockdescriptionsection2'] = 'Opis sekcji 2';
$string['frontpageblockiconsection2'] = 'Ikona Font-Awesome dla sekcji 2';
$string['sectionbuttontext2'] = 'Tekst przycisku dla sekcji 2';
$string['sectionbuttonlink2'] = 'Link URL dla sekcji 2';

// Block section 3.
$string['frontpageblocksection3'] = 'Tytuł sekcji 3';
$string['frontpageblockdescriptionsection3'] = 'Opis sekcji 3';
$string['frontpageblockiconsection3'] = 'Ikona Font-Awesome dla sekcji 3';
$string['sectionbuttontext3'] = 'Tekst przycisku dla sekcji 3';
$string['sectionbuttonlink3'] = 'Link URL dla sekcji 3';

// Block section 4.
$string['frontpageblocksection4'] = 'Tytuł sekcji 4';
$string['frontpageblockdescriptionsection4'] = 'Opis sekcji 4';
$string['frontpageblockiconsection4'] = 'Ikona Font-Awesome dla sekcji 4';
$string['sectionbuttontext4'] = 'Tekst przycisku dla sekcji 4';
$string['sectionbuttonlink4'] = 'Link URL dla sekcji 4';
$string['defaultdescriptionsection'] = 'Kompleksowo wykorzystaj technologie "just in time" w oparciu o scenariusze korporacyjne.';
$string['frontpagetestimonial'] = 'Referencje na stronie głównej';
$string['frontpagetestimonialdesc'] = 'Sekcja referencji na stronie głównej';
$string['enablefrontpageaboutus'] = 'Włącz sekcję referencji';
$string['enablefrontpageaboutusdesc'] = 'Włącz sekcję referencji na stronie głównej.';
$string['frontpageaboutusheading'] = 'Tytuł sekcji referencji';
$string['frontpageaboutusheadingdesc'] = 'Tytuł dla domyślnego tekstu nagłówka sekcji';
$string['frontpageaboutustext'] = 'Tekst referencji';
$string['frontpageaboutustextdesc'] = 'Wpisz tekst referencji dla strony głównej.';
$string['frontpageaboutusdefault'] = '<p class="lead">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.
              Ut enim ad minim veniam.</p>';
$string['testimonialcount'] = 'Ilość referencji';
$string['testimonialcountdesc'] = 'Liczba referencji do wyświetlenia.';
$string['testimonialimage'] = 'Obrazek osoby';
$string['testimonialimagedesc'] = 'Obraz osoby do wyświetlenia z referencją';
$string['testimonialname'] = 'Nazwa osoby';
$string['testimonialnamedesc'] = 'Imię i nazwisko osoby';
$string['testimonialdesignation'] = 'Stanowisko osoby';
$string['testimonialdesignationdesc'] = 'Stanowisko osoby.';
$string['testimonialtext'] = 'Referencja osoby';
$string['testimonialtextdesc'] = 'Co osoba mówi';
$string['frontpageblockimage'] = 'Prześlij obrazek';
$string['frontpageblockimagedesc'] = 'Możesz przesłać obrazek jako treść dla tej sekcji.';
$string['frontpageblockiconsectiondesc'] = 'Możesz wybrać dowolną ikonę z tej <a href="https://fontawesome.com/v4.7.0/cheatsheet/" target="_new">listy</a>. Wpisz tylko tekst po "fa-". ';
$string['frontpageblockdescriptionsectiondesc'] = 'Krótki opis dotyczący tytułu.';

// Course.
$string['graderreport'] = 'Raport oceniania';
$string['enroluser'] = 'Zapisz użytkowników';
$string['activityeport'] = 'Raport aktywności';
$string['editcourse'] = 'Edytuj kurs';
$string['imageforcourse'] = 'Obrazek dla kursu';
// Next Previous Activity.
$string['activityprev'] = 'Poprzednia aktywność';
$string['activitynext'] = 'Następna aktywność';
$string['activitynextpreviousbutton'] = 'Włącz przycisk "Następna i poprzednia aktywność"';
$string['activitynextpreviousbuttondesc'] = 'Po włączeniu przycisk "Następna i poprzednia aktywność" pojawi się na stronie pojedynczej aktywności, aby przełączać się między aktywnościami.';
$string['disablenextprevious'] = 'Wyłącz';
$string['enablenextprevious'] = 'Włącz';
$string['enablenextpreviouswithname'] = 'Włącz z nazwą aktywności';

// Importer.
$string['importer'] = 'Importer';
$string['importer-missing'] = 'Brakuje wtyczki Edwiser Site Importer. Aby ją pobrać, odwiedź stronę <a href="https://edwiser.org">Edwiser</a>.';

// Information center.
$string['informationcenter'] = 'Centrum informacji';
$string['licensenotactive'] = '<strong>Alert!</strong> Licencja nie jest aktywowana, proszę <strong>aktywuj</strong> licencję w ustawieniach RemUI.';
$string['licensenotactiveadmin'] = '<strong>Alert!</strong> Licencja nie jest aktywowana, proszę <strong>aktywuj</strong> licencję <a class="text-primary" href="'.$CFG->wwwroot.'/admin/settings.php?section=themesettingremui#informationcenter" >tutaj</a>.';
$string['activatelicense'] = 'Aktywuj licencję';
$string['deactivatelicense'] = 'Dezaktywuj licencję';
$string['renewlicense'] = 'Odnów licencję';
$string['deactivated'] = 'Dezaktywowana';
$string['active'] = 'Aktywna';
$string['notactive'] = 'Nieaktywna';
$string['expired'] = 'Wygasła';
$string['licensekey'] = 'Klucz licencji';
$string['licensestatus'] = 'Status licencji';
$string['no_activations_left'] = 'Limit został przekroczony';
$string['activationfailed'] = 'Aktywacja klucza licencyjnego nie powiodła się. Proszę spróbuj ponownie później.';
$string['noresponsereceived'] = 'Nie otrzymano odpowiedzi od serwera. Proszę spróbuj ponownie później.';
$string['licensekeydeactivated'] = 'Klucz licencji został dezaktywowany.';
$string['siteinactive'] = 'Strona jest nieaktywna (naciśnij Aktywuj licencję, aby aktywować wtyczkę).';
$string['entervalidlicensekey'] = 'Proszę wprowadzić prawidłowy klucz licencyjny.';
$string['nolicenselimitleft'] = 'Osiągnięto maksymalny limit aktywacji, nie ma dostępnych aktywacji.';
$string['licensekeyisdisabled'] = 'Twój klucz licencyjny jest wyłączony.';
$string['licensekeyhasexpired'] = 'Twój klucz licencyjny wygasł. Proszę go odnowić.';
$string['licensekeyactivated'] = 'Twój klucz licencyjny został aktywowany.';
$string['entervalidlicensekey'] = 'Proszę wprowadzić poprawny klucz licencyjny.';
$string['edwiserremuilicenseactivation'] = 'Aktywacja licencji Edwiser RemUI';
$string['enterlicensekey'] = 'Wprowadź klucz licencyjny...';
$string['invalid'] = 'Nieprawidłowy';

$string['courseheaderdesign'] = 'Projekt nagłówka strony kursu';
$string['courseheaderdesigndesc'] = 'Wybierz projekt nagłówka strony kursu';
$string['default'] = 'Domyślny';
$string['headerdesign'] = 'Projekt nagłówka {$a}';
$string['sidebarcoursemenuheading'] = 'Menu kursu';

// Notification.
$string['inproductnotification'] = "Aktualizacja preferencji użytkownika (Powiadomienie w produkcie) - RemUI";

$string["noti_enrolandcompletion"] = 'Nowoczesne i profesjonalne układy Edwiser RemUI pomogły w zwiększeniu zaangażowania użytkowników: W tym miesiącu zarejestrowano <b>{$a->enrolment} nowych kursów i ukończono {$a->completion} kursów</b>';

$string["noti_completion"] = 'Edwiser RemUI poprawił poziom zaangażowania Twoich uczniów: W tym miesiącu ukończono <b>{$a->completion} kursów</b>';

$string["noti_enrol"] = 'Twój projekt LMS wygląda świetnie z Edwiser RemUI: W tym miesiącu zarejestrowano <b>{$a->enrolment} nowych kursów</b> na Twoim portalu';

$string["coolthankx"] = "Świetnie, dzięki!";

$string['gridview'] = 'Widok siatki';
$string['listview'] = 'Widok listy';
$string['summaryview'] = 'Widok podsumowania';

$string['side-top'] = "Górna część boczna";
$string['content'] = "Zawartość";
$string['side-bottom'] = "Dolna część boczna";
$string['side-pre'] = "Boczna część przednia";

$string['sitenamecolor'] = "Kolor nazwy lub ikony strony.";
$string['sitenamecolordesc'] = "Kolor tekstu nazwy strony i ikony, który będzie również stosowany na stronie logowania.";

$string['coursesenrolled'] = "Zapisane kursy";
$string['coursescompleted'] = "Ukończone kursy";
$string['activitiescompleted'] = "Ukończone aktywności";
$string['activitiesdue'] = "Aktywności do wykonania";

// Customizer Strings
$string['customizer-migrate-notice'] = 'Ustawienia kolorów zostały przeniesione do Customizera. Kliknij poniższy przycisk, aby otworzyć Customizera.';
$string['customizer-close-heading'] = 'Zamknij Customizera';
$string['customizer-close-description'] = 'Nie zapisane zmiany zostaną odrzucone. Czy chcesz kontynuować?';
$string['reset'] = 'Resetuj';
$string['resetall'] = 'Resetuj wszystko';
$string['reset-settings'] = 'Resetuj wszystkie ustawienia Customizera';
$string['reset-settings-description'] = '

<div>Ustawienia Customizera zostaną przywrócone do domyślnych. Czy chcesz kontynuować?</div>
<div class="mt-3"><strong>Resetuj wszystko:</strong> Resetuj wszystkie ustawienia.</div>
<div class="mt-3"><strong>Resetuj:</strong> Ustawienia oprócz następujących zostaną przywrócone do domyślnych.</div>
';
$string['link'] = 'Link';
$string['customizer'] = 'Customizer';
$string['error'] = 'Błąd';
$string['resetdesc'] = 'Zresetuj ustawienia do ostatniego zapisu lub domyślnych, gdy nic nie zostało zapisane';
$string['noaccessright'] = 'Przepraszamy! Nie masz uprawnień do korzystania z tej strony';
$string['font-family'] = 'Rodzaj czcionki';
$string['font-family_help'] = 'Ustaw rodzaj czcionki dla {$a}';

$string['button-font-family'] = 'Rodzaj czcionki';
$string['button-font-family_help'] = 'Ustaw rodzaj czcionki dla tekstu na przyciskach';

$string['font-size'] = 'Rozmiar czcionki';
$string['font-size_help'] = 'Ustaw rozmiar czcionki dla {$a}';
$string['font-weight'] = 'Grubość czcionki';
$string['font-weight_help'] = 'Ustaw grubość czcionki dla {$a}. Właściwość font-weight ustawia, jak grube lub cienkie mają być znaki w tekście.';
$string['line-height'] = 'Wysokość linii';
$string['line-height_help'] = 'Ustaw wysokość linii {$a}';
$string['global'] = 'Globalne';
$string['global_help'] = 'Możesz zarządzać globalnymi ustawieniami, takimi jak kolor, czcionka, nagłówki, przyciski itp.';
$string['site'] = 'Strona';
$string['text-color'] = 'Kolor tekstu';
$string['welcome-text-color'] = 'Kolor tekstu powitalnego';
$string['text-hover-color'] = 'Kolor tekstu po najechaniu';
$string['text-color_help'] = 'Ustaw kolor tekstu {$a}';
$string['content-color'] = 'Kolor treści';
$string['icon-color'] = 'Kolor ikony';
$string['icon-hover-color'] = 'Kolor ikony po najechaniu';
$string['icon-color_help'] = 'Ustaw kolor ikony {$a}';
$string['link-color'] = 'Kolor linku';
$string['link-color_help'] = 'Ustaw kolor linku {$a}';
$string['link-hover-color'] = 'Kolor linku po najechaniu';
$string['link-hover-color_help'] = 'Ustaw kolor linku po najechaniu {$a}';
$string['typography'] = 'Typografia';
$string['inherit'] = 'Inherit';
$string["weight-100"] = '100';
$string["weight-200"] = '200';
$string["weight-300"] = '300';
$string["weight-400"] = '400';
$string["weight-500"] = '500';
$string["weight-600"] = '600';
$string["weight-700"] = '700';
$string["weight-800"] = '800';
$string["weight-900"] = '900';
$string['text-transform'] = 'Transformacja tekstu';
$string['text-transform_help'] = 'Właściwość text-transform kontroluje wielkość liter tekstu. Ustaw transformację tekstu {$a}.';

$string['button-text-transform'] = 'Transformacja tekstu przycisku';
$string['button-text-transform_help'] = 'Właściwość text-transform kontroluje wielkość liter w tekście. Ustaw text-transform dla tekstu przycisku.';

$string["default"] = 'Domyślny';
$string["none"] = 'Brak';
$string["capitalize"] = 'Pierwsza duża litera';
$string["uppercase"] = 'Wszystkie duże litery';
$string["lowercase"] = 'Wszystkie małe litery';
$string['background-color'] = 'Kolor tła';
$string['background-hover-color'] = 'Kolor tła po najechaniu';
$string['background-color_help'] = 'Ustaw kolor tła {$a}';
$string['background-hover-color'] = 'Kolor tła po najechaniu';
$string['background-hover-color_help'] = 'Ustaw kolor tła po najechaniu na {$a}';
$string['color'] = 'Kolor';
$string['customizing'] = 'Dostosowywanie';
$string['savesuccess'] = 'Pomyślnie zapisano.';
$string['mobile'] = 'Telefon komórkowy';
$string['tablet'] = 'Tablet';
$string['hide-customizer'] = 'Ukryj dostosowywanie';
$string['customcss_help'] = 'Możesz dodać niestandardowy CSS. Będzie on stosowany na wszystkich stronach Twojej witryny.';

// Customizer Global body.
$string['body'] = 'Treść';
$string['body-font-family_desc'] = 'Ustaw rodzinę czcionek dla całej witryny. Zauważ, że jeśli ustawiono na Standard, to czcionka z ustawienia RemUI będzie zastosowana.';
$string['body-font-size_desc'] = 'Ustaw podstawowy rozmiar czcionki dla całej witryny.';
$string['body-fontweight_desc'] = 'Ustaw wagę czcionki dla całej witryny.';
$string['body-text-transform_desc'] = 'Ustaw text-transform dla całej witryny.';
$string['body-lineheight_desc'] = 'Ustaw wysokość linii dla całej witryny.';
$string['faviconurl_help'] = 'Adres URL ikony witryny (favicon)';

// Nagłówek dostosowywania globalnego.
$string['heading'] = 'Nagłówek';
$string['use-custom-color'] = 'Użyj niestandardowego koloru';
$string['use-custom-color_help'] = 'Użyj niestandardowego koloru dla {$a}';
$string['typography-heading-all-heading'] = 'Nagłówki (H1 - H6)';
$string['typography-heading-h1-heading'] = 'Nagłówek 1';
$string['typography-heading-h2-heading'] = 'Nagłówek 2';
$string['typography-heading-h3-heading'] = 'Nagłówek 3';
$string['typography-heading-h4-heading'] = 'Nagłówek 4';
$string['typography-heading-h5-heading'] = 'Nagłówek 5';
$string['typography-heading-h6-heading'] = 'Nagłówek 6';

// Customizer Colors.
$string['primary-color'] = 'Kolor podstawowy';
$string['primary-color_help'] = 'Zastosuj kolor podstawowy marki na całej stronie. Kolor ten będzie stosowany do przycisków, linków tekstowych, podczas najechania myszą oraz dla aktywnych pozycji menu nagłówka, podczas najechania myszą oraz dla aktywnych ikon.
<br><b>Uwaga:</b> Zmiana koloru podstawowego nie zmieni kolorów przycisków, jeśli zmieniłeś kolory przycisków za pomocą ich indywidualnych ustawień (<b>Globalne> Przyciski> Ustawienia kolorów przycisków</b>). Zresetuj kolory przycisków z ich indywidualnych ustawień, aby zmienić kolor przycisków globalnie, zmieniając kolor podstawowy stąd.';

$string['secondary-color'] = 'Kolor awansowy';
$string['secondary-color_help'] = 'Zastosuj kolor awansowy na całej stronie. Kolor ten zostanie zastosowany do ikon w bloku Statystyki na stronie Pulpit, tagów na kartach kursów, nagłówków kursów.';

$string['page-background'] = 'Tło strony';
$string['page-background_help'] = 'Ustaw niestandardowe tło strony dla obszaru zawartości strony. Możesz wybrać kolor, gradient lub obraz. Kąt koloru gradientu wynosi 100 stopni.';

$string['page-background-color'] = 'Kolor tła strony';
$string['page-background-color_help'] = 'Ustaw kolor tła dla obszaru zawartości strony.';

$string['page-background-image'] = 'Obraz tła strony';
$string['page-background-image_help'] = 'Ustaw obraz jako tło dla obszaru zawartości strony.';

$string['gradient'] = 'Gradient';
$string['gradient-color1'] = 'Kolor gradientu 1';
$string['gradient-color1_help'] = 'Ustaw pierwszy kolor gradientu.';
$string['gradient-color2'] = 'Kolor gradientu 2';
$string['gradient-color2_help'] = 'Ustaw drugi kolor gradientu.';
$string['gradient-color-angle'] = 'Kąt gradientu';
$string['gradient-color-angle_help'] = 'Ustaw kąt dla kolorów gradientu.';

$string['page-background-imageattachment'] = 'Załącznik obrazu tła';
$string['page-background-imageattachment_help'] = 'Właściwość background-attachment ustala, czy obraz tła przewija się wraz z resztą strony, czy jest ustalony.';

$string['image'] = 'Obrazek';
$string['additional-css'] = 'Dodatkowe CSS';
$string['left-sidebar'] = 'Boczna belka po lewej';
$string['main-sidebar'] = 'Główna belka boczna';
$string['sidebar-links'] = 'Linki bocznej belki';
$string['secondary-sidebar'] = 'Druga belka boczna';
$string['header'] = 'Nagłówek';
$string['headertypography'] = 'Typografia nagłówka';
$string['headercolors'] = 'Kolory nagłówka';
$string['menu'] = 'Menu';
$string['site-identity'] = 'Identyfikator strony';
$string['primary-header'] = 'Główny nagłówek';
$string['color'] = 'Kolor';

// Customizer Buttons.
$string['image'] = 'Obrazek';
$string['additional-css'] = 'Dodatkowe CSS';
$string['left-sidebar'] = 'Boczna belka po lewej';
$string['main-sidebar'] = 'Główna belka boczna';
$string['sidebar-links'] = 'Linki bocznej belki';
$string['secondary-sidebar'] = 'Druga belka boczna';
$string['header'] = 'Nagłówek';
$string['headertypography'] = 'Typografia nagłówka';
$string['headercolors'] = 'Kolory nagłówka';
$string['menu'] = 'Menu';
$string['site-identity'] = 'Identyfikator strony';
$string['primary-header'] = 'Główny nagłówek';
$string['color'] = 'Kolor';

// Przyciski kreatora motywu.
$string['buttons'] = 'Przyciski';
$string['border'] = 'Obramowanie';
$string['border-width'] = 'Szerokość obramowania';
$string['border-width_help'] = 'Ustaw szerokość obramowania {$a}';
$string['border-color'] = 'Kolor obramowania';
$string['border-color_help'] = 'Ustaw kolor obramowania {$a}';
$string['border-hover-color'] = 'Kolor obramowania po najechaniu myszką';
$string['border-hover-color_help'] = 'Ustaw kolor obramowania po najechaniu myszką {$a}';
$string['border-radius'] = 'Promień obramowania';
$string['border-radius_help'] = 'Ustaw promień obramowania {$a}';
$string['letter-spacing'] = 'Odstęp między literami';
$string['letter-spacing_help'] = 'Ustaw odstęp między literami {$a}';
$string['text'] = 'Tekst';
$string['padding'] = 'Wypełnienie';
$string['padding-top'] = 'Wypełnienie górne';
$string['padding-top_help'] = 'Ustaw wypełnienie górne {$a}';
$string['padding-right'] = 'Wypełnienie prawe';
$string['padding-right_help'] = 'Ustaw wypełnienie prawe {$a}';
$string['padding-bottom'] = 'Wypełnienie dolne';
$string['padding-bottom_help'] = 'Ustaw wypełnienie dolne {$a}';
$string['padding-left'] = 'Wypełnienie lewe';
$string['padding-left_help'] = 'Ustaw wypełnienie lewe {$a}';
$string['secondary'] = 'Drugi';
$string['colors'] = 'Kolory';
$string['commonbuttonsettings'] = 'Wspólne ustawienia';
$string['buttonsizesettings'] = 'Rozmiary przycisków';
$string['buttonsizesettingshead'] = '{$a}';
$string['commonfontsettings'] = 'Czcionka';
$string['buttoncolorsettings'] = 'Ustawienia koloru przycisków';

// Customizer Header.
$string['header-background-color_help'] = 'Ustaw kolor tła nagłówka. To nie zostanie zastosowane, jeśli opcja <strong>Ustaw kolor tła nagłówka tak samo jak kolor tła logo</strong> jest włączona.';
$string['site-logo'] = 'Logo strony';
$string['header-menu'] = 'Menu nagłówka';
$string['box-shadow-size'] = 'Rozmiar cienia pudełka';
$string['box-shadow-size_help'] = 'Ustaw rozmiar cienia pudełka dla nagłówka strony';
$string['box-shadow-blur'] = 'Rozmycie cienia pudełka';
$string['box-shadow-blur_help'] = 'Ustaw rozmycie cienia pudełka dla nagłówka strony';
$string['box-shadow-color'] = 'Kolor cienia pudełka';
$string['box-shadow-color_help'] = 'Ustaw kolor cienia pudełka dla nagłówka strony';
$string['layout-desktop'] = 'Układ pulpitu';
$string['layout-desktop_help'] = 'Ustaw układ nagłówka dla pulpitu';
$string['layout-mobile'] = 'Układ mobilny';
$string['layout-mobile_help'] = 'Ustaw układ nagłówka dla urządzeń mobilnych';
$string['header-left'] = 'Ikona z lewej strony, menu z prawej';
$string['header-right'] = 'Ikona z prawej strony, menu z lewej';
$string['header-top'] = 'Ikona na górze, menu na dole';
$string['hover'] = 'Najechanie';
$string['logo'] = 'Logo';
$string['applynavbarcolor'] = 'Ustaw kolor tła nagłówka tak samo jak kolor tła logo';
$string['applynavbarcolor_help'] = 'Kolor tła logo zostanie zastosowany do całej nagłówka. Zmiana koloru tła logo spowoduje zmianę koloru tła nagłówka. Nadal można zastosować niestandardowy kolor tekstu i kolor podświetlenia dla menu nagłówka.';
$string['header-background-color-warning'] = 'Nie będzie używane, jeśli włączona jest opcja <strong>Ustaw kolor strony w pasku nawigacji</strong>.';
$string['logosize'] = 'Oczekiwany stosunek wysokości do szerokości to 130:33 dla widoku z lewej strony i 140:33 dla widoku z prawej strony.';
$string['logominisize'] = 'Oczekiwany stosunek wysokości do szerokości to 40:33.';
$string['sitenamewithlogo'] = 'Nazwa witryny z logo (tylko widok górny)';

// Customizer Sidebar.
$string['link-text'] = 'Tekst linku';
$string['link-text_help'] = 'Ustaw kolor tekstu linku {$a}';
$string['link-icon'] = 'Ikona linku';
$string['link-icon_help'] = 'Ustaw kolor ikony linku {$a}';
$string['active-link-color'] = 'Kolor aktywnego linku';
$string['active-link-color_help'] = 'Ustaw niestandardowy kolor aktywnego linku {$a}';
$string['active-link-background'] = 'Tło aktywnego linku';
$string['active-link-background_help'] = 'Ustaw niestandardowy kolor tła aktywnego linku {$a}';
$string['link-hover-background'] = 'Tło po najechaniu na link';
$string['link-hover-background_help'] = 'Ustaw kolor tła po najechaniu na link {$a}';
$string['link-hover-text'] = 'Kolor tekstu po najechaniu na link';
$string['link-hover-text_help'] = 'Ustaw kolor tekstu po najechaniu na link {$a}';

// Customizer Footer.
$string['footer'] = 'Stopka';
$string['basic'] = 'Wygląd stopki';
$string['socialall'] = 'Linki do mediów społecznościowych';
$string['advance'] = 'Główny obszar stopki';
$string['footercolumn'] = 'Widżet';
$string['footercolumnwidgetno'] = 'Wybierz ilość widżetów';
$string['footercolumndesc'] = 'Liczba widżetów do wyświetlenia w stopce.';
$string['footercolumntype'] = 'Wybierz typ';
$string['footercolumnsettings'] = 'Ustawienia kolumny stopki';
$string['footercolumntypedesc'] = 'Możesz wybrać typ widżetu stopki';
$string['footercolumnsocial'] = 'Linki do mediów społecznościowych';
$string['footercolumnsocialdesc'] = 'Wybierz wyświetlane linki. Naciśnij i przytrzymaj klawisz "ctrl" na klawiaturze, aby wybrać wiele linków.';
$string['footercolumntitle'] = 'Dodaj tytuł';
$string['footercolumntitledesc'] = 'Dodaj tytuł do tego widżetu.';
$string['footercolumncustomhtml'] = 'Zawartość';
$string['footercolumncustomhtmldesc'] = 'Możesz dostosować zawartość tego widżetu przy użyciu edytora poniżej.';
$string['both'] = 'Oba';
$string['footercolumnsize'] = 'Dostosuj szerokość widżetu';
$string['footercolumnsizenote'] = 'Przeciągnij pionową linię, aby dostosować rozmiar widżetu.';
$string['footercolumnsizedesc'] = 'Możesz ustawić indywidualny rozmiar widżetu.';
$string['footercolumnmenu'] = 'Menu';
$string['footercolumnmenureset'] = 'Menu kolumny stopki';
$string['footercolumnmenudesc'] = 'Link do menu';
$string['footermenu'] = 'Menu';
$string['footermenudesc'] = 'Dodaj menu w widżecie stopki.';
$string['customizermenuadd'] = 'Dodaj pozycję menu';
$string['customizermenuedit'] = 'Edytuj pozycję menu';
$string['customizermenumoveup'] = 'Przesuń pozycję menu do góry';
$string['customizermenuemovedown'] = 'Przesuń pozycję menu w dół';
$string['customizermenuedelete'] = 'Usuń pozycję menu';
$string['menutext'] = 'Tekst';
$string['menuaddress'] = 'Adres';
$string['menuorientation'] = 'Orientacja menu';
$string['menuorientationdesc'] = 'Ustaw orientację menu. Orientacja może być pionowa lub pozioma.';
$string['menuorientationvertical'] = 'Pionowa';
$string['menuorientationhorizontal'] = 'Pozioma';
$string['footerfacebook'] = 'Facebook';
$string['footertwitter'] = 'Twitter';
$string['footerlinkedin'] = 'Linkedin';
$string['footergplus'] = 'Google Plus';
$string['footeryoutube'] = 'Youtube';
$string['footerinstagram'] = 'Instagram';
$string['footerpinterest'] = 'Pinterest';
$string['footerquora'] = 'Quora';
$string['footershowlogo'] = 'Pokaż logo';
$string['footershowlogodesc'] = 'Pokaż logo w stopce pomocniczej.';
$string['footersecondarysocial'] = 'Pokaż linki do mediów społecznościowych';
$string['footersecondarysocialdesc'] = 'Pokaż linki do mediów społecznościowych w stopce pomocniczej.';
$string['footertermsandconditionsshow'] = 'Pokaż Regulamin';
$string['footertermsandconditions'] = 'Link do Regulaminu';
$string['footertermsandconditionsdesc'] = 'Możesz dodać link do strony z Regulaminem.';
$string['footerprivacypolicyshow'] = 'Pokaż Politykę Prywatności';
$string['footerprivacypolicy'] = 'Link do Polityki Prywatności';
$string['footerprivacypolicydesc'] = 'Możesz dodać link do strony z Polityką Prywatności.';
$string['footercopyrightsshow'] = 'Pokaż informacje o prawach autorskich';
$string['footercopyrights'] = 'Treść informacji o prawach autorskich';
$string['footercopyrightsdesc'] = 'Dodaj informacje o prawach autorskich na dole strony.';
$string['footercopyrightstags'] = 'Tagi:<br>[site] - Nazwa strony<br>[year] - Bieżący rok';
$string['termsandconditions'] = 'Regulamin';
$string['privacypolicy'] = 'Polityka Prywatności';
$string['footerfont'] = 'Czcionka';
$string['footerbasiccolumntitle'] = 'Tytuł kolumny';
$string['divider-color'] = 'Kolor dzielnika';
$string['divider-color_help'] = 'Ustaw kolor dzielnika {$a}';
$string['text-hover-color'] = 'Kolor tekstu po najechaniu';
$string['text-hover-color_help'] = 'Ustaw kolor tekstu po najechaniu {$a}';
$string['link-color'] = 'Kolor linku';
$string['link-color_help'] = 'Ustaw kolor linku {$a}';
$string['link-hover-color'] = 'Kolor linku po najechaniu';
$string['link-hover-color_help'] = 'Ustaw kolor linku po najechaniu {$a}';
$string['icon-default-color'] = 'Kolor ikony';
$string['icon-default-color_help'] = 'Kolor ikony {$a}';
$string['icon-hover-color'] = 'Kolor ikony po najechaniu';
$string['icon-hover-color_help'] = 'Kolor ikony po najechaniu {$a}';
$string['footerfontsize_help'] = 'Ustaw rozmiar czcionki';
$string['footer-color-heading1'] = 'Kolory stopki';
$string['footer-color-heading2'] = 'Linki stopki';
$string['footer-color-heading3'] = 'Ikony stopki';

$string['footerfontfamily'] = 'Rodzina czcionek';
$string['footerfontfamily_help'] = 'Rodzina czcionek';
$string['footerfontsize'] = 'Rozmiar czcionki';
$string['footerfontsize_help'] = 'Rozmiar czcionki stopki';
$string['footerfontweight'] = 'Grubość czcionki';
$string['footerfontweight_help'] = 'Grubość czcionki stopki';
$string['footerfonttext-transform'] = 'Wielkość liter';
$string['footerfonttext-transform_help'] = 'Wielkość liter';
$string['footerfontlineheight'] = 'Odstęp międzywierszowy';
$string['footerfontlineheight_help'] = 'Odstęp międzywierszowy stopki';
$string['footerfontltrspace'] = 'Odstęp międzyliterowy';
$string['footerfontltrspace_help'] = 'Ustawienie odstępu międzyliterowego {$a}';

$string['footer-columntitle-fontfamily'] = 'Rodzina czcionek';
$string['footer-columntitle-fontfamily_help'] = 'Rodzina czcionek';
$string['footer-columntitle-fontsize'] = 'Rozmiar czcionki';
$string['footer-columntitle-fontsize_help'] = 'Rozmiar czcionki tytułu kolumny stopki';
$string['footer-columntitle-fontweight'] = 'Grubość czcionki';
$string['footer-columntitle-fontweight_help'] = 'Grubość czcionki tytułu kolumny stopki';
$string['footer-columntitle-textransform'] = 'Wielkość liter';
$string['footer-columntitle-textransform_help'] = 'Wielkość liter';
$string['footer-columntitle-lineheight'] = 'Odstęp międzywierszowy';
$string['footer-columntitle-lineheight_help'] = 'Odstęp międzywierszowy tytułu kolumny stopki';
$string['footer-columntitle-ltrspace'] = 'Odstęp międzyliterowy';
$string['footer-columntitle-ltrspace_help'] = 'Odstęp międzyliterowy tytułu kolumny stopki';
$string['footer-columntitle-color'] = 'Kolor';
$string['footer-columntitle-color_help'] = 'Kolor tekstu {$a}';
$string['openinnewtab'] = 'Otwórz w nowej karcie';
$string['useheaderlogo'] = 'Użyj tego samego logo z nagłówka';
$string['secondaryfooterlogo'] = 'Dodaj nowe logo';
$string['logosettings'] = 'Ustawienia logo';
$string['loginformsettings'] = 'Ustawienia formularza logowania';
$string['loginpagesettings'] = 'Ustawienia strony logowania';
$string['footersecondary'] = 'Dolny obszar stopki';
$string['footer-columns'] = 'Kolumny stopki';
$string['footer-columntitle-color_help'] = 'Ustawienie koloru tekstu {$a}';
$string['footer-logo-color'] = 'Wybierz kolor ikony lub tekstu';
$string['footer-logo-color_help'] = 'Wybierz kolor ikony lub tekstu';

// Customizer login.
$string['login'] = 'Logowanie';
$string['panel'] = 'Panel';
$string['page'] = 'Strona';
$string['loginbackgroundopacity'] = 'Przezroczystość nakładki tła';
$string['loginbackgroundopacity_help'] = 'Zastosuj nakładkę na tło strony logowania.';
$string['loginpanelbackgroundcolor_help'] = 'Zastosuj kolor tła do panelu logowania.';
$string['loginpaneltextcolor_help'] = 'Zastosuj kolor tekstu do panelu logowania.';
$string['loginpanelcontentcolor_help'] = 'Zastosuj kolor tekstu do zawartości panelu logowania.';
$string['loginpanellinkcolor_help'] = 'Zastosuj kolor linku do panelu logowania.';
$string['loginpanellinkhovercolor_help'] = 'Zastosuj kolor linku po najechaniu na panel logowania.';
$string['login-panel-position'] = 'Pozycja panelu logowania';
$string['login-panel-position_help'] = 'Ustaw pozycję panelu logowania i rejestracji.';
$string['login-page-info'] = '<p><b>Uwaga:</b> Strona logowania nie może być podglądana w trybie dostosowywania, ponieważ tylko niezalogowani użytkownicy mogą ją wyświetlać. Możesz przetestować ustawienia, zapisując i otwierając stronę logowania w trybie prywatnego przeglądania.</p>';
$string['login-page-setting'] = 'Styl tła strony';
$string['login-page-backgroundgradient1'] = 'Wybierz kolor 1';
$string['login-page-backgroundgradient2'] = 'Wybierz kolor 2';
$string['loginpanelbackgroundcolor'] = 'Kolor tła strony';
$string['loginpagebackgroundcolor'] = 'Wybierz kolor tła';
$string['loginpagebackgroundcolor_help'] = 'Ustaw tło strony logowania. Możesz wybrać kolor, gradient lub obraz.';
$string['login-page-background_help'] = 'Zastosuj kolor tła do panelu logowania.';

/*Customizer Strings*/
$string['primary'] = 'Podstawowy';

$string['dashboardsettingdesc'] = 'Ustawienia dotyczące pulpitu nawigacyjnego';
$string['dashboardsetting'] = 'Pulpit nawigacyjny';
$string['dashboardpage'] = 'Strona pulpitu nawigacyjnego';
$string['enabledashboardcoursestats'] = 'Włącz statystyki kursów na pulpicie nawigacyjnym';
$string['enabledashboardcoursestatsdesc'] = 'Jeśli włączone, będą wyświetlane statystyki kursów na stronie pulpitu nawigacyjnego.';

$string['customizecontrolsclose'] = "Przycisk zamknięcia dostosowywania";

// Quick setup customizer.
$string['quicksetup'] = 'Szybka konfiguracja';
$string['pallet'] = 'Paleta';
$string['colorpallet'] = 'Palety kolorów';
$string['currentpallet'] = 'Aktualna paleta';
$string['currentfont'] = 'Aktualna czcionka';
$string['colorpalletdesc'] = 'Opis palet kolorów';
$string['preset1'] = 'Ustawienie wstępne 1';
$string['preset2'] = 'Ustawienie wstępne 2';
$string['sitefavicon'] = 'Ikona witryny';

$string['themecolors'] = 'Kolory motywu';
$string['brandcolors-heading'] = 'Kolory marki';
$string['border-color'] = 'Kolor obramowania';
$string['border-hover-color'] = 'Kolor obramowania po najechaniu';
$string['smart-colors-heading'] = 'Zastosuj kolory globalne';
$string['smart-colors-info'] = "<p>Kolory globalne i ich odcienie/odcień będą stosowane na stronie, aby stworzyć wizualnie oszałamiającą kombinację kolorów</p><p><b>Uwaga: </b>Masz elastyczność w personalizacji kolorów poszczególnych elementów w dowolnym momencie, po prostu odwiedzając ich konkretne ustawienia.</p>";
$string['apply'] = "Zastosuj";
$string['backgroundsettings'] = 'Ustawienia tła';

$string['ascent-background-color'] = 'Kolor tła Ascent';
$string['ascent-background-color_help'] = 'Ustaw kolor tła Ascent. Ten kolor będzie stosowany jako tło dla tagów na stronie, z wyjątkiem tagów na kartach kursów i banerów nagłówka kursów.';
$string['element-background-color'] = 'Kolor tła elementu';
$string['element-background-color_help'] = 'Ustaw kolor tła elementu. Ten kolor jest stosowany jako tło dla małych tekstów, tła podczas najechania na teksty rozwijane, tła nagłówków sekcji, podpowiedzi itp.';

$string['light-border-color'] = 'Kolor lekkiego obramowania';
$string['themecolors-lightbordercolor_help'] = 'Ustaw kolor lekkiego obramowania. Ten kolor jest stosowany jako obramowanie dla elementów z białym tłem, takich jak rozwijane menu powiadomień na nagłówku, karty kursów, wyszukiwanie kursów i linie podziału w elementach bloku itp.';

$string['medium-border-color'] = 'Kolor średniego obramowania';
$string['themecolors-mediumbordercolor_help'] = 'Ustaw kolor średniego obramowania. Ten kolor jest stosowany jako kolor obramowania i kolor podziału. Jest on specjalnie stosowany jako kolor obramowania dla rozwijanych menu i pola wyszukiwania, a także jako kolor tła dla elementów, dla których stosowany jest kolor tła elementu (ustawienie koloru tła elementu można znaleźć w sekcji <b>Kolory motywu > Ustawienia tła</b>), na przykład tła dla małych tekstów, tła nagłówków sekcji, podpowiedzi itp.';
$string['borderssettings'] = 'Ustawienia obramowań';

// Quick Menu settings.
$string['enablequickmenu'] = 'Włącz menu szybkich linków';
$string['enablequickmenudesc'] = 'Pływające menu szybkich linków ułatwiające dostęp do stron.';

// Left Navigation Drawer.
$string['createarchivepage'] = 'Strona archiwum kursu';
$string['createanewcourse'] = 'Utwórz nowy kurs';
$string['remuisettings'] = 'Ustawienia RemUI';

$string['bodysettingslinking'] = 'Zaawansowane ustawienia łączenia';
$string['bodysettingslinking_help'] = 'Po włączeniu, ustawienia z małego akapitu i małego tekstu informacyjnego będą połączone z ustawieniami treści.';
$string['bodysettingslinked'] = 'Połączone z ustawieniami treści';
$string['normal-para-font'] = "Zwykły akapit";
$string['smallpara-font'] = "Mały akapit";
$string['smallinfo-font'] = "Mały tekst informacyjny";

$string['interactiveicons'] = 'Interaktywne ikony';
$string['noninteractiveicons'] = 'Nieinteraktywne ikony';
$string['singlecolorsicon'] = "Ikonka jednokolorowa";
$string['scicon-color'] = 'Kolor';
$string['scicon-color_help'] = 'Kolor ikonki jednokolorowej w stanie spoczynku.';
$string['scicon-hover'] = 'Najedź';
$string['scicon-hover_help'] = 'Kolor ikonki jednokolorowej po najechaniu na nią myszą.';
$string['scicon-active'] = 'Aktywna';
$string['scicon-active_help'] = 'Kolor aktywnego stanu jednokolorowej ikony';

$string['dualcolorsicon'] = "Ikona dwukolorowa";
$string['dcicon-color'] = 'Kolor';
$string['dcicon-color_help'] = 'Kolor spoczynkowego stanu dwukolorowej ikony';
$string['dcicon-hover'] = 'Najedź';
$string['dcicon-hover_help'] = 'Kolor stanu najeżdżenia na dwukolorowej ikonie';
$string['dcicon-active'] = 'Aktywny';
$string['dcicon-active_help'] = 'Kolor aktywnego stanu dwukolorowej ikony';

$string['non-interactive-color'] = 'Kolor';
$string['non-interactive-color_help'] = 'Kolor nieinteraktywnej ikony';
$string['textlink'] = 'Link tekstowy';

$string['header-logo-setting'] = 'Ustawienia logo nagłówka';
$string['logo-bg-color'] = 'Kolor tła logo';
$string['logo-bg-color_help'] = 'Ustaw kolor tła dla logo marki w nagłówku.';
$string['header-design-settings'] = 'Ustawienia projektowania nagłówka';
$string['hide-show-menu-item'] = 'Ukryj/Pokaż element menu';
$string['hide-dashboard'] = 'Ukryj panel';
$string['hide-dashboard_help'] = 'Po włączeniu tej opcji element "Panel" w nagłówku zostanie ukryty.';
$string['hide-home'] = 'Ukryj Stronę główną';
$string['hide-home_help'] = 'Po włączeniu tej opcji element "Strona główna" w nagłówku zostanie ukryty.';
$string['hide-my-courses'] = 'Ukryj Moje kursy';
$string['hide-my-courses_help'] = 'Po włączeniu tej opcji elementy "Moje kursy" i zagnieżdżone elementy kursów w nagłówku zostaną ukryte.';
$string['hide-site-admin'] = 'Ukryj administrację strony';
$string['hide-site-admin_help'] = 'Po włączeniu tej opcji element "Administracja strony" w nagłówku zostanie ukryty.';
$string['hide-recent-courses'] = 'Ukryj ostatnie kursy';
$string['hide-recent-courses_help'] = 'Po włączeniu tej opcji rozwijane menu "Ostatnie kursy" w nagłówku zostanie ukryte.';
$string['header-menu-element-bg-color'] = 'Kolor tła elementu menu';
$string['header-menu-element-bg-color_help'] = 'Kolor tła elementu menu';
$string['header-menu-divider-bg-color'] = 'Kolor podziałki elementów menu';
$string['header-menu-divider-bg-color_help'] = 'Kolor podziałki elementów menu';
$string['hds-iconcolor'] = 'Kolor ikon w menu głównym';
$string['hds-boxshadow'] = 'Cień pudełka nagłówka';

$string['hds-menuitems'] = 'Elementy menu głównego';
$string['hds-menu-fontsize_desc'] = 'Ustaw rozmiar czcionki dla elementów menu nagłówka';
$string['hds-menu-color'] = 'Kolor elementów menu';
$string['hds-menu-color_desc'] = 'Ustaw kolor elementów menu nagłówka';
$string['hds-menu-hover-color'] = 'Kolor podświetlenia elementów menu';
$string['hds-menu-hover-color_desc'] = 'Ustaw kolor podświetlenia elementów menu nagłówka';
$string['hds-menu-active-color'] = 'Kolor aktywnego elementu menu';
$string['hds-menu-active-color_desc'] = 'Ustaw kolor aktywnego elementu menu nagłówka';

$string['hds-icon-color'] = 'Kolor ikon';
$string['hds-icon-color_help'] = 'Kolor ikon menu głównego';
$string['hds-icon-hover-color'] = 'Kolor podświetlenia ikon';
$string['hds-icon-hover-color_help'] = 'Kolor podświetlenia ikon menu głównego';
$string['hds-icon-active-color'] = 'Kolor aktywnych ikon';
$string['hds-icon-active-color_help'] = 'Kolor aktywnych ikon menu głównego';

$string['preset1'] = "Ustawienie 1";
$string['preset2'] = "Ustawienie 2";
$string['preset3'] = "Ustawienie 3";
$string['fonts'] = "Czcionki";
$string['show'] = "Pokaż";
$string['hide'] = "Ukryj";

$string['other-bg-color'] = 'Inne kolory tła';
$string['text-link-panel'] = 'Link tekstowy';
$string['colorpalletes'] = 'Palety kolorów';
$string['selectpallete'] = 'Wybierz paletę';
$string['selectfont'] = 'Wybierz czcionkę';

$string['socialiconspanel'] = "Panel ikon społecznościowych";
$string['social-icons-info'] = "<p>Aby wyświetlić ikony mediów społecznościowych na dole każdej kolumny z treścią, przejdź do <b>Stopka > Główna część stopki > Widget > Wybierz typ = Treść </b> i włącz opcję pokazania ikon mediów społecznościowych.</p>";
$string['social-icons-heading'] = "Ikonki mediów społecznościowych";
$string["custommenulinktext"] = 'Niestandardowe elementy menu';
$string["custommenulink"] = '<h6>Niestandardowe elementy menu</h6><p>Aby dodać/edytować/usunąć niestandardowe elementy menu, przejdź do Zarządzanie witryną > Wygląd > Ustawienia motywu > <a href="{$a}/admin/settings.php?section=themesettings#admin-custommenuitems" target ="_blank" class="text-decoration-none">Niestandardowe elementy menu</a></p>';
$string['note'] = 'Uwaga';
$string['social-media-selection-note'] = "<p>Wciśnij klawisz Ctrl, aby zaznaczyć/odznaczyć media</p>";

$string['editmodeswitch'] = "Przełącznik trybu edycji";
$string['continue'] = 'Kontynuuj';
$string['viewcourse'] = 'Przeglądaj kurs';
$string['hiddencourse'] = 'Ukryty kurs';
$string['openquickmenu'] = 'Otwórz szybkie menu';
$string['closequickmenu'] = 'Zamknij szybkie menu';
$string['start'] = 'Rozpocznij';

$string['readmore'] = 'Czytaj więcej';
$string['readless'] = 'Czytaj mniej';
$string['setting'] = 'Ustawienia';
$string['lastaccess'] = 'Ostatni dostęp';
$string['certificate'] = 'Certyfikaty';
$string['badge'] = 'Odznaki';
$string['firstname'] = 'Imię';
$string['lastname'] = 'Nazwisko';
$string['badgefrom'] = 'Odznaki od {$a}';
$string['timelinenoevenettext'] = 'Brak nadchodzących aktywności';
$string['description'] = 'Opis';
$string['instructorcounttitle'] = "Dodatkowi nauczyciele dostępni w kursie";

$string['personalizer'] = "Personalizacja wizualna";
$string['edwpersonalizer'] = "Personalizacja wizualna";
$string['editinpersonalizer'] = "Edytuj z Personalizer";
$string['activepersonalizer'] = "Przeglądanie w Edwiser Personalizer.";
$string['searchtotalcount'] = 'Wyświetlane wyniki: {$a}';
$string['noresutssearchmsg'] = "<h4 class ='p-p-6 text-center m-0 '>Nic do wyświetlenia</h4>";
$string['globarsearchresult'] = "Globalne wyniki wyszukiwania";
$string['searchresultdesctext'] = 'Pokaż wyniki dla';
$string['noresultfoundmg'] = "<h4 class ='p-p-6 text-center m-0 '>Nie znaleziono wyników</h4>";

$string['enrol_relatedcourses'] = 'Powiązane kursy';
$string['enrol_latestcourses'] = 'Najnowsze kursy';
$string['enrol_coursecardesc'] = 'Odkryj idealny program w naszych kursach.';
$string['enrol_viewall'] = 'Zobacz wszystkie';

$string['showrelatedcourse'] = "Pokaż powiązane kursy";
$string['showrelatedcoursedesc'] = "Włącz tę opcję, aby pokazać powiązane kursy na stronie zapisów na kurs.";

$string['showlatestcourse'] = 'Pokaż najnowsze kursy';
$string['showlatestcoursedesc'] = 'Włącz tę opcję, aby pokazać najnowsze kursy na stronie zapisów na kurs.';

$string['latestcoursecount'] = 'Najnowsze kursy Liczba bloków';
$string['latestcoursecountdesc'] = 'Ustaw numer dla najnowszych kursów wyświetlanych na stronie rejestracji';

$string['allcourescattext'] = 'Wszystkie kategorie';
$string['archivecoursecounttext'] = 'Kursy';
$string['coursecardlessonstext'] = 'Lekcje';
$string['prevsectionbuttontext'] = 'Poprzedni sekcja';
$string['nextsectionbuttontext'] = 'Następny sekcja';

$string['eight'] = '8';
$string['twelve'] = '12';
$string['sixteen'] = '16';
$string['twenty'] = '20';

$string['resume'] = 'Wznów';
$string['start'] = 'Rozpocznij';
$string['completed'] = 'Zakończony';

$string['siteannouncementheading'] = 'Ogłoszenie dla całej witryny';
$string['siteannouncementheadingdesc'] = 'Włącz ogłoszenie dla wszystkich użytkowników witryny.';
$string['seosettingsheading'] = 'Ustawienia SEO';
$string['seosettingsheadingdesc'] = 'Optymalizuj widoczność swojej witryny w wyszukiwarkach.';
$string['sitecustomizationhead'] = 'Dostosowanie witryny';
$string['sitecustomizationheaddesc'] = 'Wybierz czcionki, rozmiar układu stron i dostosuj je za pomocą CSS.';
$string['advancefeatureshead'] = 'Ustawienia zaawansowanych funkcji';
$string['advancefeaturesheaddesc'] = 'Udoskonal swoje doświadczenia w uczeniu się dzięki ustawieniom zaawansowanym.';
$string['mainfooterareahead'] = 'Główny obszar stopki';
$string['mainfooterareaheaddesc'] = 'Ustawienia głównego obszaru stopki.';

// heading-advance weight settings
$string['heading-adv-setting'] = 'Ustawienia wagi czcionki';
$string['heading-regular-fontweight'] = 'Waga czcionki standardowa';
$string['heading-semibold-fontweight'] = 'Waga czcionki półgruba';
$string['heading-bold-fontweight'] = 'Waga czcionki pogrubiona';
$string['heading-exbold-fontweight'] = 'Waga czcionki bardzo pogrubiona';

// Usage tracking.
$string["usagedatatracker"] = "Usage data tracker";
$string['enableusagetracking'] = "Włącz śledzenie użycia";
$string['enableusagetrackingdesc'] = "<strong>UWAGA ŚLEDZENIA UŻYTKOWANIA</strong>

<hr class='text-muted' />

<p>Od tej pory Edwiser będzie zbierać anonimowe dane w celu generowania statystyk użytkowania produktu.</p>

<p>Te informacje pomogą nam poprowadzić rozwój we właściwym kierunku i zapewnić sukces społeczności Edwiser.</p>

<p>Powiedziawszy, że nie zbieramy twoich danych osobowych ani twoich studentów podczas tego procesu. Możesz wyłączyć to we wtyczce, ilekroć chcesz zrezygnować z tej usługi.</p>

<p>Przegląd zebranych danych jest dostępny <strong><a href='https://forums.edwiser.org/topic/67/anonymously-tracking-the-usage-of-edwiser-products' target='_blank'>tutaj</a></strong>.</p>";

$string['profileinterestinfo'] = 'Aby edytować zainteresowania, przejdź do Ustawień profilu -> Edytuj profil ->';
$string['profileinterest'] = 'Zainteresowania';
$string['citytowntext'] = 'Miasto/Miejscowość';
$string['selectcountrystring'] = 'Wybierz kraj...';
