<?php
// This file is part of moodle single sign on plugin

defined('MOODLE_INTERNAL') || die;

global $CFG, $PAGE;

$PAGE->requires->js(new moodle_url('/auth/wdmwpmoodle/js/sso_settings.js'));
$PAGE->requires->js_call_amd('auth_wdmwpmoodle/sso_settings', 'init');

if ($ADMIN->fulltree) {
    // Introductory explanation.
    $settings->add(new admin_setting_heading('auth_wdmwpmoodle/description', '', new lang_string('auth_wdmwpmoodledescription', 'auth_wdmwpmoodle')));

    /*
     * Secreate key settings filed.
     */
    $connection = isset($CFG->eb_connection_settings) ? unserialize($CFG->eb_connection_settings) : false;
    if( !empty($connection)) {
        foreach ($connection as $key => $value) {
            $wp_url = $value['wp_url'] . '/wp-admin/admin.php?page=eb-settings&tab=sso_settings_general';
            $wp_url = ' <a href="' . $wp_url . '" target="_blank">here</a>';
            break;
        }
    }
    $wp_site_url = get_config('auth_wdmwpmoodle', 'wpsiteurl');
    if (!empty($wp_site_url)) {
        $wp_url = ' <a href="' . $wp_site_url . '/wp-admin/admin.php?page=eb-settings&tab=sso_settings_general" target="_blank">here</a>';
    }
    $settings->add(new admin_setting_configtext(
        'auth_wdmwpmoodle/sharedsecret',
        get_string('auth_wdmwpmoodle_secretkey', 'auth_wdmwpmoodle'),
        get_string('auth_wdmwpmoodle_secretkey_desc', 'auth_wdmwpmoodle') . $wp_url,
        '',
        PARAM_RAW
    ));

    $settings->add(
        new admin_setting_configtext(
            'auth_wdmwpmoodle/wpsiteurl',
            get_string('auth_wdmwpmoodle_wpsiteurl_lbl', 'auth_wdmwpmoodle'),
            get_string('auth_wdmwpmoodle_wpsiteurl_desc', 'auth_wdmwpmoodle'),
            '',
            PARAM_RAW
        )
    );

    /*
     * Setting filed for the logout redirect.
     */
    $settings->add(new admin_setting_configtext(
        'auth_wdmwpmoodle/logoutredirecturl',
        get_string('auth_wdmwpmoodle_logoutredirecturl_lbl', 'auth_wdmwpmoodle'),
        get_string('auth_wdmwpmoodle_logoutredirecturl_desc', 'auth_wdmwpmoodle'),
        '',
        PARAM_RAW
    ));


    // Setting to enable login with WordPress Button.
    $settings->add(new admin_setting_configcheckbox(
        'auth_wdmwpmoodle/wploginenablebtn',
        get_string('auth_wdmwpmoodle_wploginenablebtn_lbl', 'auth_wdmwpmoodle'),
        get_string('auth_wdmwpmoodle_wploginenablebtn_desc', 'auth_wdmwpmoodle'),
        '',
        PARAM_RAW
    ));


    // Setting to show text for the button.
    $settings->add(new admin_setting_configtext(
        'auth_wdmwpmoodle/wploginbtntext',
        get_string('auth_wdmwpmoodle_wploginbtntext_lbl', 'auth_wdmwpmoodle'),
        get_string('auth_wdmwpmoodle_wploginbtntext_desc', 'auth_wdmwpmoodle'),
        '',
        PARAM_RAW
    ));

    // Add wordpress login icon upload.
    $settings->add(new admin_setting_configstoredfile(
        'auth_wdmwpmoodle/wploginbtnicon',
        get_string('auth_wdmwpmoodle_wploginbtnicon_lbl', 'auth_wdmwpmoodle'),
        get_string('auth_wdmwpmoodle_wploginbtnicon_desc', 'auth_wdmwpmoodle'),
        'wploginbtnicon',
        0,
        array('maxfiles' => 1, 'accepted_types' => array('image'))
    ));

}
