!function(global,factory){"object"==typeof exports&&"undefined"!=typeof module?module.exports=factory():"function"==typeof define&&define.amd?define("block_remuiblck/chartjs-lazy",factory):(global=global||self).Chart=factory()}(window,(function(){"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self&&self;function commonjsRequire(){throw new Error("Dynamic requires are not currently supported by rollup-plugin-commonjs")}function createCommonjsModule(fn,module){return fn(module={exports:{}},module.exports),module.exports}var colorName={aliceblue:[240,248,255],antiquewhite:[250,235,215],aqua:[0,255,255],aquamarine:[127,255,212],azure:[240,255,255],beige:[245,245,220],bisque:[255,228,196],black:[0,0,0],blanchedalmond:[255,235,205],blue:[0,0,255],blueviolet:[138,43,226],brown:[165,42,42],burlywood:[222,184,135],cadetblue:[95,158,160],chartreuse:[127,255,0],chocolate:[210,105,30],coral:[255,127,80],cornflowerblue:[100,149,237],cornsilk:[255,248,220],crimson:[220,20,60],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgoldenrod:[184,134,11],darkgray:[169,169,169],darkgreen:[0,100,0],darkgrey:[169,169,169],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkseagreen:[143,188,143],darkslateblue:[72,61,139],darkslategray:[47,79,79],darkslategrey:[47,79,79],darkturquoise:[0,206,209],darkviolet:[148,0,211],deeppink:[255,20,147],deepskyblue:[0,191,255],dimgray:[105,105,105],dimgrey:[105,105,105],dodgerblue:[30,144,255],firebrick:[178,34,34],floralwhite:[255,250,240],forestgreen:[34,139,34],fuchsia:[255,0,255],gainsboro:[220,220,220],ghostwhite:[248,248,255],gold:[255,215,0],goldenrod:[218,165,32],gray:[128,128,128],green:[0,128,0],greenyellow:[173,255,47],grey:[128,128,128],honeydew:[240,255,240],hotpink:[255,105,180],indianred:[205,92,92],indigo:[75,0,130],ivory:[255,255,240],khaki:[240,230,140],lavender:[230,230,250],lavenderblush:[255,240,245],lawngreen:[124,252,0],lemonchiffon:[255,250,205],lightblue:[173,216,230],lightcoral:[240,128,128],lightcyan:[224,255,255],lightgoldenrodyellow:[250,250,210],lightgray:[211,211,211],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightsalmon:[255,160,122],lightseagreen:[32,178,170],lightskyblue:[135,206,250],lightslategray:[119,136,153],lightslategrey:[119,136,153],lightsteelblue:[176,196,222],lightyellow:[255,255,224],lime:[0,255,0],limegreen:[50,205,50],linen:[250,240,230],magenta:[255,0,255],maroon:[128,0,0],mediumaquamarine:[102,205,170],mediumblue:[0,0,205],mediumorchid:[186,85,211],mediumpurple:[147,112,219],mediumseagreen:[60,179,113],mediumslateblue:[123,104,238],mediumspringgreen:[0,250,154],mediumturquoise:[72,209,204],mediumvioletred:[199,21,133],midnightblue:[25,25,112],mintcream:[245,255,250],mistyrose:[255,228,225],moccasin:[255,228,181],navajowhite:[255,222,173],navy:[0,0,128],oldlace:[253,245,230],olive:[128,128,0],olivedrab:[107,142,35],orange:[255,165,0],orangered:[255,69,0],orchid:[218,112,214],palegoldenrod:[238,232,170],palegreen:[152,251,152],paleturquoise:[175,238,238],palevioletred:[219,112,147],papayawhip:[255,239,213],peachpuff:[255,218,185],peru:[205,133,63],pink:[255,192,203],plum:[221,160,221],powderblue:[176,224,230],purple:[128,0,128],rebeccapurple:[102,51,153],red:[255,0,0],rosybrown:[188,143,143],royalblue:[65,105,225],saddlebrown:[139,69,19],salmon:[250,128,114],sandybrown:[244,164,96],seagreen:[46,139,87],seashell:[255,245,238],sienna:[160,82,45],silver:[192,192,192],skyblue:[135,206,235],slateblue:[106,90,205],slategray:[112,128,144],slategrey:[112,128,144],snow:[255,250,250],springgreen:[0,255,127],steelblue:[70,130,180],tan:[210,180,140],teal:[0,128,128],thistle:[216,191,216],tomato:[255,99,71],turquoise:[64,224,208],violet:[238,130,238],wheat:[245,222,179],white:[255,255,255],whitesmoke:[245,245,245],yellow:[255,255,0],yellowgreen:[154,205,50]},conversions=createCommonjsModule((function(module){var reverseKeywords={};for(var key in colorName)colorName.hasOwnProperty(key)&&(reverseKeywords[colorName[key]]=key);var convert=module.exports={rgb:{channels:3,labels:"rgb"},hsl:{channels:3,labels:"hsl"},hsv:{channels:3,labels:"hsv"},hwb:{channels:3,labels:"hwb"},cmyk:{channels:4,labels:"cmyk"},xyz:{channels:3,labels:"xyz"},lab:{channels:3,labels:"lab"},lch:{channels:3,labels:"lch"},hex:{channels:1,labels:["hex"]},keyword:{channels:1,labels:["keyword"]},ansi16:{channels:1,labels:["ansi16"]},ansi256:{channels:1,labels:["ansi256"]},hcg:{channels:3,labels:["h","c","g"]},apple:{channels:3,labels:["r16","g16","b16"]},gray:{channels:1,labels:["gray"]}};for(var model in convert)if(convert.hasOwnProperty(model)){if(!("channels"in convert[model]))throw new Error("missing channels property: "+model);if(!("labels"in convert[model]))throw new Error("missing channel labels property: "+model);if(convert[model].labels.length!==convert[model].channels)throw new Error("channel and label counts mismatch: "+model);var channels=convert[model].channels,labels=convert[model].labels;delete convert[model].channels,delete convert[model].labels,Object.defineProperty(convert[model],"channels",{value:channels}),Object.defineProperty(convert[model],"labels",{value:labels})}convert.rgb.hsl=function(rgb){var h,l,r=rgb[0]/255,g=rgb[1]/255,b=rgb[2]/255,min=Math.min(r,g,b),max=Math.max(r,g,b),delta=max-min;return max===min?h=0:r===max?h=(g-b)/delta:g===max?h=2+(b-r)/delta:b===max&&(h=4+(r-g)/delta),(h=Math.min(60*h,360))<0&&(h+=360),l=(min+max)/2,[h,100*(max===min?0:l<=.5?delta/(max+min):delta/(2-max-min)),100*l]},convert.rgb.hsv=function(rgb){var rdif,gdif,bdif,h,s,r=rgb[0]/255,g=rgb[1]/255,b=rgb[2]/255,v=Math.max(r,g,b),diff=v-Math.min(r,g,b),diffc=function(c){return(v-c)/6/diff+.5};return 0===diff?h=s=0:(s=diff/v,rdif=diffc(r),gdif=diffc(g),bdif=diffc(b),r===v?h=bdif-gdif:g===v?h=1/3+rdif-bdif:b===v&&(h=2/3+gdif-rdif),h<0?h+=1:h>1&&(h-=1)),[360*h,100*s,100*v]},convert.rgb.hwb=function(rgb){var r=rgb[0],g=rgb[1],b=rgb[2];return[convert.rgb.hsl(rgb)[0],100*(1/255*Math.min(r,Math.min(g,b))),100*(b=1-1/255*Math.max(r,Math.max(g,b)))]},convert.rgb.cmyk=function(rgb){var k,r=rgb[0]/255,g=rgb[1]/255,b=rgb[2]/255;return[100*((1-r-(k=Math.min(1-r,1-g,1-b)))/(1-k)||0),100*((1-g-k)/(1-k)||0),100*((1-b-k)/(1-k)||0),100*k]},convert.rgb.keyword=function(rgb){var reversed=reverseKeywords[rgb];if(reversed)return reversed;var currentClosestKeyword,x,y,currentClosestDistance=1/0;for(var keyword in colorName)if(colorName.hasOwnProperty(keyword)){var value=colorName[keyword],distance=(x=rgb,y=value,Math.pow(x[0]-y[0],2)+Math.pow(x[1]-y[1],2)+Math.pow(x[2]-y[2],2));distance<currentClosestDistance&&(currentClosestDistance=distance,currentClosestKeyword=keyword)}return currentClosestKeyword},convert.keyword.rgb=function(keyword){return colorName[keyword]},convert.rgb.xyz=function(rgb){var r=rgb[0]/255,g=rgb[1]/255,b=rgb[2]/255;return[100*(.4124*(r=r>.04045?Math.pow((r+.055)/1.055,2.4):r/12.92)+.3576*(g=g>.04045?Math.pow((g+.055)/1.055,2.4):g/12.92)+.1805*(b=b>.04045?Math.pow((b+.055)/1.055,2.4):b/12.92)),100*(.2126*r+.7152*g+.0722*b),100*(.0193*r+.1192*g+.9505*b)]},convert.rgb.lab=function(rgb){var xyz=convert.rgb.xyz(rgb),x=xyz[0],y=xyz[1],z=xyz[2];return y/=100,z/=108.883,x=(x/=95.047)>.008856?Math.pow(x,1/3):7.787*x+16/116,[116*(y=y>.008856?Math.pow(y,1/3):7.787*y+16/116)-16,500*(x-y),200*(y-(z=z>.008856?Math.pow(z,1/3):7.787*z+16/116))]},convert.hsl.rgb=function(hsl){var t1,t2,t3,rgb,val,h=hsl[0]/360,s=hsl[1]/100,l=hsl[2]/100;if(0===s)return[val=255*l,val,val];t1=2*l-(t2=l<.5?l*(1+s):l+s-l*s),rgb=[0,0,0];for(var i=0;i<3;i++)(t3=h+1/3*-(i-1))<0&&t3++,t3>1&&t3--,val=6*t3<1?t1+6*(t2-t1)*t3:2*t3<1?t2:3*t3<2?t1+(t2-t1)*(2/3-t3)*6:t1,rgb[i]=255*val;return rgb},convert.hsl.hsv=function(hsl){var h=hsl[0],s=hsl[1]/100,l=hsl[2]/100,smin=s,lmin=Math.max(l,.01);return s*=(l*=2)<=1?l:2-l,smin*=lmin<=1?lmin:2-lmin,[h,100*(0===l?2*smin/(lmin+smin):2*s/(l+s)),100*((l+s)/2)]},convert.hsv.rgb=function(hsv){var h=hsv[0]/60,s=hsv[1]/100,v=hsv[2]/100,hi=Math.floor(h)%6,f=h-Math.floor(h),p=255*v*(1-s),q=255*v*(1-s*f),t=255*v*(1-s*(1-f));switch(v*=255,hi){case 0:return[v,t,p];case 1:return[q,v,p];case 2:return[p,v,t];case 3:return[p,q,v];case 4:return[t,p,v];case 5:return[v,p,q]}},convert.hsv.hsl=function(hsv){var lmin,sl,l,h=hsv[0],s=hsv[1]/100,v=hsv[2]/100,vmin=Math.max(v,.01);return l=(2-s)*v,sl=s*vmin,[h,100*(sl=(sl/=(lmin=(2-s)*vmin)<=1?lmin:2-lmin)||0),100*(l/=2)]},convert.hwb.rgb=function(hwb){var i,v,f,n,r,g,b,h=hwb[0]/360,wh=hwb[1]/100,bl=hwb[2]/100,ratio=wh+bl;switch(ratio>1&&(wh/=ratio,bl/=ratio),f=6*h-(i=Math.floor(6*h)),0!=(1&i)&&(f=1-f),n=wh+f*((v=1-bl)-wh),i){default:case 6:case 0:r=v,g=n,b=wh;break;case 1:r=n,g=v,b=wh;break;case 2:r=wh,g=v,b=n;break;case 3:r=wh,g=n,b=v;break;case 4:r=n,g=wh,b=v;break;case 5:r=v,g=wh,b=n}return[255*r,255*g,255*b]},convert.cmyk.rgb=function(cmyk){var c=cmyk[0]/100,m=cmyk[1]/100,y=cmyk[2]/100,k=cmyk[3]/100;return[255*(1-Math.min(1,c*(1-k)+k)),255*(1-Math.min(1,m*(1-k)+k)),255*(1-Math.min(1,y*(1-k)+k))]},convert.xyz.rgb=function(xyz){var r,g,b,x=xyz[0]/100,y=xyz[1]/100,z=xyz[2]/100;return g=-.9689*x+1.8758*y+.0415*z,b=.0557*x+-.204*y+1.057*z,r=(r=3.2406*x+-1.5372*y+-.4986*z)>.0031308?1.055*Math.pow(r,1/2.4)-.055:12.92*r,g=g>.0031308?1.055*Math.pow(g,1/2.4)-.055:12.92*g,b=b>.0031308?1.055*Math.pow(b,1/2.4)-.055:12.92*b,[255*(r=Math.min(Math.max(0,r),1)),255*(g=Math.min(Math.max(0,g),1)),255*(b=Math.min(Math.max(0,b),1))]},convert.xyz.lab=function(xyz){var x=xyz[0],y=xyz[1],z=xyz[2];return y/=100,z/=108.883,x=(x/=95.047)>.008856?Math.pow(x,1/3):7.787*x+16/116,[116*(y=y>.008856?Math.pow(y,1/3):7.787*y+16/116)-16,500*(x-y),200*(y-(z=z>.008856?Math.pow(z,1/3):7.787*z+16/116))]},convert.lab.xyz=function(lab){var x,y,z,l=lab[0];x=lab[1]/500+(y=(l+16)/116),z=y-lab[2]/200;var y2=Math.pow(y,3),x2=Math.pow(x,3),z2=Math.pow(z,3);return y=y2>.008856?y2:(y-16/116)/7.787,x=x2>.008856?x2:(x-16/116)/7.787,z=z2>.008856?z2:(z-16/116)/7.787,[x*=95.047,y*=100,z*=108.883]},convert.lab.lch=function(lab){var h,l=lab[0],a=lab[1],b=lab[2];return(h=360*Math.atan2(b,a)/2/Math.PI)<0&&(h+=360),[l,Math.sqrt(a*a+b*b),h]},convert.lch.lab=function(lch){var hr,l=lch[0],c=lch[1];return hr=lch[2]/360*2*Math.PI,[l,c*Math.cos(hr),c*Math.sin(hr)]},convert.rgb.ansi16=function(args){var r=args[0],g=args[1],b=args[2],value=1 in arguments?arguments[1]:convert.rgb.hsv(args)[2];if(0===(value=Math.round(value/50)))return 30;var ansi=30+(Math.round(b/255)<<2|Math.round(g/255)<<1|Math.round(r/255));return 2===value&&(ansi+=60),ansi},convert.hsv.ansi16=function(args){return convert.rgb.ansi16(convert.hsv.rgb(args),args[2])},convert.rgb.ansi256=function(args){var r=args[0],g=args[1],b=args[2];return r===g&&g===b?r<8?16:r>248?231:Math.round((r-8)/247*24)+232:16+36*Math.round(r/255*5)+6*Math.round(g/255*5)+Math.round(b/255*5)},convert.ansi16.rgb=function(args){var color=args%10;if(0===color||7===color)return args>50&&(color+=3.5),[color=color/10.5*255,color,color];var mult=.5*(1+~~(args>50));return[(1&color)*mult*255,(color>>1&1)*mult*255,(color>>2&1)*mult*255]},convert.ansi256.rgb=function(args){if(args>=232){var c=10*(args-232)+8;return[c,c,c]}var rem;return args-=16,[Math.floor(args/36)/5*255,Math.floor((rem=args%36)/6)/5*255,rem%6/5*255]},convert.rgb.hex=function(args){var string=(((255&Math.round(args[0]))<<16)+((255&Math.round(args[1]))<<8)+(255&Math.round(args[2]))).toString(16).toUpperCase();return"000000".substring(string.length)+string},convert.hex.rgb=function(args){var match=args.toString(16).match(/[a-f0-9]{6}|[a-f0-9]{3}/i);if(!match)return[0,0,0];var colorString=match[0];3===match[0].length&&(colorString=colorString.split("").map((function(char){return char+char})).join(""));var integer=parseInt(colorString,16);return[integer>>16&255,integer>>8&255,255&integer]},convert.rgb.hcg=function(rgb){var hue,r=rgb[0]/255,g=rgb[1]/255,b=rgb[2]/255,max=Math.max(Math.max(r,g),b),min=Math.min(Math.min(r,g),b),chroma=max-min;return hue=chroma<=0?0:max===r?(g-b)/chroma%6:max===g?2+(b-r)/chroma:4+(r-g)/chroma+4,hue/=6,[360*(hue%=1),100*chroma,100*(chroma<1?min/(1-chroma):0)]},convert.hsl.hcg=function(hsl){var s=hsl[1]/100,l=hsl[2]/100,c=1,f=0;return(c=l<.5?2*s*l:2*s*(1-l))<1&&(f=(l-.5*c)/(1-c)),[hsl[0],100*c,100*f]},convert.hsv.hcg=function(hsv){var s=hsv[1]/100,v=hsv[2]/100,c=s*v,f=0;return c<1&&(f=(v-c)/(1-c)),[hsv[0],100*c,100*f]},convert.hcg.rgb=function(hcg){var h=hcg[0]/360,c=hcg[1]/100,g=hcg[2]/100;if(0===c)return[255*g,255*g,255*g];var mg,pure=[0,0,0],hi=h%1*6,v=hi%1,w=1-v;switch(Math.floor(hi)){case 0:pure[0]=1,pure[1]=v,pure[2]=0;break;case 1:pure[0]=w,pure[1]=1,pure[2]=0;break;case 2:pure[0]=0,pure[1]=1,pure[2]=v;break;case 3:pure[0]=0,pure[1]=w,pure[2]=1;break;case 4:pure[0]=v,pure[1]=0,pure[2]=1;break;default:pure[0]=1,pure[1]=0,pure[2]=w}return mg=(1-c)*g,[255*(c*pure[0]+mg),255*(c*pure[1]+mg),255*(c*pure[2]+mg)]},convert.hcg.hsv=function(hcg){var c=hcg[1]/100,v=c+hcg[2]/100*(1-c),f=0;return v>0&&(f=c/v),[hcg[0],100*f,100*v]},convert.hcg.hsl=function(hcg){var c=hcg[1]/100,l=hcg[2]/100*(1-c)+.5*c,s=0;return l>0&&l<.5?s=c/(2*l):l>=.5&&l<1&&(s=c/(2*(1-l))),[hcg[0],100*s,100*l]},convert.hcg.hwb=function(hcg){var c=hcg[1]/100,v=c+hcg[2]/100*(1-c);return[hcg[0],100*(v-c),100*(1-v)]},convert.hwb.hcg=function(hwb){var w=hwb[1]/100,v=1-hwb[2]/100,c=v-w,g=0;return c<1&&(g=(v-c)/(1-c)),[hwb[0],100*c,100*g]},convert.apple.rgb=function(apple){return[apple[0]/65535*255,apple[1]/65535*255,apple[2]/65535*255]},convert.rgb.apple=function(rgb){return[rgb[0]/255*65535,rgb[1]/255*65535,rgb[2]/255*65535]},convert.gray.rgb=function(args){return[args[0]/100*255,args[0]/100*255,args[0]/100*255]},convert.gray.hsl=convert.gray.hsv=function(args){return[0,0,args[0]]},convert.gray.hwb=function(gray){return[0,100,gray[0]]},convert.gray.cmyk=function(gray){return[0,0,0,gray[0]]},convert.gray.lab=function(gray){return[gray[0],0,0]},convert.gray.hex=function(gray){var val=255&Math.round(gray[0]/100*255),string=((val<<16)+(val<<8)+val).toString(16).toUpperCase();return"000000".substring(string.length)+string},convert.rgb.gray=function(rgb){return[(rgb[0]+rgb[1]+rgb[2])/3/255*100]}}));conversions.rgb,conversions.hsl,conversions.hsv,conversions.hwb,conversions.cmyk,conversions.xyz,conversions.lab,conversions.lch,conversions.hex,conversions.keyword,conversions.ansi16,conversions.ansi256,conversions.hcg,conversions.apple,conversions.gray;function deriveBFS(fromModel){var graph=function(){for(var graph={},models=Object.keys(conversions),len=models.length,i=0;i<len;i++)graph[models[i]]={distance:-1,parent:null};return graph}(),queue=[fromModel];for(graph[fromModel].distance=0;queue.length;)for(var current=queue.pop(),adjacents=Object.keys(conversions[current]),len=adjacents.length,i=0;i<len;i++){var adjacent=adjacents[i],node=graph[adjacent];-1===node.distance&&(node.distance=graph[current].distance+1,node.parent=current,queue.unshift(adjacent))}return graph}function link(from,to){return function(args){return to(from(args))}}function wrapConversion(toModel,graph){for(var path=[graph[toModel].parent,toModel],fn=conversions[graph[toModel].parent][toModel],cur=graph[toModel].parent;graph[cur].parent;)path.unshift(graph[cur].parent),fn=link(conversions[graph[cur].parent][cur],fn),cur=graph[cur].parent;return fn.conversion=path,fn}var convert={};Object.keys(conversions).forEach((function(fromModel){convert[fromModel]={},Object.defineProperty(convert[fromModel],"channels",{value:conversions[fromModel].channels}),Object.defineProperty(convert[fromModel],"labels",{value:conversions[fromModel].labels});var routes=function(fromModel){for(var graph=deriveBFS(fromModel),conversion={},models=Object.keys(graph),len=models.length,i=0;i<len;i++){var toModel=models[i];null!==graph[toModel].parent&&(conversion[toModel]=wrapConversion(toModel,graph))}return conversion}(fromModel);Object.keys(routes).forEach((function(toModel){var fn=routes[toModel];convert[fromModel][toModel]=function(fn){var wrappedFn=function(args){if(null==args)return args;arguments.length>1&&(args=Array.prototype.slice.call(arguments));var result=fn(args);if("object"==typeof result)for(var len=result.length,i=0;i<len;i++)result[i]=Math.round(result[i]);return result};return"conversion"in fn&&(wrappedFn.conversion=fn.conversion),wrappedFn}(fn),convert[fromModel][toModel].raw=function(fn){var wrappedFn=function(args){return null==args?args:(arguments.length>1&&(args=Array.prototype.slice.call(arguments)),fn(args))};return"conversion"in fn&&(wrappedFn.conversion=fn.conversion),wrappedFn}(fn)}))}));var colorConvert=convert,colorName$1={aliceblue:[240,248,255],antiquewhite:[250,235,215],aqua:[0,255,255],aquamarine:[127,255,212],azure:[240,255,255],beige:[245,245,220],bisque:[255,228,196],black:[0,0,0],blanchedalmond:[255,235,205],blue:[0,0,255],blueviolet:[138,43,226],brown:[165,42,42],burlywood:[222,184,135],cadetblue:[95,158,160],chartreuse:[127,255,0],chocolate:[210,105,30],coral:[255,127,80],cornflowerblue:[100,149,237],cornsilk:[255,248,220],crimson:[220,20,60],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgoldenrod:[184,134,11],darkgray:[169,169,169],darkgreen:[0,100,0],darkgrey:[169,169,169],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkseagreen:[143,188,143],darkslateblue:[72,61,139],darkslategray:[47,79,79],darkslategrey:[47,79,79],darkturquoise:[0,206,209],darkviolet:[148,0,211],deeppink:[255,20,147],deepskyblue:[0,191,255],dimgray:[105,105,105],dimgrey:[105,105,105],dodgerblue:[30,144,255],firebrick:[178,34,34],floralwhite:[255,250,240],forestgreen:[34,139,34],fuchsia:[255,0,255],gainsboro:[220,220,220],ghostwhite:[248,248,255],gold:[255,215,0],goldenrod:[218,165,32],gray:[128,128,128],green:[0,128,0],greenyellow:[173,255,47],grey:[128,128,128],honeydew:[240,255,240],hotpink:[255,105,180],indianred:[205,92,92],indigo:[75,0,130],ivory:[255,255,240],khaki:[240,230,140],lavender:[230,230,250],lavenderblush:[255,240,245],lawngreen:[124,252,0],lemonchiffon:[255,250,205],lightblue:[173,216,230],lightcoral:[240,128,128],lightcyan:[224,255,255],lightgoldenrodyellow:[250,250,210],lightgray:[211,211,211],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightsalmon:[255,160,122],lightseagreen:[32,178,170],lightskyblue:[135,206,250],lightslategray:[119,136,153],lightslategrey:[119,136,153],lightsteelblue:[176,196,222],lightyellow:[255,255,224],lime:[0,255,0],limegreen:[50,205,50],linen:[250,240,230],magenta:[255,0,255],maroon:[128,0,0],mediumaquamarine:[102,205,170],mediumblue:[0,0,205],mediumorchid:[186,85,211],mediumpurple:[147,112,219],mediumseagreen:[60,179,113],mediumslateblue:[123,104,238],mediumspringgreen:[0,250,154],mediumturquoise:[72,209,204],mediumvioletred:[199,21,133],midnightblue:[25,25,112],mintcream:[245,255,250],mistyrose:[255,228,225],moccasin:[255,228,181],navajowhite:[255,222,173],navy:[0,0,128],oldlace:[253,245,230],olive:[128,128,0],olivedrab:[107,142,35],orange:[255,165,0],orangered:[255,69,0],orchid:[218,112,214],palegoldenrod:[238,232,170],palegreen:[152,251,152],paleturquoise:[175,238,238],palevioletred:[219,112,147],papayawhip:[255,239,213],peachpuff:[255,218,185],peru:[205,133,63],pink:[255,192,203],plum:[221,160,221],powderblue:[176,224,230],purple:[128,0,128],rebeccapurple:[102,51,153],red:[255,0,0],rosybrown:[188,143,143],royalblue:[65,105,225],saddlebrown:[139,69,19],salmon:[250,128,114],sandybrown:[244,164,96],seagreen:[46,139,87],seashell:[255,245,238],sienna:[160,82,45],silver:[192,192,192],skyblue:[135,206,235],slateblue:[106,90,205],slategray:[112,128,144],slategrey:[112,128,144],snow:[255,250,250],springgreen:[0,255,127],steelblue:[70,130,180],tan:[210,180,140],teal:[0,128,128],thistle:[216,191,216],tomato:[255,99,71],turquoise:[64,224,208],violet:[238,130,238],wheat:[245,222,179],white:[255,255,255],whitesmoke:[245,245,245],yellow:[255,255,0],yellowgreen:[154,205,50]},colorString={getRgba:getRgba,getHsla:getHsla,getRgb:function(string){var rgba=getRgba(string);return rgba&&rgba.slice(0,3)},getHsl:function(string){var hsla=getHsla(string);return hsla&&hsla.slice(0,3)},getHwb:getHwb,getAlpha:function(string){var vals=getRgba(string);if(vals)return vals[3];if(vals=getHsla(string))return vals[3];if(vals=getHwb(string))return vals[3]},hexString:function(rgba,a){a=void 0!==a&&3===rgba.length?a:rgba[3];return"#"+hexDouble(rgba[0])+hexDouble(rgba[1])+hexDouble(rgba[2])+(a>=0&&a<1?hexDouble(Math.round(255*a)):"")},rgbString:function(rgba,alpha){if(alpha<1||rgba[3]&&rgba[3]<1)return rgbaString(rgba,alpha);return"rgb("+rgba[0]+", "+rgba[1]+", "+rgba[2]+")"},rgbaString:rgbaString,percentString:function(rgba,alpha){if(alpha<1||rgba[3]&&rgba[3]<1)return percentaString(rgba,alpha);var r=Math.round(rgba[0]/255*100),g=Math.round(rgba[1]/255*100),b=Math.round(rgba[2]/255*100);return"rgb("+r+"%, "+g+"%, "+b+"%)"},percentaString:percentaString,hslString:function(hsla,alpha){if(alpha<1||hsla[3]&&hsla[3]<1)return hslaString(hsla,alpha);return"hsl("+hsla[0]+", "+hsla[1]+"%, "+hsla[2]+"%)"},hslaString:hslaString,hwbString:function(hwb,alpha){void 0===alpha&&(alpha=void 0!==hwb[3]?hwb[3]:1);return"hwb("+hwb[0]+", "+hwb[1]+"%, "+hwb[2]+"%"+(void 0!==alpha&&1!==alpha?", "+alpha:"")+")"},keyword:function(rgb){return reverseNames[rgb.slice(0,3)]}};function getRgba(string){if(string){var rgb=[0,0,0],a=1,match=string.match(/^#([a-fA-F0-9]{3,4})$/i),hexAlpha="";if(match){hexAlpha=(match=match[1])[3];for(var i=0;i<rgb.length;i++)rgb[i]=parseInt(match[i]+match[i],16);hexAlpha&&(a=Math.round(parseInt(hexAlpha+hexAlpha,16)/255*100)/100)}else if(match=string.match(/^#([a-fA-F0-9]{6}([a-fA-F0-9]{2})?)$/i)){hexAlpha=match[2],match=match[1];for(i=0;i<rgb.length;i++)rgb[i]=parseInt(match.slice(2*i,2*i+2),16);hexAlpha&&(a=Math.round(parseInt(hexAlpha,16)/255*100)/100)}else if(match=string.match(/^rgba?\(\s*([+-]?\d+)\s*,\s*([+-]?\d+)\s*,\s*([+-]?\d+)\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)$/i)){for(i=0;i<rgb.length;i++)rgb[i]=parseInt(match[i+1]);a=parseFloat(match[4])}else if(match=string.match(/^rgba?\(\s*([+-]?[\d\.]+)\%\s*,\s*([+-]?[\d\.]+)\%\s*,\s*([+-]?[\d\.]+)\%\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)$/i)){for(i=0;i<rgb.length;i++)rgb[i]=Math.round(2.55*parseFloat(match[i+1]));a=parseFloat(match[4])}else if(match=string.match(/(\w+)/)){if("transparent"==match[1])return[0,0,0,0];if(!(rgb=colorName$1[match[1]]))return}for(i=0;i<rgb.length;i++)rgb[i]=scale(rgb[i],0,255);return a=a||0==a?scale(a,0,1):1,rgb[3]=a,rgb}}function getHsla(string){if(string){var match=string.match(/^hsla?\(\s*([+-]?\d+)(?:deg)?\s*,\s*([+-]?[\d\.]+)%\s*,\s*([+-]?[\d\.]+)%\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)/);if(match){var alpha=parseFloat(match[4]);return[scale(parseInt(match[1]),0,360),scale(parseFloat(match[2]),0,100),scale(parseFloat(match[3]),0,100),scale(isNaN(alpha)?1:alpha,0,1)]}}}function getHwb(string){if(string){var match=string.match(/^hwb\(\s*([+-]?\d+)(?:deg)?\s*,\s*([+-]?[\d\.]+)%\s*,\s*([+-]?[\d\.]+)%\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)/);if(match){var alpha=parseFloat(match[4]);return[scale(parseInt(match[1]),0,360),scale(parseFloat(match[2]),0,100),scale(parseFloat(match[3]),0,100),scale(isNaN(alpha)?1:alpha,0,1)]}}}function rgbaString(rgba,alpha){return void 0===alpha&&(alpha=void 0!==rgba[3]?rgba[3]:1),"rgba("+rgba[0]+", "+rgba[1]+", "+rgba[2]+", "+alpha+")"}function percentaString(rgba,alpha){return"rgba("+Math.round(rgba[0]/255*100)+"%, "+Math.round(rgba[1]/255*100)+"%, "+Math.round(rgba[2]/255*100)+"%, "+(alpha||rgba[3]||1)+")"}function hslaString(hsla,alpha){return void 0===alpha&&(alpha=void 0!==hsla[3]?hsla[3]:1),"hsla("+hsla[0]+", "+hsla[1]+"%, "+hsla[2]+"%, "+alpha+")"}function scale(num,min,max){return Math.min(Math.max(min,num),max)}function hexDouble(num){var str=num.toString(16).toUpperCase();return str.length<2?"0"+str:str}var reverseNames={};for(var name in colorName$1)reverseNames[colorName$1[name]]=name;var Color=function(obj){return obj instanceof Color?obj:this instanceof Color?(this.valid=!1,this.values={rgb:[0,0,0],hsl:[0,0,0],hsv:[0,0,0],hwb:[0,0,0],cmyk:[0,0,0,0],alpha:1},void("string"==typeof obj?(vals=colorString.getRgba(obj))?this.setValues("rgb",vals):(vals=colorString.getHsla(obj))?this.setValues("hsl",vals):(vals=colorString.getHwb(obj))&&this.setValues("hwb",vals):"object"==typeof obj&&(void 0!==(vals=obj).r||void 0!==vals.red?this.setValues("rgb",vals):void 0!==vals.l||void 0!==vals.lightness?this.setValues("hsl",vals):void 0!==vals.v||void 0!==vals.value?this.setValues("hsv",vals):void 0!==vals.w||void 0!==vals.whiteness?this.setValues("hwb",vals):void 0===vals.c&&void 0===vals.cyan||this.setValues("cmyk",vals)))):new Color(obj);var vals};Color.prototype={isValid:function(){return this.valid},rgb:function(){return this.setSpace("rgb",arguments)},hsl:function(){return this.setSpace("hsl",arguments)},hsv:function(){return this.setSpace("hsv",arguments)},hwb:function(){return this.setSpace("hwb",arguments)},cmyk:function(){return this.setSpace("cmyk",arguments)},rgbArray:function(){return this.values.rgb},hslArray:function(){return this.values.hsl},hsvArray:function(){return this.values.hsv},hwbArray:function(){var values=this.values;return 1!==values.alpha?values.hwb.concat([values.alpha]):values.hwb},cmykArray:function(){return this.values.cmyk},rgbaArray:function(){var values=this.values;return values.rgb.concat([values.alpha])},hslaArray:function(){var values=this.values;return values.hsl.concat([values.alpha])},alpha:function(val){return void 0===val?this.values.alpha:(this.setValues("alpha",val),this)},red:function(val){return this.setChannel("rgb",0,val)},green:function(val){return this.setChannel("rgb",1,val)},blue:function(val){return this.setChannel("rgb",2,val)},hue:function(val){return val&&(val=(val%=360)<0?360+val:val),this.setChannel("hsl",0,val)},saturation:function(val){return this.setChannel("hsl",1,val)},lightness:function(val){return this.setChannel("hsl",2,val)},saturationv:function(val){return this.setChannel("hsv",1,val)},whiteness:function(val){return this.setChannel("hwb",1,val)},blackness:function(val){return this.setChannel("hwb",2,val)},value:function(val){return this.setChannel("hsv",2,val)},cyan:function(val){return this.setChannel("cmyk",0,val)},magenta:function(val){return this.setChannel("cmyk",1,val)},yellow:function(val){return this.setChannel("cmyk",2,val)},black:function(val){return this.setChannel("cmyk",3,val)},hexString:function(){return colorString.hexString(this.values.rgb)},rgbString:function(){return colorString.rgbString(this.values.rgb,this.values.alpha)},rgbaString:function(){return colorString.rgbaString(this.values.rgb,this.values.alpha)},percentString:function(){return colorString.percentString(this.values.rgb,this.values.alpha)},hslString:function(){return colorString.hslString(this.values.hsl,this.values.alpha)},hslaString:function(){return colorString.hslaString(this.values.hsl,this.values.alpha)},hwbString:function(){return colorString.hwbString(this.values.hwb,this.values.alpha)},keyword:function(){return colorString.keyword(this.values.rgb,this.values.alpha)},rgbNumber:function(){var rgb=this.values.rgb;return rgb[0]<<16|rgb[1]<<8|rgb[2]},luminosity:function(){for(var rgb=this.values.rgb,lum=[],i=0;i<rgb.length;i++){var chan=rgb[i]/255;lum[i]=chan<=.03928?chan/12.92:Math.pow((chan+.055)/1.055,2.4)}return.2126*lum[0]+.7152*lum[1]+.0722*lum[2]},contrast:function(color2){var lum1=this.luminosity(),lum2=color2.luminosity();return lum1>lum2?(lum1+.05)/(lum2+.05):(lum2+.05)/(lum1+.05)},level:function(color2){var contrastRatio=this.contrast(color2);return contrastRatio>=7.1?"AAA":contrastRatio>=4.5?"AA":""},dark:function(){var rgb=this.values.rgb;return(299*rgb[0]+587*rgb[1]+114*rgb[2])/1e3<128},light:function(){return!this.dark()},negate:function(){for(var rgb=[],i=0;i<3;i++)rgb[i]=255-this.values.rgb[i];return this.setValues("rgb",rgb),this},lighten:function(ratio){var hsl=this.values.hsl;return hsl[2]+=hsl[2]*ratio,this.setValues("hsl",hsl),this},darken:function(ratio){var hsl=this.values.hsl;return hsl[2]-=hsl[2]*ratio,this.setValues("hsl",hsl),this},saturate:function(ratio){var hsl=this.values.hsl;return hsl[1]+=hsl[1]*ratio,this.setValues("hsl",hsl),this},desaturate:function(ratio){var hsl=this.values.hsl;return hsl[1]-=hsl[1]*ratio,this.setValues("hsl",hsl),this},whiten:function(ratio){var hwb=this.values.hwb;return hwb[1]+=hwb[1]*ratio,this.setValues("hwb",hwb),this},blacken:function(ratio){var hwb=this.values.hwb;return hwb[2]+=hwb[2]*ratio,this.setValues("hwb",hwb),this},greyscale:function(){var rgb=this.values.rgb,val=.3*rgb[0]+.59*rgb[1]+.11*rgb[2];return this.setValues("rgb",[val,val,val]),this},clearer:function(ratio){var alpha=this.values.alpha;return this.setValues("alpha",alpha-alpha*ratio),this},opaquer:function(ratio){var alpha=this.values.alpha;return this.setValues("alpha",alpha+alpha*ratio),this},rotate:function(degrees){var hsl=this.values.hsl,hue=(hsl[0]+degrees)%360;return hsl[0]=hue<0?360+hue:hue,this.setValues("hsl",hsl),this},mix:function(mixinColor,weight){var color2=mixinColor,p=void 0===weight?.5:weight,w=2*p-1,a=this.alpha()-color2.alpha(),w1=((w*a==-1?w:(w+a)/(1+w*a))+1)/2,w2=1-w1;return this.rgb(w1*this.red()+w2*color2.red(),w1*this.green()+w2*color2.green(),w1*this.blue()+w2*color2.blue()).alpha(this.alpha()*p+color2.alpha()*(1-p))},toJSON:function(){return this.rgb()},clone:function(){var value,type,result=new Color,source=this.values,target=result.values;for(var prop in source)source.hasOwnProperty(prop)&&(value=source[prop],"[object Array]"===(type={}.toString.call(value))?target[prop]=value.slice(0):"[object Number]"===type?target[prop]=value:console.error("unexpected color value:",value));return result}},Color.prototype.spaces={rgb:["red","green","blue"],hsl:["hue","saturation","lightness"],hsv:["hue","saturation","value"],hwb:["hue","whiteness","blackness"],cmyk:["cyan","magenta","yellow","black"]},Color.prototype.maxes={rgb:[255,255,255],hsl:[360,100,100],hsv:[360,100,100],hwb:[360,100,100],cmyk:[100,100,100,100]},Color.prototype.getValues=function(space){for(var values=this.values,vals={},i=0;i<space.length;i++)vals[space.charAt(i)]=values[space][i];return 1!==values.alpha&&(vals.a=values.alpha),vals},Color.prototype.setValues=function(space,vals){var i,capped,values=this.values,spaces=this.spaces,maxes=this.maxes,alpha=1;if(this.valid=!0,"alpha"===space)alpha=vals;else if(vals.length)values[space]=vals.slice(0,space.length),alpha=vals[space.length];else if(void 0!==vals[space.charAt(0)]){for(i=0;i<space.length;i++)values[space][i]=vals[space.charAt(i)];alpha=vals.a}else if(void 0!==vals[spaces[space][0]]){var chans=spaces[space];for(i=0;i<space.length;i++)values[space][i]=vals[chans[i]];alpha=vals.alpha}if(values.alpha=Math.max(0,Math.min(1,void 0===alpha?values.alpha:alpha)),"alpha"===space)return!1;for(i=0;i<space.length;i++)capped=Math.max(0,Math.min(maxes[space][i],values[space][i])),values[space][i]=Math.round(capped);for(var sname in spaces)sname!==space&&(values[sname]=colorConvert[space][sname](values[space]));return!0},Color.prototype.setSpace=function(space,args){var vals=args[0];return void 0===vals?this.getValues(space):("number"==typeof vals&&(vals=Array.prototype.slice.call(args)),this.setValues(space,vals),this)},Color.prototype.setChannel=function(space,index,val){var svalues=this.values[space];return void 0===val?svalues[index]:(val===svalues[index]||(svalues[index]=val,this.setValues(space,svalues)),this)},"undefined"!=typeof window&&(window.Color=Color);var chartjsColor=Color;function isValidKey(key){return-1===["__proto__","prototype","constructor"].indexOf(key)}var id,helpers={noop:function(){},uid:(id=0,function(){return id++}),isNullOrUndef:function(value){return null==value},isArray:function(value){if(Array.isArray&&Array.isArray(value))return!0;var type=Object.prototype.toString.call(value);return"[object"===type.substr(0,7)&&"Array]"===type.substr(-6)},isObject:function(value){return null!==value&&"[object Object]"===Object.prototype.toString.call(value)},isFinite:function(value){return("number"==typeof value||value instanceof Number)&&isFinite(value)},valueOrDefault:function(value,defaultValue){return void 0===value?defaultValue:value},valueAtIndexOrDefault:function(value,index,defaultValue){return helpers.valueOrDefault(helpers.isArray(value)?value[index]:value,defaultValue)},callback:function(fn,args,thisArg){if(fn&&"function"==typeof fn.call)return fn.apply(thisArg,args)},each:function(loopable,fn,thisArg,reverse){var i,len,keys;if(helpers.isArray(loopable))if(len=loopable.length,reverse)for(i=len-1;i>=0;i--)fn.call(thisArg,loopable[i],i);else for(i=0;i<len;i++)fn.call(thisArg,loopable[i],i);else if(helpers.isObject(loopable))for(len=(keys=Object.keys(loopable)).length,i=0;i<len;i++)fn.call(thisArg,loopable[keys[i]],keys[i])},arrayEquals:function(a0,a1){var i,ilen,v0,v1;if(!a0||!a1||a0.length!==a1.length)return!1;for(i=0,ilen=a0.length;i<ilen;++i)if(v0=a0[i],v1=a1[i],v0 instanceof Array&&v1 instanceof Array){if(!helpers.arrayEquals(v0,v1))return!1}else if(v0!==v1)return!1;return!0},clone:function(source){if(helpers.isArray(source))return source.map(helpers.clone);if(helpers.isObject(source)){for(var target=Object.create(source),keys=Object.keys(source),klen=keys.length,k=0;k<klen;++k)target[keys[k]]=helpers.clone(source[keys[k]]);return target}return source},_merger:function(key,target,source,options){if(isValidKey(key)){var tval=target[key],sval=source[key];helpers.isObject(tval)&&helpers.isObject(sval)?helpers.merge(tval,sval,options):target[key]=helpers.clone(sval)}},_mergerIf:function(key,target,source){if(isValidKey(key)){var tval=target[key],sval=source[key];helpers.isObject(tval)&&helpers.isObject(sval)?helpers.mergeIf(tval,sval):target.hasOwnProperty(key)||(target[key]=helpers.clone(sval))}},merge:function(target,source,options){var merge,i,keys,klen,k,sources=helpers.isArray(source)?source:[source],ilen=sources.length;if(!helpers.isObject(target))return target;for(merge=(options=options||{}).merger||helpers._merger,i=0;i<ilen;++i)if(source=sources[i],helpers.isObject(source))for(k=0,klen=(keys=Object.keys(source)).length;k<klen;++k)merge(keys[k],target,source,options);return target},mergeIf:function(target,source){return helpers.merge(target,source,{merger:helpers._mergerIf})},extend:Object.assign||function(target){return helpers.merge(target,[].slice.call(arguments,1),{merger:function(key,dst,src){dst[key]=src[key]}})},inherits:function(extensions){var me=this,ChartElement=extensions&&extensions.hasOwnProperty("constructor")?extensions.constructor:function(){return me.apply(this,arguments)},Surrogate=function(){this.constructor=ChartElement};return Surrogate.prototype=me.prototype,ChartElement.prototype=new Surrogate,ChartElement.extend=helpers.inherits,extensions&&helpers.extend(ChartElement.prototype,extensions),ChartElement.__super__=me.prototype,ChartElement},_deprecated:function(scope,value,previous,current){void 0!==value&&console.warn(scope+': "'+previous+'" is deprecated. Please use "'+current+'" instead')}},helpers_core=helpers;helpers.callCallback=helpers.callback,helpers.indexOf=function(array,item,fromIndex){return Array.prototype.indexOf.call(array,item,fromIndex)},helpers.getValueOrDefault=helpers.valueOrDefault,helpers.getValueAtIndexOrDefault=helpers.valueAtIndexOrDefault;var effects={linear:function(t){return t},easeInQuad:function(t){return t*t},easeOutQuad:function(t){return-t*(t-2)},easeInOutQuad:function(t){return(t/=.5)<1?.5*t*t:-.5*(--t*(t-2)-1)},easeInCubic:function(t){return t*t*t},easeOutCubic:function(t){return(t-=1)*t*t+1},easeInOutCubic:function(t){return(t/=.5)<1?.5*t*t*t:.5*((t-=2)*t*t+2)},easeInQuart:function(t){return t*t*t*t},easeOutQuart:function(t){return-((t-=1)*t*t*t-1)},easeInOutQuart:function(t){return(t/=.5)<1?.5*t*t*t*t:-.5*((t-=2)*t*t*t-2)},easeInQuint:function(t){return t*t*t*t*t},easeOutQuint:function(t){return(t-=1)*t*t*t*t+1},easeInOutQuint:function(t){return(t/=.5)<1?.5*t*t*t*t*t:.5*((t-=2)*t*t*t*t+2)},easeInSine:function(t){return 1-Math.cos(t*(Math.PI/2))},easeOutSine:function(t){return Math.sin(t*(Math.PI/2))},easeInOutSine:function(t){return-.5*(Math.cos(Math.PI*t)-1)},easeInExpo:function(t){return 0===t?0:Math.pow(2,10*(t-1))},easeOutExpo:function(t){return 1===t?1:1-Math.pow(2,-10*t)},easeInOutExpo:function(t){return 0===t?0:1===t?1:(t/=.5)<1?.5*Math.pow(2,10*(t-1)):.5*(2-Math.pow(2,-10*--t))},easeInCirc:function(t){return t>=1?t:-(Math.sqrt(1-t*t)-1)},easeOutCirc:function(t){return Math.sqrt(1-(t-=1)*t)},easeInOutCirc:function(t){return(t/=.5)<1?-.5*(Math.sqrt(1-t*t)-1):.5*(Math.sqrt(1-(t-=2)*t)+1)},easeInElastic:function(t){var s=1.70158,p=0,a=1;return 0===t?0:1===t?1:(p||(p=.3),a<1?(a=1,s=p/4):s=p/(2*Math.PI)*Math.asin(1/a),-a*Math.pow(2,10*(t-=1))*Math.sin((t-s)*(2*Math.PI)/p))},easeOutElastic:function(t){var s=1.70158,p=0,a=1;return 0===t?0:1===t?1:(p||(p=.3),a<1?(a=1,s=p/4):s=p/(2*Math.PI)*Math.asin(1/a),a*Math.pow(2,-10*t)*Math.sin((t-s)*(2*Math.PI)/p)+1)},easeInOutElastic:function(t){var s=1.70158,p=0,a=1;return 0===t?0:2==(t/=.5)?1:(p||(p=.45),a<1?(a=1,s=p/4):s=p/(2*Math.PI)*Math.asin(1/a),t<1?a*Math.pow(2,10*(t-=1))*Math.sin((t-s)*(2*Math.PI)/p)*-.5:a*Math.pow(2,-10*(t-=1))*Math.sin((t-s)*(2*Math.PI)/p)*.5+1)},easeInBack:function(t){var s=1.70158;return t*t*((s+1)*t-s)},easeOutBack:function(t){var s=1.70158;return(t-=1)*t*((s+1)*t+s)+1},easeInOutBack:function(t){var s=1.70158;return(t/=.5)<1?t*t*((1+(s*=1.525))*t-s)*.5:.5*((t-=2)*t*((1+(s*=1.525))*t+s)+2)},easeInBounce:function(t){return 1-effects.easeOutBounce(1-t)},easeOutBounce:function(t){return t<1/2.75?7.5625*t*t:t<2/2.75?7.5625*(t-=1.5/2.75)*t+.75:t<2.5/2.75?7.5625*(t-=2.25/2.75)*t+.9375:7.5625*(t-=2.625/2.75)*t+.984375},easeInOutBounce:function(t){return t<.5?.5*effects.easeInBounce(2*t):.5*effects.easeOutBounce(2*t-1)+.5}},helpers_easing={effects:effects};helpers_core.easingEffects=effects;var PI=Math.PI,RAD_PER_DEG=PI/180,DOUBLE_PI=2*PI,HALF_PI=PI/2,QUARTER_PI=PI/4,TWO_THIRDS_PI=2*PI/3,exports$1={clear:function(chart){chart.ctx.clearRect(0,0,chart.width,chart.height)},roundedRect:function(ctx,x,y,width,height,radius){if(radius){var r=Math.min(radius,height/2,width/2),left=x+r,top=y+r,right=x+width-r,bottom=y+height-r;ctx.moveTo(x,top),left<right&&top<bottom?(ctx.arc(left,top,r,-PI,-HALF_PI),ctx.arc(right,top,r,-HALF_PI,0),ctx.arc(right,bottom,r,0,HALF_PI),ctx.arc(left,bottom,r,HALF_PI,PI)):left<right?(ctx.moveTo(left,y),ctx.arc(right,top,r,-HALF_PI,HALF_PI),ctx.arc(left,top,r,HALF_PI,PI+HALF_PI)):top<bottom?(ctx.arc(left,top,r,-PI,0),ctx.arc(left,bottom,r,0,PI)):ctx.arc(left,top,r,-PI,PI),ctx.closePath(),ctx.moveTo(x,y)}else ctx.rect(x,y,width,height)},drawPoint:function(ctx,style,radius,x,y,rotation){var type,xOffset,yOffset,size,cornerRadius,rad=(rotation||0)*RAD_PER_DEG;if(style&&"object"==typeof style&&("[object HTMLImageElement]"===(type=style.toString())||"[object HTMLCanvasElement]"===type))return ctx.save(),ctx.translate(x,y),ctx.rotate(rad),ctx.drawImage(style,-style.width/2,-style.height/2,style.width,style.height),void ctx.restore();if(!(isNaN(radius)||radius<=0)){switch(ctx.beginPath(),style){default:ctx.arc(x,y,radius,0,DOUBLE_PI),ctx.closePath();break;case"triangle":ctx.moveTo(x+Math.sin(rad)*radius,y-Math.cos(rad)*radius),rad+=TWO_THIRDS_PI,ctx.lineTo(x+Math.sin(rad)*radius,y-Math.cos(rad)*radius),rad+=TWO_THIRDS_PI,ctx.lineTo(x+Math.sin(rad)*radius,y-Math.cos(rad)*radius),ctx.closePath();break;case"rectRounded":size=radius-(cornerRadius=.516*radius),xOffset=Math.cos(rad+QUARTER_PI)*size,yOffset=Math.sin(rad+QUARTER_PI)*size,ctx.arc(x-xOffset,y-yOffset,cornerRadius,rad-PI,rad-HALF_PI),ctx.arc(x+yOffset,y-xOffset,cornerRadius,rad-HALF_PI,rad),ctx.arc(x+xOffset,y+yOffset,cornerRadius,rad,rad+HALF_PI),ctx.arc(x-yOffset,y+xOffset,cornerRadius,rad+HALF_PI,rad+PI),ctx.closePath();break;case"rect":if(!rotation){size=Math.SQRT1_2*radius,ctx.rect(x-size,y-size,2*size,2*size);break}rad+=QUARTER_PI;case"rectRot":xOffset=Math.cos(rad)*radius,yOffset=Math.sin(rad)*radius,ctx.moveTo(x-xOffset,y-yOffset),ctx.lineTo(x+yOffset,y-xOffset),ctx.lineTo(x+xOffset,y+yOffset),ctx.lineTo(x-yOffset,y+xOffset),ctx.closePath();break;case"crossRot":rad+=QUARTER_PI;case"cross":xOffset=Math.cos(rad)*radius,yOffset=Math.sin(rad)*radius,ctx.moveTo(x-xOffset,y-yOffset),ctx.lineTo(x+xOffset,y+yOffset),ctx.moveTo(x+yOffset,y-xOffset),ctx.lineTo(x-yOffset,y+xOffset);break;case"star":xOffset=Math.cos(rad)*radius,yOffset=Math.sin(rad)*radius,ctx.moveTo(x-xOffset,y-yOffset),ctx.lineTo(x+xOffset,y+yOffset),ctx.moveTo(x+yOffset,y-xOffset),ctx.lineTo(x-yOffset,y+xOffset),rad+=QUARTER_PI,xOffset=Math.cos(rad)*radius,yOffset=Math.sin(rad)*radius,ctx.moveTo(x-xOffset,y-yOffset),ctx.lineTo(x+xOffset,y+yOffset),ctx.moveTo(x+yOffset,y-xOffset),ctx.lineTo(x-yOffset,y+xOffset);break;case"line":xOffset=Math.cos(rad)*radius,yOffset=Math.sin(rad)*radius,ctx.moveTo(x-xOffset,y-yOffset),ctx.lineTo(x+xOffset,y+yOffset);break;case"dash":ctx.moveTo(x,y),ctx.lineTo(x+Math.cos(rad)*radius,y+Math.sin(rad)*radius)}ctx.fill(),ctx.stroke()}},_isPointInArea:function(point,area){return point.x>area.left-1e-6&&point.x<area.right+1e-6&&point.y>area.top-1e-6&&point.y<area.bottom+1e-6},clipArea:function(ctx,area){ctx.save(),ctx.beginPath(),ctx.rect(area.left,area.top,area.right-area.left,area.bottom-area.top),ctx.clip()},unclipArea:function(ctx){ctx.restore()},lineTo:function(ctx,previous,target,flip){var stepped=target.steppedLine;if(stepped){if("middle"===stepped){var midpoint=(previous.x+target.x)/2;ctx.lineTo(midpoint,flip?target.y:previous.y),ctx.lineTo(midpoint,flip?previous.y:target.y)}else"after"===stepped&&!flip||"after"!==stepped&&flip?ctx.lineTo(previous.x,target.y):ctx.lineTo(target.x,previous.y);ctx.lineTo(target.x,target.y)}else target.tension?ctx.bezierCurveTo(flip?previous.controlPointPreviousX:previous.controlPointNextX,flip?previous.controlPointPreviousY:previous.controlPointNextY,flip?target.controlPointNextX:target.controlPointPreviousX,flip?target.controlPointNextY:target.controlPointPreviousY,target.x,target.y):ctx.lineTo(target.x,target.y)}},helpers_canvas=exports$1;helpers_core.clear=exports$1.clear,helpers_core.drawRoundedRectangle=function(ctx){ctx.beginPath(),exports$1.roundedRect.apply(exports$1,arguments)};var defaults={_set:function(scope,values){return helpers_core.merge(this[scope]||(this[scope]={}),values)}};defaults._set("global",{defaultColor:"rgba(0,0,0,0.1)",defaultFontColor:"#666",defaultFontFamily:"'Helvetica Neue', 'Helvetica', 'Arial', sans-serif",defaultFontSize:12,defaultFontStyle:"normal",defaultLineHeight:1.2,showLines:!0});var core_defaults=defaults,valueOrDefault=helpers_core.valueOrDefault;var helpers_options={toLineHeight:function(value,size){var matches=(""+value).match(/^(normal|(\d+(?:\.\d+)?)(px|em|%)?)$/);if(!matches||"normal"===matches[1])return 1.2*size;switch(value=+matches[2],matches[3]){case"px":return value;case"%":value/=100}return size*value},toPadding:function(value){var t,r,b,l;return helpers_core.isObject(value)?(t=+value.top||0,r=+value.right||0,b=+value.bottom||0,l=+value.left||0):t=r=b=l=+value||0,{top:t,right:r,bottom:b,left:l,height:t+b,width:l+r}},_parseFont:function(options){var globalDefaults=core_defaults.global,size=valueOrDefault(options.fontSize,globalDefaults.defaultFontSize),font={family:valueOrDefault(options.fontFamily,globalDefaults.defaultFontFamily),lineHeight:helpers_core.options.toLineHeight(valueOrDefault(options.lineHeight,globalDefaults.defaultLineHeight),size),size:size,style:valueOrDefault(options.fontStyle,globalDefaults.defaultFontStyle),weight:null,string:""};return font.string=function(font){return!font||helpers_core.isNullOrUndef(font.size)||helpers_core.isNullOrUndef(font.family)?null:(font.style?font.style+" ":"")+(font.weight?font.weight+" ":"")+font.size+"px "+font.family}(font),font},resolve:function(inputs,context,index,info){var i,ilen,value,cacheable=!0;for(i=0,ilen=inputs.length;i<ilen;++i)if(void 0!==(value=inputs[i])&&(void 0!==context&&"function"==typeof value&&(value=value(context),cacheable=!1),void 0!==index&&helpers_core.isArray(value)&&(value=value[index],cacheable=!1),void 0!==value))return info&&!cacheable&&(info.cacheable=!1),value}},exports$2={_factorize:function(value){var i,result=[],sqrt=Math.sqrt(value);for(i=1;i<sqrt;i++)value%i==0&&(result.push(i),result.push(value/i));return sqrt===(0|sqrt)&&result.push(sqrt),result.sort((function(a,b){return a-b})).pop(),result},log10:Math.log10||function(x){var exponent=Math.log(x)*Math.LOG10E,powerOf10=Math.round(exponent);return x===Math.pow(10,powerOf10)?powerOf10:exponent}},helpers_math=exports$2;helpers_core.log10=exports$2.log10;var helpers_rtl={getRtlAdapter:function(rtl,rectX,width){return rtl?function(rectX,width){return{x:function(x){return rectX+rectX+width-x},setWidth:function(w){width=w},textAlign:function(align){return"center"===align?align:"right"===align?"left":"right"},xPlus:function(x,value){return x-value},leftForLtr:function(x,itemWidth){return x-itemWidth}}}(rectX,width):{x:function(x){return x},setWidth:function(w){},textAlign:function(align){return align},xPlus:function(x,value){return x+value},leftForLtr:function(x,_itemWidth){return x}}},overrideTextDirection:function(ctx,direction){var style,original;"ltr"!==direction&&"rtl"!==direction||(original=[(style=ctx.canvas.style).getPropertyValue("direction"),style.getPropertyPriority("direction")],style.setProperty("direction",direction,"important"),ctx.prevTextDirection=original)},restoreTextDirection:function(ctx){var original=ctx.prevTextDirection;void 0!==original&&(delete ctx.prevTextDirection,ctx.canvas.style.setProperty("direction",original[0],original[1]))}},helpers$1=helpers_core,easing=helpers_easing,canvas=helpers_canvas,options=helpers_options,math=helpers_math,rtl=helpers_rtl;helpers$1.easing=easing,helpers$1.canvas=canvas,helpers$1.options=options,helpers$1.math=math,helpers$1.rtl=rtl;var Element=function(configuration){helpers$1.extend(this,configuration),this.initialize.apply(this,arguments)};helpers$1.extend(Element.prototype,{_type:void 0,initialize:function(){this.hidden=!1},pivot:function(){var me=this;return me._view||(me._view=helpers$1.extend({},me._model)),me._start={},me},transition:function(ease){var me=this,model=me._model,start=me._start,view=me._view;return model&&1!==ease?(view||(view=me._view={}),start||(start=me._start={}),function(start,view,model,ease){var i,ilen,key,actual,origin,target,type,c0,c1,keys=Object.keys(model);for(i=0,ilen=keys.length;i<ilen;++i)if(target=model[key=keys[i]],view.hasOwnProperty(key)||(view[key]=target),(actual=view[key])!==target&&"_"!==key[0]){if(start.hasOwnProperty(key)||(start[key]=actual),(type=typeof target)==typeof(origin=start[key]))if("string"===type){if((c0=chartjsColor(origin)).valid&&(c1=chartjsColor(target)).valid){view[key]=c1.mix(c0,ease).rgbString();continue}}else if(helpers$1.isFinite(origin)&&helpers$1.isFinite(target)){view[key]=origin+(target-origin)*ease;continue}view[key]=target}}(start,view,model,ease),me):(me._view=helpers$1.extend({},model),me._start=null,me)},tooltipPosition:function(){return{x:this._model.x,y:this._model.y}},hasValue:function(){return helpers$1.isNumber(this._model.x)&&helpers$1.isNumber(this._model.y)}}),Element.extend=helpers$1.inherits;var core_element=Element,exports$3=core_element.extend({chart:null,currentStep:0,numSteps:60,easing:"",render:null,onAnimationProgress:null,onAnimationComplete:null}),core_animation=exports$3;Object.defineProperty(exports$3.prototype,"animationObject",{get:function(){return this}}),Object.defineProperty(exports$3.prototype,"chartInstance",{get:function(){return this.chart},set:function(value){this.chart=value}}),core_defaults._set("global",{animation:{duration:1e3,easing:"easeOutQuart",onProgress:helpers$1.noop,onComplete:helpers$1.noop}});var core_animations={animations:[],request:null,addAnimation:function(chart,animation,duration,lazy){var i,ilen,animations=this.animations;for(animation.chart=chart,animation.startTime=Date.now(),animation.duration=duration,lazy||(chart.animating=!0),i=0,ilen=animations.length;i<ilen;++i)if(animations[i].chart===chart)return void(animations[i]=animation);animations.push(animation),1===animations.length&&this.requestAnimationFrame()},cancelAnimation:function(chart){var index=helpers$1.findIndex(this.animations,(function(animation){return animation.chart===chart}));-1!==index&&(this.animations.splice(index,1),chart.animating=!1)},requestAnimationFrame:function(){var me=this;null===me.request&&(me.request=helpers$1.requestAnimFrame.call(window,(function(){me.request=null,me.startDigest()})))},startDigest:function(){this.advance(),this.animations.length>0&&this.requestAnimationFrame()},advance:function(){for(var animation,chart,numSteps,nextStep,animations=this.animations,i=0;i<animations.length;)chart=(animation=animations[i]).chart,numSteps=animation.numSteps,nextStep=Math.floor((Date.now()-animation.startTime)/animation.duration*numSteps)+1,animation.currentStep=Math.min(nextStep,numSteps),helpers$1.callback(animation.render,[chart,animation],chart),helpers$1.callback(animation.onAnimationProgress,[animation],chart),animation.currentStep>=numSteps?(helpers$1.callback(animation.onAnimationComplete,[animation],chart),chart.animating=!1,animations.splice(i,1)):++i}},resolve=helpers$1.options.resolve,arrayEvents=["push","pop","shift","splice","unshift"];function unlistenArrayEvents(array,listener){var stub=array._chartjs;if(stub){var listeners=stub.listeners,index=listeners.indexOf(listener);-1!==index&&listeners.splice(index,1),listeners.length>0||(arrayEvents.forEach((function(key){delete array[key]})),delete array._chartjs)}}var DatasetController=function(chart,datasetIndex){this.initialize(chart,datasetIndex)};helpers$1.extend(DatasetController.prototype,{datasetElementType:null,dataElementType:null,_datasetElementOptions:["backgroundColor","borderCapStyle","borderColor","borderDash","borderDashOffset","borderJoinStyle","borderWidth"],_dataElementOptions:["backgroundColor","borderColor","borderWidth","pointStyle"],initialize:function(chart,datasetIndex){var me=this;me.chart=chart,me.index=datasetIndex,me.linkScales(),me.addElements(),me._type=me.getMeta().type},updateIndex:function(datasetIndex){this.index=datasetIndex},linkScales:function(){var meta=this.getMeta(),chart=this.chart,scales=chart.scales,dataset=this.getDataset(),scalesOpts=chart.options.scales;null!==meta.xAxisID&&meta.xAxisID in scales&&!dataset.xAxisID||(meta.xAxisID=dataset.xAxisID||scalesOpts.xAxes[0].id),null!==meta.yAxisID&&meta.yAxisID in scales&&!dataset.yAxisID||(meta.yAxisID=dataset.yAxisID||scalesOpts.yAxes[0].id)},getDataset:function(){return this.chart.data.datasets[this.index]},getMeta:function(){return this.chart.getDatasetMeta(this.index)},getScaleForId:function(scaleID){return this.chart.scales[scaleID]},_getValueScaleId:function(){return this.getMeta().yAxisID},_getIndexScaleId:function(){return this.getMeta().xAxisID},_getValueScale:function(){return this.getScaleForId(this._getValueScaleId())},_getIndexScale:function(){return this.getScaleForId(this._getIndexScaleId())},reset:function(){this._update(!0)},destroy:function(){this._data&&unlistenArrayEvents(this._data,this)},createMetaDataset:function(){var type=this.datasetElementType;return type&&new type({_chart:this.chart,_datasetIndex:this.index})},createMetaData:function(index){var type=this.dataElementType;return type&&new type({_chart:this.chart,_datasetIndex:this.index,_index:index})},addElements:function(){var i,ilen,meta=this.getMeta(),data=this.getDataset().data||[],metaData=meta.data;for(i=0,ilen=data.length;i<ilen;++i)metaData[i]=metaData[i]||this.createMetaData(i);meta.dataset=meta.dataset||this.createMetaDataset()},addElementAndReset:function(index){var element=this.createMetaData(index);this.getMeta().data.splice(index,0,element),this.updateElement(element,index,!0)},buildOrUpdateElements:function(){var array,listener,me=this,dataset=me.getDataset(),data=dataset.data||(dataset.data=[]);me._data!==data&&(me._data&&unlistenArrayEvents(me._data,me),data&&Object.isExtensible(data)&&(listener=me,(array=data)._chartjs?array._chartjs.listeners.push(listener):(Object.defineProperty(array,"_chartjs",{configurable:!0,enumerable:!1,value:{listeners:[listener]}}),arrayEvents.forEach((function(key){var method="onData"+key.charAt(0).toUpperCase()+key.slice(1),base=array[key];Object.defineProperty(array,key,{configurable:!0,enumerable:!1,value:function(){var args=Array.prototype.slice.call(arguments),res=base.apply(this,args);return helpers$1.each(array._chartjs.listeners,(function(object){"function"==typeof object[method]&&object[method].apply(object,args)})),res}})})))),me._data=data),me.resyncElements()},_configure:function(){this._config=helpers$1.merge(Object.create(null),[this.chart.options.datasets[this._type],this.getDataset()],{merger:function(key,target,source){"_meta"!==key&&"data"!==key&&helpers$1._merger(key,target,source)}})},_update:function(reset){this._configure(),this._cachedDataOpts=null,this.update(reset)},update:helpers$1.noop,transition:function(easingValue){for(var meta=this.getMeta(),elements=meta.data||[],ilen=elements.length,i=0;i<ilen;++i)elements[i].transition(easingValue);meta.dataset&&meta.dataset.transition(easingValue)},draw:function(){var meta=this.getMeta(),elements=meta.data||[],ilen=elements.length,i=0;for(meta.dataset&&meta.dataset.draw();i<ilen;++i)elements[i].draw()},getStyle:function(index){var style,meta=this.getMeta(),dataset=meta.dataset;return this._configure(),dataset&&void 0===index?style=this._resolveDatasetElementOptions(dataset||{}):(index=index||0,style=this._resolveDataElementOptions(meta.data[index]||{},index)),!1!==style.fill&&null!==style.fill||(style.backgroundColor=style.borderColor),style},_resolveDatasetElementOptions:function(element,hover){var i,ilen,key,readKey,me=this,chart=me.chart,datasetOpts=me._config,custom=element.custom||{},options=chart.options.elements[me.datasetElementType.prototype._type]||{},elementOptions=me._datasetElementOptions,values={},context={chart:chart,dataset:me.getDataset(),datasetIndex:me.index,hover:hover};for(i=0,ilen=elementOptions.length;i<ilen;++i)key=elementOptions[i],readKey=hover?"hover"+key.charAt(0).toUpperCase()+key.slice(1):key,values[key]=resolve([custom[readKey],datasetOpts[readKey],options[readKey]],context);return values},_resolveDataElementOptions:function(element,index){var me=this,custom=element&&element.custom,cached=me._cachedDataOpts;if(cached&&!custom)return cached;var keys,i,ilen,key,chart=me.chart,datasetOpts=me._config,options=chart.options.elements[me.dataElementType.prototype._type]||{},elementOptions=me._dataElementOptions,values={},context={chart:chart,dataIndex:index,dataset:me.getDataset(),datasetIndex:me.index},info={cacheable:!custom};if(custom=custom||{},helpers$1.isArray(elementOptions))for(i=0,ilen=elementOptions.length;i<ilen;++i)values[key=elementOptions[i]]=resolve([custom[key],datasetOpts[key],options[key]],context,index,info);else for(i=0,ilen=(keys=Object.keys(elementOptions)).length;i<ilen;++i)values[key=keys[i]]=resolve([custom[key],datasetOpts[elementOptions[key]],datasetOpts[key],options[key]],context,index,info);return info.cacheable&&(me._cachedDataOpts=Object.freeze(values)),values},removeHoverStyle:function(element){helpers$1.merge(element._model,element.$previousStyle||{}),delete element.$previousStyle},setHoverStyle:function(element){var dataset=this.chart.data.datasets[element._datasetIndex],index=element._index,custom=element.custom||{},model=element._model,getHoverColor=helpers$1.getHoverColor;element.$previousStyle={backgroundColor:model.backgroundColor,borderColor:model.borderColor,borderWidth:model.borderWidth},model.backgroundColor=resolve([custom.hoverBackgroundColor,dataset.hoverBackgroundColor,getHoverColor(model.backgroundColor)],void 0,index),model.borderColor=resolve([custom.hoverBorderColor,dataset.hoverBorderColor,getHoverColor(model.borderColor)],void 0,index),model.borderWidth=resolve([custom.hoverBorderWidth,dataset.hoverBorderWidth,model.borderWidth],void 0,index)},_removeDatasetHoverStyle:function(){var element=this.getMeta().dataset;element&&this.removeHoverStyle(element)},_setDatasetHoverStyle:function(){var i,ilen,key,keys,hoverOptions,model,element=this.getMeta().dataset,prev={};if(element){for(model=element._model,hoverOptions=this._resolveDatasetElementOptions(element,!0),i=0,ilen=(keys=Object.keys(hoverOptions)).length;i<ilen;++i)prev[key=keys[i]]=model[key],model[key]=hoverOptions[key];element.$previousStyle=prev}},resyncElements:function(){var meta=this.getMeta(),data=this.getDataset().data,numMeta=meta.data.length,numData=data.length;numData<numMeta?meta.data.splice(numData,numMeta-numData):numData>numMeta&&this.insertElements(numMeta,numData-numMeta)},insertElements:function(start,count){for(var i=0;i<count;++i)this.addElementAndReset(start+i)},onDataPush:function(){var count=arguments.length;this.insertElements(this.getDataset().data.length-count,count)},onDataPop:function(){this.getMeta().data.pop()},onDataShift:function(){this.getMeta().data.shift()},onDataSplice:function(start,count){this.getMeta().data.splice(start,count),this.insertElements(start,arguments.length-2)},onDataUnshift:function(){this.insertElements(0,arguments.length)}}),DatasetController.extend=helpers$1.inherits;var core_datasetController=DatasetController,TAU=2*Math.PI;function clipArc(ctx,arc){var startAngle=arc.startAngle,endAngle=arc.endAngle,pixelMargin=arc.pixelMargin,angleMargin=pixelMargin/arc.outerRadius,x=arc.x,y=arc.y;ctx.beginPath(),ctx.arc(x,y,arc.outerRadius,startAngle-angleMargin,endAngle+angleMargin),arc.innerRadius>pixelMargin?(angleMargin=pixelMargin/arc.innerRadius,ctx.arc(x,y,arc.innerRadius-pixelMargin,endAngle+angleMargin,startAngle-angleMargin,!0)):ctx.arc(x,y,pixelMargin,endAngle+Math.PI/2,startAngle-Math.PI/2),ctx.closePath(),ctx.clip()}function drawBorder(ctx,vm,arc){var inner="inner"===vm.borderAlign;inner?(ctx.lineWidth=2*vm.borderWidth,ctx.lineJoin="round"):(ctx.lineWidth=vm.borderWidth,ctx.lineJoin="bevel"),arc.fullCircles&&function(ctx,vm,arc,inner){var i,endAngle=arc.endAngle;for(inner&&(arc.endAngle=arc.startAngle+TAU,clipArc(ctx,arc),arc.endAngle=endAngle,arc.endAngle===arc.startAngle&&arc.fullCircles&&(arc.endAngle+=TAU,arc.fullCircles--)),ctx.beginPath(),ctx.arc(arc.x,arc.y,arc.innerRadius,arc.startAngle+TAU,arc.startAngle,!0),i=0;i<arc.fullCircles;++i)ctx.stroke();for(ctx.beginPath(),ctx.arc(arc.x,arc.y,vm.outerRadius,arc.startAngle,arc.startAngle+TAU),i=0;i<arc.fullCircles;++i)ctx.stroke()}(ctx,vm,arc,inner),inner&&clipArc(ctx,arc),ctx.beginPath(),ctx.arc(arc.x,arc.y,vm.outerRadius,arc.startAngle,arc.endAngle),ctx.arc(arc.x,arc.y,arc.innerRadius,arc.endAngle,arc.startAngle,!0),ctx.closePath(),ctx.stroke()}core_defaults._set("global",{elements:{arc:{backgroundColor:core_defaults.global.defaultColor,borderColor:"#fff",borderWidth:2,borderAlign:"center"}}});var element_arc=core_element.extend({_type:"arc",inLabelRange:function(mouseX){var vm=this._view;return!!vm&&Math.pow(mouseX-vm.x,2)<Math.pow(vm.radius+vm.hoverRadius,2)},inRange:function(chartX,chartY){var vm=this._view;if(vm){for(var pointRelativePosition=helpers$1.getAngleFromPoint(vm,{x:chartX,y:chartY}),angle=pointRelativePosition.angle,distance=pointRelativePosition.distance,startAngle=vm.startAngle,endAngle=vm.endAngle;endAngle<startAngle;)endAngle+=TAU;for(;angle>endAngle;)angle-=TAU;for(;angle<startAngle;)angle+=TAU;var betweenAngles=angle>=startAngle&&angle<=endAngle,withinRadius=distance>=vm.innerRadius&&distance<=vm.outerRadius;return betweenAngles&&withinRadius}return!1},getCenterPoint:function(){var vm=this._view,halfAngle=(vm.startAngle+vm.endAngle)/2,halfRadius=(vm.innerRadius+vm.outerRadius)/2;return{x:vm.x+Math.cos(halfAngle)*halfRadius,y:vm.y+Math.sin(halfAngle)*halfRadius}},getArea:function(){var vm=this._view;return Math.PI*((vm.endAngle-vm.startAngle)/(2*Math.PI))*(Math.pow(vm.outerRadius,2)-Math.pow(vm.innerRadius,2))},tooltipPosition:function(){var vm=this._view,centreAngle=vm.startAngle+(vm.endAngle-vm.startAngle)/2,rangeFromCentre=(vm.outerRadius-vm.innerRadius)/2+vm.innerRadius;return{x:vm.x+Math.cos(centreAngle)*rangeFromCentre,y:vm.y+Math.sin(centreAngle)*rangeFromCentre}},draw:function(){var i,ctx=this._chart.ctx,vm=this._view,pixelMargin="inner"===vm.borderAlign?.33:0,arc={x:vm.x,y:vm.y,innerRadius:vm.innerRadius,outerRadius:Math.max(vm.outerRadius-pixelMargin,0),pixelMargin:pixelMargin,startAngle:vm.startAngle,endAngle:vm.endAngle,fullCircles:Math.floor(vm.circumference/TAU)};if(ctx.save(),ctx.fillStyle=vm.backgroundColor,ctx.strokeStyle=vm.borderColor,arc.fullCircles){for(arc.endAngle=arc.startAngle+TAU,ctx.beginPath(),ctx.arc(arc.x,arc.y,arc.outerRadius,arc.startAngle,arc.endAngle),ctx.arc(arc.x,arc.y,arc.innerRadius,arc.endAngle,arc.startAngle,!0),ctx.closePath(),i=0;i<arc.fullCircles;++i)ctx.fill();arc.endAngle=arc.startAngle+vm.circumference%TAU}ctx.beginPath(),ctx.arc(arc.x,arc.y,arc.outerRadius,arc.startAngle,arc.endAngle),ctx.arc(arc.x,arc.y,arc.innerRadius,arc.endAngle,arc.startAngle,!0),ctx.closePath(),ctx.fill(),vm.borderWidth&&drawBorder(ctx,vm,arc),ctx.restore()}}),valueOrDefault$1=helpers$1.valueOrDefault,defaultColor=core_defaults.global.defaultColor;core_defaults._set("global",{elements:{line:{tension:.4,backgroundColor:defaultColor,borderWidth:3,borderColor:defaultColor,borderCapStyle:"butt",borderDash:[],borderDashOffset:0,borderJoinStyle:"miter",capBezierPoints:!0,fill:!0}}});var element_line=core_element.extend({_type:"line",draw:function(){var index,previous,currentVM,me=this,vm=me._view,ctx=me._chart.ctx,spanGaps=vm.spanGaps,points=me._children.slice(),globalDefaults=core_defaults.global,globalOptionLineElements=globalDefaults.elements.line,lastDrawnIndex=-1,closePath=me._loop;if(points.length){if(me._loop){for(index=0;index<points.length;++index)if(previous=helpers$1.previousItem(points,index),!points[index]._view.skip&&previous._view.skip){points=points.slice(index).concat(points.slice(0,index)),closePath=spanGaps;break}closePath&&points.push(points[0])}for(ctx.save(),ctx.lineCap=vm.borderCapStyle||globalOptionLineElements.borderCapStyle,ctx.setLineDash&&ctx.setLineDash(vm.borderDash||globalOptionLineElements.borderDash),ctx.lineDashOffset=valueOrDefault$1(vm.borderDashOffset,globalOptionLineElements.borderDashOffset),ctx.lineJoin=vm.borderJoinStyle||globalOptionLineElements.borderJoinStyle,ctx.lineWidth=valueOrDefault$1(vm.borderWidth,globalOptionLineElements.borderWidth),ctx.strokeStyle=vm.borderColor||globalDefaults.defaultColor,ctx.beginPath(),(currentVM=points[0]._view).skip||(ctx.moveTo(currentVM.x,currentVM.y),lastDrawnIndex=0),index=1;index<points.length;++index)currentVM=points[index]._view,previous=-1===lastDrawnIndex?helpers$1.previousItem(points,index):points[lastDrawnIndex],currentVM.skip||(lastDrawnIndex!==index-1&&!spanGaps||-1===lastDrawnIndex?ctx.moveTo(currentVM.x,currentVM.y):helpers$1.canvas.lineTo(ctx,previous._view,currentVM),lastDrawnIndex=index);closePath&&ctx.closePath(),ctx.stroke(),ctx.restore()}}}),valueOrDefault$2=helpers$1.valueOrDefault,defaultColor$1=core_defaults.global.defaultColor;function xRange(mouseX){var vm=this._view;return!!vm&&Math.abs(mouseX-vm.x)<vm.radius+vm.hitRadius}core_defaults._set("global",{elements:{point:{radius:3,pointStyle:"circle",backgroundColor:defaultColor$1,borderColor:defaultColor$1,borderWidth:1,hitRadius:1,hoverRadius:4,hoverBorderWidth:1}}});var element_point=core_element.extend({_type:"point",inRange:function(mouseX,mouseY){var vm=this._view;return!!vm&&Math.pow(mouseX-vm.x,2)+Math.pow(mouseY-vm.y,2)<Math.pow(vm.hitRadius+vm.radius,2)},inLabelRange:xRange,inXRange:xRange,inYRange:function(mouseY){var vm=this._view;return!!vm&&Math.abs(mouseY-vm.y)<vm.radius+vm.hitRadius},getCenterPoint:function(){var vm=this._view;return{x:vm.x,y:vm.y}},getArea:function(){return Math.PI*Math.pow(this._view.radius,2)},tooltipPosition:function(){var vm=this._view;return{x:vm.x,y:vm.y,padding:vm.radius+vm.borderWidth}},draw:function(chartArea){var vm=this._view,ctx=this._chart.ctx,pointStyle=vm.pointStyle,rotation=vm.rotation,radius=vm.radius,x=vm.x,y=vm.y,globalDefaults=core_defaults.global,defaultColor=globalDefaults.defaultColor;vm.skip||(void 0===chartArea||helpers$1.canvas._isPointInArea(vm,chartArea))&&(ctx.strokeStyle=vm.borderColor||defaultColor,ctx.lineWidth=valueOrDefault$2(vm.borderWidth,globalDefaults.elements.point.borderWidth),ctx.fillStyle=vm.backgroundColor||defaultColor,helpers$1.canvas.drawPoint(ctx,pointStyle,radius,x,y,rotation))}}),defaultColor$2=core_defaults.global.defaultColor;function isVertical(vm){return vm&&void 0!==vm.width}function getBarBounds(vm){var x1,x2,y1,y2,half;return isVertical(vm)?(half=vm.width/2,x1=vm.x-half,x2=vm.x+half,y1=Math.min(vm.y,vm.base),y2=Math.max(vm.y,vm.base)):(half=vm.height/2,x1=Math.min(vm.x,vm.base),x2=Math.max(vm.x,vm.base),y1=vm.y-half,y2=vm.y+half),{left:x1,top:y1,right:x2,bottom:y2}}function swap(orig,v1,v2){return orig===v1?v2:orig===v2?v1:orig}function parseBorderWidth(vm,maxW,maxH){var t,r,b,l,value=vm.borderWidth,skip=function(vm){var edge=vm.borderSkipped,res={};return edge?(vm.horizontal?vm.base>vm.x&&(edge=swap(edge,"left","right")):vm.base<vm.y&&(edge=swap(edge,"bottom","top")),res[edge]=!0,res):res}(vm);return helpers$1.isObject(value)?(t=+value.top||0,r=+value.right||0,b=+value.bottom||0,l=+value.left||0):t=r=b=l=+value||0,{t:skip.top||t<0?0:t>maxH?maxH:t,r:skip.right||r<0?0:r>maxW?maxW:r,b:skip.bottom||b<0?0:b>maxH?maxH:b,l:skip.left||l<0?0:l>maxW?maxW:l}}function inRange(vm,x,y){var skipX=null===x,skipY=null===y,bounds=!(!vm||skipX&&skipY)&&getBarBounds(vm);return bounds&&(skipX||x>=bounds.left&&x<=bounds.right)&&(skipY||y>=bounds.top&&y<=bounds.bottom)}core_defaults._set("global",{elements:{rectangle:{backgroundColor:defaultColor$2,borderColor:defaultColor$2,borderSkipped:"bottom",borderWidth:0}}});var element_rectangle=core_element.extend({_type:"rectangle",draw:function(){var ctx=this._chart.ctx,vm=this._view,rects=function(vm){var bounds=getBarBounds(vm),width=bounds.right-bounds.left,height=bounds.bottom-bounds.top,border=parseBorderWidth(vm,width/2,height/2);return{outer:{x:bounds.left,y:bounds.top,w:width,h:height},inner:{x:bounds.left+border.l,y:bounds.top+border.t,w:width-border.l-border.r,h:height-border.t-border.b}}}(vm),outer=rects.outer,inner=rects.inner;ctx.fillStyle=vm.backgroundColor,ctx.fillRect(outer.x,outer.y,outer.w,outer.h),outer.w===inner.w&&outer.h===inner.h||(ctx.save(),ctx.beginPath(),ctx.rect(outer.x,outer.y,outer.w,outer.h),ctx.clip(),ctx.fillStyle=vm.borderColor,ctx.rect(inner.x,inner.y,inner.w,inner.h),ctx.fill("evenodd"),ctx.restore())},height:function(){var vm=this._view;return vm.base-vm.y},inRange:function(mouseX,mouseY){return inRange(this._view,mouseX,mouseY)},inLabelRange:function(mouseX,mouseY){var vm=this._view;return isVertical(vm)?inRange(vm,mouseX,null):inRange(vm,null,mouseY)},inXRange:function(mouseX){return inRange(this._view,mouseX,null)},inYRange:function(mouseY){return inRange(this._view,null,mouseY)},getCenterPoint:function(){var x,y,vm=this._view;return isVertical(vm)?(x=vm.x,y=(vm.y+vm.base)/2):(x=(vm.x+vm.base)/2,y=vm.y),{x:x,y:y}},getArea:function(){var vm=this._view;return isVertical(vm)?vm.width*Math.abs(vm.y-vm.base):vm.height*Math.abs(vm.x-vm.base)},tooltipPosition:function(){var vm=this._view;return{x:vm.x,y:vm.y}}}),elements={},Arc=element_arc,Line=element_line,Point=element_point,Rectangle=element_rectangle;elements.Arc=Arc,elements.Line=Line,elements.Point=Point,elements.Rectangle=Rectangle;var deprecated=helpers$1._deprecated,valueOrDefault$3=helpers$1.valueOrDefault;function computeFitCategoryTraits(index,ruler,options){var size,ratio,thickness=options.barThickness,count=ruler.stackCount,curr=ruler.pixels[index],min=helpers$1.isNullOrUndef(thickness)?function(scale,pixels){var prev,curr,i,ilen,min=scale._length;for(i=1,ilen=pixels.length;i<ilen;++i)min=Math.min(min,Math.abs(pixels[i]-pixels[i-1]));for(i=0,ilen=scale.getTicks().length;i<ilen;++i)curr=scale.getPixelForTick(i),min=i>0?Math.min(min,Math.abs(curr-prev)):min,prev=curr;return min}(ruler.scale,ruler.pixels):-1;return helpers$1.isNullOrUndef(thickness)?(size=min*options.categoryPercentage,ratio=options.barPercentage):(size=thickness*count,ratio=1),{chunk:size/count,ratio:ratio,start:curr-size/2}}core_defaults._set("bar",{hover:{mode:"label"},scales:{xAxes:[{type:"category",offset:!0,gridLines:{offsetGridLines:!0}}],yAxes:[{type:"linear"}]}}),core_defaults._set("global",{datasets:{bar:{categoryPercentage:.8,barPercentage:.9}}});var controller_bar=core_datasetController.extend({dataElementType:elements.Rectangle,_dataElementOptions:["backgroundColor","borderColor","borderSkipped","borderWidth","barPercentage","barThickness","categoryPercentage","maxBarThickness","minBarLength"],initialize:function(){var meta,scaleOpts,me=this;core_datasetController.prototype.initialize.apply(me,arguments),(meta=me.getMeta()).stack=me.getDataset().stack,meta.bar=!0,scaleOpts=me._getIndexScale().options,deprecated("bar chart",scaleOpts.barPercentage,"scales.[x/y]Axes.barPercentage","dataset.barPercentage"),deprecated("bar chart",scaleOpts.barThickness,"scales.[x/y]Axes.barThickness","dataset.barThickness"),deprecated("bar chart",scaleOpts.categoryPercentage,"scales.[x/y]Axes.categoryPercentage","dataset.categoryPercentage"),deprecated("bar chart",me._getValueScale().options.minBarLength,"scales.[x/y]Axes.minBarLength","dataset.minBarLength"),deprecated("bar chart",scaleOpts.maxBarThickness,"scales.[x/y]Axes.maxBarThickness","dataset.maxBarThickness")},update:function(reset){var i,ilen,rects=this.getMeta().data;for(this._ruler=this.getRuler(),i=0,ilen=rects.length;i<ilen;++i)this.updateElement(rects[i],i,reset)},updateElement:function(rectangle,index,reset){var me=this,meta=me.getMeta(),dataset=me.getDataset(),options=me._resolveDataElementOptions(rectangle,index);rectangle._xScale=me.getScaleForId(meta.xAxisID),rectangle._yScale=me.getScaleForId(meta.yAxisID),rectangle._datasetIndex=me.index,rectangle._index=index,rectangle._model={backgroundColor:options.backgroundColor,borderColor:options.borderColor,borderSkipped:options.borderSkipped,borderWidth:options.borderWidth,datasetLabel:dataset.label,label:me.chart.data.labels[index]},helpers$1.isArray(dataset.data[index])&&(rectangle._model.borderSkipped=null),me._updateElementGeometry(rectangle,index,reset,options),rectangle.pivot()},_updateElementGeometry:function(rectangle,index,reset,options){var me=this,model=rectangle._model,vscale=me._getValueScale(),base=vscale.getBasePixel(),horizontal=vscale.isHorizontal(),ruler=me._ruler||me.getRuler(),vpixels=me.calculateBarValuePixels(me.index,index,options),ipixels=me.calculateBarIndexPixels(me.index,index,ruler,options);model.horizontal=horizontal,model.base=reset?base:vpixels.base,model.x=horizontal?reset?base:vpixels.head:ipixels.center,model.y=horizontal?ipixels.center:reset?base:vpixels.head,model.height=horizontal?ipixels.size:void 0,model.width=horizontal?void 0:ipixels.size},_getStacks:function(last){var i,meta,scale=this._getIndexScale(),metasets=scale._getMatchingVisibleMetas(this._type),stacked=scale.options.stacked,ilen=metasets.length,stacks=[];for(i=0;i<ilen&&(meta=metasets[i],(!1===stacked||-1===stacks.indexOf(meta.stack)||void 0===stacked&&void 0===meta.stack)&&stacks.push(meta.stack),meta.index!==last);++i);return stacks},getStackCount:function(){return this._getStacks().length},getStackIndex:function(datasetIndex,name){var stacks=this._getStacks(datasetIndex),index=void 0!==name?stacks.indexOf(name):-1;return-1===index?stacks.length-1:index},getRuler:function(){var i,ilen,scale=this._getIndexScale(),pixels=[];for(i=0,ilen=this.getMeta().data.length;i<ilen;++i)pixels.push(scale.getPixelForValue(null,i,this.index));return{pixels:pixels,start:scale._startPixel,end:scale._endPixel,stackCount:this.getStackCount(),scale:scale}},calculateBarValuePixels:function(datasetIndex,index,options){var i,imeta,ivalue,base,head,size,stackLength,chart=this.chart,scale=this._getValueScale(),isHorizontal=scale.isHorizontal(),datasets=chart.data.datasets,metasets=scale._getMatchingVisibleMetas(this._type),value=scale._parseValue(datasets[datasetIndex].data[index]),minBarLength=options.minBarLength,stacked=scale.options.stacked,stack=this.getMeta().stack,start=void 0===value.start?0:value.max>=0&&value.min>=0?value.min:value.max,length=void 0===value.start?value.end:value.max>=0&&value.min>=0?value.max-value.min:value.min-value.max,ilen=metasets.length;if(stacked||void 0===stacked&&void 0!==stack)for(i=0;i<ilen&&(imeta=metasets[i]).index!==datasetIndex;++i)imeta.stack===stack&&(ivalue=void 0===(stackLength=scale._parseValue(datasets[imeta.index].data[index])).start?stackLength.end:stackLength.min>=0&&stackLength.max>=0?stackLength.max:stackLength.min,(value.min<0&&ivalue<0||value.max>=0&&ivalue>0)&&(start+=ivalue));return base=scale.getPixelForValue(start),size=(head=scale.getPixelForValue(start+length))-base,void 0!==minBarLength&&Math.abs(size)<minBarLength&&(size=minBarLength,head=length>=0&&!isHorizontal||length<0&&isHorizontal?base-minBarLength:base+minBarLength),{size:size,base:base,head:head,center:head+size/2}},calculateBarIndexPixels:function(datasetIndex,index,ruler,options){var range="flex"===options.barThickness?function(index,ruler,options){var start,pixels=ruler.pixels,curr=pixels[index],prev=index>0?pixels[index-1]:null,next=index<pixels.length-1?pixels[index+1]:null,percent=options.categoryPercentage;return null===prev&&(prev=curr-(null===next?ruler.end-ruler.start:next-curr)),null===next&&(next=curr+curr-prev),start=curr-(curr-Math.min(prev,next))/2*percent,{chunk:Math.abs(next-prev)/2*percent/ruler.stackCount,ratio:options.barPercentage,start:start}}(index,ruler,options):computeFitCategoryTraits(index,ruler,options),stackIndex=this.getStackIndex(datasetIndex,this.getMeta().stack),center=range.start+range.chunk*stackIndex+range.chunk/2,size=Math.min(valueOrDefault$3(options.maxBarThickness,1/0),range.chunk*range.ratio);return{base:center-size/2,head:center+size/2,center:center,size:size}},draw:function(){var chart=this.chart,scale=this._getValueScale(),rects=this.getMeta().data,dataset=this.getDataset(),ilen=rects.length,i=0;for(helpers$1.canvas.clipArea(chart.ctx,chart.chartArea);i<ilen;++i){var val=scale._parseValue(dataset.data[i]);isNaN(val.min)||isNaN(val.max)||rects[i].draw()}helpers$1.canvas.unclipArea(chart.ctx)},_resolveDataElementOptions:function(){var me=this,values=helpers$1.extend({},core_datasetController.prototype._resolveDataElementOptions.apply(me,arguments)),indexOpts=me._getIndexScale().options,valueOpts=me._getValueScale().options;return values.barPercentage=valueOrDefault$3(indexOpts.barPercentage,values.barPercentage),values.barThickness=valueOrDefault$3(indexOpts.barThickness,values.barThickness),values.categoryPercentage=valueOrDefault$3(indexOpts.categoryPercentage,values.categoryPercentage),values.maxBarThickness=valueOrDefault$3(indexOpts.maxBarThickness,values.maxBarThickness),values.minBarLength=valueOrDefault$3(valueOpts.minBarLength,values.minBarLength),values}}),valueOrDefault$4=helpers$1.valueOrDefault,resolve$1=helpers$1.options.resolve;core_defaults._set("bubble",{hover:{mode:"single"},scales:{xAxes:[{type:"linear",position:"bottom",id:"x-axis-0"}],yAxes:[{type:"linear",position:"left",id:"y-axis-0"}]},tooltips:{callbacks:{title:function(){return""},label:function(item,data){var datasetLabel=data.datasets[item.datasetIndex].label||"",dataPoint=data.datasets[item.datasetIndex].data[item.index];return datasetLabel+": ("+item.xLabel+", "+item.yLabel+", "+dataPoint.r+")"}}}});var controller_bubble=core_datasetController.extend({dataElementType:elements.Point,_dataElementOptions:["backgroundColor","borderColor","borderWidth","hoverBackgroundColor","hoverBorderColor","hoverBorderWidth","hoverRadius","hitRadius","pointStyle","rotation"],update:function(reset){var me=this,points=me.getMeta().data;helpers$1.each(points,(function(point,index){me.updateElement(point,index,reset)}))},updateElement:function(point,index,reset){var me=this,meta=me.getMeta(),custom=point.custom||{},xScale=me.getScaleForId(meta.xAxisID),yScale=me.getScaleForId(meta.yAxisID),options=me._resolveDataElementOptions(point,index),data=me.getDataset().data[index],dsIndex=me.index,x=reset?xScale.getPixelForDecimal(.5):xScale.getPixelForValue("object"==typeof data?data:NaN,index,dsIndex),y=reset?yScale.getBasePixel():yScale.getPixelForValue(data,index,dsIndex);point._xScale=xScale,point._yScale=yScale,point._options=options,point._datasetIndex=dsIndex,point._index=index,point._model={backgroundColor:options.backgroundColor,borderColor:options.borderColor,borderWidth:options.borderWidth,hitRadius:options.hitRadius,pointStyle:options.pointStyle,rotation:options.rotation,radius:reset?0:options.radius,skip:custom.skip||isNaN(x)||isNaN(y),x:x,y:y},point.pivot()},setHoverStyle:function(point){var model=point._model,options=point._options,getHoverColor=helpers$1.getHoverColor;point.$previousStyle={backgroundColor:model.backgroundColor,borderColor:model.borderColor,borderWidth:model.borderWidth,radius:model.radius},model.backgroundColor=valueOrDefault$4(options.hoverBackgroundColor,getHoverColor(options.backgroundColor)),model.borderColor=valueOrDefault$4(options.hoverBorderColor,getHoverColor(options.borderColor)),model.borderWidth=valueOrDefault$4(options.hoverBorderWidth,options.borderWidth),model.radius=options.radius+options.hoverRadius},_resolveDataElementOptions:function(point,index){var me=this,chart=me.chart,dataset=me.getDataset(),custom=point.custom||{},data=dataset.data[index]||{},values=core_datasetController.prototype._resolveDataElementOptions.apply(me,arguments),context={chart:chart,dataIndex:index,dataset:dataset,datasetIndex:me.index};return me._cachedDataOpts===values&&(values=helpers$1.extend({},values)),values.radius=resolve$1([custom.radius,data.r,me._config.radius,chart.options.elements.point.radius],context,index),values}}),valueOrDefault$5=helpers$1.valueOrDefault,PI$1=Math.PI,DOUBLE_PI$1=2*PI$1,HALF_PI$1=PI$1/2;core_defaults._set("doughnut",{animation:{animateRotate:!0,animateScale:!1},hover:{mode:"single"},legendCallback:function(chart){var i,ilen,listItem,list=document.createElement("ul"),data=chart.data,datasets=data.datasets,labels=data.labels;if(list.setAttribute("class",chart.id+"-legend"),datasets.length)for(i=0,ilen=datasets[0].data.length;i<ilen;++i)(listItem=list.appendChild(document.createElement("li"))).appendChild(document.createElement("span")).style.backgroundColor=datasets[0].backgroundColor[i],labels[i]&&listItem.appendChild(document.createTextNode(labels[i]));return list.outerHTML},legend:{labels:{generateLabels:function(chart){var data=chart.data;return data.labels.length&&data.datasets.length?data.labels.map((function(label,i){var meta=chart.getDatasetMeta(0),style=meta.controller.getStyle(i);return{text:label,fillStyle:style.backgroundColor,strokeStyle:style.borderColor,lineWidth:style.borderWidth,hidden:isNaN(data.datasets[0].data[i])||meta.data[i].hidden,index:i}})):[]}},onClick:function(e,legendItem){var i,ilen,meta,index=legendItem.index,chart=this.chart;for(i=0,ilen=(chart.data.datasets||[]).length;i<ilen;++i)(meta=chart.getDatasetMeta(i)).data[index]&&(meta.data[index].hidden=!meta.data[index].hidden);chart.update()}},cutoutPercentage:50,rotation:-HALF_PI$1,circumference:DOUBLE_PI$1,tooltips:{callbacks:{title:function(){return""},label:function(tooltipItem,data){var dataLabel=data.labels[tooltipItem.index],value=": "+data.datasets[tooltipItem.datasetIndex].data[tooltipItem.index];return helpers$1.isArray(dataLabel)?(dataLabel=dataLabel.slice())[0]+=value:dataLabel+=value,dataLabel}}}});var controller_doughnut=core_datasetController.extend({dataElementType:elements.Arc,linkScales:helpers$1.noop,_dataElementOptions:["backgroundColor","borderColor","borderWidth","borderAlign","hoverBackgroundColor","hoverBorderColor","hoverBorderWidth"],getRingIndex:function(datasetIndex){for(var ringIndex=0,j=0;j<datasetIndex;++j)this.chart.isDatasetVisible(j)&&++ringIndex;return ringIndex},update:function(reset){var maxWidth,maxHeight,i,ilen,me=this,chart=me.chart,chartArea=chart.chartArea,opts=chart.options,ratioX=1,ratioY=1,offsetX=0,offsetY=0,meta=me.getMeta(),arcs=meta.data,cutout=opts.cutoutPercentage/100||0,circumference=opts.circumference,chartWeight=me._getRingWeight(me.index);if(circumference<DOUBLE_PI$1){var startAngle=opts.rotation%DOUBLE_PI$1,endAngle=(startAngle+=startAngle>=PI$1?-DOUBLE_PI$1:startAngle<-PI$1?DOUBLE_PI$1:0)+circumference,startX=Math.cos(startAngle),startY=Math.sin(startAngle),endX=Math.cos(endAngle),endY=Math.sin(endAngle),contains0=startAngle<=0&&endAngle>=0||endAngle>=DOUBLE_PI$1,contains90=startAngle<=HALF_PI$1&&endAngle>=HALF_PI$1||endAngle>=DOUBLE_PI$1+HALF_PI$1,contains270=startAngle<=-HALF_PI$1&&endAngle>=-HALF_PI$1||endAngle>=PI$1+HALF_PI$1,minX=startAngle===-PI$1||endAngle>=PI$1?-1:Math.min(startX,startX*cutout,endX,endX*cutout),minY=contains270?-1:Math.min(startY,startY*cutout,endY,endY*cutout),maxX=contains0?1:Math.max(startX,startX*cutout,endX,endX*cutout),maxY=contains90?1:Math.max(startY,startY*cutout,endY,endY*cutout);ratioX=(maxX-minX)/2,ratioY=(maxY-minY)/2,offsetX=-(maxX+minX)/2,offsetY=-(maxY+minY)/2}for(i=0,ilen=arcs.length;i<ilen;++i)arcs[i]._options=me._resolveDataElementOptions(arcs[i],i);for(chart.borderWidth=me.getMaxBorderWidth(),maxWidth=(chartArea.right-chartArea.left-chart.borderWidth)/ratioX,maxHeight=(chartArea.bottom-chartArea.top-chart.borderWidth)/ratioY,chart.outerRadius=Math.max(Math.min(maxWidth,maxHeight)/2,0),chart.innerRadius=Math.max(chart.outerRadius*cutout,0),chart.radiusLength=(chart.outerRadius-chart.innerRadius)/(me._getVisibleDatasetWeightTotal()||1),chart.offsetX=offsetX*chart.outerRadius,chart.offsetY=offsetY*chart.outerRadius,meta.total=me.calculateTotal(),me.outerRadius=chart.outerRadius-chart.radiusLength*me._getRingWeightOffset(me.index),me.innerRadius=Math.max(me.outerRadius-chart.radiusLength*chartWeight,0),i=0,ilen=arcs.length;i<ilen;++i)me.updateElement(arcs[i],i,reset)},updateElement:function(arc,index,reset){var me=this,chart=me.chart,chartArea=chart.chartArea,opts=chart.options,animationOpts=opts.animation,centerX=(chartArea.left+chartArea.right)/2,centerY=(chartArea.top+chartArea.bottom)/2,startAngle=opts.rotation,endAngle=opts.rotation,dataset=me.getDataset(),circumference=reset&&animationOpts.animateRotate||arc.hidden?0:me.calculateCircumference(dataset.data[index])*(opts.circumference/DOUBLE_PI$1),innerRadius=reset&&animationOpts.animateScale?0:me.innerRadius,outerRadius=reset&&animationOpts.animateScale?0:me.outerRadius,options=arc._options||{};helpers$1.extend(arc,{_datasetIndex:me.index,_index:index,_model:{backgroundColor:options.backgroundColor,borderColor:options.borderColor,borderWidth:options.borderWidth,borderAlign:options.borderAlign,x:centerX+chart.offsetX,y:centerY+chart.offsetY,startAngle:startAngle,endAngle:endAngle,circumference:circumference,outerRadius:outerRadius,innerRadius:innerRadius,label:helpers$1.valueAtIndexOrDefault(dataset.label,index,chart.data.labels[index])}});var model=arc._model;reset&&animationOpts.animateRotate||(model.startAngle=0===index?opts.rotation:me.getMeta().data[index-1]._model.endAngle,model.endAngle=model.startAngle+model.circumference),arc.pivot()},calculateTotal:function(){var value,dataset=this.getDataset(),meta=this.getMeta(),total=0;return helpers$1.each(meta.data,(function(element,index){value=dataset.data[index],isNaN(value)||element.hidden||(total+=Math.abs(value))})),total},calculateCircumference:function(value){var total=this.getMeta().total;return total>0&&!isNaN(value)?DOUBLE_PI$1*(Math.abs(value)/total):0},getMaxBorderWidth:function(arcs){var i,ilen,meta,arc,controller,options,borderWidth,hoverWidth,max=0,chart=this.chart;if(!arcs)for(i=0,ilen=chart.data.datasets.length;i<ilen;++i)if(chart.isDatasetVisible(i)){arcs=(meta=chart.getDatasetMeta(i)).data,i!==this.index&&(controller=meta.controller);break}if(!arcs)return 0;for(i=0,ilen=arcs.length;i<ilen;++i)arc=arcs[i],controller?(controller._configure(),options=controller._resolveDataElementOptions(arc,i)):options=arc._options,"inner"!==options.borderAlign&&(borderWidth=options.borderWidth,max=(hoverWidth=options.hoverBorderWidth)>(max=borderWidth>max?borderWidth:max)?hoverWidth:max);return max},setHoverStyle:function(arc){var model=arc._model,options=arc._options,getHoverColor=helpers$1.getHoverColor;arc.$previousStyle={backgroundColor:model.backgroundColor,borderColor:model.borderColor,borderWidth:model.borderWidth},model.backgroundColor=valueOrDefault$5(options.hoverBackgroundColor,getHoverColor(options.backgroundColor)),model.borderColor=valueOrDefault$5(options.hoverBorderColor,getHoverColor(options.borderColor)),model.borderWidth=valueOrDefault$5(options.hoverBorderWidth,options.borderWidth)},_getRingWeightOffset:function(datasetIndex){for(var ringWeightOffset=0,i=0;i<datasetIndex;++i)this.chart.isDatasetVisible(i)&&(ringWeightOffset+=this._getRingWeight(i));return ringWeightOffset},_getRingWeight:function(dataSetIndex){return Math.max(valueOrDefault$5(this.chart.data.datasets[dataSetIndex].weight,1),0)},_getVisibleDatasetWeightTotal:function(){return this._getRingWeightOffset(this.chart.data.datasets.length)}});core_defaults._set("horizontalBar",{hover:{mode:"index",axis:"y"},scales:{xAxes:[{type:"linear",position:"bottom"}],yAxes:[{type:"category",position:"left",offset:!0,gridLines:{offsetGridLines:!0}}]},elements:{rectangle:{borderSkipped:"left"}},tooltips:{mode:"index",axis:"y"}}),core_defaults._set("global",{datasets:{horizontalBar:{categoryPercentage:.8,barPercentage:.9}}});var controller_horizontalBar=controller_bar.extend({_getValueScaleId:function(){return this.getMeta().xAxisID},_getIndexScaleId:function(){return this.getMeta().yAxisID}}),valueOrDefault$6=helpers$1.valueOrDefault,resolve$2=helpers$1.options.resolve,isPointInArea=helpers$1.canvas._isPointInArea;function scaleClip(scale,halfBorderWidth){var tickOpts=scale&&scale.options.ticks||{},reverse=tickOpts.reverse,min=void 0===tickOpts.min?halfBorderWidth:0,max=void 0===tickOpts.max?halfBorderWidth:0;return{start:reverse?max:min,end:reverse?min:max}}function defaultClip(xScale,yScale,borderWidth){var halfBorderWidth=borderWidth/2,x=scaleClip(xScale,halfBorderWidth),y=scaleClip(yScale,halfBorderWidth);return{top:y.end,right:x.end,bottom:y.start,left:x.start}}function toClip(value){var t,r,b,l;return helpers$1.isObject(value)?(t=value.top,r=value.right,b=value.bottom,l=value.left):t=r=b=l=value,{top:t,right:r,bottom:b,left:l}}core_defaults._set("line",{showLines:!0,spanGaps:!1,hover:{mode:"label"},scales:{xAxes:[{type:"category",id:"x-axis-0"}],yAxes:[{type:"linear",id:"y-axis-0"}]}});var controller_line=core_datasetController.extend({datasetElementType:elements.Line,dataElementType:elements.Point,_datasetElementOptions:["backgroundColor","borderCapStyle","borderColor","borderDash","borderDashOffset","borderJoinStyle","borderWidth","cubicInterpolationMode","fill"],_dataElementOptions:{backgroundColor:"pointBackgroundColor",borderColor:"pointBorderColor",borderWidth:"pointBorderWidth",hitRadius:"pointHitRadius",hoverBackgroundColor:"pointHoverBackgroundColor",hoverBorderColor:"pointHoverBorderColor",hoverBorderWidth:"pointHoverBorderWidth",hoverRadius:"pointHoverRadius",pointStyle:"pointStyle",radius:"pointRadius",rotation:"pointRotation"},update:function(reset){var i,ilen,me=this,meta=me.getMeta(),line=meta.dataset,points=meta.data||[],options=me.chart.options,config=me._config,showLine=me._showLine=valueOrDefault$6(config.showLine,options.showLines);for(me._xScale=me.getScaleForId(meta.xAxisID),me._yScale=me.getScaleForId(meta.yAxisID),showLine&&(void 0!==config.tension&&void 0===config.lineTension&&(config.lineTension=config.tension),line._scale=me._yScale,line._datasetIndex=me.index,line._children=points,line._model=me._resolveDatasetElementOptions(line),line.pivot()),i=0,ilen=points.length;i<ilen;++i)me.updateElement(points[i],i,reset);for(showLine&&0!==line._model.tension&&me.updateBezierControlPoints(),i=0,ilen=points.length;i<ilen;++i)points[i].pivot()},updateElement:function(point,index,reset){var x,y,me=this,meta=me.getMeta(),custom=point.custom||{},dataset=me.getDataset(),datasetIndex=me.index,value=dataset.data[index],xScale=me._xScale,yScale=me._yScale,lineModel=meta.dataset._model,options=me._resolveDataElementOptions(point,index);x=xScale.getPixelForValue("object"==typeof value?value:NaN,index,datasetIndex),y=reset?yScale.getBasePixel():me.calculatePointY(value,index,datasetIndex),point._xScale=xScale,point._yScale=yScale,point._options=options,point._datasetIndex=datasetIndex,point._index=index,point._model={x:x,y:y,skip:custom.skip||isNaN(x)||isNaN(y),radius:options.radius,pointStyle:options.pointStyle,rotation:options.rotation,backgroundColor:options.backgroundColor,borderColor:options.borderColor,borderWidth:options.borderWidth,tension:valueOrDefault$6(custom.tension,lineModel?lineModel.tension:0),steppedLine:!!lineModel&&lineModel.steppedLine,hitRadius:options.hitRadius}},_resolveDatasetElementOptions:function(element){var me=this,config=me._config,custom=element.custom||{},options=me.chart.options,lineOptions=options.elements.line,values=core_datasetController.prototype._resolveDatasetElementOptions.apply(me,arguments);return values.spanGaps=valueOrDefault$6(config.spanGaps,options.spanGaps),values.tension=valueOrDefault$6(config.lineTension,lineOptions.tension),values.steppedLine=resolve$2([custom.steppedLine,config.steppedLine,lineOptions.stepped]),values.clip=toClip(valueOrDefault$6(config.clip,defaultClip(me._xScale,me._yScale,values.borderWidth))),values},calculatePointY:function(value,index,datasetIndex){var i,ds,dsMeta,stackedRightValue,rightValue,metasets,ilen,chart=this.chart,yScale=this._yScale,sumPos=0,sumNeg=0;if(yScale.options.stacked){for(rightValue=+yScale.getRightValue(value),ilen=(metasets=chart._getSortedVisibleDatasetMetas()).length,i=0;i<ilen&&(dsMeta=metasets[i]).index!==datasetIndex;++i)ds=chart.data.datasets[dsMeta.index],"line"===dsMeta.type&&dsMeta.yAxisID===yScale.id&&((stackedRightValue=+yScale.getRightValue(ds.data[index]))<0?sumNeg+=stackedRightValue||0:sumPos+=stackedRightValue||0);return rightValue<0?yScale.getPixelForValue(sumNeg+rightValue):yScale.getPixelForValue(sumPos+rightValue)}return yScale.getPixelForValue(value)},updateBezierControlPoints:function(){var i,ilen,model,controlPoints,chart=this.chart,meta=this.getMeta(),lineModel=meta.dataset._model,area=chart.chartArea,points=meta.data||[];function capControlPoint(pt,min,max){return Math.max(Math.min(pt,max),min)}if(lineModel.spanGaps&&(points=points.filter((function(pt){return!pt._model.skip}))),"monotone"===lineModel.cubicInterpolationMode)helpers$1.splineCurveMonotone(points);else for(i=0,ilen=points.length;i<ilen;++i)model=points[i]._model,controlPoints=helpers$1.splineCurve(helpers$1.previousItem(points,i)._model,model,helpers$1.nextItem(points,i)._model,lineModel.tension),model.controlPointPreviousX=controlPoints.previous.x,model.controlPointPreviousY=controlPoints.previous.y,model.controlPointNextX=controlPoints.next.x,model.controlPointNextY=controlPoints.next.y;if(chart.options.elements.line.capBezierPoints)for(i=0,ilen=points.length;i<ilen;++i)model=points[i]._model,isPointInArea(model,area)&&(i>0&&isPointInArea(points[i-1]._model,area)&&(model.controlPointPreviousX=capControlPoint(model.controlPointPreviousX,area.left,area.right),model.controlPointPreviousY=capControlPoint(model.controlPointPreviousY,area.top,area.bottom)),i<points.length-1&&isPointInArea(points[i+1]._model,area)&&(model.controlPointNextX=capControlPoint(model.controlPointNextX,area.left,area.right),model.controlPointNextY=capControlPoint(model.controlPointNextY,area.top,area.bottom)))},draw:function(){var clip,chart=this.chart,meta=this.getMeta(),points=meta.data||[],area=chart.chartArea,canvas=chart.canvas,i=0,ilen=points.length;for(this._showLine&&(clip=meta.dataset._model.clip,helpers$1.canvas.clipArea(chart.ctx,{left:!1===clip.left?0:area.left-clip.left,right:!1===clip.right?canvas.width:area.right+clip.right,top:!1===clip.top?0:area.top-clip.top,bottom:!1===clip.bottom?canvas.height:area.bottom+clip.bottom}),meta.dataset.draw(),helpers$1.canvas.unclipArea(chart.ctx));i<ilen;++i)points[i].draw(area)},setHoverStyle:function(point){var model=point._model,options=point._options,getHoverColor=helpers$1.getHoverColor;point.$previousStyle={backgroundColor:model.backgroundColor,borderColor:model.borderColor,borderWidth:model.borderWidth,radius:model.radius},model.backgroundColor=valueOrDefault$6(options.hoverBackgroundColor,getHoverColor(options.backgroundColor)),model.borderColor=valueOrDefault$6(options.hoverBorderColor,getHoverColor(options.borderColor)),model.borderWidth=valueOrDefault$6(options.hoverBorderWidth,options.borderWidth),model.radius=valueOrDefault$6(options.hoverRadius,options.radius)}}),resolve$3=helpers$1.options.resolve;core_defaults._set("polarArea",{scale:{type:"radialLinear",angleLines:{display:!1},gridLines:{circular:!0},pointLabels:{display:!1},ticks:{beginAtZero:!0}},animation:{animateRotate:!0,animateScale:!0},startAngle:-.5*Math.PI,legendCallback:function(chart){var i,ilen,listItem,list=document.createElement("ul"),data=chart.data,datasets=data.datasets,labels=data.labels;if(list.setAttribute("class",chart.id+"-legend"),datasets.length)for(i=0,ilen=datasets[0].data.length;i<ilen;++i)(listItem=list.appendChild(document.createElement("li"))).appendChild(document.createElement("span")).style.backgroundColor=datasets[0].backgroundColor[i],labels[i]&&listItem.appendChild(document.createTextNode(labels[i]));return list.outerHTML},legend:{labels:{generateLabels:function(chart){var data=chart.data;return data.labels.length&&data.datasets.length?data.labels.map((function(label,i){var meta=chart.getDatasetMeta(0),style=meta.controller.getStyle(i);return{text:label,fillStyle:style.backgroundColor,strokeStyle:style.borderColor,lineWidth:style.borderWidth,hidden:isNaN(data.datasets[0].data[i])||meta.data[i].hidden,index:i}})):[]}},onClick:function(e,legendItem){var i,ilen,meta,index=legendItem.index,chart=this.chart;for(i=0,ilen=(chart.data.datasets||[]).length;i<ilen;++i)(meta=chart.getDatasetMeta(i)).data[index].hidden=!meta.data[index].hidden;chart.update()}},tooltips:{callbacks:{title:function(){return""},label:function(item,data){return data.labels[item.index]+": "+item.yLabel}}}});var controller_polarArea=core_datasetController.extend({dataElementType:elements.Arc,linkScales:helpers$1.noop,_dataElementOptions:["backgroundColor","borderColor","borderWidth","borderAlign","hoverBackgroundColor","hoverBorderColor","hoverBorderWidth"],_getIndexScaleId:function(){return this.chart.scale.id},_getValueScaleId:function(){return this.chart.scale.id},update:function(reset){var i,ilen,angle,me=this,dataset=me.getDataset(),meta=me.getMeta(),start=me.chart.options.startAngle||0,starts=me._starts=[],angles=me._angles=[],arcs=meta.data;for(me._updateRadius(),meta.count=me.countVisibleElements(),i=0,ilen=dataset.data.length;i<ilen;i++)starts[i]=start,angle=me._computeAngle(i),angles[i]=angle,start+=angle;for(i=0,ilen=arcs.length;i<ilen;++i)arcs[i]._options=me._resolveDataElementOptions(arcs[i],i),me.updateElement(arcs[i],i,reset)},_updateRadius:function(){var me=this,chart=me.chart,chartArea=chart.chartArea,opts=chart.options,minSize=Math.min(chartArea.right-chartArea.left,chartArea.bottom-chartArea.top);chart.outerRadius=Math.max(minSize/2,0),chart.innerRadius=Math.max(opts.cutoutPercentage?chart.outerRadius/100*opts.cutoutPercentage:1,0),chart.radiusLength=(chart.outerRadius-chart.innerRadius)/chart.getVisibleDatasetCount(),me.outerRadius=chart.outerRadius-chart.radiusLength*me.index,me.innerRadius=me.outerRadius-chart.radiusLength},updateElement:function(arc,index,reset){var me=this,chart=me.chart,dataset=me.getDataset(),opts=chart.options,animationOpts=opts.animation,scale=chart.scale,labels=chart.data.labels,centerX=scale.xCenter,centerY=scale.yCenter,datasetStartAngle=opts.startAngle,distance=arc.hidden?0:scale.getDistanceFromCenterForValue(dataset.data[index]),startAngle=me._starts[index],endAngle=startAngle+(arc.hidden?0:me._angles[index]),resetRadius=animationOpts.animateScale?0:scale.getDistanceFromCenterForValue(dataset.data[index]),options=arc._options||{};helpers$1.extend(arc,{_datasetIndex:me.index,_index:index,_scale:scale,_model:{backgroundColor:options.backgroundColor,borderColor:options.borderColor,borderWidth:options.borderWidth,borderAlign:options.borderAlign,x:centerX,y:centerY,innerRadius:0,outerRadius:reset?resetRadius:distance,startAngle:reset&&animationOpts.animateRotate?datasetStartAngle:startAngle,endAngle:reset&&animationOpts.animateRotate?datasetStartAngle:endAngle,label:helpers$1.valueAtIndexOrDefault(labels,index,labels[index])}}),arc.pivot()},countVisibleElements:function(){var dataset=this.getDataset(),meta=this.getMeta(),count=0;return helpers$1.each(meta.data,(function(element,index){isNaN(dataset.data[index])||element.hidden||count++})),count},setHoverStyle:function(arc){var model=arc._model,options=arc._options,getHoverColor=helpers$1.getHoverColor,valueOrDefault=helpers$1.valueOrDefault;arc.$previousStyle={backgroundColor:model.backgroundColor,borderColor:model.borderColor,borderWidth:model.borderWidth},model.backgroundColor=valueOrDefault(options.hoverBackgroundColor,getHoverColor(options.backgroundColor)),model.borderColor=valueOrDefault(options.hoverBorderColor,getHoverColor(options.borderColor)),model.borderWidth=valueOrDefault(options.hoverBorderWidth,options.borderWidth)},_computeAngle:function(index){var me=this,count=this.getMeta().count,dataset=me.getDataset(),meta=me.getMeta();if(isNaN(dataset.data[index])||meta.data[index].hidden)return 0;var context={chart:me.chart,dataIndex:index,dataset:dataset,datasetIndex:me.index};return resolve$3([me.chart.options.elements.arc.angle,2*Math.PI/count],context,index)}});core_defaults._set("pie",helpers$1.clone(core_defaults.doughnut)),core_defaults._set("pie",{cutoutPercentage:0});var controller_pie=controller_doughnut,valueOrDefault$7=helpers$1.valueOrDefault;core_defaults._set("radar",{spanGaps:!1,scale:{type:"radialLinear"},elements:{line:{fill:"start",tension:0}}});var controller_radar=core_datasetController.extend({datasetElementType:elements.Line,dataElementType:elements.Point,linkScales:helpers$1.noop,_datasetElementOptions:["backgroundColor","borderWidth","borderColor","borderCapStyle","borderDash","borderDashOffset","borderJoinStyle","fill"],_dataElementOptions:{backgroundColor:"pointBackgroundColor",borderColor:"pointBorderColor",borderWidth:"pointBorderWidth",hitRadius:"pointHitRadius",hoverBackgroundColor:"pointHoverBackgroundColor",hoverBorderColor:"pointHoverBorderColor",hoverBorderWidth:"pointHoverBorderWidth",hoverRadius:"pointHoverRadius",pointStyle:"pointStyle",radius:"pointRadius",rotation:"pointRotation"},_getIndexScaleId:function(){return this.chart.scale.id},_getValueScaleId:function(){return this.chart.scale.id},update:function(reset){var i,ilen,me=this,meta=me.getMeta(),line=meta.dataset,points=meta.data||[],scale=me.chart.scale,config=me._config;for(void 0!==config.tension&&void 0===config.lineTension&&(config.lineTension=config.tension),line._scale=scale,line._datasetIndex=me.index,line._children=points,line._loop=!0,line._model=me._resolveDatasetElementOptions(line),line.pivot(),i=0,ilen=points.length;i<ilen;++i)me.updateElement(points[i],i,reset);for(me.updateBezierControlPoints(),i=0,ilen=points.length;i<ilen;++i)points[i].pivot()},updateElement:function(point,index,reset){var me=this,custom=point.custom||{},dataset=me.getDataset(),scale=me.chart.scale,pointPosition=scale.getPointPositionForValue(index,dataset.data[index]),options=me._resolveDataElementOptions(point,index),lineModel=me.getMeta().dataset._model,x=reset?scale.xCenter:pointPosition.x,y=reset?scale.yCenter:pointPosition.y;point._scale=scale,point._options=options,point._datasetIndex=me.index,point._index=index,point._model={x:x,y:y,skip:custom.skip||isNaN(x)||isNaN(y),radius:options.radius,pointStyle:options.pointStyle,rotation:options.rotation,backgroundColor:options.backgroundColor,borderColor:options.borderColor,borderWidth:options.borderWidth,tension:valueOrDefault$7(custom.tension,lineModel?lineModel.tension:0),hitRadius:options.hitRadius}},_resolveDatasetElementOptions:function(){var me=this,config=me._config,options=me.chart.options,values=core_datasetController.prototype._resolveDatasetElementOptions.apply(me,arguments);return values.spanGaps=valueOrDefault$7(config.spanGaps,options.spanGaps),values.tension=valueOrDefault$7(config.lineTension,options.elements.line.tension),values},updateBezierControlPoints:function(){var i,ilen,model,controlPoints,meta=this.getMeta(),area=this.chart.chartArea,points=meta.data||[];function capControlPoint(pt,min,max){return Math.max(Math.min(pt,max),min)}for(meta.dataset._model.spanGaps&&(points=points.filter((function(pt){return!pt._model.skip}))),i=0,ilen=points.length;i<ilen;++i)model=points[i]._model,controlPoints=helpers$1.splineCurve(helpers$1.previousItem(points,i,!0)._model,model,helpers$1.nextItem(points,i,!0)._model,model.tension),model.controlPointPreviousX=capControlPoint(controlPoints.previous.x,area.left,area.right),model.controlPointPreviousY=capControlPoint(controlPoints.previous.y,area.top,area.bottom),model.controlPointNextX=capControlPoint(controlPoints.next.x,area.left,area.right),model.controlPointNextY=capControlPoint(controlPoints.next.y,area.top,area.bottom)},setHoverStyle:function(point){var model=point._model,options=point._options,getHoverColor=helpers$1.getHoverColor;point.$previousStyle={backgroundColor:model.backgroundColor,borderColor:model.borderColor,borderWidth:model.borderWidth,radius:model.radius},model.backgroundColor=valueOrDefault$7(options.hoverBackgroundColor,getHoverColor(options.backgroundColor)),model.borderColor=valueOrDefault$7(options.hoverBorderColor,getHoverColor(options.borderColor)),model.borderWidth=valueOrDefault$7(options.hoverBorderWidth,options.borderWidth),model.radius=valueOrDefault$7(options.hoverRadius,options.radius)}});core_defaults._set("scatter",{hover:{mode:"single"},scales:{xAxes:[{id:"x-axis-1",type:"linear",position:"bottom"}],yAxes:[{id:"y-axis-1",type:"linear",position:"left"}]},tooltips:{callbacks:{title:function(){return""},label:function(item){return"("+item.xLabel+", "+item.yLabel+")"}}}}),core_defaults._set("global",{datasets:{scatter:{showLine:!1}}});var controllers={bar:controller_bar,bubble:controller_bubble,doughnut:controller_doughnut,horizontalBar:controller_horizontalBar,line:controller_line,polarArea:controller_polarArea,pie:controller_pie,radar:controller_radar,scatter:controller_line};function getRelativePosition(e,chart){return e.native?{x:e.x,y:e.y}:helpers$1.getRelativePosition(e,chart)}function parseVisibleItems(chart,handler){var metadata,i,j,ilen,jlen,element,metasets=chart._getSortedVisibleDatasetMetas();for(i=0,ilen=metasets.length;i<ilen;++i)for(j=0,jlen=(metadata=metasets[i].data).length;j<jlen;++j)(element=metadata[j])._view.skip||handler(element)}function getIntersectItems(chart,position){var elements=[];return parseVisibleItems(chart,(function(element){element.inRange(position.x,position.y)&&elements.push(element)})),elements}function getNearestItems(chart,position,intersect,distanceMetric){var minDistance=Number.POSITIVE_INFINITY,nearestItems=[];return parseVisibleItems(chart,(function(element){if(!intersect||element.inRange(position.x,position.y)){var center=element.getCenterPoint(),distance=distanceMetric(position,center);distance<minDistance?(nearestItems=[element],minDistance=distance):distance===minDistance&&nearestItems.push(element)}})),nearestItems}function getDistanceMetricForAxis(axis){var useX=-1!==axis.indexOf("x"),useY=-1!==axis.indexOf("y");return function(pt1,pt2){var deltaX=useX?Math.abs(pt1.x-pt2.x):0,deltaY=useY?Math.abs(pt1.y-pt2.y):0;return Math.sqrt(Math.pow(deltaX,2)+Math.pow(deltaY,2))}}function indexMode(chart,e,options){var position=getRelativePosition(e,chart);options.axis=options.axis||"x";var distanceMetric=getDistanceMetricForAxis(options.axis),items=options.intersect?getIntersectItems(chart,position):getNearestItems(chart,position,!1,distanceMetric),elements=[];return items.length?(chart._getSortedVisibleDatasetMetas().forEach((function(meta){var element=meta.data[items[0]._index];element&&!element._view.skip&&elements.push(element)})),elements):[]}var core_interaction={modes:{single:function(chart,e){var position=getRelativePosition(e,chart),elements=[];return parseVisibleItems(chart,(function(element){if(element.inRange(position.x,position.y))return elements.push(element),elements})),elements.slice(0,1)},label:indexMode,index:indexMode,dataset:function(chart,e,options){var position=getRelativePosition(e,chart);options.axis=options.axis||"xy";var distanceMetric=getDistanceMetricForAxis(options.axis),items=options.intersect?getIntersectItems(chart,position):getNearestItems(chart,position,!1,distanceMetric);return items.length>0&&(items=chart.getDatasetMeta(items[0]._datasetIndex).data),items},"x-axis":function(chart,e){return indexMode(chart,e,{intersect:!1})},point:function(chart,e){return getIntersectItems(chart,getRelativePosition(e,chart))},nearest:function(chart,e,options){var position=getRelativePosition(e,chart);options.axis=options.axis||"xy";var distanceMetric=getDistanceMetricForAxis(options.axis);return getNearestItems(chart,position,options.intersect,distanceMetric)},x:function(chart,e,options){var position=getRelativePosition(e,chart),items=[],intersectsItem=!1;return parseVisibleItems(chart,(function(element){element.inXRange(position.x)&&items.push(element),element.inRange(position.x,position.y)&&(intersectsItem=!0)})),options.intersect&&!intersectsItem&&(items=[]),items},y:function(chart,e,options){var position=getRelativePosition(e,chart),items=[],intersectsItem=!1;return parseVisibleItems(chart,(function(element){element.inYRange(position.y)&&items.push(element),element.inRange(position.x,position.y)&&(intersectsItem=!0)})),options.intersect&&!intersectsItem&&(items=[]),items}}},extend=helpers$1.extend;function filterByPosition(array,position){return helpers$1.where(array,(function(v){return v.pos===position}))}function sortByWeight(array,reverse){return array.sort((function(a,b){var v0=reverse?b:a,v1=reverse?a:b;return v0.weight===v1.weight?v0.index-v1.index:v0.weight-v1.weight}))}function getCombinedMax(maxPadding,chartArea,a,b){return Math.max(maxPadding[a],chartArea[a])+Math.max(maxPadding[b],chartArea[b])}function updateDims(chartArea,params,layout){var newWidth,newHeight,box=layout.box,maxPadding=chartArea.maxPadding;if(layout.size&&(chartArea[layout.pos]-=layout.size),layout.size=layout.horizontal?box.height:box.width,chartArea[layout.pos]+=layout.size,box.getPadding){var boxPadding=box.getPadding();maxPadding.top=Math.max(maxPadding.top,boxPadding.top),maxPadding.left=Math.max(maxPadding.left,boxPadding.left),maxPadding.bottom=Math.max(maxPadding.bottom,boxPadding.bottom),maxPadding.right=Math.max(maxPadding.right,boxPadding.right)}if(newWidth=params.outerWidth-getCombinedMax(maxPadding,chartArea,"left","right"),newHeight=params.outerHeight-getCombinedMax(maxPadding,chartArea,"top","bottom"),newWidth!==chartArea.w||newHeight!==chartArea.h){chartArea.w=newWidth,chartArea.h=newHeight;var sizes=layout.horizontal?[newWidth,chartArea.w]:[newHeight,chartArea.h];return!(sizes[0]===sizes[1]||isNaN(sizes[0])&&isNaN(sizes[1]))}}function getMargins(horizontal,chartArea){var maxPadding=chartArea.maxPadding;function marginForPositions(positions){var margin={left:0,top:0,right:0,bottom:0};return positions.forEach((function(pos){margin[pos]=Math.max(chartArea[pos],maxPadding[pos])})),margin}return marginForPositions(horizontal?["left","right"]:["top","bottom"])}function fitBoxes(boxes,chartArea,params){var i,ilen,layout,box,refit,changed,refitBoxes=[];for(i=0,ilen=boxes.length;i<ilen;++i)(box=(layout=boxes[i]).box).update(layout.width||chartArea.w,layout.height||chartArea.h,getMargins(layout.horizontal,chartArea)),updateDims(chartArea,params,layout)&&(changed=!0,refitBoxes.length&&(refit=!0)),box.fullWidth||refitBoxes.push(layout);return refit&&fitBoxes(refitBoxes,chartArea,params)||changed}function placeBoxes(boxes,chartArea,params){var i,ilen,layout,box,userPadding=params.padding,x=chartArea.x,y=chartArea.y;for(i=0,ilen=boxes.length;i<ilen;++i)box=(layout=boxes[i]).box,layout.horizontal?(box.left=box.fullWidth?userPadding.left:chartArea.left,box.right=box.fullWidth?params.outerWidth-userPadding.right:chartArea.left+chartArea.w,box.top=y,box.bottom=y+box.height,box.width=box.right-box.left,y=box.bottom):(box.left=x,box.right=x+box.width,box.top=chartArea.top,box.bottom=chartArea.top+chartArea.h,box.height=box.bottom-box.top,x=box.right);chartArea.x=x,chartArea.y=y}core_defaults._set("global",{layout:{padding:{top:0,right:0,bottom:0,left:0}}});var n,core_layouts={defaults:{},addBox:function(chart,item){chart.boxes||(chart.boxes=[]),item.fullWidth=item.fullWidth||!1,item.position=item.position||"top",item.weight=item.weight||0,item._layers=item._layers||function(){return[{z:0,draw:function(){item.draw.apply(item,arguments)}}]},chart.boxes.push(item)},removeBox:function(chart,layoutItem){var index=chart.boxes?chart.boxes.indexOf(layoutItem):-1;-1!==index&&chart.boxes.splice(index,1)},configure:function(chart,item,options){for(var prop,props=["fullWidth","position","weight"],ilen=props.length,i=0;i<ilen;++i)prop=props[i],options.hasOwnProperty(prop)&&(item[prop]=options[prop])},update:function(chart,width,height){if(chart){var layoutOptions=chart.options.layout||{},padding=helpers$1.options.toPadding(layoutOptions.padding),availableWidth=width-padding.width,availableHeight=height-padding.height,boxes=function(boxes){var layoutBoxes=function(boxes){var i,ilen,box,layoutBoxes=[];for(i=0,ilen=(boxes||[]).length;i<ilen;++i)box=boxes[i],layoutBoxes.push({index:i,box:box,pos:box.position,horizontal:box.isHorizontal(),weight:box.weight});return layoutBoxes}(boxes),left=sortByWeight(filterByPosition(layoutBoxes,"left"),!0),right=sortByWeight(filterByPosition(layoutBoxes,"right")),top=sortByWeight(filterByPosition(layoutBoxes,"top"),!0),bottom=sortByWeight(filterByPosition(layoutBoxes,"bottom"));return{leftAndTop:left.concat(top),rightAndBottom:right.concat(bottom),chartArea:filterByPosition(layoutBoxes,"chartArea"),vertical:left.concat(right),horizontal:top.concat(bottom)}}(chart.boxes),verticalBoxes=boxes.vertical,horizontalBoxes=boxes.horizontal,params=Object.freeze({outerWidth:width,outerHeight:height,padding:padding,availableWidth:availableWidth,vBoxMaxWidth:availableWidth/2/verticalBoxes.length,hBoxMaxHeight:availableHeight/2}),chartArea=extend({maxPadding:extend({},padding),w:availableWidth,h:availableHeight,x:padding.left,y:padding.top},padding);!function(layouts,params){var i,ilen,layout;for(i=0,ilen=layouts.length;i<ilen;++i)(layout=layouts[i]).width=layout.horizontal?layout.box.fullWidth&&params.availableWidth:params.vBoxMaxWidth,layout.height=layout.horizontal&&params.hBoxMaxHeight}(verticalBoxes.concat(horizontalBoxes),params),fitBoxes(verticalBoxes,chartArea,params),fitBoxes(horizontalBoxes,chartArea,params)&&fitBoxes(verticalBoxes,chartArea,params),function(chartArea){var maxPadding=chartArea.maxPadding;function updatePos(pos){var change=Math.max(maxPadding[pos]-chartArea[pos],0);return chartArea[pos]+=change,change}chartArea.y+=updatePos("top"),chartArea.x+=updatePos("left"),updatePos("right"),updatePos("bottom")}(chartArea),placeBoxes(boxes.leftAndTop,chartArea,params),chartArea.x+=chartArea.w,chartArea.y+=chartArea.h,placeBoxes(boxes.rightAndBottom,chartArea,params),chart.chartArea={left:chartArea.left,top:chartArea.top,right:chartArea.left+chartArea.w,bottom:chartArea.top+chartArea.h},helpers$1.each(boxes.chartArea,(function(layout){var box=layout.box;extend(box,chart.chartArea),box.update(chartArea.w,chartArea.h)}))}}},platform_dom$1=Object.freeze({__proto__:null,default:"/*\r\n * DOM element rendering detection\r\n * https://davidwalsh.name/detect-node-insertion\r\n */\r\n@keyframes chartjs-render-animation {\r\n\tfrom { opacity: 0.99; }\r\n\tto { opacity: 1; }\r\n}\r\n\r\n.chartjs-render-monitor {\r\n\tanimation: chartjs-render-animation 0.001s;\r\n}\r\n\r\n/*\r\n * DOM element resizing detection\r\n * https://github.com/marcj/css-element-queries\r\n */\r\n.chartjs-size-monitor,\r\n.chartjs-size-monitor-expand,\r\n.chartjs-size-monitor-shrink {\r\n\tposition: absolute;\r\n\tdirection: ltr;\r\n\tleft: 0;\r\n\ttop: 0;\r\n\tright: 0;\r\n\tbottom: 0;\r\n\toverflow: hidden;\r\n\tpointer-events: none;\r\n\tvisibility: hidden;\r\n\tz-index: -1;\r\n}\r\n\r\n.chartjs-size-monitor-expand > div {\r\n\tposition: absolute;\r\n\twidth: 1000000px;\r\n\theight: 1000000px;\r\n\tleft: 0;\r\n\ttop: 0;\r\n}\r\n\r\n.chartjs-size-monitor-shrink > div {\r\n\tposition: absolute;\r\n\twidth: 200%;\r\n\theight: 200%;\r\n\tleft: 0;\r\n\ttop: 0;\r\n}\r\n"}),stylesheet=(n=platform_dom$1)&&n.default||n,ANIMATION_START_EVENTS=["animationstart","webkitAnimationStart"],EVENT_TYPES={touchstart:"mousedown",touchmove:"mousemove",touchend:"mouseup",pointerenter:"mouseenter",pointerdown:"mousedown",pointermove:"mousemove",pointerup:"mouseup",pointerleave:"mouseout",pointerout:"mouseout"};function readUsedSize(element,property){var value=helpers$1.getStyle(element,property),matches=value&&value.match(/^(\d+)(\.\d+)?px$/);return matches?Number(matches[1]):void 0}var supportsEventListenerOptions=function(){var supports=!1;try{var options=Object.defineProperty({},"passive",{get:function(){supports=!0}});window.addEventListener("e",null,options)}catch(e){}return supports}(),eventListenerOptions=!!supportsEventListenerOptions&&{passive:!0};function addListener(node,type,listener){node.addEventListener(type,listener,eventListenerOptions)}function removeListener(node,type,listener){node.removeEventListener(type,listener,eventListenerOptions)}function createEvent(type,chart,x,y,nativeEvent){return{type:type,chart:chart,native:nativeEvent||null,x:void 0!==x?x:null,y:void 0!==y?y:null}}function createDiv(cls){var el=document.createElement("div");return el.className=cls||"",el}function addResizeListener(node,listener,chart){var fn,thisArg,ticking,args,expando=node.$chartjs||(node.$chartjs={}),resizer=expando.resizer=function(handler){var resizer=createDiv("chartjs-size-monitor"),expand=createDiv("chartjs-size-monitor-expand"),shrink=createDiv("chartjs-size-monitor-shrink");expand.appendChild(createDiv()),shrink.appendChild(createDiv()),resizer.appendChild(expand),resizer.appendChild(shrink),resizer._reset=function(){expand.scrollLeft=1e6,expand.scrollTop=1e6,shrink.scrollLeft=1e6,shrink.scrollTop=1e6};var onScroll=function(){resizer._reset(),handler()};return addListener(expand,"scroll",onScroll.bind(expand,"expand")),addListener(shrink,"scroll",onScroll.bind(shrink,"shrink")),resizer}((fn=function(){if(expando.resizer){var container=chart.options.maintainAspectRatio&&node.parentNode,w=container?container.clientWidth:0;listener(createEvent("resize",chart)),container&&container.clientWidth<w&&chart.canvas&&listener(createEvent("resize",chart))}},ticking=!1,args=[],function(){args=Array.prototype.slice.call(arguments),thisArg=thisArg||this,ticking||(ticking=!0,helpers$1.requestAnimFrame.call(window,(function(){ticking=!1,fn.apply(thisArg,args)})))}));!function(node,handler){var expando=node.$chartjs||(node.$chartjs={}),proxy=expando.renderProxy=function(e){"chartjs-render-animation"===e.animationName&&handler()};helpers$1.each(ANIMATION_START_EVENTS,(function(type){addListener(node,type,proxy)})),expando.reflow=!!node.offsetParent,node.classList.add("chartjs-render-monitor")}(node,(function(){if(expando.resizer){var container=node.parentNode;container&&container!==resizer.parentNode&&container.insertBefore(resizer,container.firstChild),resizer._reset()}}))}function removeResizeListener(node){var expando=node.$chartjs||{},resizer=expando.resizer;delete expando.resizer,function(node){var expando=node.$chartjs||{},proxy=expando.renderProxy;proxy&&(helpers$1.each(ANIMATION_START_EVENTS,(function(type){removeListener(node,type,proxy)})),delete expando.renderProxy),node.classList.remove("chartjs-render-monitor")}(node),resizer&&resizer.parentNode&&resizer.parentNode.removeChild(resizer)}var platform_dom$2={disableCSSInjection:!1,_enabled:"undefined"!=typeof window&&"undefined"!=typeof document,_ensureLoaded:function(canvas){if(!this.disableCSSInjection){var root=canvas.getRootNode?canvas.getRootNode():document;!function(rootNode,css){var expando=rootNode.$chartjs||(rootNode.$chartjs={});if(!expando.containsStyles){expando.containsStyles=!0,css="/* Chart.js */\n"+css;var style=document.createElement("style");style.setAttribute("type","text/css"),style.appendChild(document.createTextNode(css)),rootNode.appendChild(style)}}(root.host?root:document.head,stylesheet)}},acquireContext:function(item,config){"string"==typeof item?item=document.getElementById(item):item.length&&(item=item[0]),item&&item.canvas&&(item=item.canvas);var context=item&&item.getContext&&item.getContext("2d");return context&&context.canvas===item?(this._ensureLoaded(item),function(canvas,config){var style=canvas.style,renderHeight=canvas.getAttribute("height"),renderWidth=canvas.getAttribute("width");if(canvas.$chartjs={initial:{height:renderHeight,width:renderWidth,style:{display:style.display,height:style.height,width:style.width}}},style.display=style.display||"block",null===renderWidth||""===renderWidth){var displayWidth=readUsedSize(canvas,"width");void 0!==displayWidth&&(canvas.width=displayWidth)}if(null===renderHeight||""===renderHeight)if(""===canvas.style.height)canvas.height=canvas.width/(config.options.aspectRatio||2);else{var displayHeight=readUsedSize(canvas,"height");void 0!==displayWidth&&(canvas.height=displayHeight)}}(item,config),context):null},releaseContext:function(context){var canvas=context.canvas;if(canvas.$chartjs){var initial=canvas.$chartjs.initial;["height","width"].forEach((function(prop){var value=initial[prop];helpers$1.isNullOrUndef(value)?canvas.removeAttribute(prop):canvas.setAttribute(prop,value)})),helpers$1.each(initial.style||{},(function(value,key){canvas.style[key]=value})),canvas.width=canvas.width,delete canvas.$chartjs}},addEventListener:function(chart,type,listener){var canvas=chart.canvas;if("resize"!==type){var expando=listener.$chartjs||(listener.$chartjs={}),proxy=(expando.proxies||(expando.proxies={}))[chart.id+"_"+type]=function(event){listener(function(event,chart){var type=EVENT_TYPES[event.type]||event.type,pos=helpers$1.getRelativePosition(event,chart);return createEvent(type,chart,pos.x,pos.y,event)}(event,chart))};addListener(canvas,type,proxy)}else addResizeListener(canvas,listener,chart)},removeEventListener:function(chart,type,listener){var canvas=chart.canvas;if("resize"!==type){var proxy=((listener.$chartjs||{}).proxies||{})[chart.id+"_"+type];proxy&&removeListener(canvas,type,proxy)}else removeResizeListener(canvas)}};helpers$1.addEvent=addListener,helpers$1.removeEvent=removeListener;var implementation=platform_dom$2._enabled?platform_dom$2:{acquireContext:function(item){return item&&item.canvas&&(item=item.canvas),item&&item.getContext("2d")||null}},platform=helpers$1.extend({initialize:function(){},acquireContext:function(){},releaseContext:function(){},addEventListener:function(){},removeEventListener:function(){}},implementation);core_defaults._set("global",{plugins:{}});var core_plugins={_plugins:[],_cacheId:0,register:function(plugins){var p=this._plugins;[].concat(plugins).forEach((function(plugin){-1===p.indexOf(plugin)&&p.push(plugin)})),this._cacheId++},unregister:function(plugins){var p=this._plugins;[].concat(plugins).forEach((function(plugin){var idx=p.indexOf(plugin);-1!==idx&&p.splice(idx,1)})),this._cacheId++},clear:function(){this._plugins=[],this._cacheId++},count:function(){return this._plugins.length},getAll:function(){return this._plugins},notify:function(chart,hook,args){var i,descriptor,plugin,params,method,descriptors=this.descriptors(chart),ilen=descriptors.length;for(i=0;i<ilen;++i)if("function"==typeof(method=(plugin=(descriptor=descriptors[i]).plugin)[hook])&&((params=[chart].concat(args||[])).push(descriptor.options),!1===method.apply(plugin,params)))return!1;return!0},descriptors:function(chart){var cache=chart.$plugins||(chart.$plugins={});if(cache.id===this._cacheId)return cache.descriptors;var plugins=[],descriptors=[],config=chart&&chart.config||{},options=config.options&&config.options.plugins||{};return this._plugins.concat(config.plugins||[]).forEach((function(plugin){if(-1===plugins.indexOf(plugin)){var id=plugin.id,opts=options[id];!1!==opts&&(!0===opts&&(opts=helpers$1.clone(core_defaults.global.plugins[id])),plugins.push(plugin),descriptors.push({plugin:plugin,options:opts||{}}))}})),cache.descriptors=descriptors,cache.id=this._cacheId,descriptors},_invalidate:function(chart){delete chart.$plugins}},core_scaleService={constructors:{},defaults:{},registerScaleType:function(type,scaleConstructor,scaleDefaults){this.constructors[type]=scaleConstructor,this.defaults[type]=helpers$1.clone(scaleDefaults)},getScaleConstructor:function(type){return this.constructors.hasOwnProperty(type)?this.constructors[type]:void 0},getScaleDefaults:function(type){return this.defaults.hasOwnProperty(type)?helpers$1.merge(Object.create(null),[core_defaults.scale,this.defaults[type]]):{}},updateScaleDefaults:function(type,additions){this.defaults.hasOwnProperty(type)&&(this.defaults[type]=helpers$1.extend(this.defaults[type],additions))},addScalesToLayout:function(chart){helpers$1.each(chart.scales,(function(scale){scale.fullWidth=scale.options.fullWidth,scale.position=scale.options.position,scale.weight=scale.options.weight,core_layouts.addBox(chart,scale)}))}},valueOrDefault$8=helpers$1.valueOrDefault,getRtlHelper=helpers$1.rtl.getRtlAdapter;core_defaults._set("global",{tooltips:{enabled:!0,custom:null,mode:"nearest",position:"average",intersect:!0,backgroundColor:"rgba(0,0,0,0.8)",titleFontStyle:"bold",titleSpacing:2,titleMarginBottom:6,titleFontColor:"#fff",titleAlign:"left",bodySpacing:2,bodyFontColor:"#fff",bodyAlign:"left",footerFontStyle:"bold",footerSpacing:2,footerMarginTop:6,footerFontColor:"#fff",footerAlign:"left",yPadding:6,xPadding:6,caretPadding:2,caretSize:5,cornerRadius:6,multiKeyBackground:"#fff",displayColors:!0,borderColor:"rgba(0,0,0,0)",borderWidth:0,callbacks:{beforeTitle:helpers$1.noop,title:function(tooltipItems,data){var title="",labels=data.labels,labelCount=labels?labels.length:0;if(tooltipItems.length>0){var item=tooltipItems[0];item.label?title=item.label:item.xLabel?title=item.xLabel:labelCount>0&&item.index<labelCount&&(title=labels[item.index])}return title},afterTitle:helpers$1.noop,beforeBody:helpers$1.noop,beforeLabel:helpers$1.noop,label:function(tooltipItem,data){var label=data.datasets[tooltipItem.datasetIndex].label||"";return label&&(label+=": "),helpers$1.isNullOrUndef(tooltipItem.value)?label+=tooltipItem.yLabel:label+=tooltipItem.value,label},labelColor:function(tooltipItem,chart){var view=chart.getDatasetMeta(tooltipItem.datasetIndex).data[tooltipItem.index]._view;return{borderColor:view.borderColor,backgroundColor:view.backgroundColor}},labelTextColor:function(){return this._options.bodyFontColor},afterLabel:helpers$1.noop,afterBody:helpers$1.noop,beforeFooter:helpers$1.noop,footer:helpers$1.noop,afterFooter:helpers$1.noop}}});var positioners={average:function(elements){if(!elements.length)return!1;var i,len,x=0,y=0,count=0;for(i=0,len=elements.length;i<len;++i){var el=elements[i];if(el&&el.hasValue()){var pos=el.tooltipPosition();x+=pos.x,y+=pos.y,++count}}return{x:x/count,y:y/count}},nearest:function(elements,eventPosition){var i,len,nearestElement,x=eventPosition.x,y=eventPosition.y,minDistance=Number.POSITIVE_INFINITY;for(i=0,len=elements.length;i<len;++i){var el=elements[i];if(el&&el.hasValue()){var center=el.getCenterPoint(),d=helpers$1.distanceBetweenPoints(eventPosition,center);d<minDistance&&(minDistance=d,nearestElement=el)}}if(nearestElement){var tp=nearestElement.tooltipPosition();x=tp.x,y=tp.y}return{x:x,y:y}}};function pushOrConcat(base,toPush){return toPush&&(helpers$1.isArray(toPush)?Array.prototype.push.apply(base,toPush):base.push(toPush)),base}function splitNewlines(str){return("string"==typeof str||str instanceof String)&&str.indexOf("\n")>-1?str.split("\n"):str}function getBaseModel(tooltipOpts){var globalDefaults=core_defaults.global;return{xPadding:tooltipOpts.xPadding,yPadding:tooltipOpts.yPadding,xAlign:tooltipOpts.xAlign,yAlign:tooltipOpts.yAlign,rtl:tooltipOpts.rtl,textDirection:tooltipOpts.textDirection,bodyFontColor:tooltipOpts.bodyFontColor,_bodyFontFamily:valueOrDefault$8(tooltipOpts.bodyFontFamily,globalDefaults.defaultFontFamily),_bodyFontStyle:valueOrDefault$8(tooltipOpts.bodyFontStyle,globalDefaults.defaultFontStyle),_bodyAlign:tooltipOpts.bodyAlign,bodyFontSize:valueOrDefault$8(tooltipOpts.bodyFontSize,globalDefaults.defaultFontSize),bodySpacing:tooltipOpts.bodySpacing,titleFontColor:tooltipOpts.titleFontColor,_titleFontFamily:valueOrDefault$8(tooltipOpts.titleFontFamily,globalDefaults.defaultFontFamily),_titleFontStyle:valueOrDefault$8(tooltipOpts.titleFontStyle,globalDefaults.defaultFontStyle),titleFontSize:valueOrDefault$8(tooltipOpts.titleFontSize,globalDefaults.defaultFontSize),_titleAlign:tooltipOpts.titleAlign,titleSpacing:tooltipOpts.titleSpacing,titleMarginBottom:tooltipOpts.titleMarginBottom,footerFontColor:tooltipOpts.footerFontColor,_footerFontFamily:valueOrDefault$8(tooltipOpts.footerFontFamily,globalDefaults.defaultFontFamily),_footerFontStyle:valueOrDefault$8(tooltipOpts.footerFontStyle,globalDefaults.defaultFontStyle),footerFontSize:valueOrDefault$8(tooltipOpts.footerFontSize,globalDefaults.defaultFontSize),_footerAlign:tooltipOpts.footerAlign,footerSpacing:tooltipOpts.footerSpacing,footerMarginTop:tooltipOpts.footerMarginTop,caretSize:tooltipOpts.caretSize,cornerRadius:tooltipOpts.cornerRadius,backgroundColor:tooltipOpts.backgroundColor,opacity:0,legendColorBackground:tooltipOpts.multiKeyBackground,displayColors:tooltipOpts.displayColors,borderColor:tooltipOpts.borderColor,borderWidth:tooltipOpts.borderWidth}}function getAlignedX(vm,align){return"center"===align?vm.x+vm.width/2:"right"===align?vm.x+vm.width-vm.xPadding:vm.x+vm.xPadding}function getBeforeAfterBodyLines(callback){return pushOrConcat([],splitNewlines(callback))}var exports$4=core_element.extend({initialize:function(){this._model=getBaseModel(this._options),this._lastActive=[]},getTitle:function(){var me=this,opts=me._options,callbacks=opts.callbacks,beforeTitle=callbacks.beforeTitle.apply(me,arguments),title=callbacks.title.apply(me,arguments),afterTitle=callbacks.afterTitle.apply(me,arguments),lines=[];return lines=pushOrConcat(lines,splitNewlines(beforeTitle)),lines=pushOrConcat(lines,splitNewlines(title)),lines=pushOrConcat(lines,splitNewlines(afterTitle))},getBeforeBody:function(){return getBeforeAfterBodyLines(this._options.callbacks.beforeBody.apply(this,arguments))},getBody:function(tooltipItems,data){var me=this,callbacks=me._options.callbacks,bodyItems=[];return helpers$1.each(tooltipItems,(function(tooltipItem){var bodyItem={before:[],lines:[],after:[]};pushOrConcat(bodyItem.before,splitNewlines(callbacks.beforeLabel.call(me,tooltipItem,data))),pushOrConcat(bodyItem.lines,callbacks.label.call(me,tooltipItem,data)),pushOrConcat(bodyItem.after,splitNewlines(callbacks.afterLabel.call(me,tooltipItem,data))),bodyItems.push(bodyItem)})),bodyItems},getAfterBody:function(){return getBeforeAfterBodyLines(this._options.callbacks.afterBody.apply(this,arguments))},getFooter:function(){var me=this,callbacks=me._options.callbacks,beforeFooter=callbacks.beforeFooter.apply(me,arguments),footer=callbacks.footer.apply(me,arguments),afterFooter=callbacks.afterFooter.apply(me,arguments),lines=[];return lines=pushOrConcat(lines,splitNewlines(beforeFooter)),lines=pushOrConcat(lines,splitNewlines(footer)),lines=pushOrConcat(lines,splitNewlines(afterFooter))},update:function(changed){var i,len,element,xScale,yScale,index,datasetIndex,controller,indexScale,valueScale,me=this,opts=me._options,existingModel=me._model,model=me._model=getBaseModel(opts),active=me._active,data=me._data,alignment={xAlign:existingModel.xAlign,yAlign:existingModel.yAlign},backgroundPoint={x:existingModel.x,y:existingModel.y},tooltipSize={width:existingModel.width,height:existingModel.height},tooltipPosition={x:existingModel.caretX,y:existingModel.caretY};if(active.length){model.opacity=1;var labelColors=[],labelTextColors=[];tooltipPosition=positioners[opts.position].call(me,active,me._eventPosition);var tooltipItems=[];for(i=0,len=active.length;i<len;++i)tooltipItems.push((element=active[i],xScale=void 0,yScale=void 0,index=void 0,datasetIndex=void 0,controller=void 0,indexScale=void 0,valueScale=void 0,xScale=element._xScale,yScale=element._yScale||element._scale,index=element._index,datasetIndex=element._datasetIndex,controller=element._chart.getDatasetMeta(datasetIndex).controller,indexScale=controller._getIndexScale(),valueScale=controller._getValueScale(),{xLabel:xScale?xScale.getLabelForIndex(index,datasetIndex):"",yLabel:yScale?yScale.getLabelForIndex(index,datasetIndex):"",label:indexScale?""+indexScale.getLabelForIndex(index,datasetIndex):"",value:valueScale?""+valueScale.getLabelForIndex(index,datasetIndex):"",index:index,datasetIndex:datasetIndex,x:element._model.x,y:element._model.y}));opts.filter&&(tooltipItems=tooltipItems.filter((function(a){return opts.filter(a,data)}))),opts.itemSort&&(tooltipItems=tooltipItems.sort((function(a,b){return opts.itemSort(a,b,data)}))),helpers$1.each(tooltipItems,(function(tooltipItem){labelColors.push(opts.callbacks.labelColor.call(me,tooltipItem,me._chart)),labelTextColors.push(opts.callbacks.labelTextColor.call(me,tooltipItem,me._chart))})),model.title=me.getTitle(tooltipItems,data),model.beforeBody=me.getBeforeBody(tooltipItems,data),model.body=me.getBody(tooltipItems,data),model.afterBody=me.getAfterBody(tooltipItems,data),model.footer=me.getFooter(tooltipItems,data),model.x=tooltipPosition.x,model.y=tooltipPosition.y,model.caretPadding=opts.caretPadding,model.labelColors=labelColors,model.labelTextColors=labelTextColors,model.dataPoints=tooltipItems,tooltipSize=function(tooltip,model){var ctx=tooltip._chart.ctx,height=2*model.yPadding,width=0,body=model.body,combinedBodyLength=body.reduce((function(count,bodyItem){return count+bodyItem.before.length+bodyItem.lines.length+bodyItem.after.length}),0);combinedBodyLength+=model.beforeBody.length+model.afterBody.length;var titleLineCount=model.title.length,footerLineCount=model.footer.length,titleFontSize=model.titleFontSize,bodyFontSize=model.bodyFontSize,footerFontSize=model.footerFontSize;height+=titleLineCount*titleFontSize,height+=titleLineCount?(titleLineCount-1)*model.titleSpacing:0,height+=titleLineCount?model.titleMarginBottom:0,height+=combinedBodyLength*bodyFontSize,height+=combinedBodyLength?(combinedBodyLength-1)*model.bodySpacing:0,height+=footerLineCount?model.footerMarginTop:0,height+=footerLineCount*footerFontSize,height+=footerLineCount?(footerLineCount-1)*model.footerSpacing:0;var widthPadding=0,maxLineWidth=function(line){width=Math.max(width,ctx.measureText(line).width+widthPadding)};return ctx.font=helpers$1.fontString(titleFontSize,model._titleFontStyle,model._titleFontFamily),helpers$1.each(model.title,maxLineWidth),ctx.font=helpers$1.fontString(bodyFontSize,model._bodyFontStyle,model._bodyFontFamily),helpers$1.each(model.beforeBody.concat(model.afterBody),maxLineWidth),widthPadding=model.displayColors?bodyFontSize+2:0,helpers$1.each(body,(function(bodyItem){helpers$1.each(bodyItem.before,maxLineWidth),helpers$1.each(bodyItem.lines,maxLineWidth),helpers$1.each(bodyItem.after,maxLineWidth)})),widthPadding=0,ctx.font=helpers$1.fontString(footerFontSize,model._footerFontStyle,model._footerFontFamily),helpers$1.each(model.footer,maxLineWidth),{width:width+=2*model.xPadding,height:height}}(this,model),alignment=function(tooltip,size){var lf,rf,olf,orf,yf,model=tooltip._model,chart=tooltip._chart,chartArea=tooltip._chart.chartArea,xAlign="center",yAlign="center";model.y<size.height?yAlign="top":model.y>chart.height-size.height&&(yAlign="bottom");var midX=(chartArea.left+chartArea.right)/2,midY=(chartArea.top+chartArea.bottom)/2;"center"===yAlign?(lf=function(x){return x<=midX},rf=function(x){return x>midX}):(lf=function(x){return x<=size.width/2},rf=function(x){return x>=chart.width-size.width/2}),olf=function(x){return x+size.width+model.caretSize+model.caretPadding>chart.width},orf=function(x){return x-size.width-model.caretSize-model.caretPadding<0},yf=function(y){return y<=midY?"top":"bottom"},lf(model.x)?(xAlign="left",olf(model.x)&&(xAlign="center",yAlign=yf(model.y))):rf(model.x)&&(xAlign="right",orf(model.x)&&(xAlign="center",yAlign=yf(model.y)));var opts=tooltip._options;return{xAlign:opts.xAlign?opts.xAlign:xAlign,yAlign:opts.yAlign?opts.yAlign:yAlign}}(this,tooltipSize),backgroundPoint=function(vm,size,alignment,chart){var x=vm.x,y=vm.y,caretSize=vm.caretSize,caretPadding=vm.caretPadding,cornerRadius=vm.cornerRadius,xAlign=alignment.xAlign,yAlign=alignment.yAlign,paddingAndSize=caretSize+caretPadding,radiusAndPadding=cornerRadius+caretPadding;return"right"===xAlign?x-=size.width:"center"===xAlign&&((x-=size.width/2)+size.width>chart.width&&(x=chart.width-size.width),x<0&&(x=0)),"top"===yAlign?y+=paddingAndSize:y-="bottom"===yAlign?size.height+paddingAndSize:size.height/2,"center"===yAlign?"left"===xAlign?x+=paddingAndSize:"right"===xAlign&&(x-=paddingAndSize):"left"===xAlign?x-=radiusAndPadding:"right"===xAlign&&(x+=radiusAndPadding),{x:x,y:y}}(model,tooltipSize,alignment,me._chart)}else model.opacity=0;return model.xAlign=alignment.xAlign,model.yAlign=alignment.yAlign,model.x=backgroundPoint.x,model.y=backgroundPoint.y,model.width=tooltipSize.width,model.height=tooltipSize.height,model.caretX=tooltipPosition.x,model.caretY=tooltipPosition.y,me._model=model,changed&&opts.custom&&opts.custom.call(me,model),me},drawCaret:function(tooltipPoint,size){var ctx=this._chart.ctx,vm=this._view,caretPosition=this.getCaretPosition(tooltipPoint,size,vm);ctx.lineTo(caretPosition.x1,caretPosition.y1),ctx.lineTo(caretPosition.x2,caretPosition.y2),ctx.lineTo(caretPosition.x3,caretPosition.y3)},getCaretPosition:function(tooltipPoint,size,vm){var x1,x2,x3,y1,y2,y3,caretSize=vm.caretSize,cornerRadius=vm.cornerRadius,xAlign=vm.xAlign,yAlign=vm.yAlign,ptX=tooltipPoint.x,ptY=tooltipPoint.y,width=size.width,height=size.height;if("center"===yAlign)y2=ptY+height/2,"left"===xAlign?(x2=(x1=ptX)-caretSize,x3=x1,y1=y2+caretSize,y3=y2-caretSize):(x2=(x1=ptX+width)+caretSize,x3=x1,y1=y2-caretSize,y3=y2+caretSize);else if("left"===xAlign?(x1=(x2=ptX+cornerRadius+caretSize)-caretSize,x3=x2+caretSize):"right"===xAlign?(x1=(x2=ptX+width-cornerRadius-caretSize)-caretSize,x3=x2+caretSize):(x1=(x2=vm.caretX)-caretSize,x3=x2+caretSize),"top"===yAlign)y2=(y1=ptY)-caretSize,y3=y1;else{y2=(y1=ptY+height)+caretSize,y3=y1;var tmp=x3;x3=x1,x1=tmp}return{x1:x1,x2:x2,x3:x3,y1:y1,y2:y2,y3:y3}},drawTitle:function(pt,vm,ctx){var titleFontSize,titleSpacing,i,title=vm.title,length=title.length;if(length){var rtlHelper=getRtlHelper(vm.rtl,vm.x,vm.width);for(pt.x=getAlignedX(vm,vm._titleAlign),ctx.textAlign=rtlHelper.textAlign(vm._titleAlign),ctx.textBaseline="middle",titleFontSize=vm.titleFontSize,titleSpacing=vm.titleSpacing,ctx.fillStyle=vm.titleFontColor,ctx.font=helpers$1.fontString(titleFontSize,vm._titleFontStyle,vm._titleFontFamily),i=0;i<length;++i)ctx.fillText(title[i],rtlHelper.x(pt.x),pt.y+titleFontSize/2),pt.y+=titleFontSize+titleSpacing,i+1===length&&(pt.y+=vm.titleMarginBottom-titleSpacing)}},drawBody:function(pt,vm,ctx){var bodyItem,textColor,labelColors,lines,i,j,ilen,jlen,bodyFontSize=vm.bodyFontSize,bodySpacing=vm.bodySpacing,bodyAlign=vm._bodyAlign,body=vm.body,drawColorBoxes=vm.displayColors,xLinePadding=0,colorX=drawColorBoxes?getAlignedX(vm,"left"):0,rtlHelper=getRtlHelper(vm.rtl,vm.x,vm.width),fillLineOfText=function(line){ctx.fillText(line,rtlHelper.x(pt.x+xLinePadding),pt.y+bodyFontSize/2),pt.y+=bodyFontSize+bodySpacing},bodyAlignForCalculation=rtlHelper.textAlign(bodyAlign);for(ctx.textAlign=bodyAlign,ctx.textBaseline="middle",ctx.font=helpers$1.fontString(bodyFontSize,vm._bodyFontStyle,vm._bodyFontFamily),pt.x=getAlignedX(vm,bodyAlignForCalculation),ctx.fillStyle=vm.bodyFontColor,helpers$1.each(vm.beforeBody,fillLineOfText),xLinePadding=drawColorBoxes&&"right"!==bodyAlignForCalculation?"center"===bodyAlign?bodyFontSize/2+1:bodyFontSize+2:0,i=0,ilen=body.length;i<ilen;++i){for(bodyItem=body[i],textColor=vm.labelTextColors[i],labelColors=vm.labelColors[i],ctx.fillStyle=textColor,helpers$1.each(bodyItem.before,fillLineOfText),j=0,jlen=(lines=bodyItem.lines).length;j<jlen;++j){if(drawColorBoxes){var rtlColorX=rtlHelper.x(colorX);ctx.fillStyle=vm.legendColorBackground,ctx.fillRect(rtlHelper.leftForLtr(rtlColorX,bodyFontSize),pt.y,bodyFontSize,bodyFontSize),ctx.lineWidth=1,ctx.strokeStyle=labelColors.borderColor,ctx.strokeRect(rtlHelper.leftForLtr(rtlColorX,bodyFontSize),pt.y,bodyFontSize,bodyFontSize),ctx.fillStyle=labelColors.backgroundColor,ctx.fillRect(rtlHelper.leftForLtr(rtlHelper.xPlus(rtlColorX,1),bodyFontSize-2),pt.y+1,bodyFontSize-2,bodyFontSize-2),ctx.fillStyle=textColor}fillLineOfText(lines[j])}helpers$1.each(bodyItem.after,fillLineOfText)}xLinePadding=0,helpers$1.each(vm.afterBody,fillLineOfText),pt.y-=bodySpacing},drawFooter:function(pt,vm,ctx){var footerFontSize,i,footer=vm.footer,length=footer.length;if(length){var rtlHelper=getRtlHelper(vm.rtl,vm.x,vm.width);for(pt.x=getAlignedX(vm,vm._footerAlign),pt.y+=vm.footerMarginTop,ctx.textAlign=rtlHelper.textAlign(vm._footerAlign),ctx.textBaseline="middle",footerFontSize=vm.footerFontSize,ctx.fillStyle=vm.footerFontColor,ctx.font=helpers$1.fontString(footerFontSize,vm._footerFontStyle,vm._footerFontFamily),i=0;i<length;++i)ctx.fillText(footer[i],rtlHelper.x(pt.x),pt.y+footerFontSize/2),pt.y+=footerFontSize+vm.footerSpacing}},drawBackground:function(pt,vm,ctx,tooltipSize){ctx.fillStyle=vm.backgroundColor,ctx.strokeStyle=vm.borderColor,ctx.lineWidth=vm.borderWidth;var xAlign=vm.xAlign,yAlign=vm.yAlign,x=pt.x,y=pt.y,width=tooltipSize.width,height=tooltipSize.height,radius=vm.cornerRadius;ctx.beginPath(),ctx.moveTo(x+radius,y),"top"===yAlign&&this.drawCaret(pt,tooltipSize),ctx.lineTo(x+width-radius,y),ctx.quadraticCurveTo(x+width,y,x+width,y+radius),"center"===yAlign&&"right"===xAlign&&this.drawCaret(pt,tooltipSize),ctx.lineTo(x+width,y+height-radius),ctx.quadraticCurveTo(x+width,y+height,x+width-radius,y+height),"bottom"===yAlign&&this.drawCaret(pt,tooltipSize),ctx.lineTo(x+radius,y+height),ctx.quadraticCurveTo(x,y+height,x,y+height-radius),"center"===yAlign&&"left"===xAlign&&this.drawCaret(pt,tooltipSize),ctx.lineTo(x,y+radius),ctx.quadraticCurveTo(x,y,x+radius,y),ctx.closePath(),ctx.fill(),vm.borderWidth>0&&ctx.stroke()},draw:function(){var ctx=this._chart.ctx,vm=this._view;if(0!==vm.opacity){var tooltipSize={width:vm.width,height:vm.height},pt={x:vm.x,y:vm.y},opacity=Math.abs(vm.opacity<.001)?0:vm.opacity,hasTooltipContent=vm.title.length||vm.beforeBody.length||vm.body.length||vm.afterBody.length||vm.footer.length;this._options.enabled&&hasTooltipContent&&(ctx.save(),ctx.globalAlpha=opacity,this.drawBackground(pt,vm,ctx,tooltipSize),pt.y+=vm.yPadding,helpers$1.rtl.overrideTextDirection(ctx,vm.textDirection),this.drawTitle(pt,vm,ctx),this.drawBody(pt,vm,ctx),this.drawFooter(pt,vm,ctx),helpers$1.rtl.restoreTextDirection(ctx,vm.textDirection),ctx.restore())}},handleEvent:function(e){var changed,me=this,options=me._options;return me._lastActive=me._lastActive||[],"mouseout"===e.type?me._active=[]:(me._active=me._chart.getElementsAtEventForMode(e,options.mode,options),options.reverse&&me._active.reverse()),(changed=!helpers$1.arrayEquals(me._active,me._lastActive))&&(me._lastActive=me._active,(options.enabled||options.custom)&&(me._eventPosition={x:e.x,y:e.y},me.update(!0),me.pivot())),changed}}),positioners_1=positioners,core_tooltip=exports$4;core_tooltip.positioners=positioners_1;var valueOrDefault$9=helpers$1.valueOrDefault;function mergeScaleConfig(){return helpers$1.merge(Object.create(null),[].slice.call(arguments),{merger:function(key,target,source,options){if("xAxes"===key||"yAxes"===key){var i,type,scale,slen=source[key].length;for(target[key]||(target[key]=[]),i=0;i<slen;++i)scale=source[key][i],type=valueOrDefault$9(scale.type,"xAxes"===key?"category":"linear"),i>=target[key].length&&target[key].push({}),!target[key][i].type||scale.type&&scale.type!==target[key][i].type?helpers$1.merge(target[key][i],[core_scaleService.getScaleDefaults(type),scale]):helpers$1.merge(target[key][i],scale)}else helpers$1._merger(key,target,source,options)}})}function mergeConfig(){return helpers$1.merge(Object.create(null),[].slice.call(arguments),{merger:function(key,target,source,options){var tval=target[key]||Object.create(null),sval=source[key];"scales"===key?target[key]=mergeScaleConfig(tval,sval):"scale"===key?target[key]=helpers$1.merge(tval,[core_scaleService.getScaleDefaults(sval.type),sval]):helpers$1._merger(key,target,source,options)}})}function updateConfig(chart){var newOptions=chart.options;helpers$1.each(chart.scales,(function(scale){core_layouts.removeBox(chart,scale)})),newOptions=mergeConfig(core_defaults.global,core_defaults[chart.config.type],newOptions),chart.options=chart.config.options=newOptions,chart.ensureScalesHaveIDs(),chart.buildOrUpdateScales(),chart.tooltip._options=newOptions.tooltips,chart.tooltip.initialize()}function nextAvailableScaleId(axesOpts,prefix,index){var id,hasId=function(obj){return obj.id===id};do{id=prefix+index++}while(helpers$1.findIndex(axesOpts,hasId)>=0);return id}function positionIsHorizontal(position){return"top"===position||"bottom"===position}function compare2Level(l1,l2){return function(a,b){return a[l1]===b[l1]?a[l2]-b[l2]:a[l1]-b[l1]}}core_defaults._set("global",{elements:{},events:["mousemove","mouseout","click","touchstart","touchmove"],hover:{onHover:null,mode:"nearest",intersect:!0,animationDuration:400},onClick:null,maintainAspectRatio:!0,responsive:!0,responsiveAnimationDuration:0});var Chart=function(item,config){return this.construct(item,config),this};helpers$1.extend(Chart.prototype,{construct:function(item,config){var me=this;config=function(config){var data=(config=config||Object.create(null)).data=config.data||{};return data.datasets=data.datasets||[],data.labels=data.labels||[],config.options=mergeConfig(core_defaults.global,core_defaults[config.type],config.options||{}),config}(config);var context=platform.acquireContext(item,config),canvas=context&&context.canvas,height=canvas&&canvas.height,width=canvas&&canvas.width;me.id=helpers$1.uid(),me.ctx=context,me.canvas=canvas,me.config=config,me.width=width,me.height=height,me.aspectRatio=height?width/height:null,me.options=config.options,me._bufferedRender=!1,me._layers=[],me.chart=me,me.controller=me,Chart.instances[me.id]=me,Object.defineProperty(me,"data",{get:function(){return me.config.data},set:function(value){me.config.data=value}}),context&&canvas?(me.initialize(),me.update()):console.error("Failed to create chart: can't acquire context from the given item")},initialize:function(){var me=this;return core_plugins.notify(me,"beforeInit"),helpers$1.retinaScale(me,me.options.devicePixelRatio),me.bindEvents(),me.options.responsive&&me.resize(!0),me.initToolTip(),core_plugins.notify(me,"afterInit"),me},clear:function(){return helpers$1.canvas.clear(this),this},stop:function(){return core_animations.cancelAnimation(this),this},resize:function(silent){var me=this,options=me.options,canvas=me.canvas,aspectRatio=options.maintainAspectRatio&&me.aspectRatio||null,newWidth=Math.max(0,Math.floor(helpers$1.getMaximumWidth(canvas))),newHeight=Math.max(0,Math.floor(aspectRatio?newWidth/aspectRatio:helpers$1.getMaximumHeight(canvas)));if((me.width!==newWidth||me.height!==newHeight)&&(canvas.width=me.width=newWidth,canvas.height=me.height=newHeight,canvas.style.width=newWidth+"px",canvas.style.height=newHeight+"px",helpers$1.retinaScale(me,options.devicePixelRatio),!silent)){var newSize={width:newWidth,height:newHeight};core_plugins.notify(me,"resize",[newSize]),options.onResize&&options.onResize(me,newSize),me.stop(),me.update({duration:options.responsiveAnimationDuration})}},ensureScalesHaveIDs:function(){var options=this.options,scalesOptions=options.scales||{},scaleOptions=options.scale;helpers$1.each(scalesOptions.xAxes,(function(xAxisOptions,index){xAxisOptions.id||(xAxisOptions.id=nextAvailableScaleId(scalesOptions.xAxes,"x-axis-",index))})),helpers$1.each(scalesOptions.yAxes,(function(yAxisOptions,index){yAxisOptions.id||(yAxisOptions.id=nextAvailableScaleId(scalesOptions.yAxes,"y-axis-",index))})),scaleOptions&&(scaleOptions.id=scaleOptions.id||"scale")},buildOrUpdateScales:function(){var me=this,options=me.options,scales=me.scales||{},items=[],updated=Object.keys(scales).reduce((function(obj,id){return obj[id]=!1,obj}),{});options.scales&&(items=items.concat((options.scales.xAxes||[]).map((function(xAxisOptions){return{options:xAxisOptions,dtype:"category",dposition:"bottom"}})),(options.scales.yAxes||[]).map((function(yAxisOptions){return{options:yAxisOptions,dtype:"linear",dposition:"left"}})))),options.scale&&items.push({options:options.scale,dtype:"radialLinear",isDefault:!0,dposition:"chartArea"}),helpers$1.each(items,(function(item){var scaleOptions=item.options,id=scaleOptions.id,scaleType=valueOrDefault$9(scaleOptions.type,item.dtype);positionIsHorizontal(scaleOptions.position)!==positionIsHorizontal(item.dposition)&&(scaleOptions.position=item.dposition),updated[id]=!0;var scale=null;if(id in scales&&scales[id].type===scaleType)(scale=scales[id]).options=scaleOptions,scale.ctx=me.ctx,scale.chart=me;else{var scaleClass=core_scaleService.getScaleConstructor(scaleType);if(!scaleClass)return;scale=new scaleClass({id:id,type:scaleType,options:scaleOptions,ctx:me.ctx,chart:me}),scales[scale.id]=scale}scale.mergeTicksOptions(),item.isDefault&&(me.scale=scale)})),helpers$1.each(updated,(function(hasUpdated,id){hasUpdated||delete scales[id]})),me.scales=scales,core_scaleService.addScalesToLayout(this)},buildOrUpdateControllers:function(){var i,ilen,me=this,newControllers=[],datasets=me.data.datasets;for(i=0,ilen=datasets.length;i<ilen;i++){var dataset=datasets[i],meta=me.getDatasetMeta(i),type=dataset.type||me.config.type;if(meta.type&&meta.type!==type&&(me.destroyDatasetMeta(i),meta=me.getDatasetMeta(i)),meta.type=type,meta.order=dataset.order||0,meta.index=i,meta.controller)meta.controller.updateIndex(i),meta.controller.linkScales();else{var ControllerClass=controllers[meta.type];if(void 0===ControllerClass)throw new Error('"'+meta.type+'" is not a chart type.');meta.controller=new ControllerClass(me,i),newControllers.push(meta.controller)}}return newControllers},resetElements:function(){var me=this;helpers$1.each(me.data.datasets,(function(dataset,datasetIndex){me.getDatasetMeta(datasetIndex).controller.reset()}),me)},reset:function(){this.resetElements(),this.tooltip.initialize()},update:function(config){var i,ilen,me=this;if(config&&"object"==typeof config||(config={duration:config,lazy:arguments[1]}),updateConfig(me),core_plugins._invalidate(me),!1!==core_plugins.notify(me,"beforeUpdate")){me.tooltip._data=me.data;var newControllers=me.buildOrUpdateControllers();for(i=0,ilen=me.data.datasets.length;i<ilen;i++)me.getDatasetMeta(i).controller.buildOrUpdateElements();me.updateLayout(),me.options.animation&&me.options.animation.duration&&helpers$1.each(newControllers,(function(controller){controller.reset()})),me.updateDatasets(),me.tooltip.initialize(),me.lastActive=[],core_plugins.notify(me,"afterUpdate"),me._layers.sort(compare2Level("z","_idx")),me._bufferedRender?me._bufferedRequest={duration:config.duration,easing:config.easing,lazy:config.lazy}:me.render(config)}},updateLayout:function(){var me=this;!1!==core_plugins.notify(me,"beforeLayout")&&(core_layouts.update(this,this.width,this.height),me._layers=[],helpers$1.each(me.boxes,(function(box){box._configure&&box._configure(),me._layers.push.apply(me._layers,box._layers())}),me),me._layers.forEach((function(item,index){item._idx=index})),core_plugins.notify(me,"afterScaleUpdate"),core_plugins.notify(me,"afterLayout"))},updateDatasets:function(){if(!1!==core_plugins.notify(this,"beforeDatasetsUpdate")){for(var i=0,ilen=this.data.datasets.length;i<ilen;++i)this.updateDataset(i);core_plugins.notify(this,"afterDatasetsUpdate")}},updateDataset:function(index){var meta=this.getDatasetMeta(index),args={meta:meta,index:index};!1!==core_plugins.notify(this,"beforeDatasetUpdate",[args])&&(meta.controller._update(),core_plugins.notify(this,"afterDatasetUpdate",[args]))},render:function(config){var me=this;config&&"object"==typeof config||(config={duration:config,lazy:arguments[1]});var animationOptions=me.options.animation,duration=valueOrDefault$9(config.duration,animationOptions&&animationOptions.duration),lazy=config.lazy;if(!1!==core_plugins.notify(me,"beforeRender")){var onComplete=function(animation){core_plugins.notify(me,"afterRender"),helpers$1.callback(animationOptions&&animationOptions.onComplete,[animation],me)};if(animationOptions&&duration){var animation=new core_animation({numSteps:duration/16.66,easing:config.easing||animationOptions.easing,render:function(chart,animationObject){var easingFunction=helpers$1.easing.effects[animationObject.easing],currentStep=animationObject.currentStep,stepDecimal=currentStep/animationObject.numSteps;chart.draw(easingFunction(stepDecimal),stepDecimal,currentStep)},onAnimationProgress:animationOptions.onProgress,onAnimationComplete:onComplete});core_animations.addAnimation(me,animation,duration,lazy)}else me.draw(),onComplete(new core_animation({numSteps:0,chart:me}));return me}},draw:function(easingValue){var i,layers,me=this;if(me.clear(),helpers$1.isNullOrUndef(easingValue)&&(easingValue=1),me.transition(easingValue),!(me.width<=0||me.height<=0)&&!1!==core_plugins.notify(me,"beforeDraw",[easingValue])){for(layers=me._layers,i=0;i<layers.length&&layers[i].z<=0;++i)layers[i].draw(me.chartArea);for(me.drawDatasets(easingValue);i<layers.length;++i)layers[i].draw(me.chartArea);me._drawTooltip(easingValue),core_plugins.notify(me,"afterDraw",[easingValue])}},transition:function(easingValue){for(var i=0,ilen=(this.data.datasets||[]).length;i<ilen;++i)this.isDatasetVisible(i)&&this.getDatasetMeta(i).controller.transition(easingValue);this.tooltip.transition(easingValue)},_getSortedDatasetMetas:function(filterVisible){var i,ilen,result=[];for(i=0,ilen=(this.data.datasets||[]).length;i<ilen;++i)filterVisible&&!this.isDatasetVisible(i)||result.push(this.getDatasetMeta(i));return result.sort(compare2Level("order","index")),result},_getSortedVisibleDatasetMetas:function(){return this._getSortedDatasetMetas(!0)},drawDatasets:function(easingValue){var metasets,i;if(!1!==core_plugins.notify(this,"beforeDatasetsDraw",[easingValue])){for(i=(metasets=this._getSortedVisibleDatasetMetas()).length-1;i>=0;--i)this.drawDataset(metasets[i],easingValue);core_plugins.notify(this,"afterDatasetsDraw",[easingValue])}},drawDataset:function(meta,easingValue){var args={meta:meta,index:meta.index,easingValue:easingValue};!1!==core_plugins.notify(this,"beforeDatasetDraw",[args])&&(meta.controller.draw(easingValue),core_plugins.notify(this,"afterDatasetDraw",[args]))},_drawTooltip:function(easingValue){var tooltip=this.tooltip,args={tooltip:tooltip,easingValue:easingValue};!1!==core_plugins.notify(this,"beforeTooltipDraw",[args])&&(tooltip.draw(),core_plugins.notify(this,"afterTooltipDraw",[args]))},getElementAtEvent:function(e){return core_interaction.modes.single(this,e)},getElementsAtEvent:function(e){return core_interaction.modes.label(this,e,{intersect:!0})},getElementsAtXAxis:function(e){return core_interaction.modes["x-axis"](this,e,{intersect:!0})},getElementsAtEventForMode:function(e,mode,options){var method=core_interaction.modes[mode];return"function"==typeof method?method(this,e,options):[]},getDatasetAtEvent:function(e){return core_interaction.modes.dataset(this,e,{intersect:!0})},getDatasetMeta:function(datasetIndex){var dataset=this.data.datasets[datasetIndex];dataset._meta||(dataset._meta={});var meta=dataset._meta[this.id];return meta||(meta=dataset._meta[this.id]={type:null,data:[],dataset:null,controller:null,hidden:null,xAxisID:null,yAxisID:null,order:dataset.order||0,index:datasetIndex}),meta},getVisibleDatasetCount:function(){for(var count=0,i=0,ilen=this.data.datasets.length;i<ilen;++i)this.isDatasetVisible(i)&&count++;return count},isDatasetVisible:function(datasetIndex){var meta=this.getDatasetMeta(datasetIndex);return"boolean"==typeof meta.hidden?!meta.hidden:!this.data.datasets[datasetIndex].hidden},generateLegend:function(){return this.options.legendCallback(this)},destroyDatasetMeta:function(datasetIndex){var id=this.id,dataset=this.data.datasets[datasetIndex],meta=dataset._meta&&dataset._meta[id];meta&&(meta.controller.destroy(),delete dataset._meta[id])},destroy:function(){var i,ilen,me=this,canvas=me.canvas;for(me.stop(),i=0,ilen=me.data.datasets.length;i<ilen;++i)me.destroyDatasetMeta(i);canvas&&(me.unbindEvents(),helpers$1.canvas.clear(me),platform.releaseContext(me.ctx),me.canvas=null,me.ctx=null),core_plugins.notify(me,"destroy"),delete Chart.instances[me.id]},toBase64Image:function(){return this.canvas.toDataURL.apply(this.canvas,arguments)},initToolTip:function(){var me=this;me.tooltip=new core_tooltip({_chart:me,_chartInstance:me,_data:me.data,_options:me.options.tooltips},me)},bindEvents:function(){var me=this,listeners=me._listeners={},listener=function(){me.eventHandler.apply(me,arguments)};helpers$1.each(me.options.events,(function(type){platform.addEventListener(me,type,listener),listeners[type]=listener})),me.options.responsive&&(listener=function(){me.resize()},platform.addEventListener(me,"resize",listener),listeners.resize=listener)},unbindEvents:function(){var me=this,listeners=me._listeners;listeners&&(delete me._listeners,helpers$1.each(listeners,(function(listener,type){platform.removeEventListener(me,type,listener)})))},updateHoverStyle:function(elements,mode,enabled){var element,i,ilen,prefix=enabled?"set":"remove";for(i=0,ilen=elements.length;i<ilen;++i)(element=elements[i])&&this.getDatasetMeta(element._datasetIndex).controller[prefix+"HoverStyle"](element);"dataset"===mode&&this.getDatasetMeta(elements[0]._datasetIndex).controller["_"+prefix+"DatasetHoverStyle"]()},eventHandler:function(e){var me=this,tooltip=me.tooltip;if(!1!==core_plugins.notify(me,"beforeEvent",[e])){me._bufferedRender=!0,me._bufferedRequest=null;var changed=me.handleEvent(e);tooltip&&(changed=tooltip._start?tooltip.handleEvent(e):changed|tooltip.handleEvent(e)),core_plugins.notify(me,"afterEvent",[e]);var bufferedRequest=me._bufferedRequest;return bufferedRequest?me.render(bufferedRequest):changed&&!me.animating&&(me.stop(),me.render({duration:me.options.hover.animationDuration,lazy:!0})),me._bufferedRender=!1,me._bufferedRequest=null,me}},handleEvent:function(e){var changed,me=this,options=me.options||{},hoverOptions=options.hover;return me.lastActive=me.lastActive||[],"mouseout"===e.type?me.active=[]:me.active=me.getElementsAtEventForMode(e,hoverOptions.mode,hoverOptions),helpers$1.callback(options.onHover||options.hover.onHover,[e.native,me.active],me),"mouseup"!==e.type&&"click"!==e.type||options.onClick&&options.onClick.call(me,e.native,me.active),me.lastActive.length&&me.updateHoverStyle(me.lastActive,hoverOptions.mode,!1),me.active.length&&hoverOptions.mode&&me.updateHoverStyle(me.active,hoverOptions.mode,!0),changed=!helpers$1.arrayEquals(me.active,me.lastActive),me.lastActive=me.active,changed}}),Chart.instances={};var core_controller=Chart;Chart.Controller=Chart,Chart.types={},helpers$1.configMerge=mergeConfig,helpers$1.scaleMerge=mergeScaleConfig;function abstract(){throw new Error("This method is not implemented: either no adapter can be found or an incomplete integration was provided.")}function DateAdapter(options){this.options=options||{}}helpers$1.extend(DateAdapter.prototype,{formats:abstract,parse:abstract,format:abstract,add:abstract,diff:abstract,startOf:abstract,endOf:abstract,_create:function(value){return value}}),DateAdapter.override=function(members){helpers$1.extend(DateAdapter.prototype,members)};var core_adapters={_date:DateAdapter},core_ticks={formatters:{values:function(value){return helpers$1.isArray(value)?value:""+value},linear:function(tickValue,index,ticks){var delta=ticks.length>3?ticks[2]-ticks[1]:ticks[1]-ticks[0];Math.abs(delta)>1&&tickValue!==Math.floor(tickValue)&&(delta=tickValue-Math.floor(tickValue));var logDelta=helpers$1.log10(Math.abs(delta)),tickString="";if(0!==tickValue)if(Math.max(Math.abs(ticks[0]),Math.abs(ticks[ticks.length-1]))<1e-4){var logTick=helpers$1.log10(Math.abs(tickValue)),numExponential=Math.floor(logTick)-Math.floor(logDelta);numExponential=Math.max(Math.min(numExponential,20),0),tickString=tickValue.toExponential(numExponential)}else{var numDecimal=-1*Math.floor(logDelta);numDecimal=Math.max(Math.min(numDecimal,20),0),tickString=tickValue.toFixed(numDecimal)}else tickString="0";return tickString},logarithmic:function(tickValue,index,ticks){var remain=tickValue/Math.pow(10,Math.floor(helpers$1.log10(tickValue)));return 0===tickValue?"0":1===remain||2===remain||5===remain||0===index||index===ticks.length-1?tickValue.toExponential():""}}},isArray=helpers$1.isArray,isNullOrUndef=helpers$1.isNullOrUndef,valueOrDefault$a=helpers$1.valueOrDefault,valueAtIndexOrDefault=helpers$1.valueAtIndexOrDefault;function getPixelForGridLine(scale,index,offsetGridLines){var offset,length=scale.getTicks().length,validIndex=Math.min(index,length-1),lineValue=scale.getPixelForTick(validIndex),start=scale._startPixel,end=scale._endPixel;if(!(offsetGridLines&&(offset=1===length?Math.max(lineValue-start,end-lineValue):0===index?(scale.getPixelForTick(1)-lineValue)/2:(lineValue-scale.getPixelForTick(validIndex-1))/2,(lineValue+=validIndex<index?offset:-offset)<start-1e-6||lineValue>end+1e-6)))return lineValue}function computeLabelSizes(ctx,tickFonts,ticks,caches){var i,j,jlen,label,tickFont,fontString,cache,lineHeight,width,height,nestedLabel,widest,highest,length=ticks.length,widths=[],heights=[],offsets=[],widestLabelSize=0,highestLabelSize=0;for(i=0;i<length;++i){if(label=ticks[i].label,tickFont=ticks[i].major?tickFonts.major:tickFonts.minor,ctx.font=fontString=tickFont.string,cache=caches[fontString]=caches[fontString]||{data:{},gc:[]},lineHeight=tickFont.lineHeight,width=height=0,isNullOrUndef(label)||isArray(label)){if(isArray(label))for(j=0,jlen=label.length;j<jlen;++j)nestedLabel=label[j],isNullOrUndef(nestedLabel)||isArray(nestedLabel)||(width=helpers$1.measureText(ctx,cache.data,cache.gc,width,nestedLabel),height+=lineHeight)}else width=helpers$1.measureText(ctx,cache.data,cache.gc,width,label),height=lineHeight;widths.push(width),heights.push(height),offsets.push(lineHeight/2),widestLabelSize=Math.max(width,widestLabelSize),highestLabelSize=Math.max(height,highestLabelSize)}function valueAt(idx){return{width:widths[idx]||0,height:heights[idx]||0,offset:offsets[idx]||0}}return function(caches,length){helpers$1.each(caches,(function(cache){var i,gc=cache.gc,gcLen=gc.length/2;if(gcLen>length){for(i=0;i<gcLen;++i)delete cache.data[gc[i]];gc.splice(0,gcLen)}}))}(caches,length),widest=widths.indexOf(widestLabelSize),highest=heights.indexOf(highestLabelSize),{first:valueAt(0),last:valueAt(length-1),widest:valueAt(widest),highest:valueAt(highest)}}function getTickMarkLength(options){return options.drawTicks?options.tickMarkLength:0}function getScaleLabelHeight(options){var font,padding;return options.display?(font=helpers$1.options._parseFont(options),padding=helpers$1.options.toPadding(options.padding),font.lineHeight+padding.height):0}function parseFontOptions(options,nestedOpts){return helpers$1.extend(helpers$1.options._parseFont({fontFamily:valueOrDefault$a(nestedOpts.fontFamily,options.fontFamily),fontSize:valueOrDefault$a(nestedOpts.fontSize,options.fontSize),fontStyle:valueOrDefault$a(nestedOpts.fontStyle,options.fontStyle),lineHeight:valueOrDefault$a(nestedOpts.lineHeight,options.lineHeight)}),{color:helpers$1.options.resolve([nestedOpts.fontColor,options.fontColor,core_defaults.global.defaultFontColor])})}function parseTickFontOptions(options){var minor=parseFontOptions(options,options.minor);return{minor:minor,major:options.major.enabled?parseFontOptions(options,options.major):minor}}function nonSkipped(ticksToFilter){var item,index,len,filtered=[];for(index=0,len=ticksToFilter.length;index<len;++index)void 0!==(item=ticksToFilter[index])._index&&filtered.push(item);return filtered}function skip(ticks,spacing,majorStart,majorEnd){var length,i,tick,next,start=valueOrDefault$a(majorStart,0),end=Math.min(valueOrDefault$a(majorEnd,ticks.length),ticks.length),count=0;for(spacing=Math.ceil(spacing),majorEnd&&(spacing=(length=majorEnd-majorStart)/Math.floor(length/spacing)),next=start;next<0;)count++,next=Math.round(start+count*spacing);for(i=Math.max(start,0);i<end;i++)tick=ticks[i],i===next?(tick._index=i,count++,next=Math.round(start+count*spacing)):delete tick.label}core_defaults._set("scale",{display:!0,position:"left",offset:!1,gridLines:{display:!0,color:"rgba(0,0,0,0.1)",lineWidth:1,drawBorder:!0,drawOnChartArea:!0,drawTicks:!0,tickMarkLength:10,zeroLineWidth:1,zeroLineColor:"rgba(0,0,0,0.25)",zeroLineBorderDash:[],zeroLineBorderDashOffset:0,offsetGridLines:!1,borderDash:[],borderDashOffset:0},scaleLabel:{display:!1,labelString:"",padding:{top:4,bottom:4}},ticks:{beginAtZero:!1,minRotation:0,maxRotation:50,mirror:!1,padding:0,reverse:!1,display:!0,autoSkip:!0,autoSkipPadding:0,labelOffset:0,callback:core_ticks.formatters.values,minor:{},major:{}}});var Scale=core_element.extend({zeroLineIndex:0,getPadding:function(){return{left:this.paddingLeft||0,top:this.paddingTop||0,right:this.paddingRight||0,bottom:this.paddingBottom||0}},getTicks:function(){return this._ticks},_getLabels:function(){var data=this.chart.data;return this.options.labels||(this.isHorizontal()?data.xLabels:data.yLabels)||data.labels||[]},mergeTicksOptions:function(){},beforeUpdate:function(){helpers$1.callback(this.options.beforeUpdate,[this])},update:function(maxWidth,maxHeight,margins){var i,ilen,labels,ticks,samplingEnabled,me=this,tickOpts=me.options.ticks,sampleSize=tickOpts.sampleSize;if(me.beforeUpdate(),me.maxWidth=maxWidth,me.maxHeight=maxHeight,me.margins=helpers$1.extend({left:0,right:0,top:0,bottom:0},margins),me._ticks=null,me.ticks=null,me._labelSizes=null,me._maxLabelLines=0,me.longestLabelWidth=0,me.longestTextCache=me.longestTextCache||{},me._gridLineItems=null,me._labelItems=null,me.beforeSetDimensions(),me.setDimensions(),me.afterSetDimensions(),me.beforeDataLimits(),me.determineDataLimits(),me.afterDataLimits(),me.beforeBuildTicks(),ticks=me.buildTicks()||[],(!(ticks=me.afterBuildTicks(ticks)||ticks)||!ticks.length)&&me.ticks)for(ticks=[],i=0,ilen=me.ticks.length;i<ilen;++i)ticks.push({value:me.ticks[i],major:!1});return me._ticks=ticks,samplingEnabled=sampleSize<ticks.length,labels=me._convertTicksToLabels(samplingEnabled?function(arr,numItems){for(var result=[],increment=arr.length/numItems,i=0,len=arr.length;i<len;i+=increment)result.push(arr[Math.floor(i)]);return result}(ticks,sampleSize):ticks),me._configure(),me.beforeCalculateTickRotation(),me.calculateTickRotation(),me.afterCalculateTickRotation(),me.beforeFit(),me.fit(),me.afterFit(),me._ticksToDraw=tickOpts.display&&(tickOpts.autoSkip||"auto"===tickOpts.source)?me._autoSkip(ticks):ticks,samplingEnabled&&(labels=me._convertTicksToLabels(me._ticksToDraw)),me.ticks=labels,me.afterUpdate(),me.minSize},_configure:function(){var startPixel,endPixel,me=this,reversePixels=me.options.ticks.reverse;me.isHorizontal()?(startPixel=me.left,endPixel=me.right):(startPixel=me.top,endPixel=me.bottom,reversePixels=!reversePixels),me._startPixel=startPixel,me._endPixel=endPixel,me._reversePixels=reversePixels,me._length=endPixel-startPixel},afterUpdate:function(){helpers$1.callback(this.options.afterUpdate,[this])},beforeSetDimensions:function(){helpers$1.callback(this.options.beforeSetDimensions,[this])},setDimensions:function(){var me=this;me.isHorizontal()?(me.width=me.maxWidth,me.left=0,me.right=me.width):(me.height=me.maxHeight,me.top=0,me.bottom=me.height),me.paddingLeft=0,me.paddingTop=0,me.paddingRight=0,me.paddingBottom=0},afterSetDimensions:function(){helpers$1.callback(this.options.afterSetDimensions,[this])},beforeDataLimits:function(){helpers$1.callback(this.options.beforeDataLimits,[this])},determineDataLimits:helpers$1.noop,afterDataLimits:function(){helpers$1.callback(this.options.afterDataLimits,[this])},beforeBuildTicks:function(){helpers$1.callback(this.options.beforeBuildTicks,[this])},buildTicks:helpers$1.noop,afterBuildTicks:function(ticks){var me=this;return isArray(ticks)&&ticks.length?helpers$1.callback(me.options.afterBuildTicks,[me,ticks]):(me.ticks=helpers$1.callback(me.options.afterBuildTicks,[me,me.ticks])||me.ticks,ticks)},beforeTickToLabelConversion:function(){helpers$1.callback(this.options.beforeTickToLabelConversion,[this])},convertTicksToLabels:function(){var tickOpts=this.options.ticks;this.ticks=this.ticks.map(tickOpts.userCallback||tickOpts.callback,this)},afterTickToLabelConversion:function(){helpers$1.callback(this.options.afterTickToLabelConversion,[this])},beforeCalculateTickRotation:function(){helpers$1.callback(this.options.beforeCalculateTickRotation,[this])},calculateTickRotation:function(){var labelSizes,maxLabelWidth,maxLabelHeight,maxWidth,tickWidth,maxHeight,maxLabelDiagonal,me=this,options=me.options,tickOpts=options.ticks,numTicks=me.getTicks().length,minRotation=tickOpts.minRotation||0,maxRotation=tickOpts.maxRotation,labelRotation=minRotation;!me._isVisible()||!tickOpts.display||minRotation>=maxRotation||numTicks<=1||!me.isHorizontal()?me.labelRotation=minRotation:(maxLabelWidth=(labelSizes=me._getLabelSizes()).widest.width,maxLabelHeight=labelSizes.highest.height-labelSizes.highest.offset,maxWidth=Math.min(me.maxWidth,me.chart.width-maxLabelWidth),maxLabelWidth+6>(tickWidth=options.offset?me.maxWidth/numTicks:maxWidth/(numTicks-1))&&(tickWidth=maxWidth/(numTicks-(options.offset?.5:1)),maxHeight=me.maxHeight-getTickMarkLength(options.gridLines)-tickOpts.padding-getScaleLabelHeight(options.scaleLabel),maxLabelDiagonal=Math.sqrt(maxLabelWidth*maxLabelWidth+maxLabelHeight*maxLabelHeight),labelRotation=helpers$1.toDegrees(Math.min(Math.asin(Math.min((labelSizes.highest.height+6)/tickWidth,1)),Math.asin(Math.min(maxHeight/maxLabelDiagonal,1))-Math.asin(maxLabelHeight/maxLabelDiagonal))),labelRotation=Math.max(minRotation,Math.min(maxRotation,labelRotation))),me.labelRotation=labelRotation)},afterCalculateTickRotation:function(){helpers$1.callback(this.options.afterCalculateTickRotation,[this])},beforeFit:function(){helpers$1.callback(this.options.beforeFit,[this])},fit:function(){var me=this,minSize=me.minSize={width:0,height:0},chart=me.chart,opts=me.options,tickOpts=opts.ticks,scaleLabelOpts=opts.scaleLabel,gridLineOpts=opts.gridLines,display=me._isVisible(),isBottom="bottom"===opts.position,isHorizontal=me.isHorizontal();if(isHorizontal?minSize.width=me.maxWidth:display&&(minSize.width=getTickMarkLength(gridLineOpts)+getScaleLabelHeight(scaleLabelOpts)),isHorizontal?display&&(minSize.height=getTickMarkLength(gridLineOpts)+getScaleLabelHeight(scaleLabelOpts)):minSize.height=me.maxHeight,tickOpts.display&&display){var tickFonts=parseTickFontOptions(tickOpts),labelSizes=me._getLabelSizes(),firstLabelSize=labelSizes.first,lastLabelSize=labelSizes.last,widestLabelSize=labelSizes.widest,highestLabelSize=labelSizes.highest,lineSpace=.4*tickFonts.minor.lineHeight,tickPadding=tickOpts.padding;if(isHorizontal){var isRotated=0!==me.labelRotation,angleRadians=helpers$1.toRadians(me.labelRotation),cosRotation=Math.cos(angleRadians),sinRotation=Math.sin(angleRadians),labelHeight=sinRotation*widestLabelSize.width+cosRotation*(highestLabelSize.height-(isRotated?highestLabelSize.offset:0))+(isRotated?0:lineSpace);minSize.height=Math.min(me.maxHeight,minSize.height+labelHeight+tickPadding);var paddingLeft,paddingRight,offsetLeft=me.getPixelForTick(0)-me.left,offsetRight=me.right-me.getPixelForTick(me.getTicks().length-1);isRotated?(paddingLeft=isBottom?cosRotation*firstLabelSize.width+sinRotation*firstLabelSize.offset:sinRotation*(firstLabelSize.height-firstLabelSize.offset),paddingRight=isBottom?sinRotation*(lastLabelSize.height-lastLabelSize.offset):cosRotation*lastLabelSize.width+sinRotation*lastLabelSize.offset):(paddingLeft=firstLabelSize.width/2,paddingRight=lastLabelSize.width/2),me.paddingLeft=Math.max((paddingLeft-offsetLeft)*me.width/(me.width-offsetLeft),0)+3,me.paddingRight=Math.max((paddingRight-offsetRight)*me.width/(me.width-offsetRight),0)+3}else{var labelWidth=tickOpts.mirror?0:widestLabelSize.width+tickPadding+lineSpace;minSize.width=Math.min(me.maxWidth,minSize.width+labelWidth),me.paddingTop=firstLabelSize.height/2,me.paddingBottom=lastLabelSize.height/2}}me.handleMargins(),isHorizontal?(me.width=me._length=chart.width-me.margins.left-me.margins.right,me.height=minSize.height):(me.width=minSize.width,me.height=me._length=chart.height-me.margins.top-me.margins.bottom)},handleMargins:function(){var me=this;me.margins&&(me.margins.left=Math.max(me.paddingLeft,me.margins.left),me.margins.top=Math.max(me.paddingTop,me.margins.top),me.margins.right=Math.max(me.paddingRight,me.margins.right),me.margins.bottom=Math.max(me.paddingBottom,me.margins.bottom))},afterFit:function(){helpers$1.callback(this.options.afterFit,[this])},isHorizontal:function(){var pos=this.options.position;return"top"===pos||"bottom"===pos},isFullWidth:function(){return this.options.fullWidth},getRightValue:function(rawValue){if(isNullOrUndef(rawValue))return NaN;if(("number"==typeof rawValue||rawValue instanceof Number)&&!isFinite(rawValue))return NaN;if(rawValue)if(this.isHorizontal()){if(void 0!==rawValue.x)return this.getRightValue(rawValue.x)}else if(void 0!==rawValue.y)return this.getRightValue(rawValue.y);return rawValue},_convertTicksToLabels:function(ticks){var labels,i,ilen,me=this;for(me.ticks=ticks.map((function(tick){return tick.value})),me.beforeTickToLabelConversion(),labels=me.convertTicksToLabels(ticks)||me.ticks,me.afterTickToLabelConversion(),i=0,ilen=ticks.length;i<ilen;++i)ticks[i].label=labels[i];return labels},_getLabelSizes:function(){var me=this,labelSizes=me._labelSizes;return labelSizes||(me._labelSizes=labelSizes=computeLabelSizes(me.ctx,parseTickFontOptions(me.options.ticks),me.getTicks(),me.longestTextCache),me.longestLabelWidth=labelSizes.widest.width),labelSizes},_parseValue:function(value){var start,end,min,max;return isArray(value)?(start=+this.getRightValue(value[0]),end=+this.getRightValue(value[1]),min=Math.min(start,end),max=Math.max(start,end)):(start=void 0,end=value=+this.getRightValue(value),min=value,max=value),{min:min,max:max,start:start,end:end}},_getScaleLabel:function(rawValue){var v=this._parseValue(rawValue);return void 0!==v.start?"["+v.start+", "+v.end+"]":+this.getRightValue(rawValue)},getLabelForIndex:helpers$1.noop,getPixelForValue:helpers$1.noop,getValueForPixel:helpers$1.noop,getPixelForTick:function(index){var offset=this.options.offset,numTicks=this._ticks.length,tickWidth=1/Math.max(numTicks-(offset?0:1),1);return index<0||index>numTicks-1?null:this.getPixelForDecimal(index*tickWidth+(offset?tickWidth/2:0))},getPixelForDecimal:function(decimal){return this._reversePixels&&(decimal=1-decimal),this._startPixel+decimal*this._length},getDecimalForPixel:function(pixel){var decimal=(pixel-this._startPixel)/this._length;return this._reversePixels?1-decimal:decimal},getBasePixel:function(){return this.getPixelForValue(this.getBaseValue())},getBaseValue:function(){var min=this.min,max=this.max;return this.beginAtZero?0:min<0&&max<0?max:min>0&&max>0?min:0},_autoSkip:function(ticks){var i,ilen,spacing,avgMajorSpacing,tickOpts=this.options.ticks,axisLength=this._length,ticksLimit=tickOpts.maxTicksLimit||axisLength/this._tickSize()+1,majorIndices=tickOpts.major.enabled?function(ticks){var i,ilen,result=[];for(i=0,ilen=ticks.length;i<ilen;i++)ticks[i].major&&result.push(i);return result}(ticks):[],numMajorIndices=majorIndices.length,first=majorIndices[0],last=majorIndices[numMajorIndices-1];if(numMajorIndices>ticksLimit)return function(ticks,majorIndices,spacing){var i,tick,count=0,next=majorIndices[0];for(spacing=Math.ceil(spacing),i=0;i<ticks.length;i++)tick=ticks[i],i===next?(tick._index=i,next=majorIndices[++count*spacing]):delete tick.label}(ticks,majorIndices,numMajorIndices/ticksLimit),nonSkipped(ticks);if(spacing=function(majorIndices,ticks,axisLength,ticksLimit){var factors,factor,i,ilen,evenMajorSpacing=function(arr){var i,diff,len=arr.length;if(len<2)return!1;for(diff=arr[0],i=1;i<len;++i)if(arr[i]-arr[i-1]!==diff)return!1;return diff}(majorIndices),spacing=(ticks.length-1)/ticksLimit;if(!evenMajorSpacing)return Math.max(spacing,1);for(i=0,ilen=(factors=helpers$1.math._factorize(evenMajorSpacing)).length-1;i<ilen;i++)if((factor=factors[i])>spacing)return factor;return Math.max(spacing,1)}(majorIndices,ticks,0,ticksLimit),numMajorIndices>0){for(i=0,ilen=numMajorIndices-1;i<ilen;i++)skip(ticks,spacing,majorIndices[i],majorIndices[i+1]);return avgMajorSpacing=numMajorIndices>1?(last-first)/(numMajorIndices-1):null,skip(ticks,spacing,helpers$1.isNullOrUndef(avgMajorSpacing)?0:first-avgMajorSpacing,first),skip(ticks,spacing,last,helpers$1.isNullOrUndef(avgMajorSpacing)?ticks.length:last+avgMajorSpacing),nonSkipped(ticks)}return skip(ticks,spacing),nonSkipped(ticks)},_tickSize:function(){var optionTicks=this.options.ticks,rot=helpers$1.toRadians(this.labelRotation),cos=Math.abs(Math.cos(rot)),sin=Math.abs(Math.sin(rot)),labelSizes=this._getLabelSizes(),padding=optionTicks.autoSkipPadding||0,w=labelSizes?labelSizes.widest.width+padding:0,h=labelSizes?labelSizes.highest.height+padding:0;return this.isHorizontal()?h*cos>w*sin?w/cos:h/sin:h*sin<w*cos?h/cos:w/sin},_isVisible:function(){var i,ilen,meta,chart=this.chart,display=this.options.display;if("auto"!==display)return!!display;for(i=0,ilen=chart.data.datasets.length;i<ilen;++i)if(chart.isDatasetVisible(i)&&((meta=chart.getDatasetMeta(i)).xAxisID===this.id||meta.yAxisID===this.id))return!0;return!1},_computeGridLineItems:function(chartArea){var borderValue,i,tick,lineValue,alignedLineValue,tx1,ty1,tx2,ty2,x1,y1,x2,y2,lineWidth,lineColor,borderDash,borderDashOffset,me=this,chart=me.chart,options=me.options,gridLines=options.gridLines,position=options.position,offsetGridLines=gridLines.offsetGridLines,isHorizontal=me.isHorizontal(),ticks=me._ticksToDraw,ticksLength=ticks.length+(offsetGridLines?1:0),tl=getTickMarkLength(gridLines),items=[],axisWidth=gridLines.drawBorder?valueAtIndexOrDefault(gridLines.lineWidth,0,0):0,axisHalfWidth=axisWidth/2,alignPixel=helpers$1._alignPixel,alignBorderValue=function(pixel){return alignPixel(chart,pixel,axisWidth)};for("top"===position?(borderValue=alignBorderValue(me.bottom),ty1=me.bottom-tl,ty2=borderValue-axisHalfWidth,y1=alignBorderValue(chartArea.top)+axisHalfWidth,y2=chartArea.bottom):"bottom"===position?(borderValue=alignBorderValue(me.top),y1=chartArea.top,y2=alignBorderValue(chartArea.bottom)-axisHalfWidth,ty1=borderValue+axisHalfWidth,ty2=me.top+tl):"left"===position?(borderValue=alignBorderValue(me.right),tx1=me.right-tl,tx2=borderValue-axisHalfWidth,x1=alignBorderValue(chartArea.left)+axisHalfWidth,x2=chartArea.right):(borderValue=alignBorderValue(me.left),x1=chartArea.left,x2=alignBorderValue(chartArea.right)-axisHalfWidth,tx1=borderValue+axisHalfWidth,tx2=me.left+tl),i=0;i<ticksLength;++i)tick=ticks[i]||{},isNullOrUndef(tick.label)&&i<ticks.length||(i===me.zeroLineIndex&&options.offset===offsetGridLines?(lineWidth=gridLines.zeroLineWidth,lineColor=gridLines.zeroLineColor,borderDash=gridLines.zeroLineBorderDash||[],borderDashOffset=gridLines.zeroLineBorderDashOffset||0):(lineWidth=valueAtIndexOrDefault(gridLines.lineWidth,i,1),lineColor=valueAtIndexOrDefault(gridLines.color,i,"rgba(0,0,0,0.1)"),borderDash=gridLines.borderDash||[],borderDashOffset=gridLines.borderDashOffset||0),void 0!==(lineValue=getPixelForGridLine(me,tick._index||i,offsetGridLines))&&(alignedLineValue=alignPixel(chart,lineValue,lineWidth),isHorizontal?tx1=tx2=x1=x2=alignedLineValue:ty1=ty2=y1=y2=alignedLineValue,items.push({tx1:tx1,ty1:ty1,tx2:tx2,ty2:ty2,x1:x1,y1:y1,x2:x2,y2:y2,width:lineWidth,color:lineColor,borderDash:borderDash,borderDashOffset:borderDashOffset})));return items.ticksLength=ticksLength,items.borderValue=borderValue,items},_computeLabelItems:function(){var i,ilen,tick,label,x,y,textAlign,pixel,font,lineHeight,lineCount,textOffset,me=this,options=me.options,optionTicks=options.ticks,position=options.position,isMirrored=optionTicks.mirror,isHorizontal=me.isHorizontal(),ticks=me._ticksToDraw,fonts=parseTickFontOptions(optionTicks),tickPadding=optionTicks.padding,tl=getTickMarkLength(options.gridLines),rotation=-helpers$1.toRadians(me.labelRotation),items=[];for("top"===position?(y=me.bottom-tl-tickPadding,textAlign=rotation?"left":"center"):"bottom"===position?(y=me.top+tl+tickPadding,textAlign=rotation?"right":"center"):"left"===position?(x=me.right-(isMirrored?0:tl)-tickPadding,textAlign=isMirrored?"left":"right"):(x=me.left+(isMirrored?0:tl)+tickPadding,textAlign=isMirrored?"right":"left"),i=0,ilen=ticks.length;i<ilen;++i)label=(tick=ticks[i]).label,isNullOrUndef(label)||(pixel=me.getPixelForTick(tick._index||i)+optionTicks.labelOffset,lineHeight=(font=tick.major?fonts.major:fonts.minor).lineHeight,lineCount=isArray(label)?label.length:1,isHorizontal?(x=pixel,textOffset="top"===position?((rotation?1:.5)-lineCount)*lineHeight:(rotation?0:.5)*lineHeight):(y=pixel,textOffset=(1-lineCount)*lineHeight/2),items.push({x:x,y:y,rotation:rotation,label:label,font:font,textOffset:textOffset,textAlign:textAlign}));return items},_drawGrid:function(chartArea){var me=this,gridLines=me.options.gridLines;if(gridLines.display){var width,color,i,ilen,item,ctx=me.ctx,chart=me.chart,alignPixel=helpers$1._alignPixel,axisWidth=gridLines.drawBorder?valueAtIndexOrDefault(gridLines.lineWidth,0,0):0,items=me._gridLineItems||(me._gridLineItems=me._computeGridLineItems(chartArea));for(i=0,ilen=items.length;i<ilen;++i)width=(item=items[i]).width,color=item.color,width&&color&&(ctx.save(),ctx.lineWidth=width,ctx.strokeStyle=color,ctx.setLineDash&&(ctx.setLineDash(item.borderDash),ctx.lineDashOffset=item.borderDashOffset),ctx.beginPath(),gridLines.drawTicks&&(ctx.moveTo(item.tx1,item.ty1),ctx.lineTo(item.tx2,item.ty2)),gridLines.drawOnChartArea&&(ctx.moveTo(item.x1,item.y1),ctx.lineTo(item.x2,item.y2)),ctx.stroke(),ctx.restore());if(axisWidth){var x1,x2,y1,y2,firstLineWidth=axisWidth,lastLineWidth=valueAtIndexOrDefault(gridLines.lineWidth,items.ticksLength-1,1),borderValue=items.borderValue;me.isHorizontal()?(x1=alignPixel(chart,me.left,firstLineWidth)-firstLineWidth/2,x2=alignPixel(chart,me.right,lastLineWidth)+lastLineWidth/2,y1=y2=borderValue):(y1=alignPixel(chart,me.top,firstLineWidth)-firstLineWidth/2,y2=alignPixel(chart,me.bottom,lastLineWidth)+lastLineWidth/2,x1=x2=borderValue),ctx.lineWidth=axisWidth,ctx.strokeStyle=valueAtIndexOrDefault(gridLines.color,0),ctx.beginPath(),ctx.moveTo(x1,y1),ctx.lineTo(x2,y2),ctx.stroke()}}},_drawLabels:function(){var me=this;if(me.options.ticks.display){var i,j,ilen,jlen,item,tickFont,label,y,ctx=me.ctx,items=me._labelItems||(me._labelItems=me._computeLabelItems());for(i=0,ilen=items.length;i<ilen;++i){if(tickFont=(item=items[i]).font,ctx.save(),ctx.translate(item.x,item.y),ctx.rotate(item.rotation),ctx.font=tickFont.string,ctx.fillStyle=tickFont.color,ctx.textBaseline="middle",ctx.textAlign=item.textAlign,label=item.label,y=item.textOffset,isArray(label))for(j=0,jlen=label.length;j<jlen;++j)ctx.fillText(""+label[j],0,y),y+=tickFont.lineHeight;else ctx.fillText(label,0,y);ctx.restore()}}},_drawTitle:function(){var me=this,ctx=me.ctx,options=me.options,scaleLabel=options.scaleLabel;if(scaleLabel.display){var scaleLabelX,scaleLabelY,scaleLabelFontColor=valueOrDefault$a(scaleLabel.fontColor,core_defaults.global.defaultFontColor),scaleLabelFont=helpers$1.options._parseFont(scaleLabel),scaleLabelPadding=helpers$1.options.toPadding(scaleLabel.padding),halfLineHeight=scaleLabelFont.lineHeight/2,position=options.position,rotation=0;if(me.isHorizontal())scaleLabelX=me.left+me.width/2,scaleLabelY="bottom"===position?me.bottom-halfLineHeight-scaleLabelPadding.bottom:me.top+halfLineHeight+scaleLabelPadding.top;else{var isLeft="left"===position;scaleLabelX=isLeft?me.left+halfLineHeight+scaleLabelPadding.top:me.right-halfLineHeight-scaleLabelPadding.top,scaleLabelY=me.top+me.height/2,rotation=isLeft?-.5*Math.PI:.5*Math.PI}ctx.save(),ctx.translate(scaleLabelX,scaleLabelY),ctx.rotate(rotation),ctx.textAlign="center",ctx.textBaseline="middle",ctx.fillStyle=scaleLabelFontColor,ctx.font=scaleLabelFont.string,ctx.fillText(scaleLabel.labelString,0,0),ctx.restore()}},draw:function(chartArea){this._isVisible()&&(this._drawGrid(chartArea),this._drawTitle(),this._drawLabels())},_layers:function(){var me=this,opts=me.options,tz=opts.ticks&&opts.ticks.z||0,gz=opts.gridLines&&opts.gridLines.z||0;return me._isVisible()&&tz!==gz&&me.draw===me._draw?[{z:gz,draw:function(){me._drawGrid.apply(me,arguments),me._drawTitle.apply(me,arguments)}},{z:tz,draw:function(){me._drawLabels.apply(me,arguments)}}]:[{z:tz,draw:function(){me.draw.apply(me,arguments)}}]},_getMatchingVisibleMetas:function(type){var me=this,isHorizontal=me.isHorizontal();return me.chart._getSortedVisibleDatasetMetas().filter((function(meta){return(!type||meta.type===type)&&(isHorizontal?meta.xAxisID===me.id:meta.yAxisID===me.id)}))}});Scale.prototype._draw=Scale.prototype.draw;var core_scale=Scale,isNullOrUndef$1=helpers$1.isNullOrUndef,scale_category=core_scale.extend({determineDataLimits:function(){var findIndex,me=this,labels=me._getLabels(),ticksOpts=me.options.ticks,min=ticksOpts.min,max=ticksOpts.max,minIndex=0,maxIndex=labels.length-1;void 0!==min&&(findIndex=labels.indexOf(min))>=0&&(minIndex=findIndex),void 0!==max&&(findIndex=labels.indexOf(max))>=0&&(maxIndex=findIndex),me.minIndex=minIndex,me.maxIndex=maxIndex,me.min=labels[minIndex],me.max=labels[maxIndex]},buildTicks:function(){var labels=this._getLabels(),minIndex=this.minIndex,maxIndex=this.maxIndex;this.ticks=0===minIndex&&maxIndex===labels.length-1?labels:labels.slice(minIndex,maxIndex+1)},getLabelForIndex:function(index,datasetIndex){var chart=this.chart;return chart.getDatasetMeta(datasetIndex).controller._getValueScaleId()===this.id?this.getRightValue(chart.data.datasets[datasetIndex].data[index]):this._getLabels()[index]},_configure:function(){var me=this,offset=me.options.offset,ticks=me.ticks;core_scale.prototype._configure.call(me),me.isHorizontal()||(me._reversePixels=!me._reversePixels),ticks&&(me._startValue=me.minIndex-(offset?.5:0),me._valueRange=Math.max(ticks.length-(offset?0:1),1))},getPixelForValue:function(value,index,datasetIndex){var valueCategory,labels,idx,me=this;return isNullOrUndef$1(index)||isNullOrUndef$1(datasetIndex)||(value=me.chart.data.datasets[datasetIndex].data[index]),isNullOrUndef$1(value)||(valueCategory=me.isHorizontal()?value.x:value.y),(void 0!==valueCategory||void 0!==value&&isNaN(index))&&(labels=me._getLabels(),value=helpers$1.valueOrDefault(valueCategory,value),index=-1!==(idx=labels.indexOf(value))?idx:index,isNaN(index)&&(index=value)),me.getPixelForDecimal((index-me._startValue)/me._valueRange)},getPixelForTick:function(index){var ticks=this.ticks;return index<0||index>ticks.length-1?null:this.getPixelForValue(ticks[index],index+this.minIndex)},getValueForPixel:function(pixel){var value=Math.round(this._startValue+this.getDecimalForPixel(pixel)*this._valueRange);return Math.min(Math.max(value,0),this.ticks.length-1)},getBasePixel:function(){return this.bottom}}),_defaults={position:"bottom"};scale_category._defaults=_defaults;var noop=helpers$1.noop,isNullOrUndef$2=helpers$1.isNullOrUndef;var scale_linearbase=core_scale.extend({getRightValue:function(value){return"string"==typeof value?+value:core_scale.prototype.getRightValue.call(this,value)},handleTickRangeOptions:function(){var me=this,tickOpts=me.options.ticks;if(tickOpts.beginAtZero){var minSign=helpers$1.sign(me.min),maxSign=helpers$1.sign(me.max);minSign<0&&maxSign<0?me.max=0:minSign>0&&maxSign>0&&(me.min=0)}var setMin=void 0!==tickOpts.min||void 0!==tickOpts.suggestedMin,setMax=void 0!==tickOpts.max||void 0!==tickOpts.suggestedMax;void 0!==tickOpts.min?me.min=tickOpts.min:void 0!==tickOpts.suggestedMin&&(null===me.min?me.min=tickOpts.suggestedMin:me.min=Math.min(me.min,tickOpts.suggestedMin)),void 0!==tickOpts.max?me.max=tickOpts.max:void 0!==tickOpts.suggestedMax&&(null===me.max?me.max=tickOpts.suggestedMax:me.max=Math.max(me.max,tickOpts.suggestedMax)),setMin!==setMax&&me.min>=me.max&&(setMin?me.max=me.min+1:me.min=me.max-1),me.min===me.max&&(me.max++,tickOpts.beginAtZero||me.min--)},getTickLimit:function(){var maxTicks,tickOpts=this.options.ticks,stepSize=tickOpts.stepSize,maxTicksLimit=tickOpts.maxTicksLimit;return stepSize?maxTicks=Math.ceil(this.max/stepSize)-Math.floor(this.min/stepSize)+1:(maxTicks=this._computeTickLimit(),maxTicksLimit=maxTicksLimit||11),maxTicksLimit&&(maxTicks=Math.min(maxTicksLimit,maxTicks)),maxTicks},_computeTickLimit:function(){return Number.POSITIVE_INFINITY},handleDirectionalChanges:noop,buildTicks:function(){var me=this,tickOpts=me.options.ticks,maxTicks=me.getTickLimit(),numericGeneratorOptions={maxTicks:maxTicks=Math.max(2,maxTicks),min:tickOpts.min,max:tickOpts.max,precision:tickOpts.precision,stepSize:helpers$1.valueOrDefault(tickOpts.fixedStepSize,tickOpts.stepSize)},ticks=me.ticks=function(generationOptions,dataRange){var factor,niceMin,niceMax,numSpaces,ticks=[],stepSize=generationOptions.stepSize,unit=stepSize||1,maxNumSpaces=generationOptions.maxTicks-1,min=generationOptions.min,max=generationOptions.max,precision=generationOptions.precision,rmin=dataRange.min,rmax=dataRange.max,spacing=helpers$1.niceNum((rmax-rmin)/maxNumSpaces/unit)*unit;if(spacing<1e-14&&isNullOrUndef$2(min)&&isNullOrUndef$2(max))return[rmin,rmax];(numSpaces=Math.ceil(rmax/spacing)-Math.floor(rmin/spacing))>maxNumSpaces&&(spacing=helpers$1.niceNum(numSpaces*spacing/maxNumSpaces/unit)*unit),stepSize||isNullOrUndef$2(precision)?factor=Math.pow(10,helpers$1._decimalPlaces(spacing)):(factor=Math.pow(10,precision),spacing=Math.ceil(spacing*factor)/factor),niceMin=Math.floor(rmin/spacing)*spacing,niceMax=Math.ceil(rmax/spacing)*spacing,stepSize&&(!isNullOrUndef$2(min)&&helpers$1.almostWhole(min/spacing,spacing/1e3)&&(niceMin=min),!isNullOrUndef$2(max)&&helpers$1.almostWhole(max/spacing,spacing/1e3)&&(niceMax=max)),numSpaces=(niceMax-niceMin)/spacing,numSpaces=helpers$1.almostEquals(numSpaces,Math.round(numSpaces),spacing/1e3)?Math.round(numSpaces):Math.ceil(numSpaces),niceMin=Math.round(niceMin*factor)/factor,niceMax=Math.round(niceMax*factor)/factor,ticks.push(isNullOrUndef$2(min)?niceMin:min);for(var j=1;j<numSpaces;++j)ticks.push(Math.round((niceMin+j*spacing)*factor)/factor);return ticks.push(isNullOrUndef$2(max)?niceMax:max),ticks}(numericGeneratorOptions,me);me.handleDirectionalChanges(),me.max=helpers$1.max(ticks),me.min=helpers$1.min(ticks),tickOpts.reverse?(ticks.reverse(),me.start=me.max,me.end=me.min):(me.start=me.min,me.end=me.max)},convertTicksToLabels:function(){var me=this;me.ticksAsNumbers=me.ticks.slice(),me.zeroLineIndex=me.ticks.indexOf(0),core_scale.prototype.convertTicksToLabels.call(me)},_configure:function(){var offset,me=this,ticks=me.getTicks(),start=me.min,end=me.max;core_scale.prototype._configure.call(me),me.options.offset&&ticks.length&&(start-=offset=(end-start)/Math.max(ticks.length-1,1)/2,end+=offset),me._startValue=start,me._endValue=end,me._valueRange=end-start}}),defaultConfig$1={position:"left",ticks:{callback:core_ticks.formatters.linear}};function stackData(scale,stacks,meta,data){var i,value,opts=scale.options,stack=function(stacks,stacked,meta){var key=[meta.type,void 0===stacked&&void 0===meta.stack?meta.index:"",meta.stack].join(".");return void 0===stacks[key]&&(stacks[key]={pos:[],neg:[]}),stacks[key]}(stacks,opts.stacked,meta),pos=stack.pos,neg=stack.neg,ilen=data.length;for(i=0;i<ilen;++i)value=scale._parseValue(data[i]),isNaN(value.min)||isNaN(value.max)||meta.data[i].hidden||(pos[i]=pos[i]||0,neg[i]=neg[i]||0,opts.relativePoints?pos[i]=100:value.min<0||value.max<0?neg[i]+=value.min:pos[i]+=value.max)}function updateMinMax(scale,meta,data){var i,value,ilen=data.length;for(i=0;i<ilen;++i)value=scale._parseValue(data[i]),isNaN(value.min)||isNaN(value.max)||meta.data[i].hidden||(scale.min=Math.min(scale.min,value.min),scale.max=Math.max(scale.max,value.max))}var scale_linear=scale_linearbase.extend({determineDataLimits:function(){var i,meta,data,values,me=this,opts=me.options,datasets=me.chart.data.datasets,metasets=me._getMatchingVisibleMetas(),hasStacks=opts.stacked,stacks={},ilen=metasets.length;if(me.min=Number.POSITIVE_INFINITY,me.max=Number.NEGATIVE_INFINITY,void 0===hasStacks)for(i=0;!hasStacks&&i<ilen;++i)hasStacks=void 0!==(meta=metasets[i]).stack;for(i=0;i<ilen;++i)data=datasets[(meta=metasets[i]).index].data,hasStacks?stackData(me,stacks,meta,data):updateMinMax(me,meta,data);helpers$1.each(stacks,(function(stackValues){values=stackValues.pos.concat(stackValues.neg),me.min=Math.min(me.min,helpers$1.min(values)),me.max=Math.max(me.max,helpers$1.max(values))})),me.min=helpers$1.isFinite(me.min)&&!isNaN(me.min)?me.min:0,me.max=helpers$1.isFinite(me.max)&&!isNaN(me.max)?me.max:1,me.handleTickRangeOptions()},_computeTickLimit:function(){var tickFont;return this.isHorizontal()?Math.ceil(this.width/40):(tickFont=helpers$1.options._parseFont(this.options.ticks),Math.ceil(this.height/tickFont.lineHeight))},handleDirectionalChanges:function(){this.isHorizontal()||this.ticks.reverse()},getLabelForIndex:function(index,datasetIndex){return this._getScaleLabel(this.chart.data.datasets[datasetIndex].data[index])},getPixelForValue:function(value){return this.getPixelForDecimal((+this.getRightValue(value)-this._startValue)/this._valueRange)},getValueForPixel:function(pixel){return this._startValue+this.getDecimalForPixel(pixel)*this._valueRange},getPixelForTick:function(index){var ticks=this.ticksAsNumbers;return index<0||index>ticks.length-1?null:this.getPixelForValue(ticks[index])}}),_defaults$1=defaultConfig$1;scale_linear._defaults=_defaults$1;var valueOrDefault$b=helpers$1.valueOrDefault,log10=helpers$1.math.log10;var defaultConfig$2={position:"left",ticks:{callback:core_ticks.formatters.logarithmic}};function nonNegativeOrDefault(value,defaultValue){return helpers$1.isFinite(value)&&value>=0?value:defaultValue}var scale_logarithmic=core_scale.extend({determineDataLimits:function(){var datasetIndex,meta,value,data,i,ilen,me=this,opts=me.options,chart=me.chart,datasets=chart.data.datasets,isHorizontal=me.isHorizontal();function IDMatches(meta){return isHorizontal?meta.xAxisID===me.id:meta.yAxisID===me.id}me.min=Number.POSITIVE_INFINITY,me.max=Number.NEGATIVE_INFINITY,me.minNotZero=Number.POSITIVE_INFINITY;var hasStacks=opts.stacked;if(void 0===hasStacks)for(datasetIndex=0;datasetIndex<datasets.length;datasetIndex++)if(meta=chart.getDatasetMeta(datasetIndex),chart.isDatasetVisible(datasetIndex)&&IDMatches(meta)&&void 0!==meta.stack){hasStacks=!0;break}if(opts.stacked||hasStacks){var valuesPerStack={};for(datasetIndex=0;datasetIndex<datasets.length;datasetIndex++){var key=[(meta=chart.getDatasetMeta(datasetIndex)).type,void 0===opts.stacked&&void 0===meta.stack?datasetIndex:"",meta.stack].join(".");if(chart.isDatasetVisible(datasetIndex)&&IDMatches(meta))for(void 0===valuesPerStack[key]&&(valuesPerStack[key]=[]),i=0,ilen=(data=datasets[datasetIndex].data).length;i<ilen;i++){var values=valuesPerStack[key];value=me._parseValue(data[i]),isNaN(value.min)||isNaN(value.max)||meta.data[i].hidden||value.min<0||value.max<0||(values[i]=values[i]||0,values[i]+=value.max)}}helpers$1.each(valuesPerStack,(function(valuesForType){if(valuesForType.length>0){var minVal=helpers$1.min(valuesForType),maxVal=helpers$1.max(valuesForType);me.min=Math.min(me.min,minVal),me.max=Math.max(me.max,maxVal)}}))}else for(datasetIndex=0;datasetIndex<datasets.length;datasetIndex++)if(meta=chart.getDatasetMeta(datasetIndex),chart.isDatasetVisible(datasetIndex)&&IDMatches(meta))for(i=0,ilen=(data=datasets[datasetIndex].data).length;i<ilen;i++)value=me._parseValue(data[i]),isNaN(value.min)||isNaN(value.max)||meta.data[i].hidden||value.min<0||value.max<0||(me.min=Math.min(value.min,me.min),me.max=Math.max(value.max,me.max),0!==value.min&&(me.minNotZero=Math.min(value.min,me.minNotZero)));me.min=helpers$1.isFinite(me.min)?me.min:null,me.max=helpers$1.isFinite(me.max)?me.max:null,me.minNotZero=helpers$1.isFinite(me.minNotZero)?me.minNotZero:null,this.handleTickRangeOptions()},handleTickRangeOptions:function(){var me=this,tickOpts=me.options.ticks;me.min=nonNegativeOrDefault(tickOpts.min,me.min),me.max=nonNegativeOrDefault(tickOpts.max,me.max),me.min===me.max&&(0!==me.min&&null!==me.min?(me.min=Math.pow(10,Math.floor(log10(me.min))-1),me.max=Math.pow(10,Math.floor(log10(me.max))+1)):(me.min=1,me.max=10)),null===me.min&&(me.min=Math.pow(10,Math.floor(log10(me.max))-1)),null===me.max&&(me.max=0!==me.min?Math.pow(10,Math.floor(log10(me.min))+1):10),null===me.minNotZero&&(me.min>0?me.minNotZero=me.min:me.max<1?me.minNotZero=Math.pow(10,Math.floor(log10(me.max))):me.minNotZero=1)},buildTicks:function(){var me=this,tickOpts=me.options.ticks,reverse=!me.isHorizontal(),generationOptions={min:nonNegativeOrDefault(tickOpts.min),max:nonNegativeOrDefault(tickOpts.max)},ticks=me.ticks=function(generationOptions,dataRange){var exp,significand,ticks=[],tickVal=valueOrDefault$b(generationOptions.min,Math.pow(10,Math.floor(log10(dataRange.min)))),endExp=Math.floor(log10(dataRange.max)),endSignificand=Math.ceil(dataRange.max/Math.pow(10,endExp));0===tickVal?(exp=Math.floor(log10(dataRange.minNotZero)),significand=Math.floor(dataRange.minNotZero/Math.pow(10,exp)),ticks.push(tickVal),tickVal=significand*Math.pow(10,exp)):(exp=Math.floor(log10(tickVal)),significand=Math.floor(tickVal/Math.pow(10,exp)));var precision=exp<0?Math.pow(10,Math.abs(exp)):1;do{ticks.push(tickVal),10==++significand&&(significand=1,precision=++exp>=0?1:precision),tickVal=Math.round(significand*Math.pow(10,exp)*precision)/precision}while(exp<endExp||exp===endExp&&significand<endSignificand);var lastTick=valueOrDefault$b(generationOptions.max,tickVal);return ticks.push(lastTick),ticks}(generationOptions,me);me.max=helpers$1.max(ticks),me.min=helpers$1.min(ticks),tickOpts.reverse?(reverse=!reverse,me.start=me.max,me.end=me.min):(me.start=me.min,me.end=me.max),reverse&&ticks.reverse()},convertTicksToLabels:function(){this.tickValues=this.ticks.slice(),core_scale.prototype.convertTicksToLabels.call(this)},getLabelForIndex:function(index,datasetIndex){return this._getScaleLabel(this.chart.data.datasets[datasetIndex].data[index])},getPixelForTick:function(index){var ticks=this.tickValues;return index<0||index>ticks.length-1?null:this.getPixelForValue(ticks[index])},_getFirstTickValue:function(value){var exp=Math.floor(log10(value));return Math.floor(value/Math.pow(10,exp))*Math.pow(10,exp)},_configure:function(){var me=this,start=me.min,offset=0;core_scale.prototype._configure.call(me),0===start&&(start=me._getFirstTickValue(me.minNotZero),offset=valueOrDefault$b(me.options.ticks.fontSize,core_defaults.global.defaultFontSize)/me._length),me._startValue=log10(start),me._valueOffset=offset,me._valueRange=(log10(me.max)-log10(start))/(1-offset)},getPixelForValue:function(value){var me=this,decimal=0;return(value=+me.getRightValue(value))>me.min&&value>0&&(decimal=(log10(value)-me._startValue)/me._valueRange+me._valueOffset),me.getPixelForDecimal(decimal)},getValueForPixel:function(pixel){var me=this,decimal=me.getDecimalForPixel(pixel);return 0===decimal&&0===me.min?0:Math.pow(10,me._startValue+(decimal-me._valueOffset)*me._valueRange)}}),_defaults$2=defaultConfig$2;scale_logarithmic._defaults=_defaults$2;var valueOrDefault$c=helpers$1.valueOrDefault,valueAtIndexOrDefault$1=helpers$1.valueAtIndexOrDefault,resolve$4=helpers$1.options.resolve,defaultConfig$3={display:!0,animate:!0,position:"chartArea",angleLines:{display:!0,color:"rgba(0,0,0,0.1)",lineWidth:1,borderDash:[],borderDashOffset:0},gridLines:{circular:!1},ticks:{showLabelBackdrop:!0,backdropColor:"rgba(255,255,255,0.75)",backdropPaddingY:2,backdropPaddingX:2,callback:core_ticks.formatters.linear},pointLabels:{display:!0,fontSize:10,callback:function(label){return label}}};function getTickBackdropHeight(opts){var tickOpts=opts.ticks;return tickOpts.display&&opts.display?valueOrDefault$c(tickOpts.fontSize,core_defaults.global.defaultFontSize)+2*tickOpts.backdropPaddingY:0}function determineLimits(angle,pos,size,min,max){return angle===min||angle===max?{start:pos-size/2,end:pos+size/2}:angle<min||angle>max?{start:pos-size,end:pos}:{start:pos,end:pos+size}}function getTextAlignForAngle(angle){return 0===angle||180===angle?"center":angle<180?"left":"right"}function fillText(ctx,text,position,lineHeight){var i,ilen,y=position.y+lineHeight/2;if(helpers$1.isArray(text))for(i=0,ilen=text.length;i<ilen;++i)ctx.fillText(text[i],position.x,y),y+=lineHeight;else ctx.fillText(text,position.x,y)}function adjustPointPositionForLabelHeight(angle,textSize,position){90===angle||270===angle?position.y-=textSize.h/2:(angle>270||angle<90)&&(position.y-=textSize.h)}function numberOrZero(param){return helpers$1.isNumber(param)?param:0}var scale_radialLinear=scale_linearbase.extend({setDimensions:function(){var me=this;me.width=me.maxWidth,me.height=me.maxHeight,me.paddingTop=getTickBackdropHeight(me.options)/2,me.xCenter=Math.floor(me.width/2),me.yCenter=Math.floor((me.height-me.paddingTop)/2),me.drawingArea=Math.min(me.height-me.paddingTop,me.width)/2},determineDataLimits:function(){var me=this,chart=me.chart,min=Number.POSITIVE_INFINITY,max=Number.NEGATIVE_INFINITY;helpers$1.each(chart.data.datasets,(function(dataset,datasetIndex){if(chart.isDatasetVisible(datasetIndex)){var meta=chart.getDatasetMeta(datasetIndex);helpers$1.each(dataset.data,(function(rawValue,index){var value=+me.getRightValue(rawValue);isNaN(value)||meta.data[index].hidden||(min=Math.min(value,min),max=Math.max(value,max))}))}})),me.min=min===Number.POSITIVE_INFINITY?0:min,me.max=max===Number.NEGATIVE_INFINITY?0:max,me.handleTickRangeOptions()},_computeTickLimit:function(){return Math.ceil(this.drawingArea/getTickBackdropHeight(this.options))},convertTicksToLabels:function(){var me=this;scale_linearbase.prototype.convertTicksToLabels.call(me),me.pointLabels=me.chart.data.labels.map((function(){var label=helpers$1.callback(me.options.pointLabels.callback,arguments,me);return label||0===label?label:""}))},getLabelForIndex:function(index,datasetIndex){return+this.getRightValue(this.chart.data.datasets[datasetIndex].data[index])},fit:function(){var opts=this.options;opts.display&&opts.pointLabels.display?function(scale){var i,textSize,pointPosition,plFont=helpers$1.options._parseFont(scale.options.pointLabels),furthestLimits={l:0,r:scale.width,t:0,b:scale.height-scale.paddingTop},furthestAngles={};scale.ctx.font=plFont.string,scale._pointLabelSizes=[];var ctx,lineHeight,label,valueCount=scale.chart.data.labels.length;for(i=0;i<valueCount;i++){pointPosition=scale.getPointPosition(i,scale.drawingArea+5),ctx=scale.ctx,lineHeight=plFont.lineHeight,label=scale.pointLabels[i],textSize=helpers$1.isArray(label)?{w:helpers$1.longestText(ctx,ctx.font,label),h:label.length*lineHeight}:{w:ctx.measureText(label).width,h:lineHeight},scale._pointLabelSizes[i]=textSize;var angleRadians=scale.getIndexAngle(i),angle=helpers$1.toDegrees(angleRadians)%360,hLimits=determineLimits(angle,pointPosition.x,textSize.w,0,180),vLimits=determineLimits(angle,pointPosition.y,textSize.h,90,270);hLimits.start<furthestLimits.l&&(furthestLimits.l=hLimits.start,furthestAngles.l=angleRadians),hLimits.end>furthestLimits.r&&(furthestLimits.r=hLimits.end,furthestAngles.r=angleRadians),vLimits.start<furthestLimits.t&&(furthestLimits.t=vLimits.start,furthestAngles.t=angleRadians),vLimits.end>furthestLimits.b&&(furthestLimits.b=vLimits.end,furthestAngles.b=angleRadians)}scale.setReductions(scale.drawingArea,furthestLimits,furthestAngles)}(this):this.setCenterPoint(0,0,0,0)},setReductions:function(largestPossibleRadius,furthestLimits,furthestAngles){var me=this,radiusReductionLeft=furthestLimits.l/Math.sin(furthestAngles.l),radiusReductionRight=Math.max(furthestLimits.r-me.width,0)/Math.sin(furthestAngles.r),radiusReductionTop=-furthestLimits.t/Math.cos(furthestAngles.t),radiusReductionBottom=-Math.max(furthestLimits.b-(me.height-me.paddingTop),0)/Math.cos(furthestAngles.b);radiusReductionLeft=numberOrZero(radiusReductionLeft),radiusReductionRight=numberOrZero(radiusReductionRight),radiusReductionTop=numberOrZero(radiusReductionTop),radiusReductionBottom=numberOrZero(radiusReductionBottom),me.drawingArea=Math.min(Math.floor(largestPossibleRadius-(radiusReductionLeft+radiusReductionRight)/2),Math.floor(largestPossibleRadius-(radiusReductionTop+radiusReductionBottom)/2)),me.setCenterPoint(radiusReductionLeft,radiusReductionRight,radiusReductionTop,radiusReductionBottom)},setCenterPoint:function(leftMovement,rightMovement,topMovement,bottomMovement){var me=this,maxRight=me.width-rightMovement-me.drawingArea,maxLeft=leftMovement+me.drawingArea,maxTop=topMovement+me.drawingArea,maxBottom=me.height-me.paddingTop-bottomMovement-me.drawingArea;me.xCenter=Math.floor((maxLeft+maxRight)/2+me.left),me.yCenter=Math.floor((maxTop+maxBottom)/2+me.top+me.paddingTop)},getIndexAngle:function(index){var chart=this.chart,angle=(index*(360/chart.data.labels.length)+((chart.options||{}).startAngle||0))%360;return(angle<0?angle+360:angle)*Math.PI*2/360},getDistanceFromCenterForValue:function(value){var me=this;if(helpers$1.isNullOrUndef(value))return NaN;var scalingFactor=me.drawingArea/(me.max-me.min);return me.options.ticks.reverse?(me.max-value)*scalingFactor:(value-me.min)*scalingFactor},getPointPosition:function(index,distanceFromCenter){var thisAngle=this.getIndexAngle(index)-Math.PI/2;return{x:Math.cos(thisAngle)*distanceFromCenter+this.xCenter,y:Math.sin(thisAngle)*distanceFromCenter+this.yCenter}},getPointPositionForValue:function(index,value){return this.getPointPosition(index,this.getDistanceFromCenterForValue(value))},getBasePosition:function(index){var min=this.min,max=this.max;return this.getPointPositionForValue(index||0,this.beginAtZero?0:min<0&&max<0?max:min>0&&max>0?min:0)},_drawGrid:function(){var i,offset,position,me=this,ctx=me.ctx,opts=me.options,gridLineOpts=opts.gridLines,angleLineOpts=opts.angleLines,lineWidth=valueOrDefault$c(angleLineOpts.lineWidth,gridLineOpts.lineWidth),lineColor=valueOrDefault$c(angleLineOpts.color,gridLineOpts.color);if(opts.pointLabels.display&&function(scale){var ctx=scale.ctx,opts=scale.options,pointLabelOpts=opts.pointLabels,tickBackdropHeight=getTickBackdropHeight(opts),outerDistance=scale.getDistanceFromCenterForValue(opts.ticks.reverse?scale.min:scale.max),plFont=helpers$1.options._parseFont(pointLabelOpts);ctx.save(),ctx.font=plFont.string,ctx.textBaseline="middle";for(var i=scale.chart.data.labels.length-1;i>=0;i--){var extra=0===i?tickBackdropHeight/2:0,pointLabelPosition=scale.getPointPosition(i,outerDistance+extra+5),pointLabelFontColor=valueAtIndexOrDefault$1(pointLabelOpts.fontColor,i,core_defaults.global.defaultFontColor);ctx.fillStyle=pointLabelFontColor;var angleRadians=scale.getIndexAngle(i),angle=helpers$1.toDegrees(angleRadians);ctx.textAlign=getTextAlignForAngle(angle),adjustPointPositionForLabelHeight(angle,scale._pointLabelSizes[i],pointLabelPosition),fillText(ctx,scale.pointLabels[i],pointLabelPosition,plFont.lineHeight)}ctx.restore()}(me),gridLineOpts.display&&helpers$1.each(me.ticks,(function(label,index){0!==index&&(offset=me.getDistanceFromCenterForValue(me.ticksAsNumbers[index]),function(scale,gridLineOpts,radius,index){var pointPosition,ctx=scale.ctx,circular=gridLineOpts.circular,valueCount=scale.chart.data.labels.length,lineColor=valueAtIndexOrDefault$1(gridLineOpts.color,index-1),lineWidth=valueAtIndexOrDefault$1(gridLineOpts.lineWidth,index-1);if((circular||valueCount)&&lineColor&&lineWidth){if(ctx.save(),ctx.strokeStyle=lineColor,ctx.lineWidth=lineWidth,ctx.setLineDash&&(ctx.setLineDash(gridLineOpts.borderDash||[]),ctx.lineDashOffset=gridLineOpts.borderDashOffset||0),ctx.beginPath(),circular)ctx.arc(scale.xCenter,scale.yCenter,radius,0,2*Math.PI);else{pointPosition=scale.getPointPosition(0,radius),ctx.moveTo(pointPosition.x,pointPosition.y);for(var i=1;i<valueCount;i++)pointPosition=scale.getPointPosition(i,radius),ctx.lineTo(pointPosition.x,pointPosition.y)}ctx.closePath(),ctx.stroke(),ctx.restore()}}(me,gridLineOpts,offset,index))})),angleLineOpts.display&&lineWidth&&lineColor){for(ctx.save(),ctx.lineWidth=lineWidth,ctx.strokeStyle=lineColor,ctx.setLineDash&&(ctx.setLineDash(resolve$4([angleLineOpts.borderDash,gridLineOpts.borderDash,[]])),ctx.lineDashOffset=resolve$4([angleLineOpts.borderDashOffset,gridLineOpts.borderDashOffset,0])),i=me.chart.data.labels.length-1;i>=0;i--)offset=me.getDistanceFromCenterForValue(opts.ticks.reverse?me.min:me.max),position=me.getPointPosition(i,offset),ctx.beginPath(),ctx.moveTo(me.xCenter,me.yCenter),ctx.lineTo(position.x,position.y),ctx.stroke();ctx.restore()}},_drawLabels:function(){var me=this,ctx=me.ctx,tickOpts=me.options.ticks;if(tickOpts.display){var offset,width,startAngle=me.getIndexAngle(0),tickFont=helpers$1.options._parseFont(tickOpts),tickFontColor=valueOrDefault$c(tickOpts.fontColor,core_defaults.global.defaultFontColor);ctx.save(),ctx.font=tickFont.string,ctx.translate(me.xCenter,me.yCenter),ctx.rotate(startAngle),ctx.textAlign="center",ctx.textBaseline="middle",helpers$1.each(me.ticks,(function(label,index){(0!==index||tickOpts.reverse)&&(offset=me.getDistanceFromCenterForValue(me.ticksAsNumbers[index]),tickOpts.showLabelBackdrop&&(width=ctx.measureText(label).width,ctx.fillStyle=tickOpts.backdropColor,ctx.fillRect(-width/2-tickOpts.backdropPaddingX,-offset-tickFont.size/2-tickOpts.backdropPaddingY,width+2*tickOpts.backdropPaddingX,tickFont.size+2*tickOpts.backdropPaddingY)),ctx.fillStyle=tickFontColor,ctx.fillText(label,0,-offset))})),ctx.restore()}},_drawTitle:helpers$1.noop}),_defaults$3=defaultConfig$3;scale_radialLinear._defaults=_defaults$3;var deprecated$1=helpers$1._deprecated,resolve$5=helpers$1.options.resolve,valueOrDefault$d=helpers$1.valueOrDefault,MIN_INTEGER=Number.MIN_SAFE_INTEGER||-9007199254740991,MAX_INTEGER=Number.MAX_SAFE_INTEGER||9007199254740991,INTERVALS={millisecond:{common:!0,size:1,steps:1e3},second:{common:!0,size:1e3,steps:60},minute:{common:!0,size:6e4,steps:60},hour:{common:!0,size:36e5,steps:24},day:{common:!0,size:864e5,steps:30},week:{common:!1,size:6048e5,steps:4},month:{common:!0,size:2628e6,steps:12},quarter:{common:!1,size:7884e6,steps:4},year:{common:!0,size:3154e7}},UNITS=Object.keys(INTERVALS);function sorter(a,b){return a-b}function getMin(options){return helpers$1.valueOrDefault(options.time.min,options.ticks.min)}function getMax(options){return helpers$1.valueOrDefault(options.time.max,options.ticks.max)}function interpolate$1(table,skey,sval,tkey){var range=function(table,key,value){for(var mid,i0,i1,lo=0,hi=table.length-1;lo>=0&&lo<=hi;){if(i0=table[(mid=lo+hi>>1)-1]||null,i1=table[mid],!i0)return{lo:null,hi:i1};if(i1[key]<value)lo=mid+1;else{if(!(i0[key]>value))return{lo:i0,hi:i1};hi=mid-1}}return{lo:i1,hi:null}}(table,skey,sval),prev=range.lo?range.hi?range.lo:table[table.length-2]:table[0],next=range.lo?range.hi?range.hi:table[table.length-1]:table[1],span=next[skey]-prev[skey],ratio=span?(sval-prev[skey])/span:0,offset=(next[tkey]-prev[tkey])*ratio;return prev[tkey]+offset}function toTimestamp(scale,input){var adapter=scale._adapter,options=scale.options.time,parser=options.parser,format=parser||options.format,value=input;return"function"==typeof parser&&(value=parser(value)),helpers$1.isFinite(value)||(value="string"==typeof format?adapter.parse(value,format):adapter.parse(value)),null!==value?+value:(parser||"function"!=typeof format||(value=format(input),helpers$1.isFinite(value)||(value=adapter.parse(value))),value)}function parse(scale,input){if(helpers$1.isNullOrUndef(input))return null;var options=scale.options.time,value=toTimestamp(scale,scale.getRightValue(input));return null===value||options.round&&(value=+scale._adapter.startOf(value,options.round)),value}function determineUnitForAutoTicks(minUnit,min,max,capacity){var i,interval,factor,ilen=UNITS.length;for(i=UNITS.indexOf(minUnit);i<ilen-1;++i)if(factor=(interval=INTERVALS[UNITS[i]]).steps?interval.steps:MAX_INTEGER,interval.common&&Math.ceil((max-min)/(factor*interval.size))<=capacity)return UNITS[i];return UNITS[ilen-1]}function ticksFromTimestamps(scale,values,majorUnit){var i,value,ticks=[],map={},ilen=values.length;for(i=0;i<ilen;++i)map[value=values[i]]=i,ticks.push({value:value,major:!1});return 0!==ilen&&majorUnit?function(scale,ticks,map,majorUnit){var major,index,adapter=scale._adapter,first=+adapter.startOf(ticks[0].value,majorUnit),last=ticks[ticks.length-1].value;for(major=first;major<=last;major=+adapter.add(major,1,majorUnit))(index=map[major])>=0&&(ticks[index].major=!0);return ticks}(scale,ticks,map,majorUnit):ticks}var scale_time=core_scale.extend({initialize:function(){this.mergeTicksOptions(),core_scale.prototype.initialize.call(this)},update:function(){var me=this,options=me.options,time=options.time||(options.time={}),adapter=me._adapter=new core_adapters._date(options.adapters.date);return deprecated$1("time scale",time.format,"time.format","time.parser"),deprecated$1("time scale",time.min,"time.min","ticks.min"),deprecated$1("time scale",time.max,"time.max","ticks.max"),helpers$1.mergeIf(time.displayFormats,adapter.formats()),core_scale.prototype.update.apply(me,arguments)},getRightValue:function(rawValue){return rawValue&&void 0!==rawValue.t&&(rawValue=rawValue.t),core_scale.prototype.getRightValue.call(this,rawValue)},determineDataLimits:function(){var i,j,ilen,jlen,data,timestamp,labelsAdded,me=this,chart=me.chart,adapter=me._adapter,options=me.options,unit=options.time.unit||"day",min=MAX_INTEGER,max=MIN_INTEGER,timestamps=[],datasets=[],labels=[],dataLabels=me._getLabels();for(i=0,ilen=dataLabels.length;i<ilen;++i)labels.push(parse(me,dataLabels[i]));for(i=0,ilen=(chart.data.datasets||[]).length;i<ilen;++i)if(chart.isDatasetVisible(i))if(data=chart.data.datasets[i].data,helpers$1.isObject(data[0]))for(datasets[i]=[],j=0,jlen=data.length;j<jlen;++j)timestamp=parse(me,data[j]),timestamps.push(timestamp),datasets[i][j]=timestamp;else datasets[i]=labels.slice(0),labelsAdded||(timestamps=timestamps.concat(labels),labelsAdded=!0);else datasets[i]=[];labels.length&&(min=Math.min(min,labels[0]),max=Math.max(max,labels[labels.length-1])),timestamps.length&&(timestamps=ilen>1?function(items){var i,ilen,item,hash={},out=[];for(i=0,ilen=items.length;i<ilen;++i)hash[item=items[i]]||(hash[item]=!0,out.push(item));return out}(timestamps).sort(sorter):timestamps.sort(sorter),min=Math.min(min,timestamps[0]),max=Math.max(max,timestamps[timestamps.length-1])),min=parse(me,getMin(options))||min,max=parse(me,getMax(options))||max,min=min===MAX_INTEGER?+adapter.startOf(Date.now(),unit):min,max=max===MIN_INTEGER?+adapter.endOf(Date.now(),unit)+1:max,me.min=Math.min(min,max),me.max=Math.max(min+1,max),me._table=[],me._timestamps={data:timestamps,datasets:datasets,labels:labels}},buildTicks:function(){var i,ilen,timestamp,me=this,min=me.min,max=me.max,options=me.options,tickOpts=options.ticks,timeOpts=options.time,timestamps=me._timestamps,ticks=[],capacity=me.getLabelCapacity(min),source=tickOpts.source,distribution=options.distribution;for(timestamps="data"===source||"auto"===source&&"series"===distribution?timestamps.data:"labels"===source?timestamps.labels:function(scale,min,max,capacity){var time,adapter=scale._adapter,options=scale.options,timeOpts=options.time,minor=timeOpts.unit||determineUnitForAutoTicks(timeOpts.minUnit,min,max,capacity),stepSize=resolve$5([timeOpts.stepSize,timeOpts.unitStepSize,1]),weekday="week"===minor&&timeOpts.isoWeekday,first=min,ticks=[];if(weekday&&(first=+adapter.startOf(first,"isoWeek",weekday)),first=+adapter.startOf(first,weekday?"day":minor),adapter.diff(max,min,minor)>1e5*stepSize)throw min+" and "+max+" are too far apart with stepSize of "+stepSize+" "+minor;for(time=first;time<max;time=+adapter.add(time,stepSize,minor))ticks.push(time);return time!==max&&"ticks"!==options.bounds||ticks.push(time),ticks}(me,min,max,capacity),"ticks"===options.bounds&&timestamps.length&&(min=timestamps[0],max=timestamps[timestamps.length-1]),min=parse(me,getMin(options))||min,max=parse(me,getMax(options))||max,i=0,ilen=timestamps.length;i<ilen;++i)(timestamp=timestamps[i])>=min&&timestamp<=max&&ticks.push(timestamp);return me.min=min,me.max=max,me._unit=timeOpts.unit||(tickOpts.autoSkip?determineUnitForAutoTicks(timeOpts.minUnit,me.min,me.max,capacity):function(scale,numTicks,minUnit,min,max){var i,unit;for(i=UNITS.length-1;i>=UNITS.indexOf(minUnit);i--)if(unit=UNITS[i],INTERVALS[unit].common&&scale._adapter.diff(max,min,unit)>=numTicks-1)return unit;return UNITS[minUnit?UNITS.indexOf(minUnit):0]}(me,ticks.length,timeOpts.minUnit,me.min,me.max)),me._majorUnit=tickOpts.major.enabled&&"year"!==me._unit?function(unit){for(var i=UNITS.indexOf(unit)+1,ilen=UNITS.length;i<ilen;++i)if(INTERVALS[UNITS[i]].common)return UNITS[i]}(me._unit):void 0,me._table=function(timestamps,min,max,distribution){if("linear"===distribution||!timestamps.length)return[{time:min,pos:0},{time:max,pos:1}];var i,ilen,prev,curr,next,table=[],items=[min];for(i=0,ilen=timestamps.length;i<ilen;++i)(curr=timestamps[i])>min&&curr<max&&items.push(curr);for(items.push(max),i=0,ilen=items.length;i<ilen;++i)next=items[i+1],prev=items[i-1],curr=items[i],void 0!==prev&&void 0!==next&&Math.round((next+prev)/2)===curr||table.push({time:curr,pos:i/(ilen-1)});return table}(me._timestamps.data,min,max,distribution),me._offsets=function(table,ticks,min,max,options){var first,last,start=0,end=0;return options.offset&&ticks.length&&(first=interpolate$1(table,"time",ticks[0],"pos"),start=1===ticks.length?1-first:(interpolate$1(table,"time",ticks[1],"pos")-first)/2,last=interpolate$1(table,"time",ticks[ticks.length-1],"pos"),end=1===ticks.length?last:(last-interpolate$1(table,"time",ticks[ticks.length-2],"pos"))/2),{start:start,end:end,factor:1/(start+1+end)}}(me._table,ticks,0,0,options),tickOpts.reverse&&ticks.reverse(),ticksFromTimestamps(me,ticks,me._majorUnit)},getLabelForIndex:function(index,datasetIndex){var me=this,adapter=me._adapter,data=me.chart.data,timeOpts=me.options.time,label=data.labels&&index<data.labels.length?data.labels[index]:"",value=data.datasets[datasetIndex].data[index];return helpers$1.isObject(value)&&(label=me.getRightValue(value)),timeOpts.tooltipFormat?adapter.format(toTimestamp(me,label),timeOpts.tooltipFormat):"string"==typeof label?label:adapter.format(toTimestamp(me,label),timeOpts.displayFormats.datetime)},tickFormatFunction:function(time,index,ticks,format){var adapter=this._adapter,options=this.options,formats=options.time.displayFormats,minorFormat=formats[this._unit],majorUnit=this._majorUnit,majorFormat=formats[majorUnit],tick=ticks[index],tickOpts=options.ticks,major=majorUnit&&majorFormat&&tick&&tick.major,label=adapter.format(time,format||(major?majorFormat:minorFormat)),nestedTickOpts=major?tickOpts.major:tickOpts.minor,formatter=resolve$5([nestedTickOpts.callback,nestedTickOpts.userCallback,tickOpts.callback,tickOpts.userCallback]);return formatter?formatter(label,index,ticks):label},convertTicksToLabels:function(ticks){var i,ilen,labels=[];for(i=0,ilen=ticks.length;i<ilen;++i)labels.push(this.tickFormatFunction(ticks[i].value,i,ticks));return labels},getPixelForOffset:function(time){var offsets=this._offsets,pos=interpolate$1(this._table,"time",time,"pos");return this.getPixelForDecimal((offsets.start+pos)*offsets.factor)},getPixelForValue:function(value,index,datasetIndex){var time=null;if(void 0!==index&&void 0!==datasetIndex&&(time=this._timestamps.datasets[datasetIndex][index]),null===time&&(time=parse(this,value)),null!==time)return this.getPixelForOffset(time)},getPixelForTick:function(index){var ticks=this.getTicks();return index>=0&&index<ticks.length?this.getPixelForOffset(ticks[index].value):null},getValueForPixel:function(pixel){var offsets=this._offsets,pos=this.getDecimalForPixel(pixel)/offsets.factor-offsets.end,time=interpolate$1(this._table,"pos",pos,"time");return this._adapter._create(time)},_getLabelSize:function(label){var ticksOpts=this.options.ticks,tickLabelWidth=this.ctx.measureText(label).width,angle=helpers$1.toRadians(this.isHorizontal()?ticksOpts.maxRotation:ticksOpts.minRotation),cosRotation=Math.cos(angle),sinRotation=Math.sin(angle),tickFontSize=valueOrDefault$d(ticksOpts.fontSize,core_defaults.global.defaultFontSize);return{w:tickLabelWidth*cosRotation+tickFontSize*sinRotation,h:tickLabelWidth*sinRotation+tickFontSize*cosRotation}},getLabelWidth:function(label){return this._getLabelSize(label).w},getLabelCapacity:function(exampleTime){var me=this,timeOpts=me.options.time,displayFormats=timeOpts.displayFormats,format=displayFormats[timeOpts.unit]||displayFormats.millisecond,exampleLabel=me.tickFormatFunction(exampleTime,0,ticksFromTimestamps(me,[exampleTime],me._majorUnit),format),size=me._getLabelSize(exampleLabel),capacity=Math.floor(me.isHorizontal()?me.width/size.w:me.height/size.h);return me.options.offset&&capacity--,capacity>0?capacity:1}}),_defaults$4={position:"bottom",distribution:"linear",bounds:"data",adapters:{},time:{parser:!1,unit:!1,round:!1,displayFormat:!1,isoWeekday:!1,minUnit:"millisecond",displayFormats:{}},ticks:{autoSkip:!1,source:"auto",major:{enabled:!1}}};scale_time._defaults=_defaults$4;var scales={category:scale_category,linear:scale_linear,logarithmic:scale_logarithmic,radialLinear:scale_radialLinear,time:scale_time},moment=createCommonjsModule((function(module,exports){module.exports=function(){var hookCallback,some;function hooks(){return hookCallback.apply(null,arguments)}function setHookCallback(callback){hookCallback=callback}function isArray(input){return input instanceof Array||"[object Array]"===Object.prototype.toString.call(input)}function isObject(input){return null!=input&&"[object Object]"===Object.prototype.toString.call(input)}function isObjectEmpty(obj){if(Object.getOwnPropertyNames)return 0===Object.getOwnPropertyNames(obj).length;var k;for(k in obj)if(obj.hasOwnProperty(k))return!1;return!0}function isUndefined(input){return void 0===input}function isNumber(input){return"number"==typeof input||"[object Number]"===Object.prototype.toString.call(input)}function isDate(input){return input instanceof Date||"[object Date]"===Object.prototype.toString.call(input)}function map(arr,fn){var i,res=[];for(i=0;i<arr.length;++i)res.push(fn(arr[i],i));return res}function hasOwnProp(a,b){return Object.prototype.hasOwnProperty.call(a,b)}function extend(a,b){for(var i in b)hasOwnProp(b,i)&&(a[i]=b[i]);return hasOwnProp(b,"toString")&&(a.toString=b.toString),hasOwnProp(b,"valueOf")&&(a.valueOf=b.valueOf),a}function createUTC(input,format,locale,strict){return createLocalOrUTC(input,format,locale,strict,!0).utc()}function defaultParsingFlags(){return{empty:!1,unusedTokens:[],unusedInput:[],overflow:-2,charsLeftOver:0,nullInput:!1,invalidMonth:null,invalidFormat:!1,userInvalidated:!1,iso:!1,parsedDateParts:[],meridiem:null,rfc2822:!1,weekdayMismatch:!1}}function getParsingFlags(m){return null==m._pf&&(m._pf=defaultParsingFlags()),m._pf}function isValid(m){if(null==m._isValid){var flags=getParsingFlags(m),parsedParts=some.call(flags.parsedDateParts,(function(i){return null!=i})),isNowValid=!isNaN(m._d.getTime())&&flags.overflow<0&&!flags.empty&&!flags.invalidMonth&&!flags.invalidWeekday&&!flags.weekdayMismatch&&!flags.nullInput&&!flags.invalidFormat&&!flags.userInvalidated&&(!flags.meridiem||flags.meridiem&&parsedParts);if(m._strict&&(isNowValid=isNowValid&&0===flags.charsLeftOver&&0===flags.unusedTokens.length&&void 0===flags.bigHour),null!=Object.isFrozen&&Object.isFrozen(m))return isNowValid;m._isValid=isNowValid}return m._isValid}function createInvalid(flags){var m=createUTC(NaN);return null!=flags?extend(getParsingFlags(m),flags):getParsingFlags(m).userInvalidated=!0,m}some=Array.prototype.some?Array.prototype.some:function(fun){for(var t=Object(this),len=t.length>>>0,i=0;i<len;i++)if(i in t&&fun.call(this,t[i],i,t))return!0;return!1};var momentProperties=hooks.momentProperties=[];function copyConfig(to,from){var i,prop,val;if(isUndefined(from._isAMomentObject)||(to._isAMomentObject=from._isAMomentObject),isUndefined(from._i)||(to._i=from._i),isUndefined(from._f)||(to._f=from._f),isUndefined(from._l)||(to._l=from._l),isUndefined(from._strict)||(to._strict=from._strict),isUndefined(from._tzm)||(to._tzm=from._tzm),isUndefined(from._isUTC)||(to._isUTC=from._isUTC),isUndefined(from._offset)||(to._offset=from._offset),isUndefined(from._pf)||(to._pf=getParsingFlags(from)),isUndefined(from._locale)||(to._locale=from._locale),momentProperties.length>0)for(i=0;i<momentProperties.length;i++)isUndefined(val=from[prop=momentProperties[i]])||(to[prop]=val);return to}var updateInProgress=!1;function Moment(config){copyConfig(this,config),this._d=new Date(null!=config._d?config._d.getTime():NaN),this.isValid()||(this._d=new Date(NaN)),!1===updateInProgress&&(updateInProgress=!0,hooks.updateOffset(this),updateInProgress=!1)}function isMoment(obj){return obj instanceof Moment||null!=obj&&null!=obj._isAMomentObject}function absFloor(number){return number<0?Math.ceil(number)||0:Math.floor(number)}function toInt(argumentForCoercion){var coercedNumber=+argumentForCoercion,value=0;return 0!==coercedNumber&&isFinite(coercedNumber)&&(value=absFloor(coercedNumber)),value}function compareArrays(array1,array2,dontConvert){var i,len=Math.min(array1.length,array2.length),lengthDiff=Math.abs(array1.length-array2.length),diffs=0;for(i=0;i<len;i++)(dontConvert&&array1[i]!==array2[i]||!dontConvert&&toInt(array1[i])!==toInt(array2[i]))&&diffs++;return diffs+lengthDiff}function warn(msg){!1===hooks.suppressDeprecationWarnings&&"undefined"!=typeof console&&console.warn&&console.warn("Deprecation warning: "+msg)}function deprecate(msg,fn){var firstTime=!0;return extend((function(){if(null!=hooks.deprecationHandler&&hooks.deprecationHandler(null,msg),firstTime){for(var arg,args=[],i=0;i<arguments.length;i++){if(arg="","object"==typeof arguments[i]){for(var key in arg+="\n["+i+"] ",arguments[0])arg+=key+": "+arguments[0][key]+", ";arg=arg.slice(0,-2)}else arg=arguments[i];args.push(arg)}warn(msg+"\nArguments: "+Array.prototype.slice.call(args).join("")+"\n"+(new Error).stack),firstTime=!1}return fn.apply(this,arguments)}),fn)}var keys,deprecations={};function deprecateSimple(name,msg){null!=hooks.deprecationHandler&&hooks.deprecationHandler(name,msg),deprecations[name]||(warn(msg),deprecations[name]=!0)}function isFunction(input){return input instanceof Function||"[object Function]"===Object.prototype.toString.call(input)}function set(config){var prop,i;for(i in config)isFunction(prop=config[i])?this[i]=prop:this["_"+i]=prop;this._config=config,this._dayOfMonthOrdinalParseLenient=new RegExp((this._dayOfMonthOrdinalParse.source||this._ordinalParse.source)+"|"+/\d{1,2}/.source)}function mergeConfigs(parentConfig,childConfig){var prop,res=extend({},parentConfig);for(prop in childConfig)hasOwnProp(childConfig,prop)&&(isObject(parentConfig[prop])&&isObject(childConfig[prop])?(res[prop]={},extend(res[prop],parentConfig[prop]),extend(res[prop],childConfig[prop])):null!=childConfig[prop]?res[prop]=childConfig[prop]:delete res[prop]);for(prop in parentConfig)hasOwnProp(parentConfig,prop)&&!hasOwnProp(childConfig,prop)&&isObject(parentConfig[prop])&&(res[prop]=extend({},res[prop]));return res}function Locale(config){null!=config&&this.set(config)}hooks.suppressDeprecationWarnings=!1,hooks.deprecationHandler=null,keys=Object.keys?Object.keys:function(obj){var i,res=[];for(i in obj)hasOwnProp(obj,i)&&res.push(i);return res};var defaultCalendar={sameDay:"[Today at] LT",nextDay:"[Tomorrow at] LT",nextWeek:"dddd [at] LT",lastDay:"[Yesterday at] LT",lastWeek:"[Last] dddd [at] LT",sameElse:"L"};function calendar(key,mom,now){var output=this._calendar[key]||this._calendar.sameElse;return isFunction(output)?output.call(mom,now):output}var defaultLongDateFormat={LTS:"h:mm:ss A",LT:"h:mm A",L:"MM/DD/YYYY",LL:"MMMM D, YYYY",LLL:"MMMM D, YYYY h:mm A",LLLL:"dddd, MMMM D, YYYY h:mm A"};function longDateFormat(key){var format=this._longDateFormat[key],formatUpper=this._longDateFormat[key.toUpperCase()];return format||!formatUpper?format:(this._longDateFormat[key]=formatUpper.replace(/MMMM|MM|DD|dddd/g,(function(val){return val.slice(1)})),this._longDateFormat[key])}var defaultInvalidDate="Invalid date";function invalidDate(){return this._invalidDate}var defaultOrdinal="%d",defaultDayOfMonthOrdinalParse=/\d{1,2}/;function ordinal(number){return this._ordinal.replace("%d",number)}var defaultRelativeTime={future:"in %s",past:"%s ago",s:"a few seconds",ss:"%d seconds",m:"a minute",mm:"%d minutes",h:"an hour",hh:"%d hours",d:"a day",dd:"%d days",M:"a month",MM:"%d months",y:"a year",yy:"%d years"};function relativeTime(number,withoutSuffix,string,isFuture){var output=this._relativeTime[string];return isFunction(output)?output(number,withoutSuffix,string,isFuture):output.replace(/%d/i,number)}function pastFuture(diff,output){var format=this._relativeTime[diff>0?"future":"past"];return isFunction(format)?format(output):format.replace(/%s/i,output)}var aliases={};function addUnitAlias(unit,shorthand){var lowerCase=unit.toLowerCase();aliases[lowerCase]=aliases[lowerCase+"s"]=aliases[shorthand]=unit}function normalizeUnits(units){return"string"==typeof units?aliases[units]||aliases[units.toLowerCase()]:void 0}function normalizeObjectUnits(inputObject){var normalizedProp,prop,normalizedInput={};for(prop in inputObject)hasOwnProp(inputObject,prop)&&(normalizedProp=normalizeUnits(prop))&&(normalizedInput[normalizedProp]=inputObject[prop]);return normalizedInput}var priorities={};function addUnitPriority(unit,priority){priorities[unit]=priority}function getPrioritizedUnits(unitsObj){var units=[];for(var u in unitsObj)units.push({unit:u,priority:priorities[u]});return units.sort((function(a,b){return a.priority-b.priority})),units}function zeroFill(number,targetLength,forceSign){var absNumber=""+Math.abs(number),zerosToFill=targetLength-absNumber.length;return(number>=0?forceSign?"+":"":"-")+Math.pow(10,Math.max(0,zerosToFill)).toString().substr(1)+absNumber}var formattingTokens=/(\[[^\[]*\])|(\\)?([Hh]mm(ss)?|Mo|MM?M?M?|Do|DDDo|DD?D?D?|ddd?d?|do?|w[o|w]?|W[o|W]?|Qo?|YYYYYY|YYYYY|YYYY|YY|gg(ggg?)?|GG(GGG?)?|e|E|a|A|hh?|HH?|kk?|mm?|ss?|S{1,9}|x|X|zz?|ZZ?|.)/g,localFormattingTokens=/(\[[^\[]*\])|(\\)?(LTS|LT|LL?L?L?|l{1,4})/g,formatFunctions={},formatTokenFunctions={};function addFormatToken(token,padded,ordinal,callback){var func=callback;"string"==typeof callback&&(func=function(){return this[callback]()}),token&&(formatTokenFunctions[token]=func),padded&&(formatTokenFunctions[padded[0]]=function(){return zeroFill(func.apply(this,arguments),padded[1],padded[2])}),ordinal&&(formatTokenFunctions[ordinal]=function(){return this.localeData().ordinal(func.apply(this,arguments),token)})}function removeFormattingTokens(input){return input.match(/\[[\s\S]/)?input.replace(/^\[|\]$/g,""):input.replace(/\\/g,"")}function makeFormatFunction(format){var i,length,array=format.match(formattingTokens);for(i=0,length=array.length;i<length;i++)formatTokenFunctions[array[i]]?array[i]=formatTokenFunctions[array[i]]:array[i]=removeFormattingTokens(array[i]);return function(mom){var i,output="";for(i=0;i<length;i++)output+=isFunction(array[i])?array[i].call(mom,format):array[i];return output}}function formatMoment(m,format){return m.isValid()?(format=expandFormat(format,m.localeData()),formatFunctions[format]=formatFunctions[format]||makeFormatFunction(format),formatFunctions[format](m)):m.localeData().invalidDate()}function expandFormat(format,locale){var i=5;function replaceLongDateFormatTokens(input){return locale.longDateFormat(input)||input}for(localFormattingTokens.lastIndex=0;i>=0&&localFormattingTokens.test(format);)format=format.replace(localFormattingTokens,replaceLongDateFormatTokens),localFormattingTokens.lastIndex=0,i-=1;return format}var match1=/\d/,match2=/\d\d/,match3=/\d{3}/,match4=/\d{4}/,match6=/[+-]?\d{6}/,match1to2=/\d\d?/,match3to4=/\d\d\d\d?/,match5to6=/\d\d\d\d\d\d?/,match1to3=/\d{1,3}/,match1to4=/\d{1,4}/,match1to6=/[+-]?\d{1,6}/,matchUnsigned=/\d+/,matchSigned=/[+-]?\d+/,matchOffset=/Z|[+-]\d\d:?\d\d/gi,matchShortOffset=/Z|[+-]\d\d(?::?\d\d)?/gi,matchTimestamp=/[+-]?\d+(\.\d{1,3})?/,matchWord=/[0-9]{0,256}['a-z\u00A0-\u05FF\u0700-\uD7FF\uF900-\uFDCF\uFDF0-\uFF07\uFF10-\uFFEF]{1,256}|[\u0600-\u06FF\/]{1,256}(\s*?[\u0600-\u06FF]{1,256}){1,2}/i,regexes={};function addRegexToken(token,regex,strictRegex){regexes[token]=isFunction(regex)?regex:function(isStrict,localeData){return isStrict&&strictRegex?strictRegex:regex}}function getParseRegexForToken(token,config){return hasOwnProp(regexes,token)?regexes[token](config._strict,config._locale):new RegExp(unescapeFormat(token))}function unescapeFormat(s){return regexEscape(s.replace("\\","").replace(/\\(\[)|\\(\])|\[([^\]\[]*)\]|\\(.)/g,(function(matched,p1,p2,p3,p4){return p1||p2||p3||p4})))}function regexEscape(s){return s.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&")}var tokens={};function addParseToken(token,callback){var i,func=callback;for("string"==typeof token&&(token=[token]),isNumber(callback)&&(func=function(input,array){array[callback]=toInt(input)}),i=0;i<token.length;i++)tokens[token[i]]=func}function addWeekParseToken(token,callback){addParseToken(token,(function(input,array,config,token){config._w=config._w||{},callback(input,config._w,config,token)}))}function addTimeToArrayFromToken(token,input,config){null!=input&&hasOwnProp(tokens,token)&&tokens[token](input,config._a,config,token)}var YEAR=0,MONTH=1,DATE=2,HOUR=3,MINUTE=4,SECOND=5,MILLISECOND=6,WEEK=7,WEEKDAY=8;function daysInYear(year){return isLeapYear(year)?366:365}function isLeapYear(year){return year%4==0&&year%100!=0||year%400==0}addFormatToken("Y",0,0,(function(){var y=this.year();return y<=9999?""+y:"+"+y})),addFormatToken(0,["YY",2],0,(function(){return this.year()%100})),addFormatToken(0,["YYYY",4],0,"year"),addFormatToken(0,["YYYYY",5],0,"year"),addFormatToken(0,["YYYYYY",6,!0],0,"year"),addUnitAlias("year","y"),addUnitPriority("year",1),addRegexToken("Y",matchSigned),addRegexToken("YY",match1to2,match2),addRegexToken("YYYY",match1to4,match4),addRegexToken("YYYYY",match1to6,match6),addRegexToken("YYYYYY",match1to6,match6),addParseToken(["YYYYY","YYYYYY"],YEAR),addParseToken("YYYY",(function(input,array){array[YEAR]=2===input.length?hooks.parseTwoDigitYear(input):toInt(input)})),addParseToken("YY",(function(input,array){array[YEAR]=hooks.parseTwoDigitYear(input)})),addParseToken("Y",(function(input,array){array[YEAR]=parseInt(input,10)})),hooks.parseTwoDigitYear=function(input){return toInt(input)+(toInt(input)>68?1900:2e3)};var indexOf,getSetYear=makeGetSet("FullYear",!0);function getIsLeapYear(){return isLeapYear(this.year())}function makeGetSet(unit,keepTime){return function(value){return null!=value?(set$1(this,unit,value),hooks.updateOffset(this,keepTime),this):get(this,unit)}}function get(mom,unit){return mom.isValid()?mom._d["get"+(mom._isUTC?"UTC":"")+unit]():NaN}function set$1(mom,unit,value){mom.isValid()&&!isNaN(value)&&("FullYear"===unit&&isLeapYear(mom.year())&&1===mom.month()&&29===mom.date()?mom._d["set"+(mom._isUTC?"UTC":"")+unit](value,mom.month(),daysInMonth(value,mom.month())):mom._d["set"+(mom._isUTC?"UTC":"")+unit](value))}function stringGet(units){return isFunction(this[units=normalizeUnits(units)])?this[units]():this}function stringSet(units,value){if("object"==typeof units)for(var prioritized=getPrioritizedUnits(units=normalizeObjectUnits(units)),i=0;i<prioritized.length;i++)this[prioritized[i].unit](units[prioritized[i].unit]);else if(isFunction(this[units=normalizeUnits(units)]))return this[units](value);return this}function mod(n,x){return(n%x+x)%x}function daysInMonth(year,month){if(isNaN(year)||isNaN(month))return NaN;var modMonth=mod(month,12);return year+=(month-modMonth)/12,1===modMonth?isLeapYear(year)?29:28:31-modMonth%7%2}indexOf=Array.prototype.indexOf?Array.prototype.indexOf:function(o){var i;for(i=0;i<this.length;++i)if(this[i]===o)return i;return-1},addFormatToken("M",["MM",2],"Mo",(function(){return this.month()+1})),addFormatToken("MMM",0,0,(function(format){return this.localeData().monthsShort(this,format)})),addFormatToken("MMMM",0,0,(function(format){return this.localeData().months(this,format)})),addUnitAlias("month","M"),addUnitPriority("month",8),addRegexToken("M",match1to2),addRegexToken("MM",match1to2,match2),addRegexToken("MMM",(function(isStrict,locale){return locale.monthsShortRegex(isStrict)})),addRegexToken("MMMM",(function(isStrict,locale){return locale.monthsRegex(isStrict)})),addParseToken(["M","MM"],(function(input,array){array[MONTH]=toInt(input)-1})),addParseToken(["MMM","MMMM"],(function(input,array,config,token){var month=config._locale.monthsParse(input,token,config._strict);null!=month?array[MONTH]=month:getParsingFlags(config).invalidMonth=input}));var MONTHS_IN_FORMAT=/D[oD]?(\[[^\[\]]*\]|\s)+MMMM?/,defaultLocaleMonths="January_February_March_April_May_June_July_August_September_October_November_December".split("_");function localeMonths(m,format){return m?isArray(this._months)?this._months[m.month()]:this._months[(this._months.isFormat||MONTHS_IN_FORMAT).test(format)?"format":"standalone"][m.month()]:isArray(this._months)?this._months:this._months.standalone}var defaultLocaleMonthsShort="Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_");function localeMonthsShort(m,format){return m?isArray(this._monthsShort)?this._monthsShort[m.month()]:this._monthsShort[MONTHS_IN_FORMAT.test(format)?"format":"standalone"][m.month()]:isArray(this._monthsShort)?this._monthsShort:this._monthsShort.standalone}function handleStrictParse(monthName,format,strict){var i,ii,mom,llc=monthName.toLocaleLowerCase();if(!this._monthsParse)for(this._monthsParse=[],this._longMonthsParse=[],this._shortMonthsParse=[],i=0;i<12;++i)mom=createUTC([2e3,i]),this._shortMonthsParse[i]=this.monthsShort(mom,"").toLocaleLowerCase(),this._longMonthsParse[i]=this.months(mom,"").toLocaleLowerCase();return strict?"MMM"===format?-1!==(ii=indexOf.call(this._shortMonthsParse,llc))?ii:null:-1!==(ii=indexOf.call(this._longMonthsParse,llc))?ii:null:"MMM"===format?-1!==(ii=indexOf.call(this._shortMonthsParse,llc))||-1!==(ii=indexOf.call(this._longMonthsParse,llc))?ii:null:-1!==(ii=indexOf.call(this._longMonthsParse,llc))||-1!==(ii=indexOf.call(this._shortMonthsParse,llc))?ii:null}function localeMonthsParse(monthName,format,strict){var i,mom,regex;if(this._monthsParseExact)return handleStrictParse.call(this,monthName,format,strict);for(this._monthsParse||(this._monthsParse=[],this._longMonthsParse=[],this._shortMonthsParse=[]),i=0;i<12;i++){if(mom=createUTC([2e3,i]),strict&&!this._longMonthsParse[i]&&(this._longMonthsParse[i]=new RegExp("^"+this.months(mom,"").replace(".","")+"$","i"),this._shortMonthsParse[i]=new RegExp("^"+this.monthsShort(mom,"").replace(".","")+"$","i")),strict||this._monthsParse[i]||(regex="^"+this.months(mom,"")+"|^"+this.monthsShort(mom,""),this._monthsParse[i]=new RegExp(regex.replace(".",""),"i")),strict&&"MMMM"===format&&this._longMonthsParse[i].test(monthName))return i;if(strict&&"MMM"===format&&this._shortMonthsParse[i].test(monthName))return i;if(!strict&&this._monthsParse[i].test(monthName))return i}}function setMonth(mom,value){var dayOfMonth;if(!mom.isValid())return mom;if("string"==typeof value)if(/^\d+$/.test(value))value=toInt(value);else if(!isNumber(value=mom.localeData().monthsParse(value)))return mom;return dayOfMonth=Math.min(mom.date(),daysInMonth(mom.year(),value)),mom._d["set"+(mom._isUTC?"UTC":"")+"Month"](value,dayOfMonth),mom}function getSetMonth(value){return null!=value?(setMonth(this,value),hooks.updateOffset(this,!0),this):get(this,"Month")}function getDaysInMonth(){return daysInMonth(this.year(),this.month())}var defaultMonthsShortRegex=matchWord;function monthsShortRegex(isStrict){return this._monthsParseExact?(hasOwnProp(this,"_monthsRegex")||computeMonthsParse.call(this),isStrict?this._monthsShortStrictRegex:this._monthsShortRegex):(hasOwnProp(this,"_monthsShortRegex")||(this._monthsShortRegex=defaultMonthsShortRegex),this._monthsShortStrictRegex&&isStrict?this._monthsShortStrictRegex:this._monthsShortRegex)}var defaultMonthsRegex=matchWord;function monthsRegex(isStrict){return this._monthsParseExact?(hasOwnProp(this,"_monthsRegex")||computeMonthsParse.call(this),isStrict?this._monthsStrictRegex:this._monthsRegex):(hasOwnProp(this,"_monthsRegex")||(this._monthsRegex=defaultMonthsRegex),this._monthsStrictRegex&&isStrict?this._monthsStrictRegex:this._monthsRegex)}function computeMonthsParse(){function cmpLenRev(a,b){return b.length-a.length}var i,mom,shortPieces=[],longPieces=[],mixedPieces=[];for(i=0;i<12;i++)mom=createUTC([2e3,i]),shortPieces.push(this.monthsShort(mom,"")),longPieces.push(this.months(mom,"")),mixedPieces.push(this.months(mom,"")),mixedPieces.push(this.monthsShort(mom,""));for(shortPieces.sort(cmpLenRev),longPieces.sort(cmpLenRev),mixedPieces.sort(cmpLenRev),i=0;i<12;i++)shortPieces[i]=regexEscape(shortPieces[i]),longPieces[i]=regexEscape(longPieces[i]);for(i=0;i<24;i++)mixedPieces[i]=regexEscape(mixedPieces[i]);this._monthsRegex=new RegExp("^("+mixedPieces.join("|")+")","i"),this._monthsShortRegex=this._monthsRegex,this._monthsStrictRegex=new RegExp("^("+longPieces.join("|")+")","i"),this._monthsShortStrictRegex=new RegExp("^("+shortPieces.join("|")+")","i")}function createDate(y,m,d,h,M,s,ms){var date;return y<100&&y>=0?(date=new Date(y+400,m,d,h,M,s,ms),isFinite(date.getFullYear())&&date.setFullYear(y)):date=new Date(y,m,d,h,M,s,ms),date}function createUTCDate(y){var date;if(y<100&&y>=0){var args=Array.prototype.slice.call(arguments);args[0]=y+400,date=new Date(Date.UTC.apply(null,args)),isFinite(date.getUTCFullYear())&&date.setUTCFullYear(y)}else date=new Date(Date.UTC.apply(null,arguments));return date}function firstWeekOffset(year,dow,doy){var fwd=7+dow-doy;return-(7+createUTCDate(year,0,fwd).getUTCDay()-dow)%7+fwd-1}function dayOfYearFromWeeks(year,week,weekday,dow,doy){var resYear,resDayOfYear,dayOfYear=1+7*(week-1)+(7+weekday-dow)%7+firstWeekOffset(year,dow,doy);return dayOfYear<=0?resDayOfYear=daysInYear(resYear=year-1)+dayOfYear:dayOfYear>daysInYear(year)?(resYear=year+1,resDayOfYear=dayOfYear-daysInYear(year)):(resYear=year,resDayOfYear=dayOfYear),{year:resYear,dayOfYear:resDayOfYear}}function weekOfYear(mom,dow,doy){var resWeek,resYear,weekOffset=firstWeekOffset(mom.year(),dow,doy),week=Math.floor((mom.dayOfYear()-weekOffset-1)/7)+1;return week<1?resWeek=week+weeksInYear(resYear=mom.year()-1,dow,doy):week>weeksInYear(mom.year(),dow,doy)?(resWeek=week-weeksInYear(mom.year(),dow,doy),resYear=mom.year()+1):(resYear=mom.year(),resWeek=week),{week:resWeek,year:resYear}}function weeksInYear(year,dow,doy){var weekOffset=firstWeekOffset(year,dow,doy),weekOffsetNext=firstWeekOffset(year+1,dow,doy);return(daysInYear(year)-weekOffset+weekOffsetNext)/7}function localeWeek(mom){return weekOfYear(mom,this._week.dow,this._week.doy).week}addFormatToken("w",["ww",2],"wo","week"),addFormatToken("W",["WW",2],"Wo","isoWeek"),addUnitAlias("week","w"),addUnitAlias("isoWeek","W"),addUnitPriority("week",5),addUnitPriority("isoWeek",5),addRegexToken("w",match1to2),addRegexToken("ww",match1to2,match2),addRegexToken("W",match1to2),addRegexToken("WW",match1to2,match2),addWeekParseToken(["w","ww","W","WW"],(function(input,week,config,token){week[token.substr(0,1)]=toInt(input)}));var defaultLocaleWeek={dow:0,doy:6};function localeFirstDayOfWeek(){return this._week.dow}function localeFirstDayOfYear(){return this._week.doy}function getSetWeek(input){var week=this.localeData().week(this);return null==input?week:this.add(7*(input-week),"d")}function getSetISOWeek(input){var week=weekOfYear(this,1,4).week;return null==input?week:this.add(7*(input-week),"d")}function parseWeekday(input,locale){return"string"!=typeof input?input:isNaN(input)?"number"==typeof(input=locale.weekdaysParse(input))?input:null:parseInt(input,10)}function parseIsoWeekday(input,locale){return"string"==typeof input?locale.weekdaysParse(input)%7||7:isNaN(input)?null:input}function shiftWeekdays(ws,n){return ws.slice(n,7).concat(ws.slice(0,n))}addFormatToken("d",0,"do","day"),addFormatToken("dd",0,0,(function(format){return this.localeData().weekdaysMin(this,format)})),addFormatToken("ddd",0,0,(function(format){return this.localeData().weekdaysShort(this,format)})),addFormatToken("dddd",0,0,(function(format){return this.localeData().weekdays(this,format)})),addFormatToken("e",0,0,"weekday"),addFormatToken("E",0,0,"isoWeekday"),addUnitAlias("day","d"),addUnitAlias("weekday","e"),addUnitAlias("isoWeekday","E"),addUnitPriority("day",11),addUnitPriority("weekday",11),addUnitPriority("isoWeekday",11),addRegexToken("d",match1to2),addRegexToken("e",match1to2),addRegexToken("E",match1to2),addRegexToken("dd",(function(isStrict,locale){return locale.weekdaysMinRegex(isStrict)})),addRegexToken("ddd",(function(isStrict,locale){return locale.weekdaysShortRegex(isStrict)})),addRegexToken("dddd",(function(isStrict,locale){return locale.weekdaysRegex(isStrict)})),addWeekParseToken(["dd","ddd","dddd"],(function(input,week,config,token){var weekday=config._locale.weekdaysParse(input,token,config._strict);null!=weekday?week.d=weekday:getParsingFlags(config).invalidWeekday=input})),addWeekParseToken(["d","e","E"],(function(input,week,config,token){week[token]=toInt(input)}));var defaultLocaleWeekdays="Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_");function localeWeekdays(m,format){var weekdays=isArray(this._weekdays)?this._weekdays:this._weekdays[m&&!0!==m&&this._weekdays.isFormat.test(format)?"format":"standalone"];return!0===m?shiftWeekdays(weekdays,this._week.dow):m?weekdays[m.day()]:weekdays}var defaultLocaleWeekdaysShort="Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_");function localeWeekdaysShort(m){return!0===m?shiftWeekdays(this._weekdaysShort,this._week.dow):m?this._weekdaysShort[m.day()]:this._weekdaysShort}var defaultLocaleWeekdaysMin="Su_Mo_Tu_We_Th_Fr_Sa".split("_");function localeWeekdaysMin(m){return!0===m?shiftWeekdays(this._weekdaysMin,this._week.dow):m?this._weekdaysMin[m.day()]:this._weekdaysMin}function handleStrictParse$1(weekdayName,format,strict){var i,ii,mom,llc=weekdayName.toLocaleLowerCase();if(!this._weekdaysParse)for(this._weekdaysParse=[],this._shortWeekdaysParse=[],this._minWeekdaysParse=[],i=0;i<7;++i)mom=createUTC([2e3,1]).day(i),this._minWeekdaysParse[i]=this.weekdaysMin(mom,"").toLocaleLowerCase(),this._shortWeekdaysParse[i]=this.weekdaysShort(mom,"").toLocaleLowerCase(),this._weekdaysParse[i]=this.weekdays(mom,"").toLocaleLowerCase();return strict?"dddd"===format?-1!==(ii=indexOf.call(this._weekdaysParse,llc))?ii:null:"ddd"===format?-1!==(ii=indexOf.call(this._shortWeekdaysParse,llc))?ii:null:-1!==(ii=indexOf.call(this._minWeekdaysParse,llc))?ii:null:"dddd"===format?-1!==(ii=indexOf.call(this._weekdaysParse,llc))||-1!==(ii=indexOf.call(this._shortWeekdaysParse,llc))||-1!==(ii=indexOf.call(this._minWeekdaysParse,llc))?ii:null:"ddd"===format?-1!==(ii=indexOf.call(this._shortWeekdaysParse,llc))||-1!==(ii=indexOf.call(this._weekdaysParse,llc))||-1!==(ii=indexOf.call(this._minWeekdaysParse,llc))?ii:null:-1!==(ii=indexOf.call(this._minWeekdaysParse,llc))||-1!==(ii=indexOf.call(this._weekdaysParse,llc))||-1!==(ii=indexOf.call(this._shortWeekdaysParse,llc))?ii:null}function localeWeekdaysParse(weekdayName,format,strict){var i,mom,regex;if(this._weekdaysParseExact)return handleStrictParse$1.call(this,weekdayName,format,strict);for(this._weekdaysParse||(this._weekdaysParse=[],this._minWeekdaysParse=[],this._shortWeekdaysParse=[],this._fullWeekdaysParse=[]),i=0;i<7;i++){if(mom=createUTC([2e3,1]).day(i),strict&&!this._fullWeekdaysParse[i]&&(this._fullWeekdaysParse[i]=new RegExp("^"+this.weekdays(mom,"").replace(".","\\.?")+"$","i"),this._shortWeekdaysParse[i]=new RegExp("^"+this.weekdaysShort(mom,"").replace(".","\\.?")+"$","i"),this._minWeekdaysParse[i]=new RegExp("^"+this.weekdaysMin(mom,"").replace(".","\\.?")+"$","i")),this._weekdaysParse[i]||(regex="^"+this.weekdays(mom,"")+"|^"+this.weekdaysShort(mom,"")+"|^"+this.weekdaysMin(mom,""),this._weekdaysParse[i]=new RegExp(regex.replace(".",""),"i")),strict&&"dddd"===format&&this._fullWeekdaysParse[i].test(weekdayName))return i;if(strict&&"ddd"===format&&this._shortWeekdaysParse[i].test(weekdayName))return i;if(strict&&"dd"===format&&this._minWeekdaysParse[i].test(weekdayName))return i;if(!strict&&this._weekdaysParse[i].test(weekdayName))return i}}function getSetDayOfWeek(input){if(!this.isValid())return null!=input?this:NaN;var day=this._isUTC?this._d.getUTCDay():this._d.getDay();return null!=input?(input=parseWeekday(input,this.localeData()),this.add(input-day,"d")):day}function getSetLocaleDayOfWeek(input){if(!this.isValid())return null!=input?this:NaN;var weekday=(this.day()+7-this.localeData()._week.dow)%7;return null==input?weekday:this.add(input-weekday,"d")}function getSetISODayOfWeek(input){if(!this.isValid())return null!=input?this:NaN;if(null!=input){var weekday=parseIsoWeekday(input,this.localeData());return this.day(this.day()%7?weekday:weekday-7)}return this.day()||7}var defaultWeekdaysRegex=matchWord;function weekdaysRegex(isStrict){return this._weekdaysParseExact?(hasOwnProp(this,"_weekdaysRegex")||computeWeekdaysParse.call(this),isStrict?this._weekdaysStrictRegex:this._weekdaysRegex):(hasOwnProp(this,"_weekdaysRegex")||(this._weekdaysRegex=defaultWeekdaysRegex),this._weekdaysStrictRegex&&isStrict?this._weekdaysStrictRegex:this._weekdaysRegex)}var defaultWeekdaysShortRegex=matchWord;function weekdaysShortRegex(isStrict){return this._weekdaysParseExact?(hasOwnProp(this,"_weekdaysRegex")||computeWeekdaysParse.call(this),isStrict?this._weekdaysShortStrictRegex:this._weekdaysShortRegex):(hasOwnProp(this,"_weekdaysShortRegex")||(this._weekdaysShortRegex=defaultWeekdaysShortRegex),this._weekdaysShortStrictRegex&&isStrict?this._weekdaysShortStrictRegex:this._weekdaysShortRegex)}var defaultWeekdaysMinRegex=matchWord;function weekdaysMinRegex(isStrict){return this._weekdaysParseExact?(hasOwnProp(this,"_weekdaysRegex")||computeWeekdaysParse.call(this),isStrict?this._weekdaysMinStrictRegex:this._weekdaysMinRegex):(hasOwnProp(this,"_weekdaysMinRegex")||(this._weekdaysMinRegex=defaultWeekdaysMinRegex),this._weekdaysMinStrictRegex&&isStrict?this._weekdaysMinStrictRegex:this._weekdaysMinRegex)}function computeWeekdaysParse(){function cmpLenRev(a,b){return b.length-a.length}var i,mom,minp,shortp,longp,minPieces=[],shortPieces=[],longPieces=[],mixedPieces=[];for(i=0;i<7;i++)mom=createUTC([2e3,1]).day(i),minp=this.weekdaysMin(mom,""),shortp=this.weekdaysShort(mom,""),longp=this.weekdays(mom,""),minPieces.push(minp),shortPieces.push(shortp),longPieces.push(longp),mixedPieces.push(minp),mixedPieces.push(shortp),mixedPieces.push(longp);for(minPieces.sort(cmpLenRev),shortPieces.sort(cmpLenRev),longPieces.sort(cmpLenRev),mixedPieces.sort(cmpLenRev),i=0;i<7;i++)shortPieces[i]=regexEscape(shortPieces[i]),longPieces[i]=regexEscape(longPieces[i]),mixedPieces[i]=regexEscape(mixedPieces[i]);this._weekdaysRegex=new RegExp("^("+mixedPieces.join("|")+")","i"),this._weekdaysShortRegex=this._weekdaysRegex,this._weekdaysMinRegex=this._weekdaysRegex,this._weekdaysStrictRegex=new RegExp("^("+longPieces.join("|")+")","i"),this._weekdaysShortStrictRegex=new RegExp("^("+shortPieces.join("|")+")","i"),this._weekdaysMinStrictRegex=new RegExp("^("+minPieces.join("|")+")","i")}function hFormat(){return this.hours()%12||12}function kFormat(){return this.hours()||24}function meridiem(token,lowercase){addFormatToken(token,0,0,(function(){return this.localeData().meridiem(this.hours(),this.minutes(),lowercase)}))}function matchMeridiem(isStrict,locale){return locale._meridiemParse}function localeIsPM(input){return"p"===(input+"").toLowerCase().charAt(0)}addFormatToken("H",["HH",2],0,"hour"),addFormatToken("h",["hh",2],0,hFormat),addFormatToken("k",["kk",2],0,kFormat),addFormatToken("hmm",0,0,(function(){return""+hFormat.apply(this)+zeroFill(this.minutes(),2)})),addFormatToken("hmmss",0,0,(function(){return""+hFormat.apply(this)+zeroFill(this.minutes(),2)+zeroFill(this.seconds(),2)})),addFormatToken("Hmm",0,0,(function(){return""+this.hours()+zeroFill(this.minutes(),2)})),addFormatToken("Hmmss",0,0,(function(){return""+this.hours()+zeroFill(this.minutes(),2)+zeroFill(this.seconds(),2)})),meridiem("a",!0),meridiem("A",!1),addUnitAlias("hour","h"),addUnitPriority("hour",13),addRegexToken("a",matchMeridiem),addRegexToken("A",matchMeridiem),addRegexToken("H",match1to2),addRegexToken("h",match1to2),addRegexToken("k",match1to2),addRegexToken("HH",match1to2,match2),addRegexToken("hh",match1to2,match2),addRegexToken("kk",match1to2,match2),addRegexToken("hmm",match3to4),addRegexToken("hmmss",match5to6),addRegexToken("Hmm",match3to4),addRegexToken("Hmmss",match5to6),addParseToken(["H","HH"],HOUR),addParseToken(["k","kk"],(function(input,array,config){var kInput=toInt(input);array[HOUR]=24===kInput?0:kInput})),addParseToken(["a","A"],(function(input,array,config){config._isPm=config._locale.isPM(input),config._meridiem=input})),addParseToken(["h","hh"],(function(input,array,config){array[HOUR]=toInt(input),getParsingFlags(config).bigHour=!0})),addParseToken("hmm",(function(input,array,config){var pos=input.length-2;array[HOUR]=toInt(input.substr(0,pos)),array[MINUTE]=toInt(input.substr(pos)),getParsingFlags(config).bigHour=!0})),addParseToken("hmmss",(function(input,array,config){var pos1=input.length-4,pos2=input.length-2;array[HOUR]=toInt(input.substr(0,pos1)),array[MINUTE]=toInt(input.substr(pos1,2)),array[SECOND]=toInt(input.substr(pos2)),getParsingFlags(config).bigHour=!0})),addParseToken("Hmm",(function(input,array,config){var pos=input.length-2;array[HOUR]=toInt(input.substr(0,pos)),array[MINUTE]=toInt(input.substr(pos))})),addParseToken("Hmmss",(function(input,array,config){var pos1=input.length-4,pos2=input.length-2;array[HOUR]=toInt(input.substr(0,pos1)),array[MINUTE]=toInt(input.substr(pos1,2)),array[SECOND]=toInt(input.substr(pos2))}));var defaultLocaleMeridiemParse=/[ap]\.?m?\.?/i;function localeMeridiem(hours,minutes,isLower){return hours>11?isLower?"pm":"PM":isLower?"am":"AM"}var globalLocale,getSetHour=makeGetSet("Hours",!0),baseConfig={calendar:defaultCalendar,longDateFormat:defaultLongDateFormat,invalidDate:defaultInvalidDate,ordinal:defaultOrdinal,dayOfMonthOrdinalParse:defaultDayOfMonthOrdinalParse,relativeTime:defaultRelativeTime,months:defaultLocaleMonths,monthsShort:defaultLocaleMonthsShort,week:defaultLocaleWeek,weekdays:defaultLocaleWeekdays,weekdaysMin:defaultLocaleWeekdaysMin,weekdaysShort:defaultLocaleWeekdaysShort,meridiemParse:defaultLocaleMeridiemParse},locales={},localeFamilies={};function normalizeLocale(key){return key?key.toLowerCase().replace("_","-"):key}function chooseLocale(names){for(var j,next,locale,split,i=0;i<names.length;){for(j=(split=normalizeLocale(names[i]).split("-")).length,next=(next=normalizeLocale(names[i+1]))?next.split("-"):null;j>0;){if(locale=loadLocale(split.slice(0,j).join("-")))return locale;if(next&&next.length>=j&&compareArrays(split,next,!0)>=j-1)break;j--}i++}return globalLocale}function loadLocale(name){var oldLocale=null;if(!locales[name]&&module&&module.exports)try{oldLocale=globalLocale._abbr,commonjsRequire(),getSetGlobalLocale(oldLocale)}catch(e){}return locales[name]}function getSetGlobalLocale(key,values){var data;return key&&((data=isUndefined(values)?getLocale(key):defineLocale(key,values))?globalLocale=data:"undefined"!=typeof console&&console.warn&&console.warn("Locale "+key+" not found. Did you forget to load it?")),globalLocale._abbr}function defineLocale(name,config){if(null!==config){var locale,parentConfig=baseConfig;if(config.abbr=name,null!=locales[name])deprecateSimple("defineLocaleOverride","use moment.updateLocale(localeName, config) to change an existing locale. moment.defineLocale(localeName, config) should only be used for creating a new locale See http://momentjs.com/guides/#/warnings/define-locale/ for more info."),parentConfig=locales[name]._config;else if(null!=config.parentLocale)if(null!=locales[config.parentLocale])parentConfig=locales[config.parentLocale]._config;else{if(null==(locale=loadLocale(config.parentLocale)))return localeFamilies[config.parentLocale]||(localeFamilies[config.parentLocale]=[]),localeFamilies[config.parentLocale].push({name:name,config:config}),null;parentConfig=locale._config}return locales[name]=new Locale(mergeConfigs(parentConfig,config)),localeFamilies[name]&&localeFamilies[name].forEach((function(x){defineLocale(x.name,x.config)})),getSetGlobalLocale(name),locales[name]}return delete locales[name],null}function updateLocale(name,config){if(null!=config){var locale,tmpLocale,parentConfig=baseConfig;null!=(tmpLocale=loadLocale(name))&&(parentConfig=tmpLocale._config),(locale=new Locale(config=mergeConfigs(parentConfig,config))).parentLocale=locales[name],locales[name]=locale,getSetGlobalLocale(name)}else null!=locales[name]&&(null!=locales[name].parentLocale?locales[name]=locales[name].parentLocale:null!=locales[name]&&delete locales[name]);return locales[name]}function getLocale(key){var locale;if(key&&key._locale&&key._locale._abbr&&(key=key._locale._abbr),!key)return globalLocale;if(!isArray(key)){if(locale=loadLocale(key))return locale;key=[key]}return chooseLocale(key)}function listLocales(){return keys(locales)}function checkOverflow(m){var overflow,a=m._a;return a&&-2===getParsingFlags(m).overflow&&(overflow=a[MONTH]<0||a[MONTH]>11?MONTH:a[DATE]<1||a[DATE]>daysInMonth(a[YEAR],a[MONTH])?DATE:a[HOUR]<0||a[HOUR]>24||24===a[HOUR]&&(0!==a[MINUTE]||0!==a[SECOND]||0!==a[MILLISECOND])?HOUR:a[MINUTE]<0||a[MINUTE]>59?MINUTE:a[SECOND]<0||a[SECOND]>59?SECOND:a[MILLISECOND]<0||a[MILLISECOND]>999?MILLISECOND:-1,getParsingFlags(m)._overflowDayOfYear&&(overflow<YEAR||overflow>DATE)&&(overflow=DATE),getParsingFlags(m)._overflowWeeks&&-1===overflow&&(overflow=WEEK),getParsingFlags(m)._overflowWeekday&&-1===overflow&&(overflow=WEEKDAY),getParsingFlags(m).overflow=overflow),m}function defaults(a,b,c){return null!=a?a:null!=b?b:c}function currentDateArray(config){var nowValue=new Date(hooks.now());return config._useUTC?[nowValue.getUTCFullYear(),nowValue.getUTCMonth(),nowValue.getUTCDate()]:[nowValue.getFullYear(),nowValue.getMonth(),nowValue.getDate()]}function configFromArray(config){var i,date,currentDate,expectedWeekday,yearToUse,input=[];if(!config._d){for(currentDate=currentDateArray(config),config._w&&null==config._a[DATE]&&null==config._a[MONTH]&&dayOfYearFromWeekInfo(config),null!=config._dayOfYear&&(yearToUse=defaults(config._a[YEAR],currentDate[YEAR]),(config._dayOfYear>daysInYear(yearToUse)||0===config._dayOfYear)&&(getParsingFlags(config)._overflowDayOfYear=!0),date=createUTCDate(yearToUse,0,config._dayOfYear),config._a[MONTH]=date.getUTCMonth(),config._a[DATE]=date.getUTCDate()),i=0;i<3&&null==config._a[i];++i)config._a[i]=input[i]=currentDate[i];for(;i<7;i++)config._a[i]=input[i]=null==config._a[i]?2===i?1:0:config._a[i];24===config._a[HOUR]&&0===config._a[MINUTE]&&0===config._a[SECOND]&&0===config._a[MILLISECOND]&&(config._nextDay=!0,config._a[HOUR]=0),config._d=(config._useUTC?createUTCDate:createDate).apply(null,input),expectedWeekday=config._useUTC?config._d.getUTCDay():config._d.getDay(),null!=config._tzm&&config._d.setUTCMinutes(config._d.getUTCMinutes()-config._tzm),config._nextDay&&(config._a[HOUR]=24),config._w&&void 0!==config._w.d&&config._w.d!==expectedWeekday&&(getParsingFlags(config).weekdayMismatch=!0)}}function dayOfYearFromWeekInfo(config){var w,weekYear,week,weekday,dow,doy,temp,weekdayOverflow;if(null!=(w=config._w).GG||null!=w.W||null!=w.E)dow=1,doy=4,weekYear=defaults(w.GG,config._a[YEAR],weekOfYear(createLocal(),1,4).year),week=defaults(w.W,1),((weekday=defaults(w.E,1))<1||weekday>7)&&(weekdayOverflow=!0);else{dow=config._locale._week.dow,doy=config._locale._week.doy;var curWeek=weekOfYear(createLocal(),dow,doy);weekYear=defaults(w.gg,config._a[YEAR],curWeek.year),week=defaults(w.w,curWeek.week),null!=w.d?((weekday=w.d)<0||weekday>6)&&(weekdayOverflow=!0):null!=w.e?(weekday=w.e+dow,(w.e<0||w.e>6)&&(weekdayOverflow=!0)):weekday=dow}week<1||week>weeksInYear(weekYear,dow,doy)?getParsingFlags(config)._overflowWeeks=!0:null!=weekdayOverflow?getParsingFlags(config)._overflowWeekday=!0:(temp=dayOfYearFromWeeks(weekYear,week,weekday,dow,doy),config._a[YEAR]=temp.year,config._dayOfYear=temp.dayOfYear)}var extendedIsoRegex=/^\s*((?:[+-]\d{6}|\d{4})-(?:\d\d-\d\d|W\d\d-\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?::\d\d(?::\d\d(?:[.,]\d+)?)?)?)([\+\-]\d\d(?::?\d\d)?|\s*Z)?)?$/,basicIsoRegex=/^\s*((?:[+-]\d{6}|\d{4})(?:\d\d\d\d|W\d\d\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?:\d\d(?:\d\d(?:[.,]\d+)?)?)?)([\+\-]\d\d(?::?\d\d)?|\s*Z)?)?$/,tzRegex=/Z|[+-]\d\d(?::?\d\d)?/,isoDates=[["YYYYYY-MM-DD",/[+-]\d{6}-\d\d-\d\d/],["YYYY-MM-DD",/\d{4}-\d\d-\d\d/],["GGGG-[W]WW-E",/\d{4}-W\d\d-\d/],["GGGG-[W]WW",/\d{4}-W\d\d/,!1],["YYYY-DDD",/\d{4}-\d{3}/],["YYYY-MM",/\d{4}-\d\d/,!1],["YYYYYYMMDD",/[+-]\d{10}/],["YYYYMMDD",/\d{8}/],["GGGG[W]WWE",/\d{4}W\d{3}/],["GGGG[W]WW",/\d{4}W\d{2}/,!1],["YYYYDDD",/\d{7}/]],isoTimes=[["HH:mm:ss.SSSS",/\d\d:\d\d:\d\d\.\d+/],["HH:mm:ss,SSSS",/\d\d:\d\d:\d\d,\d+/],["HH:mm:ss",/\d\d:\d\d:\d\d/],["HH:mm",/\d\d:\d\d/],["HHmmss.SSSS",/\d\d\d\d\d\d\.\d+/],["HHmmss,SSSS",/\d\d\d\d\d\d,\d+/],["HHmmss",/\d\d\d\d\d\d/],["HHmm",/\d\d\d\d/],["HH",/\d\d/]],aspNetJsonRegex=/^\/?Date\((\-?\d+)/i;function configFromISO(config){var i,l,allowTime,dateFormat,timeFormat,tzFormat,string=config._i,match=extendedIsoRegex.exec(string)||basicIsoRegex.exec(string);if(match){for(getParsingFlags(config).iso=!0,i=0,l=isoDates.length;i<l;i++)if(isoDates[i][1].exec(match[1])){dateFormat=isoDates[i][0],allowTime=!1!==isoDates[i][2];break}if(null==dateFormat)return void(config._isValid=!1);if(match[3]){for(i=0,l=isoTimes.length;i<l;i++)if(isoTimes[i][1].exec(match[3])){timeFormat=(match[2]||" ")+isoTimes[i][0];break}if(null==timeFormat)return void(config._isValid=!1)}if(!allowTime&&null!=timeFormat)return void(config._isValid=!1);if(match[4]){if(!tzRegex.exec(match[4]))return void(config._isValid=!1);tzFormat="Z"}config._f=dateFormat+(timeFormat||"")+(tzFormat||""),configFromStringAndFormat(config)}else config._isValid=!1}var rfc2822=/^(?:(Mon|Tue|Wed|Thu|Fri|Sat|Sun),?\s)?(\d{1,2})\s(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\s(\d{2,4})\s(\d\d):(\d\d)(?::(\d\d))?\s(?:(UT|GMT|[ECMP][SD]T)|([Zz])|([+-]\d{4}))$/;function extractFromRFC2822Strings(yearStr,monthStr,dayStr,hourStr,minuteStr,secondStr){var result=[untruncateYear(yearStr),defaultLocaleMonthsShort.indexOf(monthStr),parseInt(dayStr,10),parseInt(hourStr,10),parseInt(minuteStr,10)];return secondStr&&result.push(parseInt(secondStr,10)),result}function untruncateYear(yearStr){var year=parseInt(yearStr,10);return year<=49?2e3+year:year<=999?1900+year:year}function preprocessRFC2822(s){return s.replace(/\([^)]*\)|[\n\t]/g," ").replace(/(\s\s+)/g," ").replace(/^\s\s*/,"").replace(/\s\s*$/,"")}function checkWeekday(weekdayStr,parsedInput,config){return!weekdayStr||defaultLocaleWeekdaysShort.indexOf(weekdayStr)===new Date(parsedInput[0],parsedInput[1],parsedInput[2]).getDay()||(getParsingFlags(config).weekdayMismatch=!0,config._isValid=!1,!1)}var obsOffsets={UT:0,GMT:0,EDT:-240,EST:-300,CDT:-300,CST:-360,MDT:-360,MST:-420,PDT:-420,PST:-480};function calculateOffset(obsOffset,militaryOffset,numOffset){if(obsOffset)return obsOffsets[obsOffset];if(militaryOffset)return 0;var hm=parseInt(numOffset,10),m=hm%100;return(hm-m)/100*60+m}function configFromRFC2822(config){var match=rfc2822.exec(preprocessRFC2822(config._i));if(match){var parsedArray=extractFromRFC2822Strings(match[4],match[3],match[2],match[5],match[6],match[7]);if(!checkWeekday(match[1],parsedArray,config))return;config._a=parsedArray,config._tzm=calculateOffset(match[8],match[9],match[10]),config._d=createUTCDate.apply(null,config._a),config._d.setUTCMinutes(config._d.getUTCMinutes()-config._tzm),getParsingFlags(config).rfc2822=!0}else config._isValid=!1}function configFromString(config){var matched=aspNetJsonRegex.exec(config._i);null===matched?(configFromISO(config),!1===config._isValid&&(delete config._isValid,configFromRFC2822(config),!1===config._isValid&&(delete config._isValid,hooks.createFromInputFallback(config)))):config._d=new Date(+matched[1])}function configFromStringAndFormat(config){if(config._f!==hooks.ISO_8601)if(config._f!==hooks.RFC_2822){config._a=[],getParsingFlags(config).empty=!0;var i,parsedInput,tokens,token,skipped,string=""+config._i,stringLength=string.length,totalParsedInputLength=0;for(tokens=expandFormat(config._f,config._locale).match(formattingTokens)||[],i=0;i<tokens.length;i++)token=tokens[i],(parsedInput=(string.match(getParseRegexForToken(token,config))||[])[0])&&((skipped=string.substr(0,string.indexOf(parsedInput))).length>0&&getParsingFlags(config).unusedInput.push(skipped),string=string.slice(string.indexOf(parsedInput)+parsedInput.length),totalParsedInputLength+=parsedInput.length),formatTokenFunctions[token]?(parsedInput?getParsingFlags(config).empty=!1:getParsingFlags(config).unusedTokens.push(token),addTimeToArrayFromToken(token,parsedInput,config)):config._strict&&!parsedInput&&getParsingFlags(config).unusedTokens.push(token);getParsingFlags(config).charsLeftOver=stringLength-totalParsedInputLength,string.length>0&&getParsingFlags(config).unusedInput.push(string),config._a[HOUR]<=12&&!0===getParsingFlags(config).bigHour&&config._a[HOUR]>0&&(getParsingFlags(config).bigHour=void 0),getParsingFlags(config).parsedDateParts=config._a.slice(0),getParsingFlags(config).meridiem=config._meridiem,config._a[HOUR]=meridiemFixWrap(config._locale,config._a[HOUR],config._meridiem),configFromArray(config),checkOverflow(config)}else configFromRFC2822(config);else configFromISO(config)}function meridiemFixWrap(locale,hour,meridiem){var isPm;return null==meridiem?hour:null!=locale.meridiemHour?locale.meridiemHour(hour,meridiem):null!=locale.isPM?((isPm=locale.isPM(meridiem))&&hour<12&&(hour+=12),isPm||12!==hour||(hour=0),hour):hour}function configFromStringAndArray(config){var tempConfig,bestMoment,scoreToBeat,i,currentScore;if(0===config._f.length)return getParsingFlags(config).invalidFormat=!0,void(config._d=new Date(NaN));for(i=0;i<config._f.length;i++)currentScore=0,tempConfig=copyConfig({},config),null!=config._useUTC&&(tempConfig._useUTC=config._useUTC),tempConfig._f=config._f[i],configFromStringAndFormat(tempConfig),isValid(tempConfig)&&(currentScore+=getParsingFlags(tempConfig).charsLeftOver,currentScore+=10*getParsingFlags(tempConfig).unusedTokens.length,getParsingFlags(tempConfig).score=currentScore,(null==scoreToBeat||currentScore<scoreToBeat)&&(scoreToBeat=currentScore,bestMoment=tempConfig));extend(config,bestMoment||tempConfig)}function configFromObject(config){if(!config._d){var i=normalizeObjectUnits(config._i);config._a=map([i.year,i.month,i.day||i.date,i.hour,i.minute,i.second,i.millisecond],(function(obj){return obj&&parseInt(obj,10)})),configFromArray(config)}}function createFromConfig(config){var res=new Moment(checkOverflow(prepareConfig(config)));return res._nextDay&&(res.add(1,"d"),res._nextDay=void 0),res}function prepareConfig(config){var input=config._i,format=config._f;return config._locale=config._locale||getLocale(config._l),null===input||void 0===format&&""===input?createInvalid({nullInput:!0}):("string"==typeof input&&(config._i=input=config._locale.preparse(input)),isMoment(input)?new Moment(checkOverflow(input)):(isDate(input)?config._d=input:isArray(format)?configFromStringAndArray(config):format?configFromStringAndFormat(config):configFromInput(config),isValid(config)||(config._d=null),config))}function configFromInput(config){var input=config._i;isUndefined(input)?config._d=new Date(hooks.now()):isDate(input)?config._d=new Date(input.valueOf()):"string"==typeof input?configFromString(config):isArray(input)?(config._a=map(input.slice(0),(function(obj){return parseInt(obj,10)})),configFromArray(config)):isObject(input)?configFromObject(config):isNumber(input)?config._d=new Date(input):hooks.createFromInputFallback(config)}function createLocalOrUTC(input,format,locale,strict,isUTC){var c={};return!0!==locale&&!1!==locale||(strict=locale,locale=void 0),(isObject(input)&&isObjectEmpty(input)||isArray(input)&&0===input.length)&&(input=void 0),c._isAMomentObject=!0,c._useUTC=c._isUTC=isUTC,c._l=locale,c._i=input,c._f=format,c._strict=strict,createFromConfig(c)}function createLocal(input,format,locale,strict){return createLocalOrUTC(input,format,locale,strict,!1)}hooks.createFromInputFallback=deprecate("value provided is not in a recognized RFC2822 or ISO format. moment construction falls back to js Date(), which is not reliable across all browsers and versions. Non RFC2822/ISO date formats are discouraged and will be removed in an upcoming major release. Please refer to http://momentjs.com/guides/#/warnings/js-date/ for more info.",(function(config){config._d=new Date(config._i+(config._useUTC?" UTC":""))})),hooks.ISO_8601=function(){},hooks.RFC_2822=function(){};var prototypeMin=deprecate("moment().min is deprecated, use moment.max instead. http://momentjs.com/guides/#/warnings/min-max/",(function(){var other=createLocal.apply(null,arguments);return this.isValid()&&other.isValid()?other<this?this:other:createInvalid()})),prototypeMax=deprecate("moment().max is deprecated, use moment.min instead. http://momentjs.com/guides/#/warnings/min-max/",(function(){var other=createLocal.apply(null,arguments);return this.isValid()&&other.isValid()?other>this?this:other:createInvalid()}));function pickBy(fn,moments){var res,i;if(1===moments.length&&isArray(moments[0])&&(moments=moments[0]),!moments.length)return createLocal();for(res=moments[0],i=1;i<moments.length;++i)moments[i].isValid()&&!moments[i][fn](res)||(res=moments[i]);return res}function min(){return pickBy("isBefore",[].slice.call(arguments,0))}function max(){return pickBy("isAfter",[].slice.call(arguments,0))}var now=function(){return Date.now?Date.now():+new Date},ordering=["year","quarter","month","week","day","hour","minute","second","millisecond"];function isDurationValid(m){for(var key in m)if(-1===indexOf.call(ordering,key)||null!=m[key]&&isNaN(m[key]))return!1;for(var unitHasDecimal=!1,i=0;i<ordering.length;++i)if(m[ordering[i]]){if(unitHasDecimal)return!1;parseFloat(m[ordering[i]])!==toInt(m[ordering[i]])&&(unitHasDecimal=!0)}return!0}function isValid$1(){return this._isValid}function createInvalid$1(){return createDuration(NaN)}function Duration(duration){var normalizedInput=normalizeObjectUnits(duration),years=normalizedInput.year||0,quarters=normalizedInput.quarter||0,months=normalizedInput.month||0,weeks=normalizedInput.week||normalizedInput.isoWeek||0,days=normalizedInput.day||0,hours=normalizedInput.hour||0,minutes=normalizedInput.minute||0,seconds=normalizedInput.second||0,milliseconds=normalizedInput.millisecond||0;this._isValid=isDurationValid(normalizedInput),this._milliseconds=+milliseconds+1e3*seconds+6e4*minutes+1e3*hours*60*60,this._days=+days+7*weeks,this._months=+months+3*quarters+12*years,this._data={},this._locale=getLocale(),this._bubble()}function isDuration(obj){return obj instanceof Duration}function absRound(number){return number<0?-1*Math.round(-1*number):Math.round(number)}function offset(token,separator){addFormatToken(token,0,0,(function(){var offset=this.utcOffset(),sign="+";return offset<0&&(offset=-offset,sign="-"),sign+zeroFill(~~(offset/60),2)+separator+zeroFill(~~offset%60,2)}))}offset("Z",":"),offset("ZZ",""),addRegexToken("Z",matchShortOffset),addRegexToken("ZZ",matchShortOffset),addParseToken(["Z","ZZ"],(function(input,array,config){config._useUTC=!0,config._tzm=offsetFromString(matchShortOffset,input)}));var chunkOffset=/([\+\-]|\d\d)/gi;function offsetFromString(matcher,string){var matches=(string||"").match(matcher);if(null===matches)return null;var parts=((matches[matches.length-1]||[])+"").match(chunkOffset)||["-",0,0],minutes=60*parts[1]+toInt(parts[2]);return 0===minutes?0:"+"===parts[0]?minutes:-minutes}function cloneWithOffset(input,model){var res,diff;return model._isUTC?(res=model.clone(),diff=(isMoment(input)||isDate(input)?input.valueOf():createLocal(input).valueOf())-res.valueOf(),res._d.setTime(res._d.valueOf()+diff),hooks.updateOffset(res,!1),res):createLocal(input).local()}function getDateOffset(m){return 15*-Math.round(m._d.getTimezoneOffset()/15)}function getSetOffset(input,keepLocalTime,keepMinutes){var localAdjust,offset=this._offset||0;if(!this.isValid())return null!=input?this:NaN;if(null!=input){if("string"==typeof input){if(null===(input=offsetFromString(matchShortOffset,input)))return this}else Math.abs(input)<16&&!keepMinutes&&(input*=60);return!this._isUTC&&keepLocalTime&&(localAdjust=getDateOffset(this)),this._offset=input,this._isUTC=!0,null!=localAdjust&&this.add(localAdjust,"m"),offset!==input&&(!keepLocalTime||this._changeInProgress?addSubtract(this,createDuration(input-offset,"m"),1,!1):this._changeInProgress||(this._changeInProgress=!0,hooks.updateOffset(this,!0),this._changeInProgress=null)),this}return this._isUTC?offset:getDateOffset(this)}function getSetZone(input,keepLocalTime){return null!=input?("string"!=typeof input&&(input=-input),this.utcOffset(input,keepLocalTime),this):-this.utcOffset()}function setOffsetToUTC(keepLocalTime){return this.utcOffset(0,keepLocalTime)}function setOffsetToLocal(keepLocalTime){return this._isUTC&&(this.utcOffset(0,keepLocalTime),this._isUTC=!1,keepLocalTime&&this.subtract(getDateOffset(this),"m")),this}function setOffsetToParsedOffset(){if(null!=this._tzm)this.utcOffset(this._tzm,!1,!0);else if("string"==typeof this._i){var tZone=offsetFromString(matchOffset,this._i);null!=tZone?this.utcOffset(tZone):this.utcOffset(0,!0)}return this}function hasAlignedHourOffset(input){return!!this.isValid()&&(input=input?createLocal(input).utcOffset():0,(this.utcOffset()-input)%60==0)}function isDaylightSavingTime(){return this.utcOffset()>this.clone().month(0).utcOffset()||this.utcOffset()>this.clone().month(5).utcOffset()}function isDaylightSavingTimeShifted(){if(!isUndefined(this._isDSTShifted))return this._isDSTShifted;var c={};if(copyConfig(c,this),(c=prepareConfig(c))._a){var other=c._isUTC?createUTC(c._a):createLocal(c._a);this._isDSTShifted=this.isValid()&&compareArrays(c._a,other.toArray())>0}else this._isDSTShifted=!1;return this._isDSTShifted}function isLocal(){return!!this.isValid()&&!this._isUTC}function isUtcOffset(){return!!this.isValid()&&this._isUTC}function isUtc(){return!!this.isValid()&&this._isUTC&&0===this._offset}hooks.updateOffset=function(){};var aspNetRegex=/^(\-|\+)?(?:(\d*)[. ])?(\d+)\:(\d+)(?:\:(\d+)(\.\d*)?)?$/,isoRegex=/^(-|\+)?P(?:([-+]?[0-9,.]*)Y)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)W)?(?:([-+]?[0-9,.]*)D)?(?:T(?:([-+]?[0-9,.]*)H)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)S)?)?$/;function createDuration(input,key){var sign,ret,diffRes,duration=input,match=null;return isDuration(input)?duration={ms:input._milliseconds,d:input._days,M:input._months}:isNumber(input)?(duration={},key?duration[key]=input:duration.milliseconds=input):(match=aspNetRegex.exec(input))?(sign="-"===match[1]?-1:1,duration={y:0,d:toInt(match[DATE])*sign,h:toInt(match[HOUR])*sign,m:toInt(match[MINUTE])*sign,s:toInt(match[SECOND])*sign,ms:toInt(absRound(1e3*match[MILLISECOND]))*sign}):(match=isoRegex.exec(input))?(sign="-"===match[1]?-1:1,duration={y:parseIso(match[2],sign),M:parseIso(match[3],sign),w:parseIso(match[4],sign),d:parseIso(match[5],sign),h:parseIso(match[6],sign),m:parseIso(match[7],sign),s:parseIso(match[8],sign)}):null==duration?duration={}:"object"==typeof duration&&("from"in duration||"to"in duration)&&(diffRes=momentsDifference(createLocal(duration.from),createLocal(duration.to)),(duration={}).ms=diffRes.milliseconds,duration.M=diffRes.months),ret=new Duration(duration),isDuration(input)&&hasOwnProp(input,"_locale")&&(ret._locale=input._locale),ret}function parseIso(inp,sign){var res=inp&&parseFloat(inp.replace(",","."));return(isNaN(res)?0:res)*sign}function positiveMomentsDifference(base,other){var res={};return res.months=other.month()-base.month()+12*(other.year()-base.year()),base.clone().add(res.months,"M").isAfter(other)&&--res.months,res.milliseconds=+other-+base.clone().add(res.months,"M"),res}function momentsDifference(base,other){var res;return base.isValid()&&other.isValid()?(other=cloneWithOffset(other,base),base.isBefore(other)?res=positiveMomentsDifference(base,other):((res=positiveMomentsDifference(other,base)).milliseconds=-res.milliseconds,res.months=-res.months),res):{milliseconds:0,months:0}}function createAdder(direction,name){return function(val,period){var tmp;return null===period||isNaN(+period)||(deprecateSimple(name,"moment()."+name+"(period, number) is deprecated. Please use moment()."+name+"(number, period). See http://momentjs.com/guides/#/warnings/add-inverted-param/ for more info."),tmp=val,val=period,period=tmp),addSubtract(this,createDuration(val="string"==typeof val?+val:val,period),direction),this}}function addSubtract(mom,duration,isAdding,updateOffset){var milliseconds=duration._milliseconds,days=absRound(duration._days),months=absRound(duration._months);mom.isValid()&&(updateOffset=null==updateOffset||updateOffset,months&&setMonth(mom,get(mom,"Month")+months*isAdding),days&&set$1(mom,"Date",get(mom,"Date")+days*isAdding),milliseconds&&mom._d.setTime(mom._d.valueOf()+milliseconds*isAdding),updateOffset&&hooks.updateOffset(mom,days||months))}createDuration.fn=Duration.prototype,createDuration.invalid=createInvalid$1;var add=createAdder(1,"add"),subtract=createAdder(-1,"subtract");function getCalendarFormat(myMoment,now){var diff=myMoment.diff(now,"days",!0);return diff<-6?"sameElse":diff<-1?"lastWeek":diff<0?"lastDay":diff<1?"sameDay":diff<2?"nextDay":diff<7?"nextWeek":"sameElse"}function calendar$1(time,formats){var now=time||createLocal(),sod=cloneWithOffset(now,this).startOf("day"),format=hooks.calendarFormat(this,sod)||"sameElse",output=formats&&(isFunction(formats[format])?formats[format].call(this,now):formats[format]);return this.format(output||this.localeData().calendar(format,this,createLocal(now)))}function clone(){return new Moment(this)}function isAfter(input,units){var localInput=isMoment(input)?input:createLocal(input);return!(!this.isValid()||!localInput.isValid())&&("millisecond"===(units=normalizeUnits(units)||"millisecond")?this.valueOf()>localInput.valueOf():localInput.valueOf()<this.clone().startOf(units).valueOf())}function isBefore(input,units){var localInput=isMoment(input)?input:createLocal(input);return!(!this.isValid()||!localInput.isValid())&&("millisecond"===(units=normalizeUnits(units)||"millisecond")?this.valueOf()<localInput.valueOf():this.clone().endOf(units).valueOf()<localInput.valueOf())}function isBetween(from,to,units,inclusivity){var localFrom=isMoment(from)?from:createLocal(from),localTo=isMoment(to)?to:createLocal(to);return!!(this.isValid()&&localFrom.isValid()&&localTo.isValid())&&("("===(inclusivity=inclusivity||"()")[0]?this.isAfter(localFrom,units):!this.isBefore(localFrom,units))&&(")"===inclusivity[1]?this.isBefore(localTo,units):!this.isAfter(localTo,units))}function isSame(input,units){var inputMs,localInput=isMoment(input)?input:createLocal(input);return!(!this.isValid()||!localInput.isValid())&&("millisecond"===(units=normalizeUnits(units)||"millisecond")?this.valueOf()===localInput.valueOf():(inputMs=localInput.valueOf(),this.clone().startOf(units).valueOf()<=inputMs&&inputMs<=this.clone().endOf(units).valueOf()))}function isSameOrAfter(input,units){return this.isSame(input,units)||this.isAfter(input,units)}function isSameOrBefore(input,units){return this.isSame(input,units)||this.isBefore(input,units)}function diff(input,units,asFloat){var that,zoneDelta,output;if(!this.isValid())return NaN;if(!(that=cloneWithOffset(input,this)).isValid())return NaN;switch(zoneDelta=6e4*(that.utcOffset()-this.utcOffset()),units=normalizeUnits(units)){case"year":output=monthDiff(this,that)/12;break;case"month":output=monthDiff(this,that);break;case"quarter":output=monthDiff(this,that)/3;break;case"second":output=(this-that)/1e3;break;case"minute":output=(this-that)/6e4;break;case"hour":output=(this-that)/36e5;break;case"day":output=(this-that-zoneDelta)/864e5;break;case"week":output=(this-that-zoneDelta)/6048e5;break;default:output=this-that}return asFloat?output:absFloor(output)}function monthDiff(a,b){var wholeMonthDiff=12*(b.year()-a.year())+(b.month()-a.month()),anchor=a.clone().add(wholeMonthDiff,"months");return-(wholeMonthDiff+(b-anchor<0?(b-anchor)/(anchor-a.clone().add(wholeMonthDiff-1,"months")):(b-anchor)/(a.clone().add(wholeMonthDiff+1,"months")-anchor)))||0}function toString(){return this.clone().locale("en").format("ddd MMM DD YYYY HH:mm:ss [GMT]ZZ")}function toISOString(keepOffset){if(!this.isValid())return null;var utc=!0!==keepOffset,m=utc?this.clone().utc():this;return m.year()<0||m.year()>9999?formatMoment(m,utc?"YYYYYY-MM-DD[T]HH:mm:ss.SSS[Z]":"YYYYYY-MM-DD[T]HH:mm:ss.SSSZ"):isFunction(Date.prototype.toISOString)?utc?this.toDate().toISOString():new Date(this.valueOf()+60*this.utcOffset()*1e3).toISOString().replace("Z",formatMoment(m,"Z")):formatMoment(m,utc?"YYYY-MM-DD[T]HH:mm:ss.SSS[Z]":"YYYY-MM-DD[T]HH:mm:ss.SSSZ")}function inspect(){if(!this.isValid())return"moment.invalid(/* "+this._i+" */)";var func="moment",zone="";this.isLocal()||(func=0===this.utcOffset()?"moment.utc":"moment.parseZone",zone="Z");var prefix="["+func+'("]',year=0<=this.year()&&this.year()<=9999?"YYYY":"YYYYYY",datetime="-MM-DD[T]HH:mm:ss.SSS",suffix=zone+'[")]';return this.format(prefix+year+datetime+suffix)}function format(inputString){inputString||(inputString=this.isUtc()?hooks.defaultFormatUtc:hooks.defaultFormat);var output=formatMoment(this,inputString);return this.localeData().postformat(output)}function from(time,withoutSuffix){return this.isValid()&&(isMoment(time)&&time.isValid()||createLocal(time).isValid())?createDuration({to:this,from:time}).locale(this.locale()).humanize(!withoutSuffix):this.localeData().invalidDate()}function fromNow(withoutSuffix){return this.from(createLocal(),withoutSuffix)}function to(time,withoutSuffix){return this.isValid()&&(isMoment(time)&&time.isValid()||createLocal(time).isValid())?createDuration({from:this,to:time}).locale(this.locale()).humanize(!withoutSuffix):this.localeData().invalidDate()}function toNow(withoutSuffix){return this.to(createLocal(),withoutSuffix)}function locale(key){var newLocaleData;return void 0===key?this._locale._abbr:(null!=(newLocaleData=getLocale(key))&&(this._locale=newLocaleData),this)}hooks.defaultFormat="YYYY-MM-DDTHH:mm:ssZ",hooks.defaultFormatUtc="YYYY-MM-DDTHH:mm:ss[Z]";var lang=deprecate("moment().lang() is deprecated. Instead, use moment().localeData() to get the language configuration. Use moment().locale() to change languages.",(function(key){return void 0===key?this.localeData():this.locale(key)}));function localeData(){return this._locale}var MS_PER_SECOND=1e3,MS_PER_MINUTE=60*MS_PER_SECOND,MS_PER_HOUR=60*MS_PER_MINUTE,MS_PER_400_YEARS=3506328*MS_PER_HOUR;function mod$1(dividend,divisor){return(dividend%divisor+divisor)%divisor}function localStartOfDate(y,m,d){return y<100&&y>=0?new Date(y+400,m,d)-MS_PER_400_YEARS:new Date(y,m,d).valueOf()}function utcStartOfDate(y,m,d){return y<100&&y>=0?Date.UTC(y+400,m,d)-MS_PER_400_YEARS:Date.UTC(y,m,d)}function startOf(units){var time;if(void 0===(units=normalizeUnits(units))||"millisecond"===units||!this.isValid())return this;var startOfDate=this._isUTC?utcStartOfDate:localStartOfDate;switch(units){case"year":time=startOfDate(this.year(),0,1);break;case"quarter":time=startOfDate(this.year(),this.month()-this.month()%3,1);break;case"month":time=startOfDate(this.year(),this.month(),1);break;case"week":time=startOfDate(this.year(),this.month(),this.date()-this.weekday());break;case"isoWeek":time=startOfDate(this.year(),this.month(),this.date()-(this.isoWeekday()-1));break;case"day":case"date":time=startOfDate(this.year(),this.month(),this.date());break;case"hour":time=this._d.valueOf(),time-=mod$1(time+(this._isUTC?0:this.utcOffset()*MS_PER_MINUTE),MS_PER_HOUR);break;case"minute":time=this._d.valueOf(),time-=mod$1(time,MS_PER_MINUTE);break;case"second":time=this._d.valueOf(),time-=mod$1(time,MS_PER_SECOND)}return this._d.setTime(time),hooks.updateOffset(this,!0),this}function endOf(units){var time;if(void 0===(units=normalizeUnits(units))||"millisecond"===units||!this.isValid())return this;var startOfDate=this._isUTC?utcStartOfDate:localStartOfDate;switch(units){case"year":time=startOfDate(this.year()+1,0,1)-1;break;case"quarter":time=startOfDate(this.year(),this.month()-this.month()%3+3,1)-1;break;case"month":time=startOfDate(this.year(),this.month()+1,1)-1;break;case"week":time=startOfDate(this.year(),this.month(),this.date()-this.weekday()+7)-1;break;case"isoWeek":time=startOfDate(this.year(),this.month(),this.date()-(this.isoWeekday()-1)+7)-1;break;case"day":case"date":time=startOfDate(this.year(),this.month(),this.date()+1)-1;break;case"hour":time=this._d.valueOf(),time+=MS_PER_HOUR-mod$1(time+(this._isUTC?0:this.utcOffset()*MS_PER_MINUTE),MS_PER_HOUR)-1;break;case"minute":time=this._d.valueOf(),time+=MS_PER_MINUTE-mod$1(time,MS_PER_MINUTE)-1;break;case"second":time=this._d.valueOf(),time+=MS_PER_SECOND-mod$1(time,MS_PER_SECOND)-1}return this._d.setTime(time),hooks.updateOffset(this,!0),this}function valueOf(){return this._d.valueOf()-6e4*(this._offset||0)}function unix(){return Math.floor(this.valueOf()/1e3)}function toDate(){return new Date(this.valueOf())}function toArray(){var m=this;return[m.year(),m.month(),m.date(),m.hour(),m.minute(),m.second(),m.millisecond()]}function toObject(){var m=this;return{years:m.year(),months:m.month(),date:m.date(),hours:m.hours(),minutes:m.minutes(),seconds:m.seconds(),milliseconds:m.milliseconds()}}function toJSON(){return this.isValid()?this.toISOString():null}function isValid$2(){return isValid(this)}function parsingFlags(){return extend({},getParsingFlags(this))}function invalidAt(){return getParsingFlags(this).overflow}function creationData(){return{input:this._i,format:this._f,locale:this._locale,isUTC:this._isUTC,strict:this._strict}}function addWeekYearFormatToken(token,getter){addFormatToken(0,[token,token.length],0,getter)}function getSetWeekYear(input){return getSetWeekYearHelper.call(this,input,this.week(),this.weekday(),this.localeData()._week.dow,this.localeData()._week.doy)}function getSetISOWeekYear(input){return getSetWeekYearHelper.call(this,input,this.isoWeek(),this.isoWeekday(),1,4)}function getISOWeeksInYear(){return weeksInYear(this.year(),1,4)}function getWeeksInYear(){var weekInfo=this.localeData()._week;return weeksInYear(this.year(),weekInfo.dow,weekInfo.doy)}function getSetWeekYearHelper(input,week,weekday,dow,doy){var weeksTarget;return null==input?weekOfYear(this,dow,doy).year:(week>(weeksTarget=weeksInYear(input,dow,doy))&&(week=weeksTarget),setWeekAll.call(this,input,week,weekday,dow,doy))}function setWeekAll(weekYear,week,weekday,dow,doy){var dayOfYearData=dayOfYearFromWeeks(weekYear,week,weekday,dow,doy),date=createUTCDate(dayOfYearData.year,0,dayOfYearData.dayOfYear);return this.year(date.getUTCFullYear()),this.month(date.getUTCMonth()),this.date(date.getUTCDate()),this}function getSetQuarter(input){return null==input?Math.ceil((this.month()+1)/3):this.month(3*(input-1)+this.month()%3)}addFormatToken(0,["gg",2],0,(function(){return this.weekYear()%100})),addFormatToken(0,["GG",2],0,(function(){return this.isoWeekYear()%100})),addWeekYearFormatToken("gggg","weekYear"),addWeekYearFormatToken("ggggg","weekYear"),addWeekYearFormatToken("GGGG","isoWeekYear"),addWeekYearFormatToken("GGGGG","isoWeekYear"),addUnitAlias("weekYear","gg"),addUnitAlias("isoWeekYear","GG"),addUnitPriority("weekYear",1),addUnitPriority("isoWeekYear",1),addRegexToken("G",matchSigned),addRegexToken("g",matchSigned),addRegexToken("GG",match1to2,match2),addRegexToken("gg",match1to2,match2),addRegexToken("GGGG",match1to4,match4),addRegexToken("gggg",match1to4,match4),addRegexToken("GGGGG",match1to6,match6),addRegexToken("ggggg",match1to6,match6),addWeekParseToken(["gggg","ggggg","GGGG","GGGGG"],(function(input,week,config,token){week[token.substr(0,2)]=toInt(input)})),addWeekParseToken(["gg","GG"],(function(input,week,config,token){week[token]=hooks.parseTwoDigitYear(input)})),addFormatToken("Q",0,"Qo","quarter"),addUnitAlias("quarter","Q"),addUnitPriority("quarter",7),addRegexToken("Q",match1),addParseToken("Q",(function(input,array){array[MONTH]=3*(toInt(input)-1)})),addFormatToken("D",["DD",2],"Do","date"),addUnitAlias("date","D"),addUnitPriority("date",9),addRegexToken("D",match1to2),addRegexToken("DD",match1to2,match2),addRegexToken("Do",(function(isStrict,locale){return isStrict?locale._dayOfMonthOrdinalParse||locale._ordinalParse:locale._dayOfMonthOrdinalParseLenient})),addParseToken(["D","DD"],DATE),addParseToken("Do",(function(input,array){array[DATE]=toInt(input.match(match1to2)[0])}));var getSetDayOfMonth=makeGetSet("Date",!0);function getSetDayOfYear(input){var dayOfYear=Math.round((this.clone().startOf("day")-this.clone().startOf("year"))/864e5)+1;return null==input?dayOfYear:this.add(input-dayOfYear,"d")}addFormatToken("DDD",["DDDD",3],"DDDo","dayOfYear"),addUnitAlias("dayOfYear","DDD"),addUnitPriority("dayOfYear",4),addRegexToken("DDD",match1to3),addRegexToken("DDDD",match3),addParseToken(["DDD","DDDD"],(function(input,array,config){config._dayOfYear=toInt(input)})),addFormatToken("m",["mm",2],0,"minute"),addUnitAlias("minute","m"),addUnitPriority("minute",14),addRegexToken("m",match1to2),addRegexToken("mm",match1to2,match2),addParseToken(["m","mm"],MINUTE);var getSetMinute=makeGetSet("Minutes",!1);addFormatToken("s",["ss",2],0,"second"),addUnitAlias("second","s"),addUnitPriority("second",15),addRegexToken("s",match1to2),addRegexToken("ss",match1to2,match2),addParseToken(["s","ss"],SECOND);var token,getSetSecond=makeGetSet("Seconds",!1);for(addFormatToken("S",0,0,(function(){return~~(this.millisecond()/100)})),addFormatToken(0,["SS",2],0,(function(){return~~(this.millisecond()/10)})),addFormatToken(0,["SSS",3],0,"millisecond"),addFormatToken(0,["SSSS",4],0,(function(){return 10*this.millisecond()})),addFormatToken(0,["SSSSS",5],0,(function(){return 100*this.millisecond()})),addFormatToken(0,["SSSSSS",6],0,(function(){return 1e3*this.millisecond()})),addFormatToken(0,["SSSSSSS",7],0,(function(){return 1e4*this.millisecond()})),addFormatToken(0,["SSSSSSSS",8],0,(function(){return 1e5*this.millisecond()})),addFormatToken(0,["SSSSSSSSS",9],0,(function(){return 1e6*this.millisecond()})),addUnitAlias("millisecond","ms"),addUnitPriority("millisecond",16),addRegexToken("S",match1to3,match1),addRegexToken("SS",match1to3,match2),addRegexToken("SSS",match1to3,match3),token="SSSS";token.length<=9;token+="S")addRegexToken(token,matchUnsigned);function parseMs(input,array){array[MILLISECOND]=toInt(1e3*("0."+input))}for(token="S";token.length<=9;token+="S")addParseToken(token,parseMs);var getSetMillisecond=makeGetSet("Milliseconds",!1);function getZoneAbbr(){return this._isUTC?"UTC":""}function getZoneName(){return this._isUTC?"Coordinated Universal Time":""}addFormatToken("z",0,0,"zoneAbbr"),addFormatToken("zz",0,0,"zoneName");var proto=Moment.prototype;function createUnix(input){return createLocal(1e3*input)}function createInZone(){return createLocal.apply(null,arguments).parseZone()}function preParsePostFormat(string){return string}proto.add=add,proto.calendar=calendar$1,proto.clone=clone,proto.diff=diff,proto.endOf=endOf,proto.format=format,proto.from=from,proto.fromNow=fromNow,proto.to=to,proto.toNow=toNow,proto.get=stringGet,proto.invalidAt=invalidAt,proto.isAfter=isAfter,proto.isBefore=isBefore,proto.isBetween=isBetween,proto.isSame=isSame,proto.isSameOrAfter=isSameOrAfter,proto.isSameOrBefore=isSameOrBefore,proto.isValid=isValid$2,proto.lang=lang,proto.locale=locale,proto.localeData=localeData,proto.max=prototypeMax,proto.min=prototypeMin,proto.parsingFlags=parsingFlags,proto.set=stringSet,proto.startOf=startOf,proto.subtract=subtract,proto.toArray=toArray,proto.toObject=toObject,proto.toDate=toDate,proto.toISOString=toISOString,proto.inspect=inspect,proto.toJSON=toJSON,proto.toString=toString,proto.unix=unix,proto.valueOf=valueOf,proto.creationData=creationData,proto.year=getSetYear,proto.isLeapYear=getIsLeapYear,proto.weekYear=getSetWeekYear,proto.isoWeekYear=getSetISOWeekYear,proto.quarter=proto.quarters=getSetQuarter,proto.month=getSetMonth,proto.daysInMonth=getDaysInMonth,proto.week=proto.weeks=getSetWeek,proto.isoWeek=proto.isoWeeks=getSetISOWeek,proto.weeksInYear=getWeeksInYear,proto.isoWeeksInYear=getISOWeeksInYear,proto.date=getSetDayOfMonth,proto.day=proto.days=getSetDayOfWeek,proto.weekday=getSetLocaleDayOfWeek,proto.isoWeekday=getSetISODayOfWeek,proto.dayOfYear=getSetDayOfYear,proto.hour=proto.hours=getSetHour,proto.minute=proto.minutes=getSetMinute,proto.second=proto.seconds=getSetSecond,proto.millisecond=proto.milliseconds=getSetMillisecond,proto.utcOffset=getSetOffset,proto.utc=setOffsetToUTC,proto.local=setOffsetToLocal,proto.parseZone=setOffsetToParsedOffset,proto.hasAlignedHourOffset=hasAlignedHourOffset,proto.isDST=isDaylightSavingTime,proto.isLocal=isLocal,proto.isUtcOffset=isUtcOffset,proto.isUtc=isUtc,proto.isUTC=isUtc,proto.zoneAbbr=getZoneAbbr,proto.zoneName=getZoneName,proto.dates=deprecate("dates accessor is deprecated. Use date instead.",getSetDayOfMonth),proto.months=deprecate("months accessor is deprecated. Use month instead",getSetMonth),proto.years=deprecate("years accessor is deprecated. Use year instead",getSetYear),proto.zone=deprecate("moment().zone is deprecated, use moment().utcOffset instead. http://momentjs.com/guides/#/warnings/zone/",getSetZone),proto.isDSTShifted=deprecate("isDSTShifted is deprecated. See http://momentjs.com/guides/#/warnings/dst-shifted/ for more information",isDaylightSavingTimeShifted);var proto$1=Locale.prototype;function get$1(format,index,field,setter){var locale=getLocale(),utc=createUTC().set(setter,index);return locale[field](utc,format)}function listMonthsImpl(format,index,field){if(isNumber(format)&&(index=format,format=void 0),format=format||"",null!=index)return get$1(format,index,field,"month");var i,out=[];for(i=0;i<12;i++)out[i]=get$1(format,i,field,"month");return out}function listWeekdaysImpl(localeSorted,format,index,field){"boolean"==typeof localeSorted?(isNumber(format)&&(index=format,format=void 0),format=format||""):(index=format=localeSorted,localeSorted=!1,isNumber(format)&&(index=format,format=void 0),format=format||"");var i,locale=getLocale(),shift=localeSorted?locale._week.dow:0;if(null!=index)return get$1(format,(index+shift)%7,field,"day");var out=[];for(i=0;i<7;i++)out[i]=get$1(format,(i+shift)%7,field,"day");return out}function listMonths(format,index){return listMonthsImpl(format,index,"months")}function listMonthsShort(format,index){return listMonthsImpl(format,index,"monthsShort")}function listWeekdays(localeSorted,format,index){return listWeekdaysImpl(localeSorted,format,index,"weekdays")}function listWeekdaysShort(localeSorted,format,index){return listWeekdaysImpl(localeSorted,format,index,"weekdaysShort")}function listWeekdaysMin(localeSorted,format,index){return listWeekdaysImpl(localeSorted,format,index,"weekdaysMin")}proto$1.calendar=calendar,proto$1.longDateFormat=longDateFormat,proto$1.invalidDate=invalidDate,proto$1.ordinal=ordinal,proto$1.preparse=preParsePostFormat,proto$1.postformat=preParsePostFormat,proto$1.relativeTime=relativeTime,proto$1.pastFuture=pastFuture,proto$1.set=set,proto$1.months=localeMonths,proto$1.monthsShort=localeMonthsShort,proto$1.monthsParse=localeMonthsParse,proto$1.monthsRegex=monthsRegex,proto$1.monthsShortRegex=monthsShortRegex,proto$1.week=localeWeek,proto$1.firstDayOfYear=localeFirstDayOfYear,proto$1.firstDayOfWeek=localeFirstDayOfWeek,proto$1.weekdays=localeWeekdays,proto$1.weekdaysMin=localeWeekdaysMin,proto$1.weekdaysShort=localeWeekdaysShort,proto$1.weekdaysParse=localeWeekdaysParse,proto$1.weekdaysRegex=weekdaysRegex,proto$1.weekdaysShortRegex=weekdaysShortRegex,proto$1.weekdaysMinRegex=weekdaysMinRegex,proto$1.isPM=localeIsPM,proto$1.meridiem=localeMeridiem,getSetGlobalLocale("en",{dayOfMonthOrdinalParse:/\d{1,2}(th|st|nd|rd)/,ordinal:function(number){var b=number%10;return number+(1===toInt(number%100/10)?"th":1===b?"st":2===b?"nd":3===b?"rd":"th")}}),hooks.lang=deprecate("moment.lang is deprecated. Use moment.locale instead.",getSetGlobalLocale),hooks.langData=deprecate("moment.langData is deprecated. Use moment.localeData instead.",getLocale);var mathAbs=Math.abs;function abs(){var data=this._data;return this._milliseconds=mathAbs(this._milliseconds),this._days=mathAbs(this._days),this._months=mathAbs(this._months),data.milliseconds=mathAbs(data.milliseconds),data.seconds=mathAbs(data.seconds),data.minutes=mathAbs(data.minutes),data.hours=mathAbs(data.hours),data.months=mathAbs(data.months),data.years=mathAbs(data.years),this}function addSubtract$1(duration,input,value,direction){var other=createDuration(input,value);return duration._milliseconds+=direction*other._milliseconds,duration._days+=direction*other._days,duration._months+=direction*other._months,duration._bubble()}function add$1(input,value){return addSubtract$1(this,input,value,1)}function subtract$1(input,value){return addSubtract$1(this,input,value,-1)}function absCeil(number){return number<0?Math.floor(number):Math.ceil(number)}function bubble(){var seconds,minutes,hours,years,monthsFromDays,milliseconds=this._milliseconds,days=this._days,months=this._months,data=this._data;return milliseconds>=0&&days>=0&&months>=0||milliseconds<=0&&days<=0&&months<=0||(milliseconds+=864e5*absCeil(monthsToDays(months)+days),days=0,months=0),data.milliseconds=milliseconds%1e3,seconds=absFloor(milliseconds/1e3),data.seconds=seconds%60,minutes=absFloor(seconds/60),data.minutes=minutes%60,hours=absFloor(minutes/60),data.hours=hours%24,days+=absFloor(hours/24),months+=monthsFromDays=absFloor(daysToMonths(days)),days-=absCeil(monthsToDays(monthsFromDays)),years=absFloor(months/12),months%=12,data.days=days,data.months=months,data.years=years,this}function daysToMonths(days){return 4800*days/146097}function monthsToDays(months){return 146097*months/4800}function as(units){if(!this.isValid())return NaN;var days,months,milliseconds=this._milliseconds;if("month"===(units=normalizeUnits(units))||"quarter"===units||"year"===units)switch(days=this._days+milliseconds/864e5,months=this._months+daysToMonths(days),units){case"month":return months;case"quarter":return months/3;case"year":return months/12}else switch(days=this._days+Math.round(monthsToDays(this._months)),units){case"week":return days/7+milliseconds/6048e5;case"day":return days+milliseconds/864e5;case"hour":return 24*days+milliseconds/36e5;case"minute":return 1440*days+milliseconds/6e4;case"second":return 86400*days+milliseconds/1e3;case"millisecond":return Math.floor(864e5*days)+milliseconds;default:throw new Error("Unknown unit "+units)}}function valueOf$1(){return this.isValid()?this._milliseconds+864e5*this._days+this._months%12*2592e6+31536e6*toInt(this._months/12):NaN}function makeAs(alias){return function(){return this.as(alias)}}var asMilliseconds=makeAs("ms"),asSeconds=makeAs("s"),asMinutes=makeAs("m"),asHours=makeAs("h"),asDays=makeAs("d"),asWeeks=makeAs("w"),asMonths=makeAs("M"),asQuarters=makeAs("Q"),asYears=makeAs("y");function clone$1(){return createDuration(this)}function get$2(units){return units=normalizeUnits(units),this.isValid()?this[units+"s"]():NaN}function makeGetter(name){return function(){return this.isValid()?this._data[name]:NaN}}var milliseconds=makeGetter("milliseconds"),seconds=makeGetter("seconds"),minutes=makeGetter("minutes"),hours=makeGetter("hours"),days=makeGetter("days"),months=makeGetter("months"),years=makeGetter("years");function weeks(){return absFloor(this.days()/7)}var round=Math.round,thresholds={ss:44,s:45,m:45,h:22,d:26,M:11};function substituteTimeAgo(string,number,withoutSuffix,isFuture,locale){return locale.relativeTime(number||1,!!withoutSuffix,string,isFuture)}function relativeTime$1(posNegDuration,withoutSuffix,locale){var duration=createDuration(posNegDuration).abs(),seconds=round(duration.as("s")),minutes=round(duration.as("m")),hours=round(duration.as("h")),days=round(duration.as("d")),months=round(duration.as("M")),years=round(duration.as("y")),a=seconds<=thresholds.ss&&["s",seconds]||seconds<thresholds.s&&["ss",seconds]||minutes<=1&&["m"]||minutes<thresholds.m&&["mm",minutes]||hours<=1&&["h"]||hours<thresholds.h&&["hh",hours]||days<=1&&["d"]||days<thresholds.d&&["dd",days]||months<=1&&["M"]||months<thresholds.M&&["MM",months]||years<=1&&["y"]||["yy",years];return a[2]=withoutSuffix,a[3]=+posNegDuration>0,a[4]=locale,substituteTimeAgo.apply(null,a)}function getSetRelativeTimeRounding(roundingFunction){return void 0===roundingFunction?round:"function"==typeof roundingFunction&&(round=roundingFunction,!0)}function getSetRelativeTimeThreshold(threshold,limit){return void 0!==thresholds[threshold]&&(void 0===limit?thresholds[threshold]:(thresholds[threshold]=limit,"s"===threshold&&(thresholds.ss=limit-1),!0))}function humanize(withSuffix){if(!this.isValid())return this.localeData().invalidDate();var locale=this.localeData(),output=relativeTime$1(this,!withSuffix,locale);return withSuffix&&(output=locale.pastFuture(+this,output)),locale.postformat(output)}var abs$1=Math.abs;function sign(x){return(x>0)-(x<0)||+x}function toISOString$1(){if(!this.isValid())return this.localeData().invalidDate();var minutes,hours,seconds=abs$1(this._milliseconds)/1e3,days=abs$1(this._days),months=abs$1(this._months);minutes=absFloor(seconds/60),hours=absFloor(minutes/60),seconds%=60,minutes%=60;var Y=absFloor(months/12),M=months%=12,D=days,h=hours,m=minutes,s=seconds?seconds.toFixed(3).replace(/\.?0+$/,""):"",total=this.asSeconds();if(!total)return"P0D";var totalSign=total<0?"-":"",ymSign=sign(this._months)!==sign(total)?"-":"",daysSign=sign(this._days)!==sign(total)?"-":"",hmsSign=sign(this._milliseconds)!==sign(total)?"-":"";return totalSign+"P"+(Y?ymSign+Y+"Y":"")+(M?ymSign+M+"M":"")+(D?daysSign+D+"D":"")+(h||m||s?"T":"")+(h?hmsSign+h+"H":"")+(m?hmsSign+m+"M":"")+(s?hmsSign+s+"S":"")}var proto$2=Duration.prototype;return proto$2.isValid=isValid$1,proto$2.abs=abs,proto$2.add=add$1,proto$2.subtract=subtract$1,proto$2.as=as,proto$2.asMilliseconds=asMilliseconds,proto$2.asSeconds=asSeconds,proto$2.asMinutes=asMinutes,proto$2.asHours=asHours,proto$2.asDays=asDays,proto$2.asWeeks=asWeeks,proto$2.asMonths=asMonths,proto$2.asQuarters=asQuarters,proto$2.asYears=asYears,proto$2.valueOf=valueOf$1,proto$2._bubble=bubble,proto$2.clone=clone$1,proto$2.get=get$2,proto$2.milliseconds=milliseconds,proto$2.seconds=seconds,proto$2.minutes=minutes,proto$2.hours=hours,proto$2.days=days,proto$2.weeks=weeks,proto$2.months=months,proto$2.years=years,proto$2.humanize=humanize,proto$2.toISOString=toISOString$1,proto$2.toString=toISOString$1,proto$2.toJSON=toISOString$1,proto$2.locale=locale,proto$2.localeData=localeData,proto$2.toIsoString=deprecate("toIsoString() is deprecated. Please use toISOString() instead (notice the capitals)",toISOString$1),proto$2.lang=lang,addFormatToken("X",0,0,"unix"),addFormatToken("x",0,0,"valueOf"),addRegexToken("x",matchSigned),addRegexToken("X",matchTimestamp),addParseToken("X",(function(input,array,config){config._d=new Date(1e3*parseFloat(input,10))})),addParseToken("x",(function(input,array,config){config._d=new Date(toInt(input))})),hooks.version="2.24.0",setHookCallback(createLocal),hooks.fn=proto,hooks.min=min,hooks.max=max,hooks.now=now,hooks.utc=createUTC,hooks.unix=createUnix,hooks.months=listMonths,hooks.isDate=isDate,hooks.locale=getSetGlobalLocale,hooks.invalid=createInvalid,hooks.duration=createDuration,hooks.isMoment=isMoment,hooks.weekdays=listWeekdays,hooks.parseZone=createInZone,hooks.localeData=getLocale,hooks.isDuration=isDuration,hooks.monthsShort=listMonthsShort,hooks.weekdaysMin=listWeekdaysMin,hooks.defineLocale=defineLocale,hooks.updateLocale=updateLocale,hooks.locales=listLocales,hooks.weekdaysShort=listWeekdaysShort,hooks.normalizeUnits=normalizeUnits,hooks.relativeTimeRounding=getSetRelativeTimeRounding,hooks.relativeTimeThreshold=getSetRelativeTimeThreshold,hooks.calendarFormat=getCalendarFormat,hooks.prototype=proto,hooks.HTML5_FMT={DATETIME_LOCAL:"YYYY-MM-DDTHH:mm",DATETIME_LOCAL_SECONDS:"YYYY-MM-DDTHH:mm:ss",DATETIME_LOCAL_MS:"YYYY-MM-DDTHH:mm:ss.SSS",DATE:"YYYY-MM-DD",TIME:"HH:mm",TIME_SECONDS:"HH:mm:ss",TIME_MS:"HH:mm:ss.SSS",WEEK:"GGGG-[W]WW",MONTH:"YYYY-MM"},hooks}()})),FORMATS={datetime:"MMM D, YYYY, h:mm:ss a",millisecond:"h:mm:ss.SSS a",second:"h:mm:ss a",minute:"h:mm a",hour:"hA",day:"MMM D",week:"ll",month:"MMM YYYY",quarter:"[Q]Q - YYYY",year:"YYYY"};core_adapters._date.override("function"==typeof moment?{_id:"moment",formats:function(){return FORMATS},parse:function(value,format){return"string"==typeof value&&"string"==typeof format?value=moment(value,format):value instanceof moment||(value=moment(value)),value.isValid()?value.valueOf():null},format:function(time,format){return moment(time).format(format)},add:function(time,amount,unit){return moment(time).add(amount,unit).valueOf()},diff:function(max,min,unit){return moment(max).diff(moment(min),unit)},startOf:function(time,unit,weekday){return time=moment(time),"isoWeek"===unit?time.isoWeekday(weekday).valueOf():time.startOf(unit).valueOf()},endOf:function(time,unit){return moment(time).endOf(unit).valueOf()},_create:function(time){return moment(time)}}:{}),core_defaults._set("global",{plugins:{filler:{propagate:!0}}});var mappers={dataset:function(source){var index=source.fill,chart=source.chart,meta=chart.getDatasetMeta(index),points=meta&&chart.isDatasetVisible(index)&&meta.dataset._children||[],length=points.length||0;return length?function(point,i){return i<length&&points[i]._view||null}:null},boundary:function(source){var boundary=source.boundary,x=boundary?boundary.x:null,y=boundary?boundary.y:null;return helpers$1.isArray(boundary)?function(point,i){return boundary[i]}:function(point){return{x:null===x?point.x:x,y:null===y?point.y:y}}}};function decodeFill(el,index,count){var target,model=el._model||{},fill=model.fill;if(void 0===fill&&(fill=!!model.backgroundColor),!1===fill||null===fill)return!1;if(!0===fill)return"origin";if(target=parseFloat(fill,10),isFinite(target)&&Math.floor(target)===target)return"-"!==fill[0]&&"+"!==fill[0]||(target=index+target),!(target===index||target<0||target>=count)&&target;switch(fill){case"bottom":return"start";case"top":return"end";case"zero":return"origin";case"origin":case"start":case"end":return fill;default:return!1}}function computeBoundary(source){return(source.el._scale||{}).getPointPositionForValue?function(source){var start,end,center,i,point,scale=source.el._scale,options=scale.options,length=scale.chart.data.labels.length,fill=source.fill,target=[];if(!length)return null;for(start=options.ticks.reverse?scale.max:scale.min,end=options.ticks.reverse?scale.min:scale.max,center=scale.getPointPositionForValue(0,start),i=0;i<length;++i)point="start"===fill||"end"===fill?scale.getPointPositionForValue(i,"start"===fill?start:end):scale.getBasePosition(i),options.gridLines.circular&&(point.cx=center.x,point.cy=center.y,point.angle=scale.getIndexAngle(i)-Math.PI/2),target.push(point);return target}(source):function(source){var horizontal,model=source.el._model||{},scale=source.el._scale||{},fill=source.fill,target=null;if(isFinite(fill))return null;if("start"===fill?target=void 0===model.scaleBottom?scale.bottom:model.scaleBottom:"end"===fill?target=void 0===model.scaleTop?scale.top:model.scaleTop:void 0!==model.scaleZero?target=model.scaleZero:scale.getBasePixel&&(target=scale.getBasePixel()),null!=target){if(void 0!==target.x&&void 0!==target.y)return target;if(helpers$1.isFinite(target))return{x:(horizontal=scale.isHorizontal())?target:null,y:horizontal?null:target}}return null}(source)}function resolveTarget(sources,index,propagate){var target,fill=sources[index].fill,visited=[index];if(!propagate)return fill;for(;!1!==fill&&-1===visited.indexOf(fill);){if(!isFinite(fill))return fill;if(!(target=sources[fill]))return!1;if(target.visible)return fill;visited.push(fill),fill=target.fill}return!1}function createMapper(source){var fill=source.fill,type="dataset";return!1===fill?null:(isFinite(fill)||(type="boundary"),mappers[type](source))}function isDrawable(point){return point&&!point.skip}function drawArea(ctx,curve0,curve1,len0,len1){var i,cx,cy,r;if(len0&&len1){for(ctx.moveTo(curve0[0].x,curve0[0].y),i=1;i<len0;++i)helpers$1.canvas.lineTo(ctx,curve0[i-1],curve0[i]);if(void 0===curve1[0].angle)for(ctx.lineTo(curve1[len1-1].x,curve1[len1-1].y),i=len1-1;i>0;--i)helpers$1.canvas.lineTo(ctx,curve1[i],curve1[i-1],!0);else for(cx=curve1[0].cx,cy=curve1[0].cy,r=Math.sqrt(Math.pow(curve1[0].x-cx,2)+Math.pow(curve1[0].y-cy,2)),i=len1-1;i>0;--i)ctx.arc(cx,cy,r,curve1[i].angle,curve1[i-1].angle,!0)}}function doFill(ctx,points,mapper,view,color,loop){var i,ilen,index,p0,p1,d0,d1,loopOffset,count=points.length,span=view.spanGaps,curve0=[],curve1=[],len0=0,len1=0;for(ctx.beginPath(),i=0,ilen=count;i<ilen;++i)p1=mapper(p0=points[index=i%count]._view,index,view),d0=isDrawable(p0),d1=isDrawable(p1),loop&&void 0===loopOffset&&d0&&(ilen=count+(loopOffset=i+1)),d0&&d1?(len0=curve0.push(p0),len1=curve1.push(p1)):len0&&len1&&(span?(d0&&curve0.push(p0),d1&&curve1.push(p1)):(drawArea(ctx,curve0,curve1,len0,len1),len0=len1=0,curve0=[],curve1=[]));drawArea(ctx,curve0,curve1,len0,len1),ctx.closePath(),ctx.fillStyle=color,ctx.fill()}var plugin_filler={id:"filler",afterDatasetsUpdate:function(chart,options){var meta,i,el,source,count=(chart.data.datasets||[]).length,propagate=options.propagate,sources=[];for(i=0;i<count;++i)source=null,(el=(meta=chart.getDatasetMeta(i)).dataset)&&el._model&&el instanceof elements.Line&&(source={visible:chart.isDatasetVisible(i),fill:decodeFill(el,i,count),chart:chart,el:el}),meta.$filler=source,sources.push(source);for(i=0;i<count;++i)(source=sources[i])&&(source.fill=resolveTarget(sources,i,propagate),source.boundary=computeBoundary(source),source.mapper=createMapper(source))},beforeDatasetsDraw:function(chart){var meta,i,el,view,points,mapper,color,metasets=chart._getSortedVisibleDatasetMetas(),ctx=chart.ctx;for(i=metasets.length-1;i>=0;--i)(meta=metasets[i].$filler)&&meta.visible&&(view=(el=meta.el)._view,points=el._children||[],mapper=meta.mapper,color=view.backgroundColor||core_defaults.global.defaultColor,mapper&&color&&points.length&&(helpers$1.canvas.clipArea(ctx,chart.chartArea),doFill(ctx,points,mapper,view,color,el._loop),helpers$1.canvas.unclipArea(ctx)))}},getRtlHelper$1=helpers$1.rtl.getRtlAdapter,noop$1=helpers$1.noop,valueOrDefault$e=helpers$1.valueOrDefault;function getBoxWidth(labelOpts,fontSize){return labelOpts.usePointStyle&&labelOpts.boxWidth>fontSize?fontSize:labelOpts.boxWidth}core_defaults._set("global",{legend:{display:!0,position:"top",align:"center",fullWidth:!0,reverse:!1,weight:1e3,onClick:function(e,legendItem){var index=legendItem.datasetIndex,ci=this.chart,meta=ci.getDatasetMeta(index);meta.hidden=null===meta.hidden?!ci.data.datasets[index].hidden:null,ci.update()},onHover:null,onLeave:null,labels:{boxWidth:40,padding:10,generateLabels:function(chart){var datasets=chart.data.datasets,options=chart.options.legend||{},usePointStyle=options.labels&&options.labels.usePointStyle;return chart._getSortedDatasetMetas().map((function(meta){var style=meta.controller.getStyle(usePointStyle?0:void 0);return{text:datasets[meta.index].label,fillStyle:style.backgroundColor,hidden:!chart.isDatasetVisible(meta.index),lineCap:style.borderCapStyle,lineDash:style.borderDash,lineDashOffset:style.borderDashOffset,lineJoin:style.borderJoinStyle,lineWidth:style.borderWidth,strokeStyle:style.borderColor,pointStyle:style.pointStyle,rotation:style.rotation,datasetIndex:meta.index}}),this)}}},legendCallback:function(chart){var i,ilen,listItem,list=document.createElement("ul"),datasets=chart.data.datasets;for(list.setAttribute("class",chart.id+"-legend"),i=0,ilen=datasets.length;i<ilen;i++)(listItem=list.appendChild(document.createElement("li"))).appendChild(document.createElement("span")).style.backgroundColor=datasets[i].backgroundColor,datasets[i].label&&listItem.appendChild(document.createTextNode(datasets[i].label));return list.outerHTML}});var Legend=core_element.extend({initialize:function(config){helpers$1.extend(this,config),this.legendHitBoxes=[],this._hoveredItem=null,this.doughnutMode=!1},beforeUpdate:noop$1,update:function(maxWidth,maxHeight,margins){var me=this;return me.beforeUpdate(),me.maxWidth=maxWidth,me.maxHeight=maxHeight,me.margins=margins,me.beforeSetDimensions(),me.setDimensions(),me.afterSetDimensions(),me.beforeBuildLabels(),me.buildLabels(),me.afterBuildLabels(),me.beforeFit(),me.fit(),me.afterFit(),me.afterUpdate(),me.minSize},afterUpdate:noop$1,beforeSetDimensions:noop$1,setDimensions:function(){var me=this;me.isHorizontal()?(me.width=me.maxWidth,me.left=0,me.right=me.width):(me.height=me.maxHeight,me.top=0,me.bottom=me.height),me.paddingLeft=0,me.paddingTop=0,me.paddingRight=0,me.paddingBottom=0,me.minSize={width:0,height:0}},afterSetDimensions:noop$1,beforeBuildLabels:noop$1,buildLabels:function(){var me=this,labelOpts=me.options.labels||{},legendItems=helpers$1.callback(labelOpts.generateLabels,[me.chart],me)||[];labelOpts.filter&&(legendItems=legendItems.filter((function(item){return labelOpts.filter(item,me.chart.data)}))),me.options.reverse&&legendItems.reverse(),me.legendItems=legendItems},afterBuildLabels:noop$1,beforeFit:noop$1,fit:function(){var me=this,opts=me.options,labelOpts=opts.labels,display=opts.display,ctx=me.ctx,labelFont=helpers$1.options._parseFont(labelOpts),fontSize=labelFont.size,hitboxes=me.legendHitBoxes=[],minSize=me.minSize,isHorizontal=me.isHorizontal();if(isHorizontal?(minSize.width=me.maxWidth,minSize.height=display?10:0):(minSize.width=display?10:0,minSize.height=me.maxHeight),display){if(ctx.font=labelFont.string,isHorizontal){var lineWidths=me.lineWidths=[0],totalHeight=0;ctx.textAlign="left",ctx.textBaseline="middle",helpers$1.each(me.legendItems,(function(legendItem,i){var width=getBoxWidth(labelOpts,fontSize)+fontSize/2+ctx.measureText(legendItem.text).width;(0===i||lineWidths[lineWidths.length-1]+width+2*labelOpts.padding>minSize.width)&&(totalHeight+=fontSize+labelOpts.padding,lineWidths[lineWidths.length-(i>0?0:1)]=0),hitboxes[i]={left:0,top:0,width:width,height:fontSize},lineWidths[lineWidths.length-1]+=width+labelOpts.padding})),minSize.height+=totalHeight}else{var vPadding=labelOpts.padding,columnWidths=me.columnWidths=[],columnHeights=me.columnHeights=[],totalWidth=labelOpts.padding,currentColWidth=0,currentColHeight=0;helpers$1.each(me.legendItems,(function(legendItem,i){var itemWidth=getBoxWidth(labelOpts,fontSize)+fontSize/2+ctx.measureText(legendItem.text).width;i>0&&currentColHeight+fontSize+2*vPadding>minSize.height&&(totalWidth+=currentColWidth+labelOpts.padding,columnWidths.push(currentColWidth),columnHeights.push(currentColHeight),currentColWidth=0,currentColHeight=0),currentColWidth=Math.max(currentColWidth,itemWidth),currentColHeight+=fontSize+vPadding,hitboxes[i]={left:0,top:0,width:itemWidth,height:fontSize}})),totalWidth+=currentColWidth,columnWidths.push(currentColWidth),columnHeights.push(currentColHeight),minSize.width+=totalWidth}me.width=minSize.width,me.height=minSize.height}else me.width=minSize.width=me.height=minSize.height=0},afterFit:noop$1,isHorizontal:function(){return"top"===this.options.position||"bottom"===this.options.position},draw:function(){var me=this,opts=me.options,labelOpts=opts.labels,globalDefaults=core_defaults.global,defaultColor=globalDefaults.defaultColor,lineDefault=globalDefaults.elements.line,legendHeight=me.height,columnHeights=me.columnHeights,legendWidth=me.width,lineWidths=me.lineWidths;if(opts.display){var cursor,rtlHelper=getRtlHelper$1(opts.rtl,me.left,me.minSize.width),ctx=me.ctx,fontColor=valueOrDefault$e(labelOpts.fontColor,globalDefaults.defaultFontColor),labelFont=helpers$1.options._parseFont(labelOpts),fontSize=labelFont.size;ctx.textAlign=rtlHelper.textAlign("left"),ctx.textBaseline="middle",ctx.lineWidth=.5,ctx.strokeStyle=fontColor,ctx.fillStyle=fontColor,ctx.font=labelFont.string;var boxWidth=getBoxWidth(labelOpts,fontSize),hitboxes=me.legendHitBoxes,alignmentOffset=function(dimension,blockSize){switch(opts.align){case"start":return labelOpts.padding;case"end":return dimension-blockSize;default:return(dimension-blockSize+labelOpts.padding)/2}},isHorizontal=me.isHorizontal();cursor=isHorizontal?{x:me.left+alignmentOffset(legendWidth,lineWidths[0]),y:me.top+labelOpts.padding,line:0}:{x:me.left+labelOpts.padding,y:me.top+alignmentOffset(legendHeight,columnHeights[0]),line:0},helpers$1.rtl.overrideTextDirection(me.ctx,opts.textDirection);var itemHeight=fontSize+labelOpts.padding;helpers$1.each(me.legendItems,(function(legendItem,i){var textWidth=ctx.measureText(legendItem.text).width,width=boxWidth+fontSize/2+textWidth,x=cursor.x,y=cursor.y;rtlHelper.setWidth(me.minSize.width),isHorizontal?i>0&&x+width+labelOpts.padding>me.left+me.minSize.width&&(y=cursor.y+=itemHeight,cursor.line++,x=cursor.x=me.left+alignmentOffset(legendWidth,lineWidths[cursor.line])):i>0&&y+itemHeight>me.top+me.minSize.height&&(x=cursor.x=x+me.columnWidths[cursor.line]+labelOpts.padding,cursor.line++,y=cursor.y=me.top+alignmentOffset(legendHeight,columnHeights[cursor.line]));var realX=rtlHelper.x(x);!function(x,y,legendItem){if(!(isNaN(boxWidth)||boxWidth<=0)){ctx.save();var lineWidth=valueOrDefault$e(legendItem.lineWidth,lineDefault.borderWidth);if(ctx.fillStyle=valueOrDefault$e(legendItem.fillStyle,defaultColor),ctx.lineCap=valueOrDefault$e(legendItem.lineCap,lineDefault.borderCapStyle),ctx.lineDashOffset=valueOrDefault$e(legendItem.lineDashOffset,lineDefault.borderDashOffset),ctx.lineJoin=valueOrDefault$e(legendItem.lineJoin,lineDefault.borderJoinStyle),ctx.lineWidth=lineWidth,ctx.strokeStyle=valueOrDefault$e(legendItem.strokeStyle,defaultColor),ctx.setLineDash&&ctx.setLineDash(valueOrDefault$e(legendItem.lineDash,lineDefault.borderDash)),labelOpts&&labelOpts.usePointStyle){var radius=boxWidth*Math.SQRT2/2,centerX=rtlHelper.xPlus(x,boxWidth/2),centerY=y+fontSize/2;helpers$1.canvas.drawPoint(ctx,legendItem.pointStyle,radius,centerX,centerY,legendItem.rotation)}else ctx.fillRect(rtlHelper.leftForLtr(x,boxWidth),y,boxWidth,fontSize),0!==lineWidth&&ctx.strokeRect(rtlHelper.leftForLtr(x,boxWidth),y,boxWidth,fontSize);ctx.restore()}}(realX,y,legendItem),hitboxes[i].left=rtlHelper.leftForLtr(realX,hitboxes[i].width),hitboxes[i].top=y,function(x,y,legendItem,textWidth){var halfFontSize=fontSize/2,xLeft=rtlHelper.xPlus(x,boxWidth+halfFontSize),yMiddle=y+halfFontSize;ctx.fillText(legendItem.text,xLeft,yMiddle),legendItem.hidden&&(ctx.beginPath(),ctx.lineWidth=2,ctx.moveTo(xLeft,yMiddle),ctx.lineTo(rtlHelper.xPlus(xLeft,textWidth),yMiddle),ctx.stroke())}(realX,y,legendItem,textWidth),isHorizontal?cursor.x+=width+labelOpts.padding:cursor.y+=itemHeight})),helpers$1.rtl.restoreTextDirection(me.ctx,opts.textDirection)}},_getLegendItemAt:function(x,y){var i,hitBox,lh,me=this;if(x>=me.left&&x<=me.right&&y>=me.top&&y<=me.bottom)for(lh=me.legendHitBoxes,i=0;i<lh.length;++i)if(x>=(hitBox=lh[i]).left&&x<=hitBox.left+hitBox.width&&y>=hitBox.top&&y<=hitBox.top+hitBox.height)return me.legendItems[i];return null},handleEvent:function(e){var hoveredItem,me=this,opts=me.options,type="mouseup"===e.type?"click":e.type;if("mousemove"===type){if(!opts.onHover&&!opts.onLeave)return}else{if("click"!==type)return;if(!opts.onClick)return}hoveredItem=me._getLegendItemAt(e.x,e.y),"click"===type?hoveredItem&&opts.onClick&&opts.onClick.call(me,e.native,hoveredItem):(opts.onLeave&&hoveredItem!==me._hoveredItem&&(me._hoveredItem&&opts.onLeave.call(me,e.native,me._hoveredItem),me._hoveredItem=hoveredItem),opts.onHover&&hoveredItem&&opts.onHover.call(me,e.native,hoveredItem))}});function createNewLegendAndAttach(chart,legendOpts){var legend=new Legend({ctx:chart.ctx,options:legendOpts,chart:chart});core_layouts.configure(chart,legend,legendOpts),core_layouts.addBox(chart,legend),chart.legend=legend}var plugin_legend={id:"legend",_element:Legend,beforeInit:function(chart){var legendOpts=chart.options.legend;legendOpts&&createNewLegendAndAttach(chart,legendOpts)},beforeUpdate:function(chart){var legendOpts=chart.options.legend,legend=chart.legend;legendOpts?(helpers$1.mergeIf(legendOpts,core_defaults.global.legend),legend?(core_layouts.configure(chart,legend,legendOpts),legend.options=legendOpts):createNewLegendAndAttach(chart,legendOpts)):legend&&(core_layouts.removeBox(chart,legend),delete chart.legend)},afterEvent:function(chart,e){var legend=chart.legend;legend&&legend.handleEvent(e)}},noop$2=helpers$1.noop;core_defaults._set("global",{title:{display:!1,fontStyle:"bold",fullWidth:!0,padding:10,position:"top",text:"",weight:2e3}});var Title=core_element.extend({initialize:function(config){helpers$1.extend(this,config),this.legendHitBoxes=[]},beforeUpdate:noop$2,update:function(maxWidth,maxHeight,margins){var me=this;return me.beforeUpdate(),me.maxWidth=maxWidth,me.maxHeight=maxHeight,me.margins=margins,me.beforeSetDimensions(),me.setDimensions(),me.afterSetDimensions(),me.beforeBuildLabels(),me.buildLabels(),me.afterBuildLabels(),me.beforeFit(),me.fit(),me.afterFit(),me.afterUpdate(),me.minSize},afterUpdate:noop$2,beforeSetDimensions:noop$2,setDimensions:function(){var me=this;me.isHorizontal()?(me.width=me.maxWidth,me.left=0,me.right=me.width):(me.height=me.maxHeight,me.top=0,me.bottom=me.height),me.paddingLeft=0,me.paddingTop=0,me.paddingRight=0,me.paddingBottom=0,me.minSize={width:0,height:0}},afterSetDimensions:noop$2,beforeBuildLabels:noop$2,buildLabels:noop$2,afterBuildLabels:noop$2,beforeFit:noop$2,fit:function(){var textSize,me=this,opts=me.options,minSize=me.minSize={},isHorizontal=me.isHorizontal();opts.display?(textSize=(helpers$1.isArray(opts.text)?opts.text.length:1)*helpers$1.options._parseFont(opts).lineHeight+2*opts.padding,me.width=minSize.width=isHorizontal?me.maxWidth:textSize,me.height=minSize.height=isHorizontal?textSize:me.maxHeight):me.width=minSize.width=me.height=minSize.height=0},afterFit:noop$2,isHorizontal:function(){var pos=this.options.position;return"top"===pos||"bottom"===pos},draw:function(){var me=this,ctx=me.ctx,opts=me.options;if(opts.display){var maxWidth,titleX,titleY,fontOpts=helpers$1.options._parseFont(opts),lineHeight=fontOpts.lineHeight,offset=lineHeight/2+opts.padding,rotation=0,top=me.top,left=me.left,bottom=me.bottom,right=me.right;ctx.fillStyle=helpers$1.valueOrDefault(opts.fontColor,core_defaults.global.defaultFontColor),ctx.font=fontOpts.string,me.isHorizontal()?(titleX=left+(right-left)/2,titleY=top+offset,maxWidth=right-left):(titleX="left"===opts.position?left+offset:right-offset,titleY=top+(bottom-top)/2,maxWidth=bottom-top,rotation=Math.PI*("left"===opts.position?-.5:.5)),ctx.save(),ctx.translate(titleX,titleY),ctx.rotate(rotation),ctx.textAlign="center",ctx.textBaseline="middle";var text=opts.text;if(helpers$1.isArray(text))for(var y=0,i=0;i<text.length;++i)ctx.fillText(text[i],0,y,maxWidth),y+=lineHeight;else ctx.fillText(text,0,0,maxWidth);ctx.restore()}}});function createNewTitleBlockAndAttach(chart,titleOpts){var title=new Title({ctx:chart.ctx,options:titleOpts,chart:chart});core_layouts.configure(chart,title,titleOpts),core_layouts.addBox(chart,title),chart.titleBlock=title}var plugins={},filler=plugin_filler,legend=plugin_legend,title={id:"title",_element:Title,beforeInit:function(chart){var titleOpts=chart.options.title;titleOpts&&createNewTitleBlockAndAttach(chart,titleOpts)},beforeUpdate:function(chart){var titleOpts=chart.options.title,titleBlock=chart.titleBlock;titleOpts?(helpers$1.mergeIf(titleOpts,core_defaults.global.title),titleBlock?(core_layouts.configure(chart,titleBlock,titleOpts),titleBlock.options=titleOpts):createNewTitleBlockAndAttach(chart,titleOpts)):titleBlock&&(core_layouts.removeBox(chart,titleBlock),delete chart.titleBlock)}};for(var k in plugins.filler=filler,plugins.legend=legend,plugins.title=title,core_controller.helpers=helpers$1,function(){function parseMaxStyle(styleValue,node,parentProperty){var valueInPixels;return"string"==typeof styleValue?(valueInPixels=parseInt(styleValue,10),-1!==styleValue.indexOf("%")&&(valueInPixels=valueInPixels/100*node.parentNode[parentProperty])):valueInPixels=styleValue,valueInPixels}function isConstrainedValue(value){return null!=value&&"none"!==value}function getConstraintDimension(domNode,maxStyle,percentageProperty){var view=document.defaultView,parentNode=helpers$1._getParentNode(domNode),constrainedNode=view.getComputedStyle(domNode)[maxStyle],constrainedContainer=view.getComputedStyle(parentNode)[maxStyle],hasCNode=isConstrainedValue(constrainedNode),hasCContainer=isConstrainedValue(constrainedContainer),infinity=Number.POSITIVE_INFINITY;return hasCNode||hasCContainer?Math.min(hasCNode?parseMaxStyle(constrainedNode,domNode,percentageProperty):infinity,hasCContainer?parseMaxStyle(constrainedContainer,parentNode,percentageProperty):infinity):"none"}helpers$1.where=function(collection,filterCallback){if(helpers$1.isArray(collection)&&Array.prototype.filter)return collection.filter(filterCallback);var filtered=[];return helpers$1.each(collection,(function(item){filterCallback(item)&&filtered.push(item)})),filtered},helpers$1.findIndex=Array.prototype.findIndex?function(array,callback,scope){return array.findIndex(callback,scope)}:function(array,callback,scope){scope=void 0===scope?array:scope;for(var i=0,ilen=array.length;i<ilen;++i)if(callback.call(scope,array[i],i,array))return i;return-1},helpers$1.findNextWhere=function(arrayToSearch,filterCallback,startIndex){helpers$1.isNullOrUndef(startIndex)&&(startIndex=-1);for(var i=startIndex+1;i<arrayToSearch.length;i++){var currentItem=arrayToSearch[i];if(filterCallback(currentItem))return currentItem}},helpers$1.findPreviousWhere=function(arrayToSearch,filterCallback,startIndex){helpers$1.isNullOrUndef(startIndex)&&(startIndex=arrayToSearch.length);for(var i=startIndex-1;i>=0;i--){var currentItem=arrayToSearch[i];if(filterCallback(currentItem))return currentItem}},helpers$1.isNumber=function(n){return!isNaN(parseFloat(n))&&isFinite(n)},helpers$1.almostEquals=function(x,y,epsilon){return Math.abs(x-y)<epsilon},helpers$1.almostWhole=function(x,epsilon){var rounded=Math.round(x);return rounded-epsilon<=x&&rounded+epsilon>=x},helpers$1.max=function(array){return array.reduce((function(max,value){return isNaN(value)?max:Math.max(max,value)}),Number.NEGATIVE_INFINITY)},helpers$1.min=function(array){return array.reduce((function(min,value){return isNaN(value)?min:Math.min(min,value)}),Number.POSITIVE_INFINITY)},helpers$1.sign=Math.sign?function(x){return Math.sign(x)}:function(x){return 0===(x=+x)||isNaN(x)?x:x>0?1:-1},helpers$1.toRadians=function(degrees){return degrees*(Math.PI/180)},helpers$1.toDegrees=function(radians){return radians*(180/Math.PI)},helpers$1._decimalPlaces=function(x){if(helpers$1.isFinite(x)){for(var e=1,p=0;Math.round(x*e)/e!==x;)e*=10,p++;return p}},helpers$1.getAngleFromPoint=function(centrePoint,anglePoint){var distanceFromXCenter=anglePoint.x-centrePoint.x,distanceFromYCenter=anglePoint.y-centrePoint.y,radialDistanceFromCenter=Math.sqrt(distanceFromXCenter*distanceFromXCenter+distanceFromYCenter*distanceFromYCenter),angle=Math.atan2(distanceFromYCenter,distanceFromXCenter);return angle<-.5*Math.PI&&(angle+=2*Math.PI),{angle:angle,distance:radialDistanceFromCenter}},helpers$1.distanceBetweenPoints=function(pt1,pt2){return Math.sqrt(Math.pow(pt2.x-pt1.x,2)+Math.pow(pt2.y-pt1.y,2))},helpers$1.aliasPixel=function(pixelWidth){return pixelWidth%2==0?0:.5},helpers$1._alignPixel=function(chart,pixel,width){var devicePixelRatio=chart.currentDevicePixelRatio,halfWidth=width/2;return Math.round((pixel-halfWidth)*devicePixelRatio)/devicePixelRatio+halfWidth},helpers$1.splineCurve=function(firstPoint,middlePoint,afterPoint,t){var previous=firstPoint.skip?middlePoint:firstPoint,current=middlePoint,next=afterPoint.skip?middlePoint:afterPoint,d01=Math.sqrt(Math.pow(current.x-previous.x,2)+Math.pow(current.y-previous.y,2)),d12=Math.sqrt(Math.pow(next.x-current.x,2)+Math.pow(next.y-current.y,2)),s01=d01/(d01+d12),s12=d12/(d01+d12),fa=t*(s01=isNaN(s01)?0:s01),fb=t*(s12=isNaN(s12)?0:s12);return{previous:{x:current.x-fa*(next.x-previous.x),y:current.y-fa*(next.y-previous.y)},next:{x:current.x+fb*(next.x-previous.x),y:current.y+fb*(next.y-previous.y)}}},helpers$1.EPSILON=Number.EPSILON||1e-14,helpers$1.splineCurveMonotone=function(points){var i,pointBefore,pointCurrent,pointAfter,alphaK,betaK,tauK,squaredMagnitude,deltaX,pointsWithTangents=(points||[]).map((function(point){return{model:point._model,deltaK:0,mK:0}})),pointsLen=pointsWithTangents.length;for(i=0;i<pointsLen;++i)if(!(pointCurrent=pointsWithTangents[i]).model.skip){if(pointBefore=i>0?pointsWithTangents[i-1]:null,(pointAfter=i<pointsLen-1?pointsWithTangents[i+1]:null)&&!pointAfter.model.skip){var slopeDeltaX=pointAfter.model.x-pointCurrent.model.x;pointCurrent.deltaK=0!==slopeDeltaX?(pointAfter.model.y-pointCurrent.model.y)/slopeDeltaX:0}!pointBefore||pointBefore.model.skip?pointCurrent.mK=pointCurrent.deltaK:!pointAfter||pointAfter.model.skip?pointCurrent.mK=pointBefore.deltaK:this.sign(pointBefore.deltaK)!==this.sign(pointCurrent.deltaK)?pointCurrent.mK=0:pointCurrent.mK=(pointBefore.deltaK+pointCurrent.deltaK)/2}for(i=0;i<pointsLen-1;++i)pointCurrent=pointsWithTangents[i],pointAfter=pointsWithTangents[i+1],pointCurrent.model.skip||pointAfter.model.skip||(helpers$1.almostEquals(pointCurrent.deltaK,0,this.EPSILON)?pointCurrent.mK=pointAfter.mK=0:(alphaK=pointCurrent.mK/pointCurrent.deltaK,betaK=pointAfter.mK/pointCurrent.deltaK,(squaredMagnitude=Math.pow(alphaK,2)+Math.pow(betaK,2))<=9||(tauK=3/Math.sqrt(squaredMagnitude),pointCurrent.mK=alphaK*tauK*pointCurrent.deltaK,pointAfter.mK=betaK*tauK*pointCurrent.deltaK)));for(i=0;i<pointsLen;++i)(pointCurrent=pointsWithTangents[i]).model.skip||(pointBefore=i>0?pointsWithTangents[i-1]:null,pointAfter=i<pointsLen-1?pointsWithTangents[i+1]:null,pointBefore&&!pointBefore.model.skip&&(deltaX=(pointCurrent.model.x-pointBefore.model.x)/3,pointCurrent.model.controlPointPreviousX=pointCurrent.model.x-deltaX,pointCurrent.model.controlPointPreviousY=pointCurrent.model.y-deltaX*pointCurrent.mK),pointAfter&&!pointAfter.model.skip&&(deltaX=(pointAfter.model.x-pointCurrent.model.x)/3,pointCurrent.model.controlPointNextX=pointCurrent.model.x+deltaX,pointCurrent.model.controlPointNextY=pointCurrent.model.y+deltaX*pointCurrent.mK))},helpers$1.nextItem=function(collection,index,loop){return loop?index>=collection.length-1?collection[0]:collection[index+1]:index>=collection.length-1?collection[collection.length-1]:collection[index+1]},helpers$1.previousItem=function(collection,index,loop){return loop?index<=0?collection[collection.length-1]:collection[index-1]:index<=0?collection[0]:collection[index-1]},helpers$1.niceNum=function(range,round){var exponent=Math.floor(helpers$1.log10(range)),fraction=range/Math.pow(10,exponent);return(round?fraction<1.5?1:fraction<3?2:fraction<7?5:10:fraction<=1?1:fraction<=2?2:fraction<=5?5:10)*Math.pow(10,exponent)},helpers$1.requestAnimFrame="undefined"==typeof window?function(callback){callback()}:window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.oRequestAnimationFrame||window.msRequestAnimationFrame||function(callback){return window.setTimeout(callback,1e3/60)},helpers$1.getRelativePosition=function(evt,chart){var mouseX,mouseY,e=evt.originalEvent||evt,canvas=evt.target||evt.srcElement,boundingRect=canvas.getBoundingClientRect(),touches=e.touches;touches&&touches.length>0?(mouseX=touches[0].clientX,mouseY=touches[0].clientY):(mouseX=e.clientX,mouseY=e.clientY);var paddingLeft=parseFloat(helpers$1.getStyle(canvas,"padding-left")),paddingTop=parseFloat(helpers$1.getStyle(canvas,"padding-top")),paddingRight=parseFloat(helpers$1.getStyle(canvas,"padding-right")),paddingBottom=parseFloat(helpers$1.getStyle(canvas,"padding-bottom")),width=boundingRect.right-boundingRect.left-paddingLeft-paddingRight,height=boundingRect.bottom-boundingRect.top-paddingTop-paddingBottom;return{x:mouseX=Math.round((mouseX-boundingRect.left-paddingLeft)/width*canvas.width/chart.currentDevicePixelRatio),y:mouseY=Math.round((mouseY-boundingRect.top-paddingTop)/height*canvas.height/chart.currentDevicePixelRatio)}},helpers$1.getConstraintWidth=function(domNode){return getConstraintDimension(domNode,"max-width","clientWidth")},helpers$1.getConstraintHeight=function(domNode){return getConstraintDimension(domNode,"max-height","clientHeight")},helpers$1._calculatePadding=function(container,padding,parentDimension){return(padding=helpers$1.getStyle(container,padding)).indexOf("%")>-1?parentDimension*parseInt(padding,10)/100:parseInt(padding,10)},helpers$1._getParentNode=function(domNode){var parent=domNode.parentNode;return parent&&"[object ShadowRoot]"===parent.toString()&&(parent=parent.host),parent},helpers$1.getMaximumWidth=function(domNode){var container=helpers$1._getParentNode(domNode);if(!container)return domNode.clientWidth;var clientWidth=container.clientWidth,w=clientWidth-helpers$1._calculatePadding(container,"padding-left",clientWidth)-helpers$1._calculatePadding(container,"padding-right",clientWidth),cw=helpers$1.getConstraintWidth(domNode);return isNaN(cw)?w:Math.min(w,cw)},helpers$1.getMaximumHeight=function(domNode){var container=helpers$1._getParentNode(domNode);if(!container)return domNode.clientHeight;var clientHeight=container.clientHeight,h=clientHeight-helpers$1._calculatePadding(container,"padding-top",clientHeight)-helpers$1._calculatePadding(container,"padding-bottom",clientHeight),ch=helpers$1.getConstraintHeight(domNode);return isNaN(ch)?h:Math.min(h,ch)},helpers$1.getStyle=function(el,property){return el.currentStyle?el.currentStyle[property]:document.defaultView.getComputedStyle(el,null).getPropertyValue(property)},helpers$1.retinaScale=function(chart,forceRatio){var pixelRatio=chart.currentDevicePixelRatio=forceRatio||"undefined"!=typeof window&&window.devicePixelRatio||1;if(1!==pixelRatio){var canvas=chart.canvas,height=chart.height,width=chart.width;canvas.height=height*pixelRatio,canvas.width=width*pixelRatio,chart.ctx.scale(pixelRatio,pixelRatio),canvas.style.height||canvas.style.width||(canvas.style.height=height+"px",canvas.style.width=width+"px")}},helpers$1.fontString=function(pixelSize,fontStyle,fontFamily){return fontStyle+" "+pixelSize+"px "+fontFamily},helpers$1.longestText=function(ctx,font,arrayOfThings,cache){var data=(cache=cache||{}).data=cache.data||{},gc=cache.garbageCollect=cache.garbageCollect||[];cache.font!==font&&(data=cache.data={},gc=cache.garbageCollect=[],cache.font=font),ctx.font=font;var i,j,jlen,thing,nestedThing,longest=0,ilen=arrayOfThings.length;for(i=0;i<ilen;i++)if(null!=(thing=arrayOfThings[i])&&!0!==helpers$1.isArray(thing))longest=helpers$1.measureText(ctx,data,gc,longest,thing);else if(helpers$1.isArray(thing))for(j=0,jlen=thing.length;j<jlen;j++)null==(nestedThing=thing[j])||helpers$1.isArray(nestedThing)||(longest=helpers$1.measureText(ctx,data,gc,longest,nestedThing));var gcLen=gc.length/2;if(gcLen>arrayOfThings.length){for(i=0;i<gcLen;i++)delete data[gc[i]];gc.splice(0,gcLen)}return longest},helpers$1.measureText=function(ctx,data,gc,longest,string){var textWidth=data[string];return textWidth||(textWidth=data[string]=ctx.measureText(string).width,gc.push(string)),textWidth>longest&&(longest=textWidth),longest},helpers$1.numberOfLabelLines=function(arrayOfThings){var numberOfLines=1;return helpers$1.each(arrayOfThings,(function(thing){helpers$1.isArray(thing)&&thing.length>numberOfLines&&(numberOfLines=thing.length)})),numberOfLines},helpers$1.color=chartjsColor?function(value){return value instanceof CanvasGradient&&(value=core_defaults.global.defaultColor),chartjsColor(value)}:function(value){return console.error("Color.js not found!"),value},helpers$1.getHoverColor=function(colorValue){return colorValue instanceof CanvasPattern||colorValue instanceof CanvasGradient?colorValue:helpers$1.color(colorValue).saturate(.5).darken(.1).rgbString()}}(),core_controller._adapters=core_adapters,core_controller.Animation=core_animation,core_controller.animationService=core_animations,core_controller.controllers=controllers,core_controller.DatasetController=core_datasetController,core_controller.defaults=core_defaults,core_controller.Element=core_element,core_controller.elements=elements,core_controller.Interaction=core_interaction,core_controller.layouts=core_layouts,core_controller.platform=platform,core_controller.plugins=core_plugins,core_controller.Scale=core_scale,core_controller.scaleService=core_scaleService,core_controller.Ticks=core_ticks,core_controller.Tooltip=core_tooltip,core_controller.helpers.each(scales,(function(scale,type){core_controller.scaleService.registerScaleType(type,scale,scale._defaults)})),plugins)plugins.hasOwnProperty(k)&&core_controller.plugins.register(plugins[k]);core_controller.platform.initialize();var src=core_controller;return"undefined"!=typeof window&&(window.Chart=core_controller),core_controller.Chart=core_controller,core_controller.Legend=plugins.legend._element,core_controller.Title=plugins.title._element,core_controller.pluginService=core_controller.plugins,core_controller.PluginBase=core_controller.Element.extend({}),core_controller.canvasHelpers=core_controller.helpers.canvas,core_controller.layoutService=core_controller.layouts,core_controller.LinearScaleBase=scale_linearbase,core_controller.helpers.each(["Bar","Bubble","Doughnut","Line","PolarArea","Radar","Scatter"],(function(klass){core_controller[klass]=function(ctx,cfg){return new core_controller(ctx,core_controller.helpers.merge(cfg||{},{type:klass.charAt(0).toLowerCase()+klass.slice(1)}))}})),src}));

//# sourceMappingURL=chartjs-lazy.min.js.map